%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2010-2011. All Rights Reserved.
%%
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%%
%% %CopyrightEnd%
%%

%%
%% A parse transform to work around dialyzer currently not
%% understanding nowarn_unused_function except on individual
%% functions. The include of diameter_gen.hrl by generated dictionary
%% modules contains code that may not be called depending on the
%% dictionary. (The relay dictionary for example.)
%%
%% Even called functions may contain cases that aren't used for a
%% particular dictionary. This also causes dialyzer to complain but
%% there's no way to silence it in this case.
%%

-module(diameter_nowarn).

-export([parse_transform/2]).

parse_transform(Forms, _Options) ->
    [{attribute, ?LINE, compile, {nowarn_unused_function, {F,A}}}
     || {function, _, F, A, _} <- Forms]
    ++ Forms.
%% Note that dialyzer also doesn't understand {nowarn_unused_function, FAs}
%% with FAs a list of tuples.
