<?php
	/**************************************************************************\
	* eGroupWare                                                               *
	* http://www.egroupware.org                                                *
	* This file was originaly written by Dan Kuykendall                        *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/
	/* $Id: header.inc.php.template 18745 2005-07-08 05:00:14Z milosch $ */

	/**************************************************************************\
	* !!!!!!! EDIT THESE LINES !!!!!!!!                                        *
	* This setting allows you to easily move the include directory and the     *
	* base of the eGroupWare install. Simple edit the following 2 lines with   *
	* the absolute path to fit your site, and you should be up and running.    *
	\**************************************************************************/

	// allow to migrate from phpgw_info to egw_info
	if (isset($GLOBALS['egw_info']))
	{
		$GLOBALS['phpgw_info'] =& $GLOBALS['egw_info'];
	}
	else
	{
		$GLOBALS['egw_info'] =& $GLOBALS['phpgw_info'];
	}

	define('EGW_SERVER_ROOT','/usr/share/egroupware');
	define('EGW_INCLUDE_ROOT','/usr/share/egroupware');
	define('PHPGW_SERVER_ROOT','/usr/share/egroupware');
	define('PHPGW_INCLUDE_ROOT','/usr/share/egroupware');

	/*
	** eGroupWare can handle session management using the database or 
	** the session support built into PHP4 which usually gives better
	** performance. 
	** Your choices are 'db' or 'php4'
	*/
	$GLOBALS['egw_info']['server']['sessions_type'] = 'php4';

	/* Select which login template set you want, most people will use default */
	$GLOBALS['egw_info']['login_template_set'] = 'idots';

	/* debugging settings */
	define('DEBUG_APP',  False);
	define('DEBUG_API',  False);
	define('DEBUG_DATATYPES',  True);
	define('DEBUG_LEVEL',  3);
	define('DEBUG_OUTPUT', 2); /* 1 = screen,  2 = DB. For both use 3. */
	define('DEBUG_TIMER', False);

	function perfgetmicrotime()
	{
		list($usec, $sec) = explode(' ',microtime());
		return ((float)$usec + (float)$sec);
	}
	$GLOBALS['egw_info']['flags']['page_start_time'] = perfgetmicrotime();

	/**************************************************************************\
	* Do not edit these lines                                                  *
	\**************************************************************************/
	define('EGW_API_INC',EGW_INCLUDE_ROOT.'/phpgwapi/inc');
	define('PHPGW_API_INC',EGW_INCLUDE_ROOT.'/phpgwapi/inc');
	include(EGW_SERVER_ROOT.'/phpgwapi/setup/setup.inc.php');
	$GLOBALS['egw_info']['server']['versions']['phpgwapi'] = $setup_info['phpgwapi']['version'];
	$GLOBALS['egw_info']['server']['versions']['current_header'] = $setup_info['phpgwapi']['versions']['current_header'];
	unset($setup_info);
	$GLOBALS['egw_info']['server']['versions']['header'] = '1.27';
	/* This is a fix for NT */
	if(!isset($GLOBALS['egw_info']['flags']['noapi']) || !$GLOBALS['egw_info']['flags']['noapi'] == True)
	{
		ob_start();	// to prevent error messages to be send before our headers
		include(EGW_API_INC . '/functions.inc.php');
		include(EGW_API_INC . '/xml_functions.inc.php');
		include(EGW_API_INC . '/soap_functions.inc.php');
	}

	/*
	  Leave off the final php closing tag, some editors will add
	  a \n or space after which will mess up cookies later on
	*/
