; NSIS installer script for dvdisaster package

; WARNING!!! the file encoding is Win-1252
; Copyright (C) 2004-2006 THE dvdisaster'S COPYRIGHT HOLDER
; Copyright 2006 Lubos Stanek
; This file is distributed under the same license as the dvdisaster package.

; Standard tasks when preparing new installation
; - check installed files
; Standard tasks when preparing new localization
; - copy English.nsh into new messages file, change all language symbols
; - check installation of the manual

; search our plugins too
!addplugindir "..\tools"

; version information generated by package's configure/make
!include "version.nsh"
; we need to be sure that this name will never change
!define CFG_PACKAGE "dvdisaster"
; this is the sample of version.nsh
;!define CFG_VERSION "0.66"
;!define RELEASE_MICRO "0"
;!define RELEASE_STATUS "stable" ;/"patch"/"devel"/"rc"
;!define CFG_PKGNAME "dvdisaster-0.66"

; other definitions
!define UNINST_KEY_ROOT "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
!define UNINST_KEY_PACKAGE "${CFG_PKGNAME}"
!define UNINST_KEY_SUBKEY "${UNINST_KEY_ROOT}\${UNINST_KEY_PACKAGE}"
!define UNINST_NAME "uninstall.exe"
!define UNINST_LOG_NAME "uninstall.log"

;General
Name "${CFG_PKGNAME}"
; here lies the package
OutFile "${CFG_PKGNAME}-setup.exe"
InstallDir "$PROGRAMFILES\${CFG_PKGNAME}"

; remeber /SOLID for final, speed up testing by removing it
SetCompressor /SOLID lzma
CRCCheck on
XPStyle on
SetOverwrite on

; global variables
Var sUpgrade ; carries the previous installation uninstall key
Var sStartMenuFolder ; carries selected Start Menu folder
Var sStartMenuPath ; carries full path to the selected Start Menu folder
Var sDirectoryFolder ; carries installation directory
Var sUninstKeyAdon ; normally "", with multiversion, it differentiates them "_?"
Var sInstallingUser ; name of the installing user
Var sUserSelection ; selected parts
Var iManualsCount ; number of manuals installed
Var iSectionErrors ; number of errors in section

; NSIS includes
!include "FileFunc.nsh"
!include "LogicLib.nsh"
!include "Sections.nsh"
!include "StrFunc.nsh"
!include "TextFunc.nsh"
!include "WinMessages.nsh"

; our log functions
Var UninstLog
!include "UninstLog.nsh"

;Include Modern UI
!include "MUI.nsh"

; MUI Installer Settings
!define MUI_ICON "install.ico"
!define MUI_UNICON "install.ico"
!define MUI_ABORTWARNING
!define MUI_UNABORTWARNING

!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "header.bmp"
!define MUI_HEADERIMAGE_UNBITMAP "header.bmp"
!define MUI_WELCOMEFINISHPAGE_BITMAP "installwiz.bmp"
!define MUI_UNWELCOMEFINISHPAGE_BITMAP "uninstallwiz.bmp"

; Installer Pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_COMPONENTS
!define MUI_DIRECTORYPAGE_VARIABLE $sDirectoryFolder
!insertmacro MUI_PAGE_DIRECTORY
!define MUI_PAGE_CUSTOMFUNCTION_PRE "PageStartmenu_Skip"
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER $sStartMenuFolder
!insertmacro MUI_PAGE_STARTMENU "Shortcuts" $sStartMenuFolder
!insertmacro MUI_PAGE_INSTFILES
!define MUI_FINISHPAGE_NOAUTOCLOSE
!define MUI_FINISHPAGE_RUN_NOTCHECKED
!define MUI_FINISHPAGE_RUN "$sDirectoryFolder\${CFG_PKGNAME}-win.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller Pages
!insertmacro MUI_UNPAGE_WELCOME
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!define MUI_UNFINISHPAGE_NOAUTOCLOSE
!insertmacro MUI_UNPAGE_FINISH

; Global languages
!insertmacro MUI_LANGUAGE "English" # first language is the default language
!insertmacro MUI_LANGUAGE "Czech"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "Italian"

; For setup localization to work right, there must be NSIS's messages
; (both basic language.nlf and MUI language.nsh - these also can be local)
; already localized (Global) plus specific this setup script's messages (Local)

; Local languages
!include "English.nsh"
!include "Czech.nsh"
!include "German.nsh"
!include "Italian.nsh"

;Version Information
VIProductVersion "${CFG_VERSION}.0.0"
VIAddVersionKey /LANG=${LANG_ENGLISH} "ProductName" "${CFG_PACKAGE}-setup"
VIAddVersionKey /LANG=${LANG_ENGLISH} "Comments" "Setup the application for additional error protection for CD/DVD media"
VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalCopyright" " 2004-2006, Carsten Gnrlich"
VIAddVersionKey /LANG=${LANG_ENGLISH} "FileDescription" "${CFG_PACKAGE}-setup"
VIAddVersionKey /LANG=${LANG_ENGLISH} "FileVersion" "${CFG_VERSION}.${RELEASE_MICRO}"
VIAddVersionKey /LANG=${LANG_ENGLISH} "SpecialBuild" "${RELEASE_STATUS}"
VIAddVersionKey /LANG=${LANG_ENGLISH} "ProductVersion" "${CFG_VERSION}.${RELEASE_MICRO}.${RELEASE_MICRO}"

;Reserve Files
;These files should be inserted before other files in the data block
!insertmacro MUI_RESERVEFILE_LANGDLL
ReserveFile "${NSISDIR}\Plugins\System.dll"
ReserveFile "${NSISDIR}\Plugins\UserInfo.dll"
ReserveFile "${NSISDIR}\Plugins\StartMenu.dll"
ReserveFile "..\tools\unpngpack.dll"

; Declare library functions
${StrStrAdv}
${StrTok}
${StrRep}
${StrTrimNewLines}
!insertmacro GetParent
!insertmacro FileReadFromEnd
!insertmacro LineFind
; uninstaller
${UnStrStrAdv}
${UnStrTrimNewLines}
!insertmacro un.FileReadFromEnd
!insertmacro un.LineFind


;Install types
InstType "$(LANG_INSTALLTYPE_STANDARD)"
InstType "$(LANG_INSTALLTYPE_FULL)"

; Sections
Section "!$(LANG_SECTION_APPLICATION)" SectionApp
  SectionIn 1 2 3 RO
  Call RemovePrevious
  ClearErrors
  ; initialize uninstall log file
  ${InitLog} "$PLUGINSDIR\${UNINST_LOG_NAME}" "${CFG_PACKAGE} ${CFG_VERSION}.${RELEASE_MICRO}.${RELEASE_MICRO}"
  IfErrors MainSectionEnd
  SetOverwrite on
  ; these files are forced to install in any type
  ; application, libraries, libraries settings, message catalogs
  ${SetOutPath} "$sDirectoryFolder"
  IfErrors MainSectionEnd
  ; the last removed file is the uninstaller
  Push "${UNINST_NAME}"
  Call FileToUninstallLog
  Push "${UNINST_LOG_NAME}"
  Call FileToUninstallLog
  ; remove also configuration
  Push ".dvdisaster"
  Call FileToUninstallLog
  IfErrors MainSectionEnd
  ${FileOverwriteNoError} "..\win-build-dir\" "COPYING"
  ${FileOverwriteNoError} "..\win-build-dir\" "CREDITS.cs"
  ${FileOverwriteNoError} "..\win-build-dir\" "CREDITS.en"
  ${FileOverwriteNoError} "..\win-build-dir\" "CREDITS.de"
  ${FileOverwriteNoError} "..\win-build-dir\" "CHANGELOG"
  ${FileOverwriteNoError} "..\win-build-dir\" "README.MODIFYING"
  ${FileOverwriteNoError} "..\win-build-dir\" "TODO"
  ${FileOverwriteIncReboot} "..\win-build-dir\" "iconv.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "intl.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libatk-1.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libgdk-win32-2.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libgdk_pixbuf-2.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libglib-2.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libgmodule-2.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libgobject-2.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libgthread-2.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libgtk-win32-2.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libpango-1.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libpangoft2-1.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "libpangowin32-1.0-0.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "pango-basic-win32.dll"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "dvdisaster.exe"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\" "dvdisaster-win.exe"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\etc"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\etc\gtk-2.0"
  IfErrors MainSectionEnd
  ${FileOverwrite} "..\win-build-dir\etc\gtk-2.0\" "gdk-pixbuf.loaders"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\etc\pango"
  IfErrors MainSectionEnd
  ${FileOverwrite} "..\win-build-dir\etc\pango\" "pango.aliases"
  IfErrors MainSectionEnd
  ${FileOverwrite} "..\win-build-dir\etc\pango\" "pango.modules"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib\locale"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib\locale\cs"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib\locale\cs\LC_MESSAGES"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\cs\LC_MESSAGES\" "atk10.mo"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\cs\LC_MESSAGES\" "glib20.mo"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\cs\LC_MESSAGES\" "gtk20.mo"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib\locale\de"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib\locale\de\LC_MESSAGES"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\de\LC_MESSAGES\" "atk10.mo"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\de\LC_MESSAGES\" "glib20.mo"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\de\LC_MESSAGES\" "gtk20.mo"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib\locale\it"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\lib\locale\it\LC_MESSAGES"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\it\LC_MESSAGES\" "atk10.mo"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\it\LC_MESSAGES\" "glib20.mo"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\lib\locale\it\LC_MESSAGES\" "gtk20.mo"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\locale"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\locale\cs"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\locale\cs\LC_MESSAGES"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\locale\cs\LC_MESSAGES\" "dvdisaster.mo"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\locale\de"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\locale\de\LC_MESSAGES"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\locale\de\LC_MESSAGES\" "dvdisaster.mo"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\locale\it"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\locale\it\LC_MESSAGES"
  IfErrors MainSectionEnd
  ${FileOverwriteIncReboot} "..\win-build-dir\locale\it\LC_MESSAGES\" "dvdisaster.mo"
  IfErrors MainSectionEnd
  ${SetOutPath} "$sDirectoryFolder\documentation"
  IfErrors MainSectionEnd
  ${FileOverwriteNoError} "..\win-build-dir\documentation\" "pubkey.asc"
  ; if anything goes wrong
MainSectionEnd:
  ${If} ${Errors}
    ${StrRep} $0 "$(LANG_SECTION_ERROR)" "%s" "$(LANG_SECTION_APPLICATION)"
    Push $0
    Call GlobalErrorAbort
  ${EndIf}
SectionEnd

; /e is more convenient for small number (max 3 + common) of translations
SectionGroup /e "$(LANG_SECTION_MANUAL)" SectionManual
  Section "$(LANG_SECTION_MANUAL_CZECH)" SectionCzech
    SectionIn 2
    ClearErrors
    StrCpy $iSectionErrors 0
    StrCpy $0 "$sUserSelection|${LANG_ID_CZECH}"
    StrCpy $sUserSelection $0
    IntOp $iManualsCount $iManualsCount + 1
    SetOverwrite on
    SetOutPath "$sDirectoryFolder"
    ${FileOverwriteNoError} "..\win-build-dir\" "CREDITS.cs"
    ${SetOutPath} "$sDirectoryFolder\documentation\cs"
    ; if we cannot create directory, end section
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background40.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background50.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background60.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "background70.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "download.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "download10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "download20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example1.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example2.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example21.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example22.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example3.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example4.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example40.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example5.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example50.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example6.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example80.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example81.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example82.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example83.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "example90.html"
;    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "imprint.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "index.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "index10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "index20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "index30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "inline1.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "inline2.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "qa.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "qa10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\cs\" "qa20.html"
    ${SetOutPath} "$sDirectoryFolder\documentation\cs\images"
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ${FileOverwriteNoError} "..\win-build-dir\documentation\" "images-cs.pngpack"
    Push "images-cs.pngpack"
    Call UnpngpackExtractAll
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ErrorSectionEnd:
    ; if anything goes wrong
    ${If} $iSectionErrors > 0
      ${StrRep} $0 "$(LANG_SECTION_ERROR) [$iSectionErrors]" "%s" "$(LANG_SECTION_MANUAL_CZECH)"
      Push $0
      Call GlobalErrorNoAbort
    ${EndIf}
  SectionEnd
  Section "$(LANG_SECTION_MANUAL_ENGLISH)" SectionEnglish
    SectionIn 2
    ClearErrors
    StrCpy $iSectionErrors 0
    StrCpy $0 "$sUserSelection|${LANG_ID_ENGLISH}"
    StrCpy $sUserSelection $0
    IntOp $iManualsCount $iManualsCount + 1
    SetOverwrite on
    ${SetOutPath} "$sDirectoryFolder\documentation\en"
    ; if we cannot create directory, end section
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background40.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background50.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background60.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "background70.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "download.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "download10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "download20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example1.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example2.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example21.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example22.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example3.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example4.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example40.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example5.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example50.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example6.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example80.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example81.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example82.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example83.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "example90.html"
;    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "imprint.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "index.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "index10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "index20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "index30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "inline1.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "inline2.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "qa.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "qa10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\en\" "qa20.html"
    ${SetOutPath} "$sDirectoryFolder\documentation\en\images"
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ${FileOverwriteNoError} "..\win-build-dir\documentation\" "images-en.pngpack"
    Push "images-en.pngpack"
    Call UnpngpackExtractAll
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ErrorSectionEnd:
    ; if anything goes wrong
    ${If} $iSectionErrors > 0
      ${StrRep} $0 "$(LANG_SECTION_ERROR) [$iSectionErrors]" "%s" "$(LANG_SECTION_MANUAL_ENGLISH)"
      Push $0
      Call GlobalErrorNoAbort
    ${EndIf}
  SectionEnd
  Section "$(LANG_SECTION_MANUAL_GERMAN)" SectionGerman
    SectionIn 2
    ClearErrors
    StrCpy $iSectionErrors 0
    StrCpy $0 "$sUserSelection|${LANG_ID_GERMAN}"
    StrCpy $sUserSelection $0
    IntOp $iManualsCount $iManualsCount + 1
    SetOverwrite on
    SetOutPath "$sDirectoryFolder"
    ${FileOverwriteNoError} "..\win-build-dir\" "CREDITS.de"
    ${SetOutPath} "$sDirectoryFolder\documentation\de"
    ; if we cannot create directory, end section
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background40.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background50.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background60.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "background70.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "download.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "download10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "download20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example1.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example2.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example21.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example22.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example3.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example4.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example40.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example5.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example50.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example6.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example80.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example81.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example82.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example83.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "example90.html"
;    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "imprint.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "index.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "index10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "index20.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "index30.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "inline1.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "inline2.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "qa.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "qa10.html"
    ${FileOverwriteNoError} "..\win-build-dir\documentation\de\" "qa20.html"
    ${SetOutPath} "$sDirectoryFolder\documentation\de\images"
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ${FileOverwriteNoError} "..\win-build-dir\documentation\" "images-de.pngpack"
    Push "images-de.pngpack"
    Call UnpngpackExtractAll
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    ErrorSectionEnd:
    ; if anything goes wrong
    ${If} $iSectionErrors > 0
      ${StrRep} $0 "$(LANG_SECTION_ERROR) [$iSectionErrors]" "%s" "$(LANG_SECTION_MANUAL_GERMAN)"
      Push $0
      Call GlobalErrorNoAbort
    ${EndIf}
  SectionEnd
  Section "-manualcommon" SectionCommon
    ClearErrors
    StrCpy $iSectionErrors 0
    ; check any documentation installed
    ${If} $iManualsCount > 0
      SetOverwrite on
      ${SetOutPath} "$sDirectoryFolder\documentation\images"
      ; if we cannot create directory, end section
      ${If} ${Errors}
        IntOp $iSectionErrors $iSectionErrors + 1
        ClearErrors
        Goto ErrorSectionEnd
      ${EndIf}
      ${FileOverwriteNoError} "..\win-build-dir\documentation\images\" "scratch-img.jpg"
      ${FileOverwriteNoError} "..\win-build-dir\documentation\" "images-common.pngpack"
      Push "images-common.pngpack"
      Call UnpngpackExtractAll
      ${If} ${Errors}
        IntOp $iSectionErrors $iSectionErrors + 1
        ClearErrors
        Goto ErrorSectionEnd
      ${EndIf}
      ErrorSectionEnd:
      ; if anything goes wrong
      ${If} $iSectionErrors > 0
        ${StrRep} $0 "$(LANG_SECTION_ERROR) [$iSectionErrors]" "%s" "ManualCommon"
        Push $0
        Call GlobalErrorNoAbort
      ${EndIf}
    ${EndIf}
  SectionEnd
SectionGroupEnd

Section "$(LANG_SECTION_SHORTCUTS)" SectionShortcuts
  SectionIn 2
  ClearErrors
  StrCpy $iSectionErrors 0
  StrCpy $0 "$sUserSelection|startmenu"
  StrCpy $sUserSelection $0
  SetOverwrite on
  SetOutPath $sDirectoryFolder
  SetShellVarContext all
  ; split path to tree and create each one to later remove the full tree if empty
  ${If} $sStartMenuFolder != ""
    StrCpy $0 0
    StrCpy $3 "$SMPROGRAMS"
    MenuParsePath:
      ${StrTok} $1 $sStartMenuFolder "\" $0 "0"
      ${IfThen} $1 == "" ${|} Goto MenuPathParsed ${|}
      StrCpy $3 "$3\$1"
      Push $3
      Call PathToUninstallLog
      IntOp $0 $0 + 1
      Goto MenuParsePath
    MenuPathParsed:
  ${EndIf}
  ClearErrors
  SetOutPath $sDirectoryFolder
  ${If} $sStartMenuFolder == ""
    StrCpy $sStartMenuPath "$SMPROGRAMS"
  ${Else}
    StrCpy $sStartMenuPath "$SMPROGRAMS\$sStartMenuFolder"
  ${EndIf}
  CreateDirectory $sStartMenuPath
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto ErrorSectionEnd
  ${EndIf}

  Push "$sStartMenuPath\${CFG_PACKAGE}.lnk"
  Pop $0
  CreateShortCut $0 \
    "$sDirectoryFolder\${CFG_PACKAGE}-win.exe" "" "$sDirectoryFolder\${CFG_PACKAGE}-win.exe" 0 \
    "" "" "$(LANG_SECTION_SHORTCUTS_DESC)"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto ErrorSectionEnd
  ${EndIf}
  Push $0
  Call FilePathToUninstallLog

  ${IfThen} $iManualsCount = 0 ${|} Goto LangShortcutsDone ${|}
  ${If} ${SectionIsSelected} ${SectionCzech}
    SetOutPath "$sDirectoryFolder\documentation\cs"
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    Push "$sStartMenuPath\$(LANG_SECTION_MANUAL) $(LANG_SECTION_MANUAL_CZECH).lnk"
    Pop $0
    CreateShortCut $0 "$sDirectoryFolder\documentation\cs\index.html" ""
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    Push $0
    Call FilePathToUninstallLog
  ${EndIf}
  ${If} ${SectionIsSelected} ${SectionEnglish}
    SetOutPath "$sDirectoryFolder\documentation\en"
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    Push "$sStartMenuPath\$(LANG_SECTION_MANUAL) $(LANG_SECTION_MANUAL_ENGLISH).lnk"
    Pop $0
    CreateShortCut $0 "$sDirectoryFolder\documentation\en\index.html" ""
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    Push $0
    Call FilePathToUninstallLog
  ${EndIf}
  ${If} ${SectionIsSelected} ${SectionGerman}
    SetOutPath "$sDirectoryFolder\documentation\de"
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    Push "$sStartMenuPath\$(LANG_SECTION_MANUAL) $(LANG_SECTION_MANUAL_GERMAN).lnk"
    Pop $0
    CreateShortCut $0 "$sDirectoryFolder\documentation\de\index.html" ""
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto ErrorSectionEnd
    ${EndIf}
    Push $0
    Call FilePathToUninstallLog
  ${EndIf}
  LangShortcutsDone:
  ErrorSectionEnd:
  ${If} $iSectionErrors > 0
    ${StrRep} $0 "$(LANG_SECTION_ERROR) [$iSectionErrors]" "%s" "$(LANG_SECTION_SHORTCUTS)"
    Push $0
    Call GlobalErrorNoAbort
  ${EndIf}
SectionEnd

Section "$(LANG_SECTION_DESKTOP)" SectionDesktop
  SectionIn 2
  ClearErrors
  StrCpy $0 "$sUserSelection|desktop"
  StrCpy $sUserSelection $0
  SetOverwrite on
  SetOutPath $sDirectoryFolder
  ; desktop shortcut works for current user, do not bother others
  SetShellVarContext current
  Push "$DESKTOP\${CFG_PACKAGE}.lnk"
  Pop $0
  CreateShortCut $0 \
    "$sDirectoryFolder\${CFG_PACKAGE}-win.exe" "" "$sDirectoryFolder\${CFG_PACKAGE}-win.exe" 0 \
    "" "" "$(LANG_SECTION_SHORTCUTS_DESC)"
  ${If} ${Errors}
    ${StrRep} $0 "$(LANG_SECTION_ERROR)" "%s" "$(LANG_SECTION_DESKTOP)"
    Push $0
    Call GlobalErrorNoAbort
  ${Else}
    Push $0
    Call FilePathToUninstallLog
  ${EndIf}
SectionEnd

Section "-PostInstall"
  SetOutPath $sDirectoryFolder
  ; return back old config
  Call RestoreOldConfigTemp

  ClearErrors
  StrCpy $iSectionErrors 0

  ; write all registry entries in the UNINST_KEY_SUBKEY
  ; as we log all written information into uninstall.log, we do not care errors
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon"
  Call RegKeyToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ; write SETUP: values for an uninstaller
  ; this replaces MUI_LANGDLL_REGISTRY_*
  StrCpy $0 "SETUP: InstallerLanguage"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 $LANGUAGE
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}
  Push $LANGUAGE
  Call InstallerLanguageToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "SETUP: InstallerLanguage"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "${NSIS_VERSION}"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ; prepare and write user selection
  StrCpy $1 $sUserSelection "" 1
  StrCpy $0 "SETUP: Selected"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 $1
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ; this replaces MUI_STARTMENUPAGE_REGISTRY_*
  StrCpy $0 "SETUP: StartMenuFolder"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 $sStartMenuFolder
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ${If} $sInstallingUser != ""
    StrCpy $0 "SETUP: User"
    WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 $sInstallingUser
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
    ${EndIf}
    Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
    Call RegValueToUninstallLog
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
      Goto PostInstallEnd
    ${EndIf}
  ${EndIf}

  ; write uninstall fields
  StrCpy $0 "DisplayName"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "${CFG_PACKAGE}"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "DisplayIcon"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 '"$sDirectoryFolder\${UNINST_NAME}",0'
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "Comments"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "$(LANG_SECTION_SHORTCUTS_DESC)"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "DisplayVersion"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "${CFG_VERSION}-${RELEASE_STATUS}-${RELEASE_MICRO}"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "Version"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "${CFG_VERSION}-${RELEASE_STATUS}-${RELEASE_MICRO}"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "Publisher"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "$(LANG_PUBLISHER)"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "HelpLink"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "$(LANG_WEB_SITE)"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ;InstallDate Installation date
  StrCpy $0 "InstallLocation"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 $sDirectoryFolder
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ;InstallSource SourceDir Property
  ;Language ProductLanguage Property

  StrCpy $0 "URLInfoAbout"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "$(LANG_PUBLISHER_SITE)"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "URLUpdateInfo"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 "$(LANG_UPDATE_SITE)"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "NoModify"
  WriteRegDWORD "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 0x00000001
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "NoRepair"
  WriteRegDWORD "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 0x00000001
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  StrCpy $0 "QuietUninstallString"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 '"$sDirectoryFolder\${UNINST_NAME}" /S'
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ;Readme ARPREADME Property - Readme provided to the Add or Remove Programs control panel.

  StrCpy $0 "UninstallString"
  WriteRegStr "HKLM" "${UNINST_KEY_SUBKEY}$sUninstKeyAdon" $0 '"$sDirectoryFolder\${UNINST_NAME}"'
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push "${UNINST_KEY_SUBKEY}$sUninstKeyAdon\$0"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}

  ; ^- all above see MSI SDK

  ; write the application path (enables start of the application from cmdline anywhere)
  Push "Software\Microsoft\Windows\CurrentVersion\App Paths\dvdisaster.exe"
  Pop $0
  Push $0
  Push $0
  Call RegKeyToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}
  Pop $0
  WriteRegStr "HKLM" "$0" "" "$sDirectoryFolder\dvdisaster.exe"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push '$0\""'
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}
  WriteRegStr "HKLM" "$0" "Path" "$sDirectoryFolder"
  Push "$0\Path"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}
  Push "Software\Microsoft\Windows\CurrentVersion\App Paths\dvdisaster-win.exe"
  Pop $0
  Push $0
  Push $0
  Call RegKeyToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}
  Pop $0
  WriteRegStr "HKLM" "$0" "" "$sDirectoryFolder\dvdisaster-win.exe"
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
  ${EndIf}
  Push '$0\""'
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}
  WriteRegStr "HKLM" "$0" "Path" "$sDirectoryFolder"
  Push "$0\Path"
  Call RegValueToUninstallLog
  ${If} ${Errors}
    IntOp $iSectionErrors $iSectionErrors + 1
    ClearErrors
    Goto PostInstallEnd
  ${EndIf}


PostInstallEnd:

  ; Write Uninstaller executable
  SetOutPath $sDirectoryFolder
  WriteUninstaller "$sDirectoryFolder\${UNINST_NAME}"
  ${If} ${Errors}
    ${StrRep} $0 "$(LANG_SECTION_ERROR)" "%s" "-PostInstall"
    Push $0
    Call GlobalErrorAbort
  ${EndIf}

  ; write uninstaller link
  ${If} ${SectionIsSelected} ${SectionShortcuts}
    Push "$sStartMenuPath\$(^UninstallCaption).lnk"
    Pop $0
    CreateShortCut $0 \
      "$sDirectoryFolder\${UNINST_NAME}" "" "$sDirectoryFolder\${UNINST_NAME}" 0 \
      "" "" "$(^UninstallCaption)"
    ${If} ${Errors}
      IntOp $iSectionErrors $iSectionErrors + 1
      ClearErrors
    ${Else}
      Push $0
      Call FilePathToUninstallLog
      ${If} ${Errors}
        IntOp $iSectionErrors $iSectionErrors + 1
        ClearErrors
      ${EndIf}
    ${EndIf}
  ${EndIf}

  ; close log
  ${FinishLog} "${CFG_PACKAGE} ${CFG_VERSION}.${RELEASE_MICRO}.${RELEASE_MICRO}"
  Rename "$PLUGINSDIR\${UNINST_LOG_NAME}" "$sDirectoryFolder\${UNINST_LOG_NAME}"
  ${If} ${Errors}
    ${StrRep} $0 "$(LANG_SECTION_ERROR)" "%s" "-PostInstall"
    Push $0
    Call GlobalErrorNoAbort
  ${EndIf}
SectionEnd

;Assign descriptions to sections
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SectionApp} $(DESC_SectionApp)
  !insertmacro MUI_DESCRIPTION_TEXT ${SectionManual} $(DESC_SectionManual)
  !insertmacro MUI_DESCRIPTION_TEXT ${SectionCzech} $(DESC_SectionManual)
  !insertmacro MUI_DESCRIPTION_TEXT ${SectionEnglish} $(DESC_SectionManual)
  !insertmacro MUI_DESCRIPTION_TEXT ${SectionGerman} $(DESC_SectionManual)
  !insertmacro MUI_DESCRIPTION_TEXT ${SectionShortcuts} $(DESC_SectionShortcuts)
  !insertmacro MUI_DESCRIPTION_TEXT ${SectionDesktop} $(DESC_SectionShortcuts)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Installer Functions
Function .onInit
  InitPluginsDir

  ; always select installer's language (only uninstaller reads previous settings)
  !insertmacro MUI_LANGDLL_DISPLAY

  ; one installer only
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "${CFG_PACKAGE}setup") i .r1 ?e'
  Pop $0
  ${If} $0 <> 0
    Abort
  ${EndIf}

  ; the app cannot be running
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "${CFG_PACKAGE}app") i .r1 ?e'
  Pop $0
  ${If} $0 <> 0
    ${Unless} ${Silent}
      MessageBox MB_ICONEXCLAMATION|MB_OK "$(LANG_APPISRUNNING)"
    ${EndIf}
    Abort
  ${EndIf}

  ; check rights for installation on the system
  ClearErrors
  StrCpy $sInstallingUser ""
  UserInfo::GetName
  IfErrors SkipRights ; Win9x
  Pop $sInstallingUser
  UserInfo::GetAccountType
  Pop $0
  ${IfThen} $0 == "Admin" ${|} Goto SkipRights ${|}
  ${IfThen} $0 == "Power" ${|} Goto SkipRights ${|}
  ${Unless} ${Silent}
    MessageBox MB_ICONEXCLAMATION|MB_OK "$(LANG_NOINSTALLPERMS)"
  ${EndIf}
  Abort
SkipRights:

  ; check our previous installation
  StrCpy $sUpgrade "${CFG_PACKAGE}_nsi1"
  ; check NSIS
  ReadRegStr $sDirectoryFolder "HKLM" "${UNINST_KEY_ROOT}\$sUpgrade" "InstallLocation"
  IfErrors CheckPreviousINNO
  ; DefaultFolder
  ${If} $sDirectoryFolder == ""
    StrCpy $sDirectoryFolder "$PROGRAMFILES\${CFG_PACKAGE}"
  ${Else}
    Call SaveOldConfigTemp
    ; try to save old config
    Call SaveOldConfigTemp
    ; strip the last part, reuse target and append current
    Push $sDirectoryFolder
    ${GetParent} $sDirectoryFolder $1
    ${If} $1 == ""
      StrCpy $sDirectoryFolder "$PROGRAMFILES\${CFG_PACKAGE}"
    ${Else}
      StrCpy $sDirectoryFolder "$1\${CFG_PACKAGE}"
    ${EndIf}
  ${EndIf}
  ; default StartMenuFolder
  StrCpy $sStartMenuFolder "${CFG_PACKAGE}"
  ; reuse previous menu folder
  ReadRegStr $0 "HKLM" "${UNINST_KEY_ROOT}\$sUpgrade" "SETUP: StartMenuFolder"
  IfErrors PreviousSections
  ${If} $0 != ""
    StrCpy $sStartMenuFolder $0
  ${EndIf}
PreviousSections:
  ; reuse previous selection "1029|startmenu|desktop"
  ReadRegStr $0 "HKLM" "${UNINST_KEY_ROOT}\$sUpgrade" "SETUP: Selected"
  IfErrors PresetSections
  StrCmp $0 "" PresetSections
  ; split parts
  StrCpy $1 0
  StrCpy $2 ""
EnumSelection:
  ${StrTok} $2 $0 "|" $1 "0"
  StrCmp $2 "" InitDone
  ${Select} $2
    ${Case} ${LANG_ID_CZECH}
      !insertmacro SetSectionInInstType ${SectionCzech} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionCzech}
    ${Case} ${LANG_ID_ENGLISH}
      !insertmacro SetSectionInInstType ${SectionEnglish} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionEnglish}
    ${Case} ${LANG_ID_GERMAN}
      !insertmacro SetSectionInInstType ${SectionGerman} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionGerman}
    ${Case} "startmenu"
      !insertmacro SetSectionInInstType ${SectionShortcuts} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionShortcuts}
    ${Case} "desktop"
      !insertmacro SetSectionInInstType ${SectionDesktop} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionDesktop}
  ${EndSelect}
  IntOp $1 $1 + 1
  Goto EnumSelection

CheckPreviousINNO:
  ; check INNO
  StrCpy $sUpgrade "${CFG_PACKAGE}_is1"
  ReadRegStr $sDirectoryFolder "HKLM" "${UNINST_KEY_ROOT}\$sUpgrade" "InstallLocation"
  IfErrors Preset
  ; DefaultFolder
  ${If} $sDirectoryFolder == ""
    StrCpy $sDirectoryFolder "$PROGRAMFILES\${CFG_PACKAGE}"
  ${Else}
    Call SaveOldConfigTemp
    ; strip the last part, reuse target and append current
    Push $sDirectoryFolder
    ${GetParent} $sDirectoryFolder $1
    ${If} $1 == ""
      StrCpy $sDirectoryFolder "$PROGRAMFILES\${CFG_PACKAGE}"
    ${Else}
      StrCpy $sDirectoryFolder "$1\${CFG_PACKAGE}"
    ${EndIf}
  ${EndIf}
  ; default StartMenuFolder
  StrCpy $sStartMenuFolder "${CFG_PACKAGE}"
  ; reuse previous menu folder
  ReadRegStr $0 "HKLM" "${UNINST_KEY_ROOT}\$sUpgrade" "Inno Setup: Icon Group"
  IfErrors PresetSections
  ${If} $0 != ""
    StrCpy $sStartMenuFolder $0
  ${EndIf}
  Goto PresetSections

Preset:
  ; predefine variables
  StrCpy $sUpgrade ""
  StrCpy $sDirectoryFolder "$PROGRAMFILES\${CFG_PACKAGE}"
  StrCpy $sStartMenuFolder "${CFG_PACKAGE}"
  StrCpy $iManualsCount 0
  StrCpy $sUninstKeyAdon ""
PresetSections:
  ; sections - default setup
  ; application already predefined in section definition
  ; check current language section for manual installation
  ${Select} $LANGUAGE
    ${Case} ${LANG_ID_CZECH}
      !insertmacro SetSectionInInstType ${SectionCzech} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionCzech}
    ${Case} ${LANG_ID_GERMAN}
      !insertmacro SetSectionInInstType ${SectionGerman} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionGerman}
    ${Default}
      !insertmacro SetSectionInInstType ${SectionEnglish} ${INSTTYPE_1}
      !insertmacro SelectSection ${SectionEnglish}
  ${EndSelect}
  !insertmacro SetSectionInInstType ${SectionShortcuts} ${INSTTYPE_1}
  !insertmacro SelectSection ${SectionShortcuts}
  !insertmacro SetSectionInInstType ${SectionDesktop} ${INSTTYPE_1}
  !insertmacro SelectSection ${SectionDesktop}

InitDone:
  ; setup proper mode name
  StrCpy $sUserSelection ""
FunctionEnd

; save old configuration
Function SaveOldConfigTemp
  Push $1
  StrCpy $1 "$sDirectoryFolder\.${CFG_PACKAGE}"
  ${If} ${FileExists} $1
    CopyFiles /SILENT $1 "$PLUGINSDIR"
  ${EndIf}
  Pop $1
FunctionEnd

; save old configuration
Function RestoreOldConfigTemp
  Push $1
  StrCpy $1 "$PLUGINSDIR\.${CFG_PACKAGE}"
  ${If} ${FileExists} $1
    CopyFiles /SILENT $1 $sDirectoryFolder
  ${EndIf}
  Pop $1
FunctionEnd

; based on mode continuation
Function DeleteFileIfExists
  Push $0
  Exch
  Exch $0
  ${If} ${FileExists} $0
    Delete $0
  ${EndIf}
  Pop $0
FunctionEnd

; $R9       current line
; $R8       current line number
; $R7       current line negative number
; $R6       current range of lines
; $R5       handle of a file opened to read
; $R4       handle of a file opened to write ($R4="" if "/NUL")
; you can use any string functions
; $R0-$R3  are not used (save data in them).
Function UnpngpackExtractAllCallBack
  ${StrTrimNewLines} $R9 $R9
  ;rendering btn-drive.png (opcodes 0 - 32)
  ${StrStrAdv} $R0 $R9 "rendering " ">" ">" "0" "0" "0"
  ${If} ${Errors}
    ClearErrors
  ${Else}
    ${If} $R0 != ""
      ${StrStrAdv} $R1 $R0 " (opcodes" ">" "<" "0" "0" "0"
      ${If} ${Errors}
        ClearErrors
      ${Else}
        ${If} $R1 != ""
          Push $R1
          Call FileToUninstallLog
        ${EndIf}
      ${EndIf}
    ${EndIf}
  ${EndIf}
  Push $0
FunctionEnd

; extract pngpack
; we are in the current directory by previous SetOutPath
; pngpack name is on the stack
Function UnpngpackExtractAll
  Push $0
  Exch
  Pop $0
  Push $1
  StrCpy $1 "$(^Extract)$0"
  DetailPrint "$1"
  unpngpack::ExtractAll $0
  Pop $1
  ${LineFind} "$OUTDIR\unpngpack.log" /NUL "1:-1" "UnpngpackExtractAllCallBack"
  ${If} ${Errors}
    Push "*.png"
    Call FileToUninstallLog
    ClearErrors
  ${EndIf}
  ${If} $1 != "success"
    Push "unpngpack.log"
    Call FileToUninstallLog
    Push "$OUTDIR\$0"
    Call DeleteFileIfExists
    SetErrors
  ${Else}
    Push "$OUTDIR\unpngpack.log"
    Call DeleteFileIfExists
    Push "$OUTDIR\$0"
    Call DeleteFileIfExists
    ClearErrors
  ${EndIf}
  Pop $1
  Pop $0
FunctionEnd

; based on mode continuation
Function PageStartmenu_Skip
  ${Unless} ${SectionIsSelected} ${SectionShortcuts}
    Abort
  ${EndIf}
FunctionEnd

Function RemovePrevious
  SetOutPath $PLUGINSDIR
  ; did we found any?
  StrCmp $sUpgrade "" RemoveDone
  ReadRegStr $1 "HKLM" "${UNINST_KEY_ROOT}\$sUpgrade" "QuietUninstallString"
  IfErrors TryNormal
  StrCmp $1 "" TryNormal
  ExecWait '$1'
  Sleep 1000
  Goto RemoveDone

TryNormal:
  ReadRegStr $1 "HKLM" "${UNINST_KEY_ROOT}\$sUpgrade" "UninstallString"
  IfErrors RemoveDone
  StrCmp $1 "" RemoveDone
  ExecWait '$1'
  Sleep 1000
RemoveDone:
FunctionEnd

Function GlobalErrorAbort
  Pop $0
  ${Unless} ${Silent}
    MessageBox MB_ICONSTOP|MB_OK "$0$\r$\rThe installer will be terminated and the system will be cleaned."
  ${EndIf}
  ; write log
  ${FinishLog} "Error installing ${CFG_PACKAGE} ${CFG_VERSION}.${RELEASE_MICRO}.${RELEASE_MICRO}"
  ; reverse playback of uninstall.log
  ${FileReadFromEnd} "$PLUGINSDIR\${UNINST_LOG_NAME}" "UninstallLogReversePlaybackCallBack"
  ${If} ${Errors}
    ${Unless} ${Silent}
      ; inform
      MessageBox MB_ICONSTOP|MB_OK "The rollback of the ${UNINST_LOG_NAME} was not successful.$\r$\rPlease revise the installation directory '$sDirectoryFolder' with the ${UNINST_LOG_NAME} file help manually."
    ${EndIf}
  ${Else}
    Delete "$PLUGINSDIR\${UNINST_LOG_NAME}"
  ${EndIf}
  Abort
FunctionEnd

Function GlobalErrorNoAbort
  Exch $0
  ${Unless} ${Silent}
    MessageBox MB_ICONSTOP|MB_OK "$0$\r$\rThe installer will continue but the installation is not complete."
  ${EndIf}
  Pop $0
FunctionEnd

; play uninstall.log in the reverse direction
; $9 current line
; $8 current line number
; $7 current line negative number
; $R0-$R9  are not used (save data in them).
Function UninstallLogReversePlaybackCallBack
  ${StrTrimNewLines} $R9 $9
  StrLen $R0 $R9
  ${If} $R0 > 2
    StrCpy $R0 $R9 1
    StrCpy $R1 $R9 "" 1
    ${Select} $R0
      ${Case} "D"
        ; remove directory
        RMDir $R1
      ${Case} "F"
        ; remove file
        Delete $R1
      ${Case} "S"
        ; remove subkey
        DeleteRegKey /ifempty "HKLM" $R1
      ${Case} "V"
        ; split path and value
        Push $R1
        Call SplitLastField
        Pop $R2
        Pop $R1
        ; remove value
        DeleteRegValue "HKLM" $R1 $R2
    ${EndSelect}
    ClearErrors
  ${EndIf}
  ${If} $8 == "0"
    StrCpy $0 "StopFileReadFromEnd"
  ${Endif}
  Push $0
FunctionEnd

; split last field
Function SplitLastField
  Exch $0
  Push $1
  ${StrStrAdv} $1 $0 "\" "<" ">" "0" "0" "0"
  ${StrStrAdv} $0 $0 "\" "<" "<" "0" "0" "0"
  Exch $1
  Exch
  Exch $0
  Exch
FunctionEnd


;Uninstaller Section
Section "Uninstall"
  ; uninstall.log
  ${If} ${FileExists} "$INSTDIR\${UNINST_LOG_NAME}"
    CopyFiles "$INSTDIR\${UNINST_LOG_NAME}" "$PLUGINSDIR\${UNINST_LOG_NAME}"
    ${un.FileReadFromEnd} "$PLUGINSDIR\${UNINST_LOG_NAME}" "un.UninstallLogReversePlaybackCallBack"
    ${If} ${Errors}
      ${Unless} ${Silent}
        MessageBox MB_ICONSTOP|MB_OK "Error occured reading the uninstall file ${UNINST_LOG_NAME}.$\r$\rThe uninstaller will be terminated."
      ${EndIf}
      Delete "$PLUGINSDIR\${UNINST_LOG_NAME}"
      Abort
    ${EndIf}
  ${Else}
    ${Unless} ${Silent}
      MessageBox MB_ICONSTOP|MB_OK "The file ${UNINST_LOG_NAME} does not exist.$\r$\rThe uninstaller will be terminated."
    ${EndIf}
  ${EndIf}
  ; should we clean other places?
SectionEnd

;Uninstaller Functions
Function un.onInit
  ; do we have necessary rights for uninstall if other user?

  ; scan uninstall.log for language
  ${If} ${FileExists} "$INSTDIR\${UNINST_LOG_NAME}"
    ${un.LineFind} "$INSTDIR\${UNINST_LOG_NAME}" /NUL "1:-1" "un.FindInstallerLanguageCallBack"
    ${If} ${Errors}
      StrCpy $0 ""
      ClearErrors
    ${EndIf}
  ${Else}
    ${Unless} ${Silent}
      MessageBox MB_ICONSTOP|MB_OK "The file ${UNINST_LOG_NAME} does not exist.$\r$\rThe uninstaller will be terminated."
    ${EndIf}
    Abort
  ${EndIf}
  ${If} $LANGUAGE == ""
    !insertmacro MUI_UNGETLANGUAGE
  ${Endif}
FunctionEnd

; $R9       current line
; $R8       current line number
; $R7       current line negative number
; $R6       current range of lines
; $R5       handle of a file opened to read
; $R4       handle of a file opened to write ($R4="" if "/NUL")
; you can use any string functions
; $R0-$R3  are not used (save data in them).
Function un.FindInstallerLanguageCallBack
  ${UnStrTrimNewLines} $R9 $9
  StrLen $R0 $R9
  ${If} $R0 > 2
    StrCpy $R0 $R9 1
    ${If} $R0 == "L"
      StrCpy $LANGUAGE $R9 "" 1
      StrCpy $0 "StopLineFind"
    ${EndIf}
  ${EndIf}
  Push $0
FunctionEnd

; play uninstall.log in the reverse direction
; $9 current line
; $8 current line number
; $7 current line negative number
; $R0-$R9  are not used (save data in them).
Function un.UninstallLogReversePlaybackCallBack
  ${UnStrTrimNewLines} $R9 $9
  StrLen $R0 $R9
  ${If} $R0 > 2
    StrCpy $R0 $R9 1
    StrCpy $R1 $R9 "" 1
    ${Select} $R0
      ${Case} "D"
        ; remove directory
        RMDir $R1
      ${Case} "F"
        ; remove file
        Delete $R1
      ${Case} "S"
        ; remove subkey
        DeleteRegKey /ifempty "HKLM" $R1
      ${Case} "V"
        ; split path and value
        Push $R1
        Call un.SplitLastField
        Pop $R2
        Pop $R1
        ; remove value
        DeleteRegValue "HKLM" $R1 $R2
    ${EndSelect}
    ClearErrors
  ${EndIf}
  ${If} $8 == "0"
    StrCpy $0 "StopFileReadFromEnd"
  ${Endif}
  Push $0
FunctionEnd

; split last field
Function un.SplitLastField
  Exch $0
  Push $1
  ${UnStrStrAdv} $1 $0 "\" "<" ">" "0" "0" "0"
  ${UnStrStrAdv} $0 $0 "\" "<" "<" "0" "0" "0"
  Exch $1
  Exch
  Exch $0
  Exch
FunctionEnd
