/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "discover.h"
#include "utils.h"

struct others_info *others_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL;
  struct pcmcia_info *pcmcia = (struct pcmcia_info *)NULL;
  struct isa_info *isa = (struct isa_info *)NULL;
  struct serial_info *serial = (struct serial_info *)NULL;
  struct usb_info *usb = (struct usb_info *)NULL;
  struct others_info *result = (struct others_info *)NULL;
  static struct others_info *first = (struct others_info *)NULL;


  if(first){
    return first;
  }/*endif*/

  if(debug){
    printf("\nListing other devices...\n");
  }/*endif*/
  
  /********************************************************************/
  /********************** PCI DEVICES *********************************/
  /********************************************************************/
  if(debug){
    printf("\tSearching PCI devices...\n");
  }/*endif*/
  for(pci = bus->pci; pci; pci = pci->next){
    if(pci->type == UNKNOWN_DEVICE){
      if(!first){
        first = result = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
      }else{
        result->next = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
        result = result->next;
      }/*endif*/
      result->next = (struct others_info *)NULL;
      result->long_id = pci->id;
      result->vendor = pci->vendor;
      result->model = pci->model;
      result->device = s_not_available;
      result->module = pci->modulename;
      result->bus= PCI;
      if(debug){
        printf("\t\tFound %s %s (ID=%ld)\n", 
                        result->vendor, result->model, result->long_id);
      }/*endif*/
    }/*endif*/
  }/*next pci*/

  /********************************************************************/
  /********************* PCMCIA DEVICES *******************************/
  /********************************************************************/
  if(debug){
    printf("\tSearching PCMCIA devices...\n");
  }/*endif*/
  for(pcmcia = bus->pcmcia; pcmcia; pcmcia = pcmcia->next){
    if(pcmcia->type == UNKNOWN_DEVICE){
      if(!first){
        first = result = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
      }else{
        result->next = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
        result = result->next;
      }/*endif*/
      result->next = (struct others_info *)NULL;
      result->long_id = pcmcia->id;
      result->vendor = pcmcia->vendor;
      result->model = pcmcia->model;
      result->device = s_not_available;
      result->module = pcmcia->modulename;
      result->bus= PCMCIA;
      if(debug){
        printf("\t\tFound %s %s\n", result->vendor, result->model);
      }/*endif*/
    }/*endif*/
  }/*next pci*/


  /********************************************************************/
  /********************** USB DEVICES *********************************/
  /********************************************************************/
  if(debug){
    printf("\tSearching USB devices...\n");
  }/*endif*/
  for(usb = bus->usb; usb; usb = usb->next){
    if((usb->type == UNKNOWN_DEVICE) && (usb->id != 0)){
      if(!first){
        first = result = (struct others_info *)
                                  my_malloc(sizeof(struct others_info));
      }else{
        result->next = (struct others_info *)
                                  my_malloc(sizeof(struct others_info));
        result = result->next;
      }/*endif*/
      result->next = (struct others_info *)NULL;
      result->long_id = usb->id;
      result->vendor = usb->vendor;
      result->model = usb->model;
      result->device = s_not_available;
      result->module = usb->modulename;
      result->bus= USB;
      if(debug){
        printf("\t\tFound %s %s\n", result->vendor, result->model);
      }/*endif*/
    }/*endif*/
  }/*next pci*/
  
  /********************************************************************/
  /********************** ISA DEVICES *********************************/
  /********************************************************************/
  if(debug){
    printf("\tSearching ISA devices...\n");
  }/*endif*/
  for(isa = bus->isa; isa; isa = isa->next){
    if(isa->type == UNKNOWN_DEVICE){
      if(!first){
        first = result = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
      }else{
        result->next = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
        result = result->next;
      }/*endif*/
      result->next = (struct others_info *)NULL;
      
      result->board_num = isa->board_num;
      result->board_id = isa->board_id;
      result->dev_num = isa->dev_num;
      result->dev_id = isa->dev_id;
      result->vendor = isa->vendor;
      result->model = isa->model;
      result->device = s_not_available;
      result->module = isa->modulename;
      result->io = isa->io;
      result->irq = isa->irq;
      result->bus = ISA;
      if(debug){
        printf("\t\tFound %s %s\n", result->vendor, result->model);
      }/*endif*/
    }/*endif*/
  }/*next isa*/
  
  /********************************************************************/
  /********************** Serial DEVICES ******************************/
  /********************************************************************/
  if(debug){
    printf("\tSearching SERIAL devices...\n");
  }/*endif*/
  for(serial = bus->serial; serial; serial = serial->next){
    if((serial->type == UNKNOWN_DEVICE) && (serial->dev_id != s_unknown)){
      if(!first){
        first = result = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
      }else{
        result->next = (struct others_info *) 
                                  my_malloc(sizeof(struct others_info));
        result = result->next;
      }/*endif*/
      result->next = (struct others_info *)NULL;
      
      result->long_id = 0;
      result->board_id = s_not_available;
      result->board_num = -1;
      result->dev_id = serial->dev_id;
      result->dev_num = -1;
      result->vendor = serial->vendor;
      result->model = serial->model;
      result->device = serial->device;
      result->module = serial->modulename;
      result->bus = SERIAL;
      result->io = -1;
      result->irq = -1;
      if(debug){
        printf("\t\tFound %s %s [%s]\n",
                         result->vendor, result->model, result->device);
      }/*endif*/
    }/*endif*/
  }/*nxt serial*/

  return first;
}/*endfunc others_detect*/
