/*
 * discover: a library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "discover.h"
#include "utils.h"



extern struct bridge_info *bridge_detect(struct bus_lst *bus){
  struct pci_info *pci = (struct pci_info *)NULL;
  struct bridge_info *result = (struct bridge_info *)NULL;
  static struct bridge_info *first = (struct bridge_info *)NULL;
  
  if(first){
    return first;
  }/*endif*/
  
  if(debug)
    fprintf(stdout, "\nProbing bridge...\n");
  
  /********************************************************************/
  /******************* PCI BRIDGE CARD DETECTION ********************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing PCI bridge...\n");
  
  for(pci = bus->pci; pci; pci = pci->next){
    if(pci->type == BRIDGE){
      if(!first){
        first = result = (struct bridge_info *) 
	  my_malloc(sizeof(struct bridge_info));
      }else{
        result->next = (struct bridge_info *) 
	  my_malloc(sizeof(struct bridge_info));
        result = result->next;
      }/*endif*/
      result->next = (struct bridge_info *)NULL;
      result->vendor = pci->vendor;
      result->model = pci->model;
      result->module = pci->modulename;
      result->long_id = pci->id;
      result->bus = PCI;
      if(debug)
	fprintf(stdout, "\t\tFound %s %s\n", 
		result->vendor, result->model);
    }/*endif*/
  }/*next pci*/


  return first;
}/*endfunc bridge_detect*/
