DACS_TOKEN(8)              DACS Web Services Manual              DACS_TOKEN(8)



[1mNAME[0m
       dacs_token - manage DACS one-time password token accounts

[1mSYNOPSIS[0m
       [1mdacs_token [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_token [22mweb service provides limited account management
       operations on accounts recognized by [34m[1mlocal_token_authenticate[0m[1m[22m[2], a
       [1mDACS [22mauthentication module. Full administrative functionality is
       provided by [1mdacstoken[22m; refer to [34m[1mdacstoken(1)[0m[1m[22m[3] for detailed
       information about one-time passwords, token devices, and user accounts.
       These accounts are completely separate from any other accounts and
       passwords.

       Subject to configuration and valid authorization, this web service
       lets:

       +o   users set an initial PIN for their account (note that his presents
           a window of opportunity for an attacker that has obtained a
           PIN-less token);

       +o   users change the PIN on their account;

       +o   users synchronize their account with their token; and

       +o   [1mDACS [22madministrators (see [34m[1mADMIN_IDENTITY[0m[1m[22m[4]) set, change, or remove
           the PIN on any account, synchronize an account with a token
           (removal depends on [34m[1mTOKEN_REQUIRES_PIN[0m[1m[22m[5]), or obtain the next OTP
           for a specified account;

       +o   anyone create and test a demonstration account (visit
           [34m[1mdacs.dss.ca[0m[1m[22m[6] to try a live demonstration).


       Outside of demonstration mode operation, accounts are managed
       identically to [34m[1mdacstoken(1)[0m[1m[22m[3] using the item types auth_token,
       auth_hotp_token, and auth_totp_token.

           [1mSecurity[0m
           The same account security stipulations as [1mdacstoken [22mapply.

           The web service applies access controls internally; a [1mDACS [22mACL can
           be added to further restrict its use. The internal rules are:

           +o   A [1mDACS [22madministrator can synchronize any account without
               providing the account's PIN; other users must provide the
               account's PIN, if there is one.

           +o   A [1mDACS [22madministrator can set, change, or remove (depending on
               [34m[1mTOKEN_REQUIRES_PIN[0m[1m[22m[5]) any account's PIN; other users can set
               or change their account's PIN by:

               +o   authenticating as the username of the account being
                   accessed (if the account has a PIN and the user has
                   forgotten it, presumably a different authentication method
                   must be used); or

               +o   contacting a [1mDACS [22madministrator.

               +o   Demonstration mode is enabled if the item type
                   auth_token_demo is defined; otherwise, if
                   auth_token_hotp_demo is defined, then demonstration mode
                   for HOTP is enabled, and if auth_token_totp_demo is
                   defined, then demonstration mode for TOTP is enabled. If
                   none of these item types is enabled, which is the default,
                   then demonstration mode is inoperative.


       When validating a HOTP one-time password, the
       [34m[1mTOKEN_HOTP_ACCEPT_WINDOW[0m[1m[22m[7] configuration directive can be used to
       allow an account's counter value to automatically "catch up" to the
       token's.

[1mOPTIONS[0m
   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[8], [1mdacs_token [22munderstands
       the following CGI arguments:

       [4mCONFIRM_NEW_PIN[0m
           Required with the SET_PIN operation, the value of this argument
           must be the same as the value of [4mCONFIRM_NEW_PIN[24m.

       [4mOPERATION[0m
           The following operations are supported:

           +o   CURRENT

               Unlike the other operations, this operation returns a
               text/plain MIME type, consisting of the current [4mmoving[24m [4mfactor[0m
               (i.e., the HOTP counter value or the TOTP interval value),
               followed by a space and the corresponding OTP for [4mUSERNAME[24m.
               This facilitates an easy-to-use, REST-type interface. In the
               case of HOTP, the counter value is advanced, "consuming" the
               OTP. Only an administrator is allowed to perform this
               operation, which can be used to build a simple mutual
               authentication capability:

                1. The user gives a username to the sign-on procedure;

                2. The sign-on procedure asks [1mDACS [22mfor the OTP it expects the
                   user's token to produce, based on the user's account
                   parameters;

                3. The sign-on procedure presents the OTP to the user, who
                   verifies its correctness by matching the presented OTP with
                   the one actually produced by the token;

                4. The user continues the authentication procedure, perhaps by
                   providing the token's next OTP or using another
                   authentication method, such as a password.
                   The appropriateness of TOTP mode for mutual authentication
                   depends on the OTP lifetime and other configuration
                   parameters.

               +o   SET_PIN

                   Set or change the PIN associated with the account for
                   [4mUSERNAME[24m. This operation requires the [4mNEW_PIN[24m,
                   [4mCONFIRM_NEW_PIN[24m, [4mMODE[24m, and [4mUSERNAME[24m arguments.

               +o   SYNC

                   Synchronize the account for [4mUSERNAME[24m so that the next
                   password produced by the token is expected to be valid.
                   This operation requires the [4mPASSWORD[24m, [4mMODE[24m, and [4mUSERNAME[0m
                   arguments.

               +o   DEMO_CREATE

                   Create a demonstration account according to the given
                   arguments, configuration values, and defaults. Required
                   arguments: [4mMODE[24m, [4mKEY[24m. Optional arguments: [4mNEW_PIN[24m,
                   [4mCONFIRM_NEW_PIN[24m, [4mNDIGITS[24m, [4mBASE[24m, [4mSERIAL[24m. Optional HOTP
                   argument: [4mCOUNTER[24m. Optional TOTP arguments: [4mDIGEST_NAME[24m,
                   [4mTIME_STEP[24m.

               +o   DEMO_SYNC

                   Synchronize a demonstration account using [4mUSERNAME[24m, a
                   one-time password or password sequence ([4mSYNC[24m), and optional
                   [4mPIN[24m.

               +o   DEMO_VALIDATE

                   Validate the given demonstration account ([4mUSERNAME[24m),
                   one-time password ([4mPASSWORD[24m), and PIN ([4mPIN[24m) in
                   demonstration mode. No credentials are actually issued.

               [4mMODE[0m
                   This argument is the device mode, which may be (case
                   insensitively) counter or hotp for counter mode, or time or
                   totp for time-based mode.

               [4mNEW_PIN[0m
                   With the SET_PIN operation, this is the new PIN to
                   associate with the account. An administrator can remove the
                   PIN entirely, provided it is allowed by
                   [34m[1mTOKEN_REQUIRES_PIN[0m[1m[22m[5], by omitting (or not providing a
                   value for) both [4mNEW_PIN[24m and [4mCONFIRM_NEW_PIN[24m.

               [4mPASSWORD[0m
                   If the request is not accompanied by credentials for
                   [4mUSERNAME[24m or an administrator identity, this one-time
                   password must validate against the expected value for
                   [4mUSERNAME[24m.

               [4mPIN[0m

               [4mUSERNAME[0m
                   The [1mDACS [22musername of interest.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       This version only provides self-service operations for users and
       limited account management for a [1mDACS [22madministrator; administrators
       must use [34m[1mdacstoken(1)[0m[1m[22m[3] for everything else. Full-blown web-based
       token account management should either be provided by [1mdacs_token [22mor
       [34m[1mdacs_admin[0m[1m[22m[9].

       Demonstration mode accounts should be manually deleted from time to
       time.

       The [4mFORMAT[24m is not understood. XML responses should be implemented.

[1mSEE ALSO[0m
       [34m[1mdacstoken(1)[0m[1m[22m[3], [34m[1mdacs.conf(5)[0m[1m[22m[10], [34m[1mdacs_authenticate(8)[0m[1m[22m[11]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[12])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[13] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_token_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_token_authenticate

        3. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

        4. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

        5. TOKEN_REQUIRES_PIN
           http://dacs.dss.ca/man/dacs.conf.5.html#TOKEN_REQUIRES_PIN

        6. dacs.dss.ca
           http://dacs.dss.ca

        7. TOKEN_HOTP_ACCEPT_WINDOW
           http://dacs.dss.ca/man/dacs.conf.html#TOKEN_HOTP_ACCEPT_WINDOW

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. dacs_admin
           http://dacs.dss.ca/man/dacs_admin.8.html

       10. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       11. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       12. www.dss.ca
           http://www.dss.ca

       13. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                     DACS_TOKEN(8)
