DACS.GROUPS(5)                DACS Formats Manual               DACS.GROUPS(5)



[1mNAME[0m
       dacs.groups - [1mDACS [22mgroups

[1mDESCRIPTION[0m
       These files are part of the [1mDACS [22msuite.

       Groups are a convenient shorthand for a jurisdiction's administrator to
       use when specifying access control rules. Rather than explicitly
       listing the set of users who have certain access rights to a service,
       an administrator can reference a group name that represents the
       membership of the set. The set's membership is built dynamically and
       consists of any combination of users and other group names. The
       membership of a particular group may vary over time and is resolved
       when a service request is subjected to access control. A jurisdiction
       may define any number of groups and specify their membership; these
       definitions may then be referenced by other jurisdictions, in their
       access control rules and their group definitions. It is the task of the
       [1mDACS [22mgroup membership service to manage group membership and determine
       the set of users who belong to each group defined within [1mDACS[22m.

       A group's membership is determined solely by the administrator of the
       jurisdiction that defines it, unless membership is delegated to other
       jurisdictions.

       For its own purposes, a jurisdiction often maintains group membership
       information, such as the organizational unit within the jurisdiction to
       which each of its users belong.  [1mDACS [22mcan consult such a group
       membership database to associate roles (or "internal-group membership")
       with the jurisdiction's users. This separately maintained information
       may easily be imported into [1mDACS[22m, eliminating the administrative burden
       that would arise from having to maintain the same information within
       two different systems.

       When [1mDACS [22mneeds to resolve group membership to determine whether the
       user making a service request is a member of a particular group, it may
       need to consult any combination of local group definitions, the roles
       associated with the user, and remote group definitions (groups defined
       by other jurisdictions).

       [1mDACS [22mdoes not dictate any particular method of storing group
       information; group information is accessed through the [1mDACS [22mvirtual
       filestore.

       Every referenced group must be defined somewhere within [1mDACS[22m, whether
       locally or by another jurisdiction, before the referencing group is
       considered valid by [1mDACS[22m.

   [1mRole-Based Group Membership[0m
       Jurisdictions (such as companies or organizations) typically have a
       hierarchical internal structure, perhaps based on subdivisions such as
       departments, groups, projects, and so on, and typically associate an
       individual with one or more of these subdivisions. Alternatively, they
       might use a organizational structure that is based on the role of each
       individual. Regardless of the type of structure, jurisdictions may have
       information services that describe and manage where an individual
       belongs within that structure. A directory system, such as X.500 or
       Microsoft's Active Directory, which is typically accessible using the
       Lightweight Directory Access Protocol (LDAP), is a common example of
       such an information service. Another example is Unix-type systems,
       which assign their users to groups for access control purposes. By
       exporting this information, a jurisdiction can use [1mDACS [22mto provide
       role-based security.

       [1mDACS [22muses the concept of a role-based group to allow a jurisdiction to
       implicitly create groups and associate users with them. At
       authentication time, a jurisdiction can indicate which roles a user
       belongs to within the jurisdiction. This information becomes part of
       the user's credentials and is consulted when determining whether the
       user is a member of a given group. The entire membership of a
       role-based group, potentially very large and possibly sensitive, need
       never be revealed or distributed to other jurisdictions.

       Group information may sometimes be extracted from a directory system by
       processing the distinguished names of users. Consider the distinguished
       name:

           {cou=CA, prov=BC, o=BigBank, ou=RandD, ou=Software, ou=Networks, cn=Auggie Doggie}

       For this individual, a role descriptor asserting membership in three
       groups within the jurisdiction might be produced: 1) RandD, 2) Software
       within RandD, and 3) Networks within Software under RandD. Within [1mDACS[0m
       access control rules, these groups might be referred to as
       "%BigBank:RandD", "%BigBank:RandD-Software", and
       "%BigBank:RandD-Software-Networks". These group names may also be
       included in the membership of other groups. Also, a group having one of
       these names can be defined and administered using [1mDACS[22m's standard group
       membership methods; its membership is the union of the role-based group
       members and the explicitly named group members.

       A concise syntax is available for expressing hierarchically-related
       elements of a role descriptor. The role descriptor
       "RandD/Software/Networks" is an equivalent way of expressing the
       three-element descriptor given above.

       It is relatively easy for a jurisdiction to use its existing services
       to export the required role description to [1mDACS[22m. The Roles clause (see
       [34m[1mdacs.conf(5)[0m[1m[22m[1]) configures how this is done.

   [1mGroup Syntax and Semantics[0m
       The following BNF syntax describes the names and symbols used in group
       definitions. Upper and lower case are distinct in the defined strings
       and all strings are constructed from a subset of the printable ASCII
       characters (e.g., the group name DSS:abc is different from the group
       name DSS:AbC).

           <Jurisdiction-Name>       ::= [A-Za-z][A-Za-z0-9\-_]*
           <Jurisdiction-Group-Name> ::= [A-Za-z][A-Za-z0-9\-_]*

       Thus, jurisdiction names and group names are composed of upper and
       lower case letters, digits, dashes, and underscores and must begin with
       a letter.

       The name of a group is formed from two components:

           <Group-Name> ::= <Jurisdiction-Name> ':' <Jurisdiction-Group-Name>

       The <Jurisdiction-Name> is the unique, officially-assigned abbreviated
       name for the [1mDACS [22mjurisdiction. The <Jurisdiction-Group-Name> is a
       unique name for the group within the jurisdiction that defines the
       <Group-Name>.

       The following XML DTD is used as the external representation of group
       definitions and membership. It is used by [1mDACS [22mboth to distribute this
       information from one jurisdiction to another.

           <!ELEMENT groups (group_definition)* >

           <!ELEMENT group_definition (group_member*) >
           <!ATTLIST group_definition
               jurisdiction    CDATA #REQUIRED
               name            CDATA #REQUIRED
               mod_date        CDATA #REQUIRED
               type            (public | private) #REQUIRED
           >

           <!ELEMENT group_member EMPTY >
           <!ATTLIST group_member
               jurisdiction    CDATA #REQUIRED
               name            CDATA #REQUIRED
               alt_name        CDATA #IMPLIED
               type            (role | dacs | username | meta) #REQUIRED
               dacs_url        CDATA #IMPLIED
               authenticates   (yes | no) #IMPLIED
               prompts         (yes | no) #IMPLIED
               auxiliary       CDATA #IMPLIED
           >

       A group_definition gives the official name of the jurisdiction that
       defined the group (jurisdiction), a name for the group that is unique
       with that jurisdiction (name), the date and time the group's definition
       was last changed (mod_date) and whether the group's membership is to be
       kept private (type). The date and time are expressed in UTC and using a
       24 hour clock, in the format Wdy, DD-Mon-YYYY HH:MM:SS GMT, based on
       [34m[1mRFC 822[0m[1m[22m[2], with the variations that the only legal time zone is GMT
       and the separators between the elements of the date must be dashes. If
       public, the type attribute indicates that the group membership may be
       distributed to other jurisdictions and included in the definition of
       another group that is distributed.

       Each group_member specifies a member of the group. The type is role if
       the named member is a role, username if it is a [1mDACS [22musername, and dacs
       if it is the name of another [1mDACS [22mgroup. The special type meta is
       reserved for the internal use of [1mDACS [22mand associated with this type
       only is the presence of information about the jurisdiction: dacs_url,
       name, altname, authenticates, and prompts, each of which must be
       present for this type, and auxiliary, which is optional. Refer to [34m[1mDACS[0m
       [1m[34mMetadata[0m[1m[22m[3] for additional information.

           [1mNote[0m
           In conjunction with [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[4], if the dacs_url
           attribute value does not begin with "http" or "https", then name
           interpolation is performed on the value as if by the [34m[1mpathname()[0m[1m[22m[5]
           function with [4mhostname[24m formed by prepending the name attribute
           value to the [34m[1mFEDERATION_DOMAIN[0m[1m[22m[6] and [4mport[24m obtained from the port
           associated with the [1mdacs_list_jurisdictions [22mrequest.

           For example, assuming FEDERATION_DOMAIN is test-03.example.com and
           given the entry:

               <group_member jurisdiction="METALOGIC" name="Metalogic"
                 type="meta" alt_name="Metalogic Software Corp."
                 dacs_url="%2+/metalogic/dacs" authenticates="yes"
                prompts="no" auxiliary="local" />

           and the request:

               http://test-03.example.com/fedadmin/dacs/dacs_list_jurisdictions

           then the effective value of dacs_url for the entry would be:

               http://test-03.example.com/metalogic/dacs

           And assuming FEDERATION_DOMAIN is dss.ca and given the entry:


               <group_member jurisdiction="DACS" name="DSS Inc." type="meta"
                alt_name="DSS Inc." dacs_url="%0:%p/cgi-bin/dacs" authenticates="yes"
                prompts="no" auxiliary="local" />

           and the request:

               https://bsd6.dss.ca:8443/cgi-bin/dacs/dacs_list_jurisdictions

           then the effective value of dacs_url would be:

               https://dacs.dss.ca:8443/cgi-bin/dacs

       If the type is role, any user who has credentials that name the given
       role is a member of the group.

       The appearance of a group name in the membership list of a group
       definition effectively inserts the entire membership of that referenced
       group in the definition. This type of inclusion is recursive, allowing
       for a configurable maximum depth. A cycle of inclusions is detected and
       not considered an error. Duplicate members are culled from the final
       membership list. All invalid group definitions are considered by [1mDACS[0m
       to have no members (that is, they are treated as having an empty
       membership list). The included group may belong to the same
       jurisdiction as the one being defined or it may refer to a group
       defined by some other jurisdiction. In the latter case, the
       administrator who defines the group delegates part of the
       responsibility for the group definition to another administrator who
       might do the same.

       A group may be defined to be empty (i.e., not having any members).

   [1mDACS Metadata[0m
       At each jurisdiction in a federation, [1mDACS [22mrequires metadata that
       describes the jurisdictions. This information might be used by
       middleware or client-side software, for instance, for creating a menu
       to present to the user, which would need to obtain a list of
       jurisdictions. The metadata is also used for various internal purposes.

           [1mImportant[0m
           The [1mDACS [22mmetadata is stored in a group definition named
           "jurisdictions" relative to the groups item type. By default, at a
           jurisdiction with [34m[1mJURISDICTION_NAME[0m[1m[22m[7] BOBO in a federation with
           [34m[1mFEDERATION_DOMAIN[0m[1m[22m[6] example.com, this will be a file named
           jurisdictions.grp in the directory
           /usr/local/dacs/federations/example.com/BOBO/DACS.

           [1mDACS [22mdoes not care about the values of the name and alt_name
           attributes, provided that they are well-formed. The alt_name might
           provide descriptive information in another language. These
           attributes might be used by middleware to construct a menu for
           users to select their home jurisdiction when logging in, for
           instance. For consistency, a federation should consider adopting a
           convention across all jurisdictions for how these two attributes
           are used.

           The dacs_url attribute is important because it tells [1mDACS [22mhow to
           construct a URL for any [1mDACS [22mweb service at the jurisdiction.

       Group information about jurisdictions is indicated by the meta
       attribute value for the type attribute.

       This example group definition describes a four jurisdiction [1mDACS[0m
       federation:

           <groups>
             <group_definition
               jurisdiction="DACS" name="jurisdictions" mod_date="Tue, 11-Sep-2001 3:00:00 GMT" type="public">

             <group_member jurisdiction="METALOGIC"
               name="Full name of this jurisdiction, in English"
               alt_name="Full name of this jurisdiction, in French"
               type="meta"
               dacs_url="http://metalogic.example.com/cgi-bin"
               authenticates="yes"
               prompts="no" />

             <group_member jurisdiction="BC"
               name="Full name of this jurisdiction, in English"
               alt_name="Full name of this jurisdiction, in French"
               type="meta"
               dacs_url="http://bc.example.com/cgi-bin"
               authenticates="yes"
               prompts="no" />

             <group_member jurisdiction="ON"
               name="Full name of this jurisdiction, in English"
               alt_name="Full name of this jurisdiction, in French"
               type="meta"
               dacs_url="http://on.example.com/cgi-bin/dacs"
               authenticates="yes"
               prompts="no" />

             <group_member jurisdiction="NF"
               name="Full name of this jurisdiction, in English"
               alt_name="Full name of this jurisdiction, in French"
               type="meta"
               dacs_url="http://nf.example.com/cgi-bin"
               authenticates="yes"
               prompts="yes" />

             </group_definition>
           </groups>


[1mEXAMPLES[0m
       The group ON:gis is defined by the jurisdiction ON to consist of three
       ordinary users:

           <groups>
             <group_definition
               jurisdiction="ON" name="gis" mod_date="Fri, 30-Nov-2001 13:17:00 GMT" type="public">
               <group_member jurisdiction="NF" name="alice@nf.example.org" type="username"/>
               <group_member jurisdiction="ON" name="bob@on.example.org" type="username"/>
               <group_member jurisdiction="METALOGIC" name="carol@example.org" type="username"/>
             </group_definition>
           </groups>

       This example defines a group that includes other groups as members:

           <groups>
             <group_definition
               jurisdiction="METALOGIC" name="admin" mod_date="Fri, 30-Nov-2001 9:17:00 GMT" type="public">
               <group_member jurisdiction="NF" name="admin" type="dacs"/>
               <group_member jurisdiction="ON" name="admin" type="dacs"/>
               <group_member jurisdiction="BC" name="admin" type="dacs"/>
               <group_member jurisdiction="NF" name="alice@gov.nf.example.org" type="username"/>
             </group_definition>

       The group METALOGIC:admin is defined by jurisdiction METALOGIC to
       consist of the membership of three other groups (NF:admin, ON:admin,
       and BC:admin) and a user.

       This group, BC:nobody, has no members:

           <groups>
             <group_definition
               jurisdiction="BC" name="nobody" mod_date="Fri, 30-Nov-2001 10:17:00 GMT" type="public"/>
           </groups>

       Here is an example of a private group:

           <groups>
             <group_definition
               jurisdiction="BC" name="pilot_admin" mod_date="Fri, 28-Dec-2001 23:59:00 GMT" type="private">
               <group_member jurisdiction="BC" name="brain@bc.example.com" type="username"/>
             </group_definition>
           </groups>

       As the first group in the example above has been declared to be
       private, access control rules may be constructed to make its membership
       invisible to other jurisdictions, to forbid its definition from being
       forwarded to other jurisdictions, and so on.

       Here is a group with dynamic, role-based membership:

           <groups>
             <group_definition
               jurisdiction="BC" name="admin" mod_date="Wed, 22-Aug-2001 17:51:00 GMT" type="public">
               <group_member jurisdiction="BC" name="ou_admin" type="role"/>
               <group_member jurisdiction="METALOGIC" name="bobo@example.com" type="username"/>
               <group_member jurisdiction="BC" name="admin" type="dacs"/>
             </group_definition>
           </groups>

       This definition references a role (ou_admin), a username, and a group.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[8])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[9] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. [1mdacs.conf(5)[0m
           http://dacs.dss.ca/man/dacs.conf.5.html

        2. RFC 822
           http://www.rfc-editor.org/rfc/rfc822.txt

        3. DACS Metadata
           http://dacs.dss.ca/man/#dacs_metadata

        4. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

        5. pathname()
           http://dacs.dss.ca/man/dacs.exprs.5.html#pathname

        6. FEDERATION_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_DOMAIN

        7. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                    DACS.GROUPS(5)
