AUTOLOGIN(8)               DACS Web Services Manual               AUTOLOGIN(8)



[1mNAME[0m
       autologin - Convert an Apache identity to a [1mDACS [22midentity

[1mSYNOPSIS[0m
       [1mautologin [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mautologin [22mCGI program, in conjunction with appropriate [1mApache [22mand
       [1mDACS [22mconfiguration, is used to automatically convert an identity
       already established by [1mApache [22minto a [1mDACS [22midentity. After standard HTTP
       Basic or Digest Authentication ([34m[1mRFC 2617[0m[1m[22m[2]) has been performed
       successfully, [1mautologin [22mcauses [1mDACS [22mcredentials to be generated and
       returned. This capability lets [1mDACS [22mleverage any of [1mApache's [22mexisting
       authentication methods through simple configuration.

       A user that has completed Basic or Digest Authentication (following a
       401 Authorization Required response from the web server) accesses
       [1mautologin[22m.  [1mautologin [22mgenerates credentials by constructing a request
       to [34m[1mdacs_authenticate(8)[0m[1m[22m[3]. The value of the [1mREMOTE_USER [22menvironment
       variable, as set by [1mApache[22m, is used by [1mdacs_authenticate [22mto derive the
       [1mDACS [22musername.

           [1mNote[0m
           [1mautologin [22mis not installed by default when [1mDACS [22mis built, in part
           because it can be a bit tricky to configure correctly and securely.
           The more recent [34m[1mRFC 2617[0m[1m[22m[2] capability built-in to [1mDACS [22mis
           recommended instead. Please refer to the section on [34m[1mHTTP[0m
           [1m[34mAuthentication[0m[1m[22m[4].

           [1mSecurity[0m
           Because this program is run during authentication processing, its
           file permissions must be set to prevent replacement or alteration
           by users other than a [1mDACS [22madministrator.

[1mOPTIONS[0m
       Only the standard [34m[4mdacsoptions[0m[4m[24m[1] command line arguments are recognized.

   [1mWeb Service Arguments[0m
       [1mautologin [22munderstands the following CGI arguments. All arguments are
       required unless otherwise indicated.

       [4mDACS_CONF[0m
           The path to the [1mDACS [22mconfiguration file that should be used to
           locate jurisdiction configuration information needed by
           [1mdacs_authenticate[22m.

       [4mDACS_ERROR_URL[0m
           When [1mautologin [22mis invoked as a result of [1mDACS [22mevent handling,
           [4mDACS_ERROR_URL[24m is automatically passed by [34m[1mdacs_acs(8)[0m[1m[22m[5] and
           represents the original URL to which access was denied. In typical
           use, [1mautologin [22mis configured as the handler for a [1mdacs_acs 902[0m
           error code (NO_AUTH, "Authentication by DACS is required").
           [1mautologin [22mthen invokes [1mdacs_authenticate[22m. If [1mDACS [22mauthentication is
           successful, [1mdacs_authenticate [22mordinarily issues a browser redirect
           to the value of [4mDACS_ERROR_URL[24m and a cookie bearing the credentials
           are set in the browser (but see the [4mNOREDIRECT[24m argument).

       [4mNOREDIRECT[0m
           If this optional argument is present (its value is immaterial),
           [1mautologin [22minstructs [1mdacs_authenticate [22mto [4mnot[24m issue a browser
           redirect to the value of [4mDACS_ERROR_URL[24m.

       [4mDACS_JURISDICTION[0m
           When [1mautologin [22mis invoked as a result of [1mDACS [22mevent handling,
           [4mDACS_JURISDICTION[24m is set by [1mDACS [22mto the name of the jurisdiction
           that received the request. By default, [1mautologin [22mgenerates
           credentials for the jurisdiction at which [1mdacs_authenticate [22mis
           invoked (specifically, [4mDACS_JURISDICTION[24m). This can be overridden
           by the [4mDACS_SET_JURISDICTION[24m parameter.

       [4mDACS_SET_JURISDICTION[0m
           This optional argument explicitly names the jurisdiction in which
           [1mautologin [22mshould generate credentials.  [4mDACS_SET_JURISDICTION[0m
           overrides the value, if any, of [4mDACS_JURISDICTION[24m and [4mmust[24m [4mbe[24m [4mthe[0m
           [4msame[24m [4mas[24m [4mthe[24m [4mjurisdiction[24m [4min[24m [4mwhich[24m [1mautologin [4m[22mis[24m [4mdeployed[24m.

       [4mJURISDICTION_URI[0m
           This is the URI identifying the jurisdiction in the [1mDACS[0m
           configuration file corresponding to the value specified in a
           [4mDACS_JURISDICTION[24m or [4mDACS_SET_JURISDICTION[24m argument. This argument
           is optional since the jurisdiction name can be used for this
           purpose.

       [4mjust_dump_stdin[0m
           This optional argument is useful for debugging. If the value of
           [1mQUERY_STRING [22mis exactly jump_dump_stdin, then the program will
           simply copy its standard input to the standard output as
           text/plain.

[1mEXAMPLE[0m
       A typical use of [1mautologin [22mis to support coexistence on the same Web
       site of [1mDACS[22m-wrapped content, services. legacy applications, or content
       deployed under HTTP Basic or Digest authentication. The following
       example illustrates configuration of [1mApache [22mand [1mDACS [22mfor the deployment
       under HTTP Basic authentication of a Web log application, [1mBlogo[22m.  [1mBlogo[0m
       will be deployed within a [1mDACS [22mjurisdiction METALOGIC. The URI space of
       interest will be example.com/metalogic/*.

       In the [1mApache [22mconfiguration file httpd.conf, a Location is defined for
       the [1mBlogo [22mapplication under Basic authentication:

           <Location /metalogic/blogo>
             AuthType Basic
             AuthName "FedDev"
             AuthUserFile /local/etc/auth-file
             Require valid-user
           </Location>

       A Location under Basic authentication also is defined where the
       [1mautologin [22mutility is deployed:

           <Location /metalogic/dacs-native>
             AuthType Basic
             AuthName "FedDev"
             AuthUserFile /local/etc/auth-file
             Require valid-user
           </Location>

       At the same time, other content in METALOGIC is protected by [1mDACS[22m:

           <Location /metalogic/dev>
             Allow from all
             AuthType DACS
             AuthDACS dacs-acs
             Require valid-user
           </Location>


           [1mNote[0m
           Basic authentication cannot be specified in a subdirectory of a
           directory or location that has been configured for [1mDACS [22maccess
           control. As above, [1mDACS [22mand Basic authentication must be configured
           in separate locations.

       In the [1mDACS [22mconfiguration file, dacs.conf, jurisdiction METALOGIC is
       configured as follows:

           <Jurisdiction uri="example.com/metalogic">

           JURISDICTION_NAME "METALOGIC"

           ACS_ERROR_HANDLER "902 https://example.com/metalogic/dacs-native/autologin\
           ?DACS_CONF=${Conf::DACS_CONF}&amp;JURISDICTION_URI=example.com/metalogic"

           <!-- Authenticate using Apache Basic/Digest Auth. -->
           <Auth id="native">
           URL "https://example.com/metalogic/dacs/local_native_authenticate"
           STYLE "native"
           CONTROL "sufficient"
           </Auth>

           </Jurisdiction>


           [1mNote[0m
           The native style of authentication [4mmust[24m be configured when
           [1mautologin [22mis being used as described. See [34m[1mdacs_authenticate(8)[0m[1m[22m[6].

       The preceding configuration results in the following behaviour. A user
       accessing [1mBlogo [22mdirectly (https://example.com/metalogic/blogo) is
       challenged to enter a valid username and password (with respect to the
       Apache accounts in /local/etc/auth-file). If the user subsequently
       accesses [1mDACS [22mcontent requiring [1mDACS [22mauthentication but no [1mDACS[0m
       credentials are present:

       +o   The [1m902 [22mevent handler is invoked, resulting in a browser redirect
           to [1mautologin[22m.

       +o   The [1mREMOTE_USER [22menvironment variable is present in the environment
           as a result of successful Basic authentication.

       +o   [1mautologin [22mruns [1mdacs_authenticate [22m(as a command, not as a web
           service).

       +o   [1mdacs_authenticate [22mthen invokes [1mlocal_native_authenticate[22m, which
           uses the value of [1mREMOTE_USER [22mas the [4mUSERNAME[24m argument.

       +o   If authentication succeeds, [1mDACS [22mcredentials for [1mREMOTE_USER [22min
           jurisdiction METALOGIC are generated. These credentials are
           returned to the browser within a cookie and the browser is
           redirected to the value of [4mDACS_ERROR_URL[24m (recall that
           [4mDACS_ERROR_URL[24m was passed to [1mautologin [22mby [1mdacs_acs [22mwhen the [1m902[0m
           handler was invoked and is forwarded to [1mdacs_authenticate[22m).


       If the user accesses [1mDACS [22mcontent without first visiting the [1mBlogo[0m
       application, the [1m902 [22mevent handler fires, resulting in a browser
       redirect to [1mautologin[22m. Since [1mautologin [22mis itself behind Basic
       authentication, the user will be prompted for a username and password.
       Once Basic authentication succeeds, [1mautologin [22mis invoked with
       [1mREMOTE_USER [22mset (and therefore so is [1mdacs_authenticate[22m) and the process
       described above is repeated.

       [1mautologin [22mmay also be used as the target of an explicit authentication
       link. For example:

           <a href="https://example.com/metalogic/dacs-native/autologin?\
           DACS_CONF=/local/dacs/federations/example.com/dacs.conf&\
           DACS_SET_JURISDICTION=METALOGIC&\
           JURISDICTION_URI=example.com/metalogic&\
           DACS_ERROR_URL=https://example.com">Login</a>

       Following the link above results first in a Basic authentication
       challenge and then sets [1mDACS [22mcredentials in jurisdiction METALOGIC.

[1mNOTES[0m
       [1mautologin [22mcannot generate credentials in a jurisdiction other than the
       one in which [1mautologin [22mis deployed.

       The behaviour of browsers with respect to the HTTP 401 Authorization
       status code may have undesired consequences. For example, browsers
       continually send username and password in any matching request. If a
       user does not exit the browser, this can result in [1mDACS [22mcredentials
       automatically being regenerated long after their configured lifetime
       has expired.  [34m[1mRFC 2617[0m[1m[22m[2] provides no way for the server to "signout" a
       user, and neither do many browsers ([34m[1mFirefox[0m[1m[22m[7] is an exception), other
       than by ending the browser session. This makes it inconvenient for a
       user to reauthenticate with respect to [1mDACS [22musing this technique.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[3] (in particular, the native authentication
       style), [34m[1mdacs_autologin_ssl(8)[0m[1m[22m[8], [34m[1mdacs_acs(8)[0m[1m[22m[5], [34m[1mdacs.conf(5)[0m[1m[22m[9]

[1mAUTHOR[0m
       [34m[1mMetalogic Software Corp.[0m[1m[22m[10] and Distributed Systems Software
       ([34m[1mwww.dss.ca[0m[1m[22m[11])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[12] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

        3. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        4. HTTP Authentication
           http://dacs.dss.ca/man/dacs_acs.8.html#http_authentication

        5. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        6. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_native_authenticate

        7. Firefox
           http://www.mozilla.com/firefox

        8. dacs_autologin_ssl(8)
           http://dacs.dss.ca/man/dacs_autologin_ssl.8.html

        9. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       10. Metalogic Software Corp.
           http://fedroot.com/admin/about-metalogic.shtml

       11. www.dss.ca
           http://www.dss.ca

       12. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                      AUTOLOGIN(8)
