.\" manual page [] for Bacula
.\" SH section heading
.\" SS subsection heading
.\" LP paragraph
.\" IP indented paragraph
.\" TP hanging label
.TH Bacula 8 "The Network Backup Solution"
.SH NAME
Bacula \- The Network Backup Solution            
.SH SYNOPSIS
.B bacula-dir \- Director
.br
.B bacula-fd \- File daemon or Client
.br
.B bacula-sd \- Storage daemon
.br
.B bconsole \- Console to control Bacula
.br
.B wx-console \- GUI Console
.br
.SH DESCRIPTION
.LP
Bacula is a set of computer programs that permits you (or the
system administrator) to manage backup, recovery, and
verification of computer data across a network of computers of
different kinds.  In technical terms, it is a network
Client/Server based backup program.  Bacula is relatively easy to
use and efficient, while offering many advanced storage
management features that make it easy to find and recover lost or
damaged files.  Due to its modular design, Bacula is scalable
from small single computer systems to systems consisting of
hundreds of computers located over a large network.

.LP
Bacula Director service consists of the program that supervises
all the backup, restore, verify and archive operations.  The
system administrator uses the Bacula Director to schedule backups
and to recover files.  For more details see the Director Services
Daemon Design Document in the Bacula Developer's Guild.  The
Director runs as a daemon or a service (i.e.  in the background).

.LP
Bacula Console services is the program that allows the
administrator or user to communicate with the Bacula Director
(see above).  Currently, the Bacula Console is available in three
versions.  The first and simplest is to run the Console program
in a shell window (i.e.  TTY interface).  Most system
administrators will find this completely adequate.  The second
version is a GNOME GUI interface that for the moment (07 October
2005) is far from complete, but quite functional as it has most
the capabilities of the shell Console.  The third version is a
wxWidgets GUI with an interactive file restore.  It also has most
of the capabilities of the shell console, allows command
completion with tabulation, and gives you instant help about the
command you are typing.

.LP
Bacula File services (or Client program) is the software program
that is installed on the machine to be backed up.  It is specific
to the operating system on which it runs and is responsible for
providing the file attributes and data when requested by the
Director.  The File services are also responsible for the file
system dependent part of restoring the file attributes and data
during a recovery operation.  For more details see the File
Services Daemon Design Document in the Bacula Developer's Guide.
This program runs as a daemon on the machine to be backed up, and
in some of the documentation, the File daemon is referred to as
the Client (for example in Bacula's configuration file).  In
addition to Unix/Linux File daemons, there is a Windows File
daemon (normally distributed in binary format).  The Windows File
daemon runs on all currently known Windows versions (98, Me,
NT, 2K, 2003,  XP).

.LP
Bacula Storage services consist of the software programs that
perform the storage and recovery of the file attributes and data
to the physical backup media or volumes.  In other words, the
Storage daemon is responsible for reading and writing your tapes
(or other storage media, e.g.  files).  For more details see the
Storage Services Daemon Design Document in the Bacula Developer's
Guild.  The Storage services runs as a daemon on the machine that
has the backup device (usually a tape drive).

.LP
Catalog services are comprised of the software programs
responsible for maintaining the file indexes and volume databases
for all files backed up.  The Catalog services permit the System
Administrator or user to quickly locate and restore any desired
file.  The Catalog services sets Bacula apart from simple backup
programs like tar and bru, because the catalog maintains a record
of all Volumes used, all Jobs run, and all Files saved,
permitting efficicient restoration and Volume management.  Bacula
currently supports three different databases, MySQL, PostgreSQL,
and SQLite, one of which must be chosen when building Bacula.

.SH OPTIONS
See the HTML/PDF documentation for details of the command line options.

.SH CONFIGURATION
Each daemon has its own configuration file which must be
tailored for each particular installation.  Please see the HTML/PDF
documentation for the details.

.SH SEE ALSO
The HTML manual installed on your system (typically found in
.br
/usr/share/doc/bacula-<version>) or the online manual at:
.br
<http://www.bacula.org>

.SH BUGS
See <http://bugs.bacula.org>

.SH AUTHOR
Kern Sibbald
.SS Current maintainer
Kern Sibbald
.SS Contributors
An enormous list of past and former persons who have devoted
their time and energy to this project -- thanks.

.SH COPYRIGHT
Bacula is distributed under a modified GPL version 2.0, as described in the
file LICENSE included with the source distribution.
