#!/bin/sh
#
# Copyright (c) 2005-2006 Atheme Development Group
# Rights to this code are documented in doc/LICENSE.
#
# This file generates version.c.
# Stolen from ircd-ratbox.
#
# $Id: version.sh 8031 2007-04-02 10:55:00Z nenolod $
#

spitshell=cat
package=atheme

echo "Extracting $package/src/version.c..."

if test -r version.c.last
then
   generation=`sed -n 's/^const char \*generation = \"\(.*\)\";/\1/p' < version.c.last`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

uname=`uname`

osinfo=`uname -a`;

creation=`date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

buildid=`echo "\$Revision: 8031 $" | \
	awk '{ print $2 }'`;

$spitshell >version.c <<!SUB!THIS!
/*
 * Copyright (c) 2005-2008 Atheme Development Group
 * Rights to this code are documented in doc/LICENSE.
 *
 * This file contains version information.
 * Autogenerated by version.sh.
 */

#include "serno.h"

const char *generation = "$generation";
const char *creation = "$creation";
const char *platform = "$uname";
const char *version = "$1";
const char *revision = SERNO;
const char *osinfo = "$osinfo";

const char *infotext[] =
{
  "Atheme IRC Services --",
  "Copyright (c) 2005-2008 Atheme Development Group (http://www.atheme.org)",
  " ",
  "Permission to use, copy, modify, and/or distribute this software for any",
  "purpose with or without fee is hereby granted, provided that the above",
  "copyright notice and this permission notice appear in all copies.",
  " ",
  "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND",
  "ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED",
  "WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE",
  "DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR",
  "ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES",
  "(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;",
  "LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON",
  "ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT",
  "(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS",
  "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.",
  " ",
  "Currently Atheme's core group consists of the following developers,",
  "in nick-alphabetical order:",
  "  gxti, Michael Tharp <gxti@partiallystapled.com>",
  "  jilles, Jilles Tjoelker <jilles@stack.nl>",
  "  nenolod, William Pitcock <nenolod@nenolod.net>",
  "  pippijn, Pippijn van Steenhoven <pippijn@one09.net>",
  "  w00t, Robin Burchell <viroteck@viroteck.net>",
  " ",
  "The following people have contributed blood, sweat and tears to",
  "this Atheme release:",
  "  alambert, Alex Lambert <alambert@quickfire.org>",
  "  beu, Elfyn McBratney <elfyn.mcbratney@gmail.com>",
  "  Dianora, Diane Bruce <db@db.net>",
  "  kog, Greg Feigenson <kog@epiphanic.org>",
  "  kuja, Jeff Katz <jeff@katzonline.net>",
  "  lu_zero, Luca Barbato <lu_zero@gentoo.org>",
  "  pfish, Patrick Fish <pofish@gmail.com>",
  "  terminal, Theo Julienne <admin@ozweb.nu>",
  "  Trystan, Trystan Scott Lee <trystan@nomadirc.net>",
  "  zparta, Jens Holmqvist <zparta@hispan.se>",
  " ",
  "Visit our website at http://www.atheme.net",
  0,
};
!SUB!THIS!
