/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: grfflt.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:35:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_GRFFLT_HXX
#define _SVX_GRFFLT_HXX

#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif
#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_GROUP_HXX
#include <vcl/group.hxx>
#endif
#ifndef _SV_SALBTYPE_HXX
#include <vcl/salbtype.hxx>
#endif
#ifndef _GRFMGR_HXX
#include <goodies/grfmgr.hxx>
#endif

#ifndef _GRAPHCTL_HXX
#include <bf_svx/graphctl.hxx>
#endif
#ifndef _SVX_DLG_CTRL_HXX
#include <bf_svx/dlgctrl.hxx>
#endif
#ifndef _SVX_RECTENUM_HXX
#include <bf_svx/rectenum.hxx>
#endif
//STRIP001 class SfxItemSet;

namespace binfilter {

// ---------------
// - Error codes -
// ---------------

//STRIP001 #define SVX_GRAPHICFILTER_ERRCODE_NONE				0x00000000
//STRIP001 #define SVX_GRAPHICFILTER_UNSUPPORTED_GRAPHICTYPE	0x00000001
//STRIP001 #define SVX_GRAPHICFILTER_UNSUPPORTED_SLOT			0x00000002

// --------------------
// - SvxGraphicFilter -
// --------------------

//STRIP001 class SfxRequest;

//STRIP001 class SvxGraphicFilter
//STRIP001 {
//STRIP001 public:
//STRIP001 
//STRIP001 	static ULONG	ExecuteGrfFilterSlot( SfxRequest& rReq, GraphicObject& rFilterObject );
//STRIP001 	static void		DisableGraphicFilterSlots( SfxItemSet& rSet );
//STRIP001 };

// -----------------------
// - GraphicFilterDialog -
// -----------------------

//STRIP001 class GraphicFilterDialog : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	class PreviewWindow : public Control
//STRIP001 	{
//STRIP001 	private:
//STRIP001 		
//STRIP001 		GraphicObject	maGraphic;
//STRIP001 
//STRIP001 		virtual void	Paint( const Rectangle& rRect );
//STRIP001 
//STRIP001 	public:
//STRIP001 
//STRIP001 						PreviewWindow( Window* pParent, const ResId& rResId );
//STRIP001 						~PreviewWindow();
//STRIP001 
//STRIP001 		void			SetGraphic( const Graphic& rGraphic );
//STRIP001 	};
//STRIP001 
//STRIP001 private:
//STRIP001 
//STRIP001 	Timer			maTimer;
//STRIP001 	Link			maModifyHdl;
//STRIP001 	Graphic			maGraphic;
//STRIP001 	double			mfScaleX;
//STRIP001 	double			mfScaleY;
//STRIP001 	Size			maSizePixel;
//STRIP001 	PreviewWindow	maPreview;
//STRIP001 	FixedLine		maFlParameter;
//STRIP001 	OKButton		maBtnOK;
//STRIP001 	CancelButton	maBtnCancel;
//STRIP001 	HelpButton		maBtnHelp;
//STRIP001 
//STRIP001 					DECL_LINK( ImplPreviewTimeoutHdl, Timer* pTimer );
//STRIP001 					DECL_LINK( ImplModifyHdl, void* p );
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	const Link&		GetModifyHdl() const { return maModifyHdl; }
//STRIP001 	const Size&		GetGraphicSizePixel() const { return maSizePixel; }
//STRIP001 
//STRIP001 public:				
//STRIP001 					
//STRIP001 					GraphicFilterDialog( Window* pParent, const ResId& rResId, const Graphic& rGraphic );
//STRIP001 					~GraphicFilterDialog();
//STRIP001 
//STRIP001 	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY ) = 0;
//STRIP001 };

// -----------------------
// - GraphicFilterMosaic -
// -----------------------

//STRIP001 class GraphicFilterMosaic : public GraphicFilterDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText		maFtWidth;
//STRIP001 	MetricField		maMtrWidth;
//STRIP001 	FixedText		maFtHeight;
//STRIP001 	MetricField		maMtrHeight;
//STRIP001 	CheckBox		maCbxEdges;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GraphicFilterMosaic( Window* pParent, const Graphic& rGraphic,
//STRIP001 										 USHORT nTileWidth, USHORT nTileHeight, BOOL bEnhanceEdges );
//STRIP001 					~GraphicFilterMosaic();
//STRIP001 
//STRIP001 	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
//STRIP001 	USHORT			GetTileWidth() const { return maMtrWidth.GetValue(); }
//STRIP001 	USHORT			GetTileHeight() const { return maMtrHeight.GetValue(); }
//STRIP001 	BOOL			IsEnhanceEdges() const { return maCbxEdges.IsChecked(); }
//STRIP001 };

// -------------------------
// - GraphicFilterSolarize -
// -------------------------

//STRIP001 class GraphicFilterSolarize : public GraphicFilterDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText		maFtThreshold;
//STRIP001 	MetricField		maMtrThreshold;
//STRIP001 	CheckBox		maCbxInvert;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GraphicFilterSolarize( Window* pParent, const Graphic& rGraphic,
//STRIP001 										   BYTE nGreyThreshold, BOOL bInvert );
//STRIP001 					~GraphicFilterSolarize();
//STRIP001 
//STRIP001 	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
//STRIP001 	BYTE			GetGreyThreshold() const { return( (BYTE) FRound( maMtrThreshold.GetValue() * 2.55 ) ); }
//STRIP001 	BOOL			IsInvert() const { return maCbxInvert.IsChecked(); }
//STRIP001 };

// ----------------------
// - GraphicFilterSepia -
// ----------------------

//STRIP001 class GraphicFilterSepia : public GraphicFilterDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText		maFtSepia;
//STRIP001 	MetricField		maMtrSepia;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GraphicFilterSepia( Window* pParent, const Graphic& rGraphic,
//STRIP001 										USHORT nSepiaPercent );
//STRIP001 					~GraphicFilterSepia();
//STRIP001 
//STRIP001 	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
//STRIP001 	USHORT			GetSepiaPercent() const { return maMtrSepia.GetValue(); }
//STRIP001 };

// -----------------------
// - GraphicFilterPoster -
// -----------------------

//STRIP001 class GraphicFilterPoster : public GraphicFilterDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText		maFtPoster;
//STRIP001 	NumericField	maNumPoster;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GraphicFilterPoster( Window* pParent, const Graphic& rGraphic,
//STRIP001 										 USHORT nPosterColorCount );
//STRIP001 					~GraphicFilterPoster();
//STRIP001 
//STRIP001 	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
//STRIP001 	USHORT			GetPosterColorCount() const { return( (USHORT) maNumPoster.GetValue() ); }
//STRIP001 };

// -----------------------
// - GraphicFilterEmboss -
// -----------------------

//STRIP001 class GraphicFilterEmboss : public GraphicFilterDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	class EmbossControl : public SvxRectCtl
//STRIP001 	{
//STRIP001 	private:
//STRIP001 
//STRIP001 		Link			maModifyHdl;
//STRIP001 
//STRIP001 		virtual void	MouseButtonDown( const MouseEvent& rEvt );
//STRIP001 
//STRIP001 	public:
//STRIP001 
//STRIP001 						EmbossControl( Window* pParent, const ResId& rResId, RECT_POINT eRectPoint ) : 
//STRIP001 							SvxRectCtl( pParent, rResId ) { SetActualRP( eRectPoint ); }
//STRIP001 	
//STRIP001 		void			SetModifyHdl( const Link& rHdl ) { maModifyHdl = rHdl; }
//STRIP001 	};
//STRIP001 
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText		maFtLight;
//STRIP001 	EmbossControl	maCtlLight;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GraphicFilterEmboss( Window* pParent, const Graphic& rGraphic,
//STRIP001 										 RECT_POINT eLightSource );
//STRIP001 					~GraphicFilterEmboss();
//STRIP001 
//STRIP001 	virtual Graphic	GetFilteredGraphic( const Graphic& rGraphic, double fScaleX, double fScaleY );
//STRIP001 	RECT_POINT		GetLightSource() const { return maCtlLight.GetActualRP(); }
//STRIP001 };

}//end of namespace binfilter
#endif
