#ifndef _SFXMACRO_HXX
#define _SFXMACRO_HXX

//====================================================================
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
// auto strip #include <com/sun/star/beans/PropertyValue.hpp>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
// auto strip #include <com/sun/star/uno/Sequence.hxx>
// auto strip #endif

// auto strip #include <tools/string.hxx>
namespace binfilter {

class SfxSlot;
class SfxShell;
struct SfxMacro_Impl;
class SfxMacro;

//====================================================================

//STRIP001 class SfxMacroStatement
//STRIP001 {
//STRIP001 	USHORT				nSlotId;	// ausgef"uhrte Slot-Id oder 0, wenn manuell
//STRIP001     ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue > aArgs;      // aktuelle Parameter, falls nSlotId != 0
//STRIP001 	String				aStatement; // Statement in BASIC-Syntax (ggf. mit CR/LF)
//STRIP001 	BOOL				bDone;  	// auskommentieren wenn kein Done() gerufen
//STRIP001 	void*				pDummy;		// f"ur alle F"alle zum kompatibel bleiben
//STRIP001 
//STRIP001 #ifdef _SFXMACRO_HXX
//STRIP001 private:
//STRIP001 	void				GenerateNameAndArgs_Impl( SfxMacro *pMacro,
//STRIP001 												  const SfxSlot &rSlot,
//STRIP001 												  BOOL bRequestDone,
//STRIP001                                                   ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& aArgs );
//STRIP001 #endif
//STRIP001 
//STRIP001 public:
//STRIP001 						SfxMacroStatement( const SfxMacroStatement &rOrig );
//STRIP001 
//STRIP001 						SfxMacroStatement( const String &rTarget,
//STRIP001 										   const SfxSlot &rSlot,
//STRIP001 										   BOOL bRequestDone,
//STRIP001                                            ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& aArgs );
//STRIP001 
//STRIP001 						SfxMacroStatement( const SfxShell &rShell,
//STRIP001 										   const String &rTarget,
//STRIP001 										   BOOL bAbsolute,
//STRIP001 										   const SfxSlot &rSlot,
//STRIP001 										   BOOL bRequestDone,
//STRIP001                                            ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& aArgs );
//STRIP001 
//STRIP001 						SfxMacroStatement( const String &rStatment );
//STRIP001 						~SfxMacroStatement();
//STRIP001 
//STRIP001 	USHORT				GetSlotId() const;
//STRIP001     const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& GetArgs() const;
//STRIP001 	BOOL				IsDone() const;
//STRIP001 	const String&		GetStatement() const;
//STRIP001 };

//--------------------------------------------------------------------

//STRIP001 inline USHORT SfxMacroStatement::GetSlotId() const

/*  [Beschreibung]

	Liefert die Slot-Id die das Statement beim Abspielen wieder ausf"uhren
	soll oder 0, falls das Statement manuell (<SFX_SLOT_RECORDMANUAL>)
	aufgezeichnet wurde.
*/

//STRIP001 {
//STRIP001 	return nSlotId;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 inline const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& SfxMacroStatement::GetArgs() const

/*  [Beschreibung]

	Liefert die Parameter mit denen Statement ausgef"uhrt wurde oder 0,
	falls das Statement	manuell (<SFX_SLOT_RECORDMANUAL>) aufgezeichnet
	wurde.

	Der R"uckgabewert geh"ort dem SfxMacroStatement und ist nur im
	unmittelbar aufrufenden Stackframe g"ultig.
*/

//STRIP001 {
//STRIP001     return aArgs;
//STRIP001 }

//--------------------------------------------------------------------

//STRIP001 inline BOOL	SfxMacroStatement::IsDone() const

/*  [Beschreibung]

	Liefert TRUE, wenn das Statement wirklich ausgef"uhrt wurde,
	also z.B. nicht vom Benutzer abgebrochen wurde. Wurde es nicht
	wirklich ausgef"uhrt, dann wird es im BASIC-Source auskommentiert.
*/

//STRIP001 {
//STRIP001 	return bDone;
//STRIP001 }

//--------------------------------------------------------------------

/*  [Beschreibung]

	Liefert das Statement in BASIC-Syntax. Wurde das Makro manuell erzeugt,
	wird genau der im Konstruktor angegebene String zur"uckgegeben, sonst
	der generierte Source-Code.

	Bei beiden Arten ist es m"oglich, da\s mehrere BASIC-Statements, jeweils
	mit CR/LF getrennt in dem String enthalten sind, da ein SFx-Statement
	ggf. in mehrere BASIC-Statements "ubersetzt wird.

	Statements f"ur die nicht <SfxRequest::Done()> gerufen wurde, werden
	mit einem vorangestellten 'rem' gekennzeichnet.
*/

//STRIP001 inline const String& SfxMacroStatement::GetStatement() const
//STRIP001 {
//STRIP001 	return aStatement;
//STRIP001 }

//====================================================================

enum SfxMacroMode

/*	[Beschreibung]

	Mit diesem enum wird bestimmt, ob eine <SfxMacro>-Instanz zum
	absoluten oder relativen Recorden erzeugt wurde, oder um ein
	existierendendes Makro zu Referenzieren.
*/

{
	SFX_MACRO_EXISTING,			/*	es handelt sich um ein bereits
									exitistierendes Makro, welches lediglich
									referenziert wird */

	SFX_MACRO_RECORDINGABSOLUTE,/*	dieses Makro soll aufgezeichnet werden,
									wobei die betroffenen Objekte m"oglichst
									direkt angesprochen werden sollen
									(Beispiel: "[doc.sdc]") */

	SFX_MACRO_RECORDINGRELATIVE/*   dieses Makro soll aufgezeichnet werden,
									wobei die betroffenen Objekte so
									angesprochen werden sollen, da\s sich das
									Abspielen auf die dann g"ultige Selektion
									bezieht (Beispiel: "ActiveDocument()") */
};

//====================================================================

//STRIP001 class SfxMacro

/*	[Beschreibung]

	"Uber diese Klasse (bzw. genaugenommen ihre Subklassen) wird zum
	einen die Lokation einer BASIC-Funktion (also in welcher Library,
	in welchem Modul sowie der Funktions-Name) beschrieben, als auch
	ein aufzuzeichnendes Makro w"ahrend der Aufzeichnung zwischen-
	gespeichert.
*/

//STRIP001 {
//STRIP001 	SfxMacro_Impl*			pImp;
//STRIP001 
//STRIP001 public:
//STRIP001                             SfxMacro( SfxMacroMode eMode = SFX_MACRO_RECORDINGRELATIVE );
//STRIP001 	virtual 				~SfxMacro();
//STRIP001 
//STRIP001 	SfxMacroMode			GetMode() const;
//STRIP001 	void					Record( SfxMacroStatement *pStatement );
//STRIP001 	void					Replace( SfxMacroStatement *pStatement );
//STRIP001 	void					Remove();
//STRIP001 	const SfxMacroStatement*GetLastStatement() const;
//STRIP001 
//STRIP001 	String					GenerateSource() const;
//STRIP001 };

}//end of namespace binfilter
#endif
