/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wizltgo.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:20:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "hintids.hxx"

#ifndef _SVX_ULSPITEM_HXX //autogen
#include <bf_svx/ulspitem.hxx>
#endif


#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>     // Writershell
#endif
#ifndef _FRMMGR_HXX
#include <frmmgr.hxx>    // Framemanager
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>  // Seitenraender,
#endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>    // Fussz,Kopfz
#endif
#ifndef _TABCOL_HXX
#include <tabcol.hxx>  	// SwTabCols
#endif
#ifndef _WIZPAGE_HXX
#include <wizpage.hxx>
#endif
#ifndef _WIZGO_HXX
#include <wizgo.hxx>
#endif
#ifndef _WIZLT_HXX
#include <wizlt.hxx>
#endif
#ifndef _CRSSKIP_HXX
#include <crsskip.hxx>
#endif
namespace binfilter {

////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef WINDOCHFILM
#define WIZNOFILM
#endif
#ifndef WINDOCHUNDO
#define WIZNOUNDO
#endif
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL LetterDialog::MakeDoc()
{
	BOOL bRet=FALSE;
	BOOL bPrivat=(a1_RBtn_PrvBrf.IsChecked());
	String aVorNam;
	if (a1_RBtn_Stil2.IsChecked())
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizbrf2" ));
	else if (a1_RBtn_Stil3.IsChecked())
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizbrf3" ));
	else
		aVorNam.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "wizbrf1" ));

	if (NewVorlage(aVorNam))
	{
#ifdef WIZNOFILM
		pShell->StartAction();
#endif
#ifdef WIZNOUNDO
		pShell->DoUndo(FALSE); // hat leider noch Seiteneffekte
#endif
		if (!bPrivat) // keine Datenbank am Privatbrief
			AssignDBas(aEmpf.pE_List_DBase->GetSelectEntry(), aEmpf.pE_List_DBTable->GetSelectEntry());
		SetMarg(aPage1,NULL,&aPage1.aFusz);
		SetPrinter(pPrinter);
#ifndef NO_PAPERBIN
		SetTray(p9_List_TrayS1->GetSelectEntryPos());
#endif
		InsLogo();
		InsEmpf();
		InsAbsn();
		InsAbs2();
		InsElem();
		InsBetr();
		InsAnrd();
		SetFusz(aPage1.aFusz,"Fus1","Num1");
		InsAnlg(); // ab hier befindet sich der Cursor auf der 2. Seite !
		InsKopi();
		InsKopF();
		SetFusz(aPageF.aFusz,"FusF","NumF");
		SetMarg(aPageF,&aPageF.aKopz,&aPageF.aFusz);
#ifndef NO_PAPERBIN
        SetTray(p9_List_TrayFF->GetSelectEntryPos());
#endif
		DelText();
		MarkText();
		CreateMacro();
		if (!bPrivat) SaveMacro();
		FillDocInfo(*pDoku);
#ifdef WIZNOFILM
		pShell->EndAction();
#endif
		if (SaveVorNewDoc(*pDoku)) bRet=TRUE;
	}
	return bRet;
}

void LetterDialog::CreateMacro()
{
	ULONG nDateFmt = NODATE;

	if (aPage1.aElem.IsVisible(4))
		nDateFmt = a5_List_Datum.GetFormat();
	 SetCreateMacro(*pDoku,nDateFmt);
}

void LetterDialog::SaveMacro()
{
	 BOOL bDown1=GetDocInfoGoDown(pDoku->pD_List_InfTit->GetSelectEntryPos());
	 BOOL bDown2=GetDocInfoGoDown(pDoku->pD_List_InfTem->GetSelectEntryPos());
	 SetSaveMacro(*pDoku,bDown1,bDown2);
}

void LetterDialog::InsAbsnStr()
{
	String aStr;
	USHORT n=CountLines(a3_MEdt_AbsInp.GetText());
	USHORT i;
	for (i=0; i<n; i++) {
		aStr=GetLine(a3_MEdt_AbsInp.GetText(),i);
		if (aStr.Len()>0) {
			USHORT nBla=0;
			char c=aStr.GetChar(nBla);
			if (c=='>') aStr.Erase(0,1);
		}
		InsString(aStr);
		if (i<n-1) pShell->SplitNode(); // kein CR and die letzte Zeile
	}
}

void LetterDialog::InsAbsn()
{
	if (GotoBookmark("Absn")) {
		if (aPage1.aAbsn.IsVisible()) {
			InsAbsnStr();
			MovFrame(aPage1.aAbsn);
			USHORT a=p9_List_AbsPrn->GetSelectEntryPos(); // 0=Immer, 1=Erste, 2=Folge, 3=Nie
			PrnFrame(a==0 || a==1);
		} else { // ansonsten wird er geloescht
			DelFrame();
		}
	}
}

void LetterDialog::InsAbs2()
{
	if (aPage1.aEmpf.IsVisible()) { // nur wenn Empfngerfeld vorhanden!
		if (GotoBookmark("Abs2")) {
			if (aPage1.aEmpf.IsAbsnShown()) {
				String aStr;
				String aStr2;
				USHORT n=CountLines(a3_MEdt_AbsInp.GetText());
				USHORT i;
				for (i=0; i<n; i++) {
					aStr2=GetLine(a3_MEdt_AbsInp.GetText(),i);
					if (aStr2.Len()>0) {
						USHORT nBla=0;
						char c=aStr2.GetChar( nBla );
						if (c=='>') {
							aStr2.Erase(0,1);
							if (aStr.Len()!=0)
								aStr.AppendAscii(
										RTL_CONSTASCII_STRINGPARAM(" - "));
							aStr+=aStr2;
						}
					}
				}
				InsString(aStr);
			} else {
				if( !pShell->IsEndPara() )
					pShell->MovePara( fnParaCurr, fnParaEnd );

				pShell->Right( CRSR_SKIP_CHARS, FALSE, 1, TRUE );       // der nchsten Zeile,
				pShell->SplitNode();   // dort einen Umbruch,
				pShell->Up( FALSE, 1, TRUE );
				pShell->Up( FALSE, 1, TRUE );
				pShell->DelFullPara();
				//pShell->UpSel();       // Und dann den unterstrichenen
				//pShell->DelRight();    // Absatz lschen
			}                          // (Dabei bleibt oben eine Leerzeile stehen!)
		}
	}
}

void LetterDialog::InsLogo()
{
	if (GotoBookmark("Logo")) {
		if (aPage1.aLogo.IsVisible()) {
			MovFrame(aPage1.aLogo);
			USHORT a=p9_List_LgoPrn->GetSelectEntryPos(); // 0=Immer, 1=Erste, 2=Folge, 3=Nie
			BOOL bPrn=(a==0 || a==1);
			PrnFrame(bPrn);
			InsLogoObj(aPage1.aLogo,FALSE,bPrn);
		} else {
			DelFrame();
		}
	}
}

void LetterDialog::InsEmpf()
{
	if (GotoBookmark("Empf"))
	{
		if (aPage1.aEmpf.IsVisible())
		{
			InsDBasFldStr(aPage1.aEmpf.GetStr());
			MovFrame(aPage1.aEmpf);
		}
		else
			DelFrame();
	}
}

void LetterDialog::InsKopF()
{
	if (GotoBookmark("AbsK")) {
		USHORT nPgDescIdx=pShell->GetCurPageDesc();
		SwPageDesc aPageDesc(pShell->GetPageDesc(nPgDescIdx));
		SwFrmFmt*  pFmt=&aPageDesc.GetMaster();  //CopyCtor geht hier nicht, da Pointer
		if (aPageF.aKopz.IsVisible()) {
			SwFmtHeader aHeaderFmt(pFmt->GetHeader());
			SwFrmFmt* pHeaderFmt=aHeaderFmt.GetHeaderFmt();
			SvxULSpaceItem aULSpace(pHeaderFmt->GetULSpace());    // Upper/Lower-Space holen
			aULSpace.SetLower(USHORT(Twip(aPageF.aKopz.GetTextDst()))); // Abstand zum Text
			pHeaderFmt->SetAttr(aULSpace);
			SwFmtFrmSize aFrmSize(ATT_FIX_SIZE);
			aFrmSize.SetHeight(Twip(aPageF.aKopz.GetHgt()+aPageF.aKopz.GetTextDst()));
			pHeaderFmt->SetAttr(aFrmSize);
			pFmt->SetAttr(aHeaderFmt);
		} else { // Kopfeile entfernen !
			pFmt->SetAttr(SwFmtHeader(BOOL(FALSE)));
			aPageDesc.ChgHeaderShare(FALSE);
		}
		pShell->ChgPageDesc(nPgDescIdx,aPageDesc);
		if (aPageF.aKopz.IsVisible()) {
			if (aPageF.aKopz.AbsnIsVisible()) { // Absender einfuegen
				InsAbsnStr();
				JstFrame(aPageF.aKopz.GetAbsnAlign());
				SizFrame(aPageF.aKopz.GetAbsnWdt(),aPageF.aKopz.GetAbsnHgt(),FALSE,TRUE);
				USHORT a=p9_List_AbsPrn->GetSelectEntryPos(); // 0=Immer, 1=Erste, 2=Folge, 3=Nie
				PrnFrame(a==0 || a==2);
			} else {
				DelFrame();
			}
			if (GotoBookmark("LgoK")) {
				if (aPageF.aKopz.LogoIsVisible()) { // Logo einfuegen
					JstFrame(aPageF.aKopz.GetLogoAlign());
					SizFrame(aPageF.aKopz.GetLogoWdt(),aPageF.aKopz.GetLogoHgt());
					USHORT a=p9_List_LgoPrn->GetSelectEntryPos(); // 0=Immer, 1=Erste, 2=Folge, 3=Nie
					BOOL bPrn=(a==0 || a==2);
					PrnFrame(bPrn);
					InsLogoObj(aPageF.aKopz.aLogo,TRUE,bPrn);
				} else {
					DelFrame();
				}
			}
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void LetterDialog::InsDocInfBookmark(USHORT nElemNum)
{
	if (GetDocInfStrOk(nElemNum)) {   // als DocInf freigegeben ?
		USHORT nIdx=nElemNum;      // nIdx geht von 0..pDoku->GetTxFieldAnz()-1
		USHORT i;
		for (i=0; i<nElemNum; i++) // fuer jeden nicht freigeg. davor, Idx um 1 dec.
			if (!GetDocInfStrOk(i)) nIdx--;
		nIdx+=pDoku->GetTxFieldOfs();
		if (nIdx==pDoku->pD_List_InfTit->GetSelectEntryPos())
			InsertBookmark("Titel");
		if (nIdx==pDoku->pD_List_InfTem->GetSelectEntryPos())
			InsertBookmark("Thema");
	}
}


void LetterDialog::InsElem()
{
	USHORT i;
	USHORT nAnz = 0;

	WizardElem& rPg1Elem = aPage1.aElem;
	for( i = 0; i < 5; ++i )
		if( rPg1Elem.IsVisible(i) )
			++nAnz;

	BOOL bDatm = rPg1Elem.NurDatum(); // || a1_RBtn_PrvBrf.IsChecked();
	BOOL bElem = !bDatm && nAnz;

	const sal_Char* pBookmkNm = "Elem";
	if( bElem && GotoBookmark( pBookmkNm ) )
	{
		USHORT nColAnz = nAnz; // Anzahl der bentigten Tabellenspalten
		BOOL bDatAbs = FALSE;  // Abstandsspalte zum Datum ?

		if( rPg1Elem.IsVisible(4) )
		{
			// Position des Datums
			long nDatPos = rPg1Elem.aBezeich[4].GetPosX();
			i = 0;
			for( USHORT j = 0; j < 4; ++j )
				if( rPg1Elem.IsVisible( j ) )
					i = j; // das Feld neben Datum suchen

			// Eine Abstandsspalte vor dem Datum (Toleranz 10 wg. Rundungsfehler)
			if( rPg1Elem.aBezeich[i].GetPosX() +
				rPg1Elem.aBezeich[i].GetWdt() + 10 < nDatPos )
			{
				bDatAbs=TRUE;
				nColAnz++;
			}
		}

		if( 5 > nColAnz )
		{
			InsertBookmark( pBookmkNm );
			pShell->GoNextCell();
			pShell->SetMark();

			for( i = ++nColAnz; i < 5; ++i )
				pShell->GoNextCell();

			pShell->DeleteCol(); 	// Ueberfluessige Spalten loeschen
			pShell->ClearMark();

			// und wieder in die Tabelle zurueck
			if( USHRT_MAX != ( i = pShell->FindBookmark(
							String::CreateFromAscii( pBookmkNm ) ) ))
			{
				pShell->GotoBookmark( i );
				pShell->DelBookmark( i );
			}
			else
				ASSERT( !this, "Wer hat meine Bookmark zerstoert" )
		}

		MovFrame( rPg1Elem.GetPosX(), rPg1Elem.GetPosY(),
					rPg1Elem.GetWdt(), rPg1Elem.GetHgt(), TRUE );

		SwTabCols aCols;
		pShell->GetTabCols( aCols );

		nColAnz = 0; // Nummer der Tabellenspalte
		USHORT nElemCnt = 0; // Nummer des Elementes [0..nAnz-1]
		for( i = 0; i < 5; ++i )
		{
			if( rPg1Elem.IsVisible( i ) )
			{
				// Breite der letzten Spalte nur setzen, wenn Datum
				if( nElemCnt < nAnz - 1 || i == 4 )
					SetTabColWidth( aCols, nColAnz,
						Twip( rPg1Elem.aBezeich[i].GetWdt() ));

				String aStr;
				switch (i)
				{
					case 0: aStr=a5_Edit_Elem1.GetText(); break;
					case 1: aStr=a5_Edit_Elem2.GetText(); break;
					case 2: aStr=a5_Edit_Elem3.GetText(); break;
					case 3: aStr=a5_Edit_Elem4.GetText(); break;
					case 4: aStr=a5_CBox_Datum.GetText();
							aStr.EraseAllChars('~');		break;
				}
				InsString( aStr );
				if( i <= 3 )
				{
					// DocInfBookmarker fuer alle Elemente ausser Datum
					if( !pShell->IsSttPara() )
						pShell->MovePara( fnParaCurr, fnParaStart );

					InsDocInfBookmark( i );
				}
				else if( i == 4 )
				{
					// Datumsfeld in die 2. Zeile
					pShell->Down( FALSE, 1, TRUE );
					InsertBookmark("Datum");
					if( !pShell->IsSttPara() )
						pShell->MovePara( fnParaCurr, fnParaStart );

					pShell->Up( FALSE, 1, TRUE );
				}

				if( nElemCnt < nAnz - 1 )
				{	 // kommt noch mehr ?
					pShell->GoNextCell();
					++nColAnz;

					if( nElemCnt == nAnz - 2 && bDatAbs )
					{
						pShell->GoNextCell();
						++nColAnz;
					}
				}
				++nElemCnt;
			}
		}
		pShell->SetTabCols( aCols, FALSE );
	}

	if (bDatm && GotoBookmark( "Datm" ))
	{
		InsertBookmark("Datum");
		MovFrame(rPg1Elem.GetPosX(), rPg1Elem.GetPosY(), rPg1Elem.GetWdt(),
							rPg1Elem.GetHgt(),TRUE);
	}

	if( !bElem && GotoBookmark( "Elem" ))
	{
		if( pShell->DeleteRow() && pShell->DeleteRow() && pShell->HasSelection() )
			pShell->EnterStdMode();
		DelFrame();
	}

	if (!bDatm && GotoBookmark( "Datm" ))
	{
		if( pShell->DeleteRow() && pShell->HasSelection() )
			pShell->EnterStdMode();
		DelFrame();
	}
}

void LetterDialog::InsBetr()
{
	if (GotoBookmark("Betr"))
	{
		if (aPage1.aBetr.IsVisible())
		{
			InsString(a5_Edit_Betref.GetText());
			if( !pShell->IsSttPara() )
				pShell->MovePara( fnParaCurr, fnParaStart );

			InsDocInfBookmark(4);
			MovFrame(aPage1.aBetr,TRUE);
		}
		else
		{
			if ( pShell->DeleteRow() && pShell->HasSelection() )
				pShell->EnterStdMode();

			DelFrame();
		}
	}
}

void LetterDialog::InsAnrd()
{
	if (GotoBookmark("Anrd"))
	{
		if (a1_RBtn_GesBrf.IsChecked())
		{
			String aStr1(aEmpf.pE_Edit_AnrFix->GetText());
			if( aEmpf.pE_List_AnrFld->GetSelectEntryPos() )
			{
				String aStr2(aEmpf.pE_List_AnrFld->GetSelectEntry());
				if( aStr2.Len() )
				{
					if (aStr1.Len() && aStr1.GetChar( aStr1.Len()-1 ) != ' ')
						aStr1 += ' ';	// Leerzeichen vor Feldbefehl einfuegen: Bug #50316
					aStr1 += '<';
					aStr1 += aStr2;
					aStr1 += '>';
				}
			}

			if( aStr1.Len() )
			{
				pShell->SttSelect();
				pShell->RightMargin( TRUE );
				pShell->EndSelect();
				pShell->DelRight();
				InsDBasFldStr(aStr1);
			}
		}
		else
		{
			// SwFmtPageDesc beibehalten !!
			SfxItemSet aSet( pShell->GetAttrPool(), RES_PAGEDESC, RES_PAGEDESC );
			pShell->GetAttr( aSet );
			pShell->DelFullPara();
			pShell->SetAttr( aSet );
		}
	}
}

void LetterDialog::InsAnlg()
{
	if( GotoBookmark("Anlg") &&
		(!a5_CBox_Anlagn.IsChecked() || !a1_RBtn_GesBrf.IsChecked() ) )
			pShell->DelFullPara();
}

void LetterDialog::InsKopi()
{
	if( GotoBookmark("Kopi") &&
		( !a5_CBox_KopiAn.IsChecked() || !a1_RBtn_GesBrf.IsChecked() ) )
			pShell->DelFullPara();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////



}
