/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: toxmgr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:58:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TOXMGR_HXX
#define _TOXMGR_HXX

#include "tox.hxx"
#ifndef _AUTHFLD_HXX
#include <authfld.hxx>
#endif
namespace binfilter {

class SwWrtShell;
class SwForm;

/*--------------------------------------------------------------------
	Beschreibung: Manager fuer Verzeichnisfunktionalitaet
 --------------------------------------------------------------------*/
//one single method will be sufficient to insert AND upate indexes

//STRIP001 class SwTOXDescription
//STRIP001 {
//STRIP001 	TOXTypes 			eTOXType;
//STRIP001 	String				aStyleNames[MAXLEVEL];
//STRIP001 	String				sSequenceName;
//STRIP001 	String 				sMainEntryCharStyle;
//STRIP001 	String 				sAutoMarkURL;
//STRIP001 	String* 			pTitle;
//STRIP001 	String* 			pTOUName;
//STRIP001 	SwForm* 			pForm;
//STRIP001 	USHORT 				nContent;
//STRIP001 	USHORT 				nIndexOptions;
//STRIP001 	USHORT 				nOLEOptions;
//STRIP001     LanguageType        eLanguage;
//STRIP001     String              sSortAlgorithm;
//STRIP001 
//STRIP001     String              sAuthBrackets;
//STRIP001 	SwCaptionDisplay	eCaptionDisplay;
//STRIP001 	SwTOXSortKey 		eSortKey1;
//STRIP001 	SwTOXSortKey 		eSortKey2;
//STRIP001 	SwTOXSortKey 		eSortKey3;
//STRIP001 	BYTE 				nLevel;
//STRIP001 	BOOL				bFromObjectNames : 1;
//STRIP001 	BOOL				bFromChapter : 1;
//STRIP001 	BOOL				bReadonly: 1;
//STRIP001 	BOOL				bLevelFromChapter : 1;
//STRIP001 	BOOL				bIsAuthSequence :1;
//STRIP001 	BOOL 				bSortByDocument :1;
//STRIP001 
//STRIP001 	//TODO: TemplateNames
//STRIP001 	//const String* pTemplateName = 0, ???
//STRIP001 	SwTOXDescription(SwTOXDescription&);
//STRIP001 public:
//STRIP001 	SwTOXDescription(TOXTypes eType) :
//STRIP001 		eTOXType(eType),
//STRIP001 		pTitle(0),
//STRIP001 		pForm(0),
//STRIP001 		nContent(TOX_MARK | TOX_OUTLINELEVEL),
//STRIP001 		nLevel(MAXLEVEL),
//STRIP001         eLanguage((LanguageType)::GetAppLanguage()),
//STRIP001 		pTOUName(0),
//STRIP001 		nIndexOptions(TOI_SAME_ENTRY|TOI_FF|TOI_CASE_SENSITIVE),
//STRIP001 		nOLEOptions(0),
//STRIP001 		eCaptionDisplay(CAPTION_COMPLETE),
//STRIP001 		bFromObjectNames(FALSE),
//STRIP001 		bFromChapter(FALSE),
//STRIP001 		bReadonly(TRUE),
//STRIP001 		bLevelFromChapter(FALSE),
//STRIP001 		bIsAuthSequence(FALSE),
//STRIP001 		bSortByDocument(TRUE)
//STRIP001 		{}
//STRIP001 	~SwTOXDescription()
//STRIP001 		{
//STRIP001 			delete pTitle;
//STRIP001 			delete pForm;
//STRIP001 			delete pTOUName;
//STRIP001 		}
//STRIP001 
//STRIP001 	void 			SetTOXType(TOXTypes eSet) { eTOXType = eSet;}
//STRIP001 	TOXTypes 		GetTOXType() const { return eTOXType;}
//STRIP001 
//STRIP001 	const String&	GetStyleNames(USHORT nLevel) const
//STRIP001 								{return aStyleNames[nLevel];}
//STRIP001 	void			SetStyleNames(const String& rSet, USHORT nLevel)
//STRIP001 								{aStyleNames[nLevel] = rSet; }
//STRIP001 
//STRIP001 	const String&	GetAutoMarkURL() const { return sAutoMarkURL;}
//STRIP001 	void			SetAutoMarkURL(const String& rSet) {sAutoMarkURL = rSet;}
//STRIP001 
//STRIP001 	void 			SetTitle(const String& pSet) {delete pTitle; pTitle = new String(pSet);}
//STRIP001 	const String* 	GetTitle() const {return pTitle; }
//STRIP001 
//STRIP001 	void 			SetTOUName(const String& pSet) {delete pTOUName; pTOUName = new String(pSet);}
//STRIP001 	const String* 	GetTOUName() const {return pTOUName; }
//STRIP001 
//STRIP001 	void 			SetForm(const SwForm& rSet) {delete pForm; pForm = new SwForm(rSet);}
//STRIP001 	const SwForm* 	GetForm() const {return pForm;}
//STRIP001 
//STRIP001 	void 			SetContentOptions(USHORT nSet) { nContent = nSet;}
//STRIP001 	USHORT  		GetContentOptions() const { return nContent;}
//STRIP001 
//STRIP001 	void 			SetIndexOptions(USHORT nSet) { nIndexOptions = nSet;}
//STRIP001 	USHORT 			GetIndexOptions() const { return nIndexOptions;}
//STRIP001 
//STRIP001 	const String&	GetMainEntryCharStyle() const {return sMainEntryCharStyle;}
//STRIP001 	void			SetMainEntryCharStyle(const String& rSet)  {sMainEntryCharStyle = rSet;}
//STRIP001 
//STRIP001 	void 			SetLevel(BYTE nSet) {nLevel = nSet;}
//STRIP001 	BYTE 			GetLevel()const  {return nLevel; }
//STRIP001 
//STRIP001 	void			SetCreateFromObjectNames(BOOL bSet) { bFromObjectNames = bSet;}
//STRIP001 	BOOL			IsCreateFromObjectNames() const {return bFromObjectNames;}
//STRIP001 
//STRIP001 	const String&	GetSequenceName() const {return sSequenceName;}
//STRIP001 	void			SetSequenceName(const String& rSet) {sSequenceName = rSet;}
//STRIP001 
//STRIP001 	SwCaptionDisplay	GetCaptionDisplay() const { return eCaptionDisplay;}
//STRIP001 	void				SetCaptionDisplay(SwCaptionDisplay eSet) {eCaptionDisplay = eSet;}
//STRIP001 
//STRIP001 	void			SetFromChapter(BOOL bSet) { bFromChapter = bSet;}
//STRIP001 	BOOL			IsFromChapter() const {return bFromChapter;}
//STRIP001 
//STRIP001 	void			SetReadonly(BOOL bSet){bReadonly = bSet;}
//STRIP001 	BOOL			IsReadonly() const {return bReadonly;}
//STRIP001 
//STRIP001 	USHORT 			GetOLEOptions() const {return nOLEOptions;}
//STRIP001 	void   			SetOLEOptions(USHORT nOpt) {nOLEOptions = nOpt;}
//STRIP001 
//STRIP001 	BOOL			IsLevelFromChapter() const {return bLevelFromChapter;}
//STRIP001 	void			SetLevelFromChapter(BOOL bSet) {bLevelFromChapter = bSet;}
//STRIP001 
//STRIP001 	String			GetAuthBrackets() const {return sAuthBrackets;}
//STRIP001 	void		    SetAuthBrackets(const String& rSet) {sAuthBrackets = rSet;}
//STRIP001 
//STRIP001 	BOOL			IsAuthSequence() const {return bIsAuthSequence;}
//STRIP001 	void 			SetAuthSequence(BOOL bSet){bIsAuthSequence = bSet;}
//STRIP001 
//STRIP001 	BOOL			IsSortByDocument()const {return bSortByDocument ;}
//STRIP001 	void 			SetSortByDocument(BOOL bSet) {bSortByDocument = bSet;}
//STRIP001 
//STRIP001 	void SetSortKeys(SwTOXSortKey eKey1,
//STRIP001 						SwTOXSortKey eKey2,
//STRIP001 							SwTOXSortKey eKey3);
//STRIP001 
//STRIP001 	SwTOXSortKey GetSortKey1() const {return eSortKey1;}
//STRIP001 	SwTOXSortKey GetSortKey2() const {return eSortKey2;}
//STRIP001 	SwTOXSortKey GetSortKey3() const {return eSortKey3;}
//STRIP001 
//STRIP001     LanguageType    GetLanguage() const {return eLanguage;}
//STRIP001     void            SetLanguage(LanguageType nLang)  {eLanguage = nLang;}
//STRIP001 
//STRIP001     const String&   GetSortAlgorithm()const {return sSortAlgorithm;}
//STRIP001     void            SetSortAlgorithm(const String& rSet) {sSortAlgorithm = rSet;}
//STRIP001 
//STRIP001     void            ApplyTo(SwTOXBase& rTOXBase);
//STRIP001 
//STRIP001 };
// --------------------------------------------------------------------------------
//STRIP001 class SwTOXMarkDescription
//STRIP001 {
//STRIP001 	TOXTypes 	eTOXType;
//STRIP001 	int 		nLevel;
//STRIP001 	BOOL		bMainEntry;
//STRIP001 
//STRIP001 	String* 	pPrimKey;
//STRIP001 	String* 	pSecKey;
//STRIP001 	String* 	pAltStr;
//STRIP001 	String* 	pTOUName;
//STRIP001 
//STRIP001 	String* 	pPhoneticReadingOfAltStr;
//STRIP001 	String* 	pPhoneticReadingOfPrimKey;
//STRIP001 	String* 	pPhoneticReadingOfSecKey;
//STRIP001 
//STRIP001 public:
//STRIP001 	SwTOXMarkDescription(TOXTypes eType) :
//STRIP001 		eTOXType(eType),
//STRIP001 		pPrimKey(0),
//STRIP001 		pSecKey(0),
//STRIP001 		pAltStr(0),
//STRIP001 		pTOUName(0),
//STRIP001 		pPhoneticReadingOfAltStr(0),
//STRIP001 		pPhoneticReadingOfPrimKey(0),
//STRIP001 		pPhoneticReadingOfSecKey(0),
//STRIP001 		nLevel(0),
//STRIP001 		bMainEntry(FALSE)
//STRIP001 		{
//STRIP001 		}
//STRIP001 	~SwTOXMarkDescription()
//STRIP001 	{
//STRIP001 		delete pPrimKey;
//STRIP001 		delete pSecKey;
//STRIP001 		delete pAltStr;
//STRIP001 		delete pTOUName;
//STRIP001 		delete pPhoneticReadingOfAltStr;
//STRIP001 		delete pPhoneticReadingOfPrimKey;
//STRIP001 		delete pPhoneticReadingOfSecKey;
//STRIP001 	}
//STRIP001 
//STRIP001 	TOXTypes		GetTOXType()const {return eTOXType;}
//STRIP001 
//STRIP001 	void 			SetLevel(int nSet) {nLevel = nSet;}
//STRIP001 	int 			GetLevel() const {return nLevel;}
//STRIP001 
//STRIP001 	void			SetMainEntry(BOOL bSet) {bMainEntry = bSet;}
//STRIP001 	BOOL			IsMainEntry() const {return bMainEntry;}
//STRIP001 
//STRIP001 	void			SetPrimKey(const String& rSet)
//STRIP001 								{delete pPrimKey; pPrimKey = new String(rSet);}
//STRIP001 	const String* 	GetPrimKey() const {return pPrimKey;}
//STRIP001 
//STRIP001 	void 			SetSecKey(const String& rSet)
//STRIP001 								{delete pSecKey;  pSecKey  = new String(rSet);}
//STRIP001 	const String* 	GetSecKey() const {	return pSecKey; }
//STRIP001 
//STRIP001 	void 			SetAltStr(const String& rSet)
//STRIP001 								{delete pAltStr;  pAltStr  = new String(rSet);}
//STRIP001 	const String* 	GetAltStr() const {	return pAltStr; }
//STRIP001 
//STRIP001 	void			SetTOUName(const String& rSet)
//STRIP001 								{delete pTOUName; pTOUName = new String(rSet);}
//STRIP001 	const String* 	GetTOUName() const {return pTOUName;}
//STRIP001 
//STRIP001 
//STRIP001 	void 			SetPhoneticReadingOfAltStr(const String& rSet)
//STRIP001 								{delete pPhoneticReadingOfAltStr;  pPhoneticReadingOfAltStr  = new String(rSet);}
//STRIP001 	const String* 	GetPhoneticReadingOfAltStr() const {	return pPhoneticReadingOfAltStr; }
//STRIP001 
//STRIP001 	void 			SetPhoneticReadingOfPrimKey(const String& rSet)
//STRIP001 								{delete pPhoneticReadingOfPrimKey;  pPhoneticReadingOfPrimKey  = new String(rSet);}
//STRIP001 	const String* 	GetPhoneticReadingOfPrimKey() const {	return pPhoneticReadingOfPrimKey; }
//STRIP001 
//STRIP001 	void 			SetPhoneticReadingOfSecKey(const String& rSet)
//STRIP001 								{delete pPhoneticReadingOfSecKey;  pPhoneticReadingOfSecKey  = new String(rSet);}
//STRIP001 	const String* 	GetPhoneticReadingOfSecKey() const {	return pPhoneticReadingOfSecKey; }
//STRIP001 };

//STRIP001 class SwTOXMgr
//STRIP001 {
//STRIP001 	SwWrtShell* 		pSh;
//STRIP001 	SwTOXMark*			pCurTOXMark;
//STRIP001 	SwTOXMarks			aCurMarks;
//STRIP001 
//STRIP001 	USHORT 				GetUserTypeID(const String& rStr);
//STRIP001 
//STRIP001 public:
//STRIP001 	SwTOXMgr(SwWrtShell* pShell);
//STRIP001 	//
//STRIP001 	// Methoden fuer Verzeichnismarkierungen
//STRIP001 	//
//STRIP001 	void	InsertTOXMark(const SwTOXMarkDescription& rDesc);
//STRIP001 
//STRIP001 	void	UpdateTOXMark(const SwTOXMarkDescription& rDesc);
//STRIP001 
//STRIP001 
//STRIP001 	void				DeleteTOXMark();
//STRIP001 	void				NextTOXMark(BOOL bSame=FALSE);
//STRIP001 	void				PrevTOXMark(BOOL bSame=FALSE);
//STRIP001 
//STRIP001 	// Aktuelle TOXmarks holen
//STRIP001 	USHORT				GetTOXMarks();
//STRIP001 	USHORT				GetTOXMarkCount();
//STRIP001 	SwTOXMark*			GetTOXMark(USHORT nId);
//STRIP001 	SwTOXMark*			GetCurTOXMark();
//STRIP001 	void				SetCurTOXMark(USHORT nId);
//STRIP001 
//STRIP001 	//
//STRIP001 	// Methoden fuer Verzeichnisse
//STRIP001 	//
//STRIP001 	BOOL 	UpdateOrInsertTOX(const SwTOXDescription& rDesc, SwTOXBase** ppBase = 0, const SfxItemSet* pSet = 0);
//STRIP001 
//STRIP001 #ifdef USE_OLD_INDEXES
//STRIP001 	void	InsertTOI(const USHORT nOptions = TOI_SAME_ENTRY|TOI_FF|TOI_CASE_SENSITIVE,
//STRIP001 						const String* pTitel = 0,
//STRIP001 						const SwForm* pForm  = 0,
//STRIP001 						SwTOXBase** ppBase = 0 );
//STRIP001 
//STRIP001 	BOOL	UpdateTOI(const USHORT nOptions,
//STRIP001 					  const String* pTitel = 0,
//STRIP001 					  const SwForm* pForm = 0);
//STRIP001 
//STRIP001 
//STRIP001 	void	InsertTOC(const USHORT nContent = TOX_MARK | TOX_OUTLINELEVEL,
//STRIP001 						int nLevel = MAXLEVEL,
//STRIP001 						const String* pTitel = 0,
//STRIP001 						const SwForm* pForm = 0,
//STRIP001 						SwTOXBase** ppBase = 0);
//STRIP001 
//STRIP001 	BOOL	UpdateTOC(const USHORT nContent = TOX_MARK | TOX_OUTLINELEVEL,
//STRIP001 					  int nLevel = MAXLEVEL,
//STRIP001 					  const String* pTitel = 0,
//STRIP001 					  const SwForm* pForm = 0);
//STRIP001 
//STRIP001 	void	InsertTOU(const USHORT nContent = TOX_MARK,
//STRIP001 						const String* pTOUName = 0,
//STRIP001 						const String* pTemplateName = 0,
//STRIP001 						int nLevel = MAXLEVEL,
//STRIP001 						const String* pTitel = 0,
//STRIP001 						const SwForm* pForm = 0,
//STRIP001 						SwTOXBase** ppBase = 0);
//STRIP001 
//STRIP001 	BOOL	UpdateTOU(const USHORT nContent,
//STRIP001 						const String* pTOUName = 0,
//STRIP001 						const String* pTemplateName = 0,
//STRIP001 						int nLevel = MAXLEVEL,
//STRIP001 						const String* pTitel = 0,
//STRIP001 						const SwForm* pForm = 0);
//STRIP001 
//STRIP001 #endif
//STRIP001 
//STRIP001 	const SwTOXType* 	GetTOXType(TOXTypes eTyp, USHORT nId) const;
//STRIP001 	const SwTOXBase*	GetCurTOX();
//STRIP001 
//STRIP001 };


/*--------------------------------------------------------------------
	Beschreibung: Inlines
 --------------------------------------------------------------------*/

//STRIP001 inline USHORT SwTOXMgr::GetTOXMarkCount()
//STRIP001 	{	return aCurMarks.Count();	}
//STRIP001 
//STRIP001 
//STRIP001 inline SwTOXMark* SwTOXMgr::GetCurTOXMark()
//STRIP001 	{	return pCurTOXMark;	}

} //namespace binfilter
#endif
