/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: excidata.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:03:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef __EXCIDATA_HXX__
#define __EXCIDATA_HXX__

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#include "excui.hxx"
class String; 
namespace binfilter {


class ExcDokument;

class ExcDataPool
	{
	private:
		ExcUiList	aInit;			// Ur-Liste
		ExcUiList	*pUiBack;		// Selektion aus UI
	public:
					ExcDataPool();
					~ExcDataPool();

		void		InsertEntry(
						const String &rName,		// z.B. Bereichsname
						ExcEntryType eType,			// Table, Named Range
						const String &rTabName,		// Tabellenname
						USHORT nTab,				// Tabellen-Nummer
						USHORT nCS, USHORT nCE,		// Col-Start/-End
						USHORT nRS, USHORT nRE/*,		// Row-Start/-End
						ULONG nStrPos*/				// Pos. des Bofs im Stream
						);

		BOOL		GetNextSelection(
						String &rName,				// eventuell Titel
						USHORT &rTab,				// Tabellen-Nummer
						USHORT &rCS, USHORT &rCE,	// Col-Start/-End
						USHORT &rRS, USHORT &rRE/*,	// Row-Start/-End
						ULONG &rStrPos*/			// Pos. des Bofs im Stream
						);

		ExcDataPool	&operator<<( ExcDokument &rExcDok );
	};



} //namespace binfilter
#endif

