/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_unins.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:44:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif
// auto strip #ifndef _SVSTOR_HXX //autogen
// auto strip #include <so3/svstor.hxx>
// auto strip #endif
// auto strip #ifndef _IPOBJ_HXX //autogen
// auto strip #include <so3/ipobj.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_KEEPITEM_HXX //autogen
// auto strip #include <bf_svx/keepitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOBJ_HXX //autogen
// auto strip #include <bf_svx/svdobj.hxx>
// auto strip #endif

// auto strip #ifndef _FMTCNTNT_HXX //autogen
// auto strip #include <fmtcntnt.hxx>
// auto strip #endif
// auto strip #ifndef _FMTANCHR_HXX //autogen
// auto strip #include <fmtanchr.hxx>
// auto strip #endif
// auto strip #ifndef _FRMFMT_HXX //autogen
// auto strip #include <frmfmt.hxx>
// auto strip #endif
#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
// auto strip #ifndef _ROLBCK_HXX
// auto strip #include <rolbck.hxx>
// auto strip #endif
// auto strip #ifndef _NDGRF_HXX
// auto strip #include <ndgrf.hxx>
// auto strip #endif
// auto strip #ifndef _NDOLE_HXX
// auto strip #include <ndole.hxx>
// auto strip #endif
// auto strip #ifndef _GRFATR_HXX
// auto strip #include <grfatr.hxx>
// auto strip #endif
// auto strip #ifndef _CNTFRM_HXX
// auto strip #include <cntfrm.hxx>
// auto strip #endif
// auto strip #ifndef _FLYFRM_HXX
// auto strip #include <flyfrm.hxx>
// auto strip #endif
// auto strip #ifndef _FESH_HXX
// auto strip #include <fesh.hxx>
// auto strip #endif
// auto strip #ifndef _SWTABLE_HXX
// auto strip #include <swtable.hxx>
// auto strip #endif
#ifndef _REDLINE_HXX
#include <redline.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
// auto strip #ifndef _ACORRECT_HXX
// auto strip #include <acorrect.hxx>
// auto strip #endif
// auto strip #ifndef _DCONTACT_HXX //autogen
// auto strip #include <dcontact.hxx>
// auto strip #endif
namespace binfilter {

//STRIP001 class _UnReplaceData : private SwUndoSaveCntnt
//STRIP001 {
//STRIP001 	String sOld, sIns;
//STRIP001 	ULONG nSttNd, nEndNd, nOffset;
//STRIP001 	xub_StrLen nSttCnt, nEndCnt, nSetPos, nSelEnd;
//STRIP001 	BOOL bSplitNext : 1;
//STRIP001 	BOOL bRegExp : 1;
//STRIP001 
//STRIP001 public:
//STRIP001 	_UnReplaceData( const SwPaM& rPam, const String& rIns, BOOL bRegExp );
//STRIP001 	~_UnReplaceData();
//STRIP001 
//STRIP001 	void Undo( SwUndoIter& rIter );
//STRIP001 	void Redo( SwUndoIter& rIter );
//STRIP001 	void SetEnd( const SwPaM& rPam );
//STRIP001 };


//STRIP001 SV_IMPL_PTRARR( _UnReplaceDatas, _UnReplaceData* )

//------------------------------------------------------------------

//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }

// zwei Zugriffs-Funktionen
//STRIP001 inline SwPosition* IterPt( SwUndoIter& rUIter )
//STRIP001 {	return rUIter.pAktPam->GetPoint();	}
//STRIP001 inline SwPosition* IterMk( SwUndoIter& rUIter )
//STRIP001 {	return rUIter.pAktPam->GetMark();	}

//------------------------------------------------------------

// INSERT

/*N*/ SwUndoInsert::SwUndoInsert( const SwNodeIndex& rNd, xub_StrLen nCnt,
/*N*/ 							xub_StrLen nL, BOOL bWDelim )
/*N*/ 	: SwUndo(UNDO_INSERT), nNode( rNd.GetIndex() ), nCntnt(nCnt), nLen(nL),
/*N*/ 		bIsWordDelim( bWDelim ), bIsAppend( FALSE ), pPos( 0 ), pTxt( 0 ),
/*N*/ 		pRedlData( 0 )
/*N*/ {
/*N*/ 	// Redline beachten
/*N*/ 	SwDoc& rDoc = *rNd.GetNode().GetDoc();
/*N*/ 	if( rDoc.IsRedlineOn() )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pRedlData = new SwRedlineData( REDLINE_INSERT,
//STRIP001 /*?*/ 										rDoc.GetRedlineAuthor() );
//STRIP001 /*?*/ 		SetRedlineMode( rDoc.GetRedlineMode() );
/*N*/ 	}
/*N*/ }

/*N*/ SwUndoInsert::SwUndoInsert( const SwNodeIndex& rNd )
/*N*/ 	: SwUndo(UNDO_INSERT), nNode( rNd.GetIndex() ), nCntnt(0), nLen(1),
/*N*/ 		bIsWordDelim( FALSE ), bIsAppend( TRUE ), pPos( 0 ), pTxt( 0 ),
/*N*/ 		pRedlData( 0 )
/*N*/ {
/*N*/ 	// Redline beachten
/*N*/ 	SwDoc& rDoc = *rNd.GetNode().GetDoc();
/*N*/ 	if( rDoc.IsRedlineOn() )
/*N*/ 	{
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pRedlData = new SwRedlineData( REDLINE_INSERT,
//STRIP001 /*?*/ 										rDoc.GetRedlineAuthor() );
//STRIP001 /*?*/ 		SetRedlineMode( rDoc.GetRedlineMode() );
/*N*/ 	}
/*N*/ }

// stelle fest, ob das naechste Insert mit dem aktuellen zusammengefasst
// werden kann. Wenn ja, dann aender die Laenge und die InsPos.
// Dann wird von SwDoc::Insert kein neues Object in die Undoliste gestellt.

/*N*/ BOOL SwUndoInsert::CanGrouping( const SwPosition& rInsPos, sal_Unicode cIns )
/*N*/ {
/*N*/ 	BOOL bRet = FALSE;
/*N*/ 	if( !bIsAppend )
/*N*/ 	{
/*N*/ 		++nCntnt;
/*N*/ 		bRet = CanGrouping( rInsPos );
/*N*/ 		--nCntnt;
/*N*/ 		if( bRet )
/*N*/ 			bRet = CanGrouping( cIns );
/*N*/ 	}
/*N*/ 	return bRet;
/*N*/ }


/*N*/ BOOL SwUndoInsert::CanGrouping( sal_Unicode cIns )
/*N*/ {
/*N*/ 	if( !bIsAppend && bIsWordDelim ==
/*N*/ 		!GetAppCharClass().isLetterNumeric( String( cIns )) )
/*N*/ 	{
/*N*/ 		nLen++;
/*N*/ 		nCntnt++;
/*N*/ 		return TRUE;
/*N*/ 	}
/*N*/ 	return FALSE;
/*N*/ }

/*N*/ BOOL SwUndoInsert::CanGrouping( const SwPosition& rPos )
/*N*/ {
/*N*/ 	BOOL bRet = FALSE;
/*N*/ 	if( nNode == rPos.nNode.GetIndex() &&
/*N*/ 		nCntnt == rPos.nContent.GetIndex() )
/*N*/ 	{
/*N*/ 		// Redline beachten
/*N*/ 		SwDoc& rDoc = *rPos.nNode.GetNode().GetDoc();
/*N*/ 		if( ( ~REDLINE_SHOW_MASK & rDoc.GetRedlineMode() ) ==
/*N*/ 			( ~REDLINE_SHOW_MASK & GetRedlineMode() ) )
/*N*/ 		{
/*N*/ 			bRet = TRUE;
/*N*/ 
/*N*/ 			// dann war oder ist noch Redline an:
/*N*/ 			// pruefe, ob an der InsPosition ein anderer Redline
/*N*/ 			// rumsteht. Wenn der gleiche nur einmalig vorhanden ist,
/*N*/ 			// kann zusammen gefasst werden.
/*N*/ 			const SwRedlineTbl& rTbl = rDoc.GetRedlineTbl();
/*N*/ 			if( rTbl.Count() )
/*N*/ 			{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	SwRedlineData aRData( REDLINE_INSERT, rDoc.GetRedlineAuthor() );
//STRIP001 /*?*/ 				const SwIndexReg* pIReg = rPos.nContent.GetIdxReg();
//STRIP001 /*?*/ 				SwIndex* pIdx;
//STRIP001 /*?*/ 				for( USHORT i = 0; i < rTbl.Count(); ++i )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SwRedline* pRedl = rTbl[ i ];
//STRIP001 /*?*/ 					if( pIReg == (pIdx = &pRedl->End()->nContent)->GetIdxReg() &&
//STRIP001 /*?*/ 						nCntnt == pIdx->GetIndex() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if( !pRedl->HasMark() || !pRedlData ||
//STRIP001 /*?*/ 							*pRedl != *pRedlData || *pRedl != aRData )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							bRet = FALSE;
//STRIP001 /*?*/ 							break;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return bRet;
/*N*/ }

/*N*/ SwUndoInsert::~SwUndoInsert()
/*N*/ {
/*N*/ 	if( pPos )      // loesche noch den Bereich aus dem UndoNodes Array
/*N*/ 	{
/*?*/ 		// Insert speichert den Inhalt in der IconSection
/*?*/ 		SwNodes& rUNds = pPos->nNode.GetNode().GetNodes();
/*?*/ 		if( pPos->nContent.GetIndex() )         // nicht den gesamten Node loeschen
/*?*/ 		{
/*?*/ 			SwTxtNode* pTxtNd = pPos->nNode.GetNode().GetTxtNode();
/*?*/ 			ASSERT( pTxtNd, "kein TextNode, aus dem geloescht werden soll" );
/*?*/ 			pTxtNd->Erase( pPos->nContent );
/*?*/ 			pPos->nNode++;
/*?*/ 		}
/*?*/ 		pPos->nContent.Assign( 0, 0 );
/*?*/ 		rUNds.Delete( pPos->nNode, rUNds.GetEndOfExtras().GetIndex() -
/*?*/ 									pPos->nNode.GetIndex() );
/*?*/ 		delete pPos;
/*N*/ 	}
/*N*/ 	else if( pTxt )		// der eingefuegte Text
/*?*/ 		delete pTxt;
//STRIP001 /*?*/ 	delete pRedlData;
/*N*/ }



//STRIP001 void SwUndoInsert::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	if( bIsAppend )
//STRIP001 	{
//STRIP001 		SwPaM* pPam = rUndoIter.pAktPam;
//STRIP001 		pPam->GetPoint()->nNode = nNode;
//STRIP001 
//STRIP001 		if( IsRedlineOn( GetRedlineMode() ))
//STRIP001 		{
//STRIP001 			pPam->GetPoint()->nContent.Assign( pPam->GetCntntNode(), 0 );
//STRIP001 			pPam->SetMark();
//STRIP001 			pPam->Move( fnMoveBackward );
//STRIP001 			pPam->Exchange();
//STRIP001 			pDoc->DeleteRedline( *pPam );
//STRIP001 		}
//STRIP001 		pPam->DeleteMark();
//STRIP001 		pDoc->DelFullPara( *pPam );
//STRIP001 		pPam->GetPoint()->nContent.Assign( pPam->GetCntntNode(), 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ULONG nNd = nNode;
//STRIP001 		xub_StrLen nCnt = nCntnt;
//STRIP001 		if( nLen )
//STRIP001 		{
//STRIP001 			SwNodeIndex aNd( pDoc->GetNodes(), nNode);
//STRIP001 			SwCntntNode* pCNd = aNd.GetNode().GetCntntNode();
//STRIP001 			SwPaM aPaM( *pCNd, nCntnt );
//STRIP001 
//STRIP001 			aPaM.SetMark();
//STRIP001 
//STRIP001 			if( pCNd->IsTxtNode() )		// Text !!
//STRIP001 			{
//STRIP001 				aPaM.GetPoint()->nContent -= nLen;
//STRIP001 				if( IsRedlineOn( GetRedlineMode() ))
//STRIP001 					pDoc->DeleteRedline( aPaM );
//STRIP001 				RemoveIdxFromRange( aPaM, FALSE );
//STRIP001 				pTxt = new String( ((SwTxtNode*)pCNd)->GetTxt().Copy(
//STRIP001 											nCntnt-nLen, nLen ) );
//STRIP001 				((SwTxtNode*)pCNd)->Erase( aPaM.GetPoint()->nContent, nLen );
//STRIP001 			}
//STRIP001 			else				// ansonsten Grafik/OLE/Text/...
//STRIP001 			{
//STRIP001 				aPaM.Move(fnMoveBackward);
//STRIP001 				if( IsRedlineOn( GetRedlineMode() ))
//STRIP001 					pDoc->DeleteRedline( aPaM );
//STRIP001 				RemoveIdxFromRange( aPaM, FALSE );
//STRIP001 			}
//STRIP001 
//STRIP001 			nNd = aPaM.GetPoint()->nNode.GetIndex();
//STRIP001 			nCnt = aPaM.GetPoint()->nContent.GetIndex();
//STRIP001 
//STRIP001 			if( !pTxt )
//STRIP001 			{
//STRIP001 				pPos = new SwPosition( *aPaM.GetPoint() );
//STRIP001 				MoveToUndoNds( aPaM, &pPos->nNode, &pPos->nContent );
//STRIP001 			}
//STRIP001 			nNode = aPaM.GetPoint()->nNode.GetIndex();
//STRIP001 			nCntnt = aPaM.GetPoint()->nContent.GetIndex();
//STRIP001 		}
//STRIP001 
//STRIP001 		// setze noch den Cursor auf den Undo-Bereich
//STRIP001 		rUndoIter.pAktPam->DeleteMark();
//STRIP001 
//STRIP001 		IterPt(rUndoIter)->nNode = nNd;
//STRIP001 		IterPt(rUndoIter)->nContent.Assign( pDoc->GetNodes()[
//STRIP001 				IterPt(rUndoIter)->nNode ]->GetCntntNode(), nCnt );
//STRIP001 		// SPoint und GetMark auf der gleichen Position
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoInsert::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// setze noch den Cursor auf den Redo-Bereich
//STRIP001 	SwPaM* pPam = rUndoIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 	pPam->DeleteMark();
//STRIP001 
//STRIP001 	if( bIsAppend )
//STRIP001 	{
//STRIP001 		pPam->GetPoint()->nNode = nNode - 1;
//STRIP001 		pDoc->AppendTxtNode( *pPam->GetPoint() );
//STRIP001 
//STRIP001 		pPam->SetMark();
//STRIP001 		pPam->Move( fnMoveBackward );
//STRIP001 		pPam->Exchange();
//STRIP001 
//STRIP001 		if( pRedlData && IsRedlineOn( GetRedlineMode() ))
//STRIP001 		{
//STRIP001 			SwRedlineMode eOld = pDoc->GetRedlineMode();
//STRIP001 			pDoc->SetRedlineMode_intern( eOld & ~REDLINE_IGNORE );
//STRIP001 			pDoc->AppendRedline( new SwRedline( *pRedlData, *pPam ));
//STRIP001 			pDoc->SetRedlineMode_intern( eOld );
//STRIP001 		}
//STRIP001 		else if( !( REDLINE_IGNORE & GetRedlineMode() ) &&
//STRIP001 				pDoc->GetRedlineTbl().Count() )
//STRIP001 			pDoc->SplitRedline( *pPam );
//STRIP001 
//STRIP001 		pPam->DeleteMark();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pPam->GetPoint()->nNode = nNode;
//STRIP001 		SwCntntNode* pCNd = pDoc->GetNodes()[ pPam->GetPoint()->nNode ]->GetCntntNode();
//STRIP001 		pPam->GetPoint()->nContent.Assign( pCNd, nCntnt );
//STRIP001 
//STRIP001 		if( nLen )
//STRIP001 		{
//STRIP001 			BOOL bMvBkwrd = MovePtBackward( *pPam );
//STRIP001 
//STRIP001 			if( pTxt )
//STRIP001 			{
//STRIP001 				ASSERT( pCNd->IsTxtNode(), "wo ist mein Textnode ??" );
//STRIP001 				((SwTxtNode*)pCNd)->Insert( *pTxt, pPam->GetMark()->nContent,
//STRIP001 											INS_EMPTYEXPAND );
//STRIP001 				DELETEZ( pTxt );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Inhalt wieder einfuegen. (erst pPos abmelden !!)
//STRIP001 				ULONG nMvNd = pPos->nNode.GetIndex();
//STRIP001 				xub_StrLen nMvCnt = pPos->nContent.GetIndex();
//STRIP001 				DELETEZ( pPos );
//STRIP001 				MoveFromUndoNds( *pDoc, nMvNd, nMvCnt, *pPam->GetMark() );
//STRIP001 			}
//STRIP001 			nNode = pPam->GetMark()->nNode.GetIndex();
//STRIP001 			nCntnt = pPam->GetMark()->nContent.GetIndex();
//STRIP001 
//STRIP001 			MovePtForward( *pPam, bMvBkwrd );
//STRIP001 			rUndoIter.pAktPam->Exchange();
//STRIP001 			if( pRedlData && IsRedlineOn( GetRedlineMode() ))
//STRIP001 			{
//STRIP001 				SwRedlineMode eOld = pDoc->GetRedlineMode();
//STRIP001 				pDoc->SetRedlineMode_intern( eOld & ~REDLINE_IGNORE );
//STRIP001 				pDoc->AppendRedline( new SwRedline( *pRedlData,
//STRIP001 											*rUndoIter.pAktPam ));
//STRIP001 				pDoc->SetRedlineMode_intern( eOld );
//STRIP001 			}
//STRIP001 			else if( !( REDLINE_IGNORE & GetRedlineMode() ) &&
//STRIP001 					pDoc->GetRedlineTbl().Count() )
//STRIP001 				pDoc->SplitRedline( *rUndoIter.pAktPam );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoInsert::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	rUndoIter.pLastUndoObj = this;
//STRIP001 	if( !nLen )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	SwNodeIndex aNd( rDoc.GetNodes(), nNode );
//STRIP001 	SwCntntNode* pCNd = aNd.GetNode().GetCntntNode();;
//STRIP001 
//STRIP001 	if( !bIsAppend && 1 == nLen )		// >1 dann immer nur Text, ansonsten Grafik/OLE/Text/...
//STRIP001 	{
//STRIP001 		SwPaM aPaM( *pCNd, nCntnt );
//STRIP001 		aPaM.SetMark();
//STRIP001 		aPaM.Move(fnMoveBackward);
//STRIP001 		pCNd = aPaM.GetCntntNode();
//STRIP001 	}
//STRIP001 
//STRIP001 // Was passiert mit dem evt. selektierten Bereich ???
//STRIP001 
//STRIP001 	switch( pCNd->GetNodeType() )
//STRIP001 	{
//STRIP001 	case ND_TEXTNODE:
//STRIP001 		if( bIsAppend )
//STRIP001 			rDoc.AppendTxtNode( *rUndoIter.pAktPam->GetPoint() );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			String aTxt( ((SwTxtNode*)pCNd)->GetTxt() );
//STRIP001 			BOOL bGroupUndo = rDoc.DoesGroupUndo();
//STRIP001 			rDoc.DoGroupUndo( FALSE );
//STRIP001 			rDoc.Insert( *rUndoIter.pAktPam, aTxt.Copy( nCntnt - nLen, nLen ));
//STRIP001 			rDoc.DoGroupUndo( bGroupUndo );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	case ND_GRFNODE:
//STRIP001 		{
//STRIP001 			SwGrfNode* pGrfNd = (SwGrfNode*)pCNd;
//STRIP001 			String sFile, sFilter;
//STRIP001 			if( pGrfNd->IsGrfLink() )
//STRIP001 				pGrfNd->GetFileFilterNms( &sFile, &sFilter );
//STRIP001 
//STRIP001 			rDoc.Insert( *rUndoIter.pAktPam, sFile, sFilter,
//STRIP001 								&pGrfNd->GetGrf(),
//STRIP001 								0/* Grafik-Collection*/ );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_OLENODE:
//STRIP001 		{
//STRIP001 			// StarView bietet noch nicht die Moeglichkeit ein StarOBJ zu kopieren
//STRIP001 			SvStorageRef aRef = new SvStorage( aEmptyStr );
//STRIP001 			SwOLEObj& rSwOLE = (SwOLEObj&)((SwOLENode*)pCNd)->GetOLEObj();
//STRIP001 			SvInPlaceObjectRef aNew((SvPersist*) rSwOLE.GetOleRef()->CopyObject( aRef ) );
//STRIP001 			rDoc.Insert( *rUndoIter.pAktPam, &aNew );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


/*  */

//STRIP001 SwUndoReplace::SwUndoReplace()
//STRIP001 	: SwUndo( UNDO_REPLACE ), nAktPos( USHRT_MAX )
//STRIP001 {
//STRIP001 }

//STRIP001 SwUndoReplace::~SwUndoReplace()
//STRIP001 {
//STRIP001 }

//STRIP001 void SwUndoReplace::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// war dieses nicht die letze Undo-Aktion, dann setze den
//STRIP001 	// Count neu
//STRIP001 	if( rUndoIter.pLastUndoObj != this )
//STRIP001 	{
//STRIP001 		nAktPos = aArr.Count();
//STRIP001 		rUndoIter.pLastUndoObj = this;
//STRIP001 		bOldIterFlag = rUndoIter.bWeiter;
//STRIP001 		rUndoIter.bWeiter = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	aArr[ --nAktPos ]->Undo( rUndoIter );
//STRIP001 
//STRIP001 	if( !nAktPos )		// alten Status wieder zurueck
//STRIP001 		rUndoIter.bWeiter = bOldIterFlag;
//STRIP001 }


//STRIP001 void SwUndoReplace::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// war dieses nicht die letze Undo-Aktion, dann setze den
//STRIP001 	// Count neu
//STRIP001 	if( rUndoIter.pLastUndoObj != this )
//STRIP001 	{
//STRIP001 		ASSERT( !nAktPos, "Redo ohne vorheriges Undo??" );
//STRIP001 		rUndoIter.pLastUndoObj = this;
//STRIP001 		bOldIterFlag = rUndoIter.bWeiter;
//STRIP001 		rUndoIter.bWeiter = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	aArr[ nAktPos ]->Redo( rUndoIter );
//STRIP001 
//STRIP001 	if( ++nAktPos >= aArr.Count() )	// alten Status wieder zurueck
//STRIP001 	{
//STRIP001 		nAktPos = USHRT_MAX;
//STRIP001 		rUndoIter.bWeiter = bOldIterFlag;
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoReplace::AddEntry( const SwPaM& rPam, const String& rInsert,
//STRIP001 								BOOL bRegExp )
//STRIP001 {
//STRIP001 	_UnReplaceData* pNew = new _UnReplaceData( rPam, rInsert, bRegExp );
//STRIP001 	aArr.C40_INSERT(_UnReplaceData, pNew, aArr.Count() );
//STRIP001 }

//STRIP001 void SwUndoReplace::SetEntryEnd( const SwPaM& rPam )
//STRIP001 {
//STRIP001 	_UnReplaceData* pEntry = aArr[ aArr.Count()-1 ];
//STRIP001 	pEntry->SetEnd( rPam );
//STRIP001 }

//STRIP001 _UnReplaceData::_UnReplaceData( const SwPaM& rPam, const String& rIns,
//STRIP001 								BOOL bRgExp )
//STRIP001 	: nOffset( 0 ), sIns( rIns )
//STRIP001 {
//STRIP001 	bRegExp = bRgExp;
//STRIP001 
//STRIP001 	const SwNodes& rNds = rPam.GetDoc()->GetNodes();
//STRIP001 	const SwPosition *pStt = rPam.Start(),
//STRIP001 					*pEnd = rPam.GetPoint() == pStt
//STRIP001 						? rPam.GetMark()
//STRIP001 						: rPam.GetPoint();
//STRIP001 
//STRIP001 	nSttNd = nEndNd = pStt->nNode.GetIndex();
//STRIP001 	nSttCnt = pStt->nContent.GetIndex();
//STRIP001 	nSelEnd = nEndCnt = pEnd->nContent.GetIndex();
//STRIP001 
//STRIP001 	bSplitNext = nSttNd != pEnd->nNode.GetIndex();
//STRIP001 
//STRIP001 	SwTxtNode* pNd = pStt->nNode.GetNode().GetTxtNode();
//STRIP001 	ASSERT( pNd, "wo ist der TextNode" );
//STRIP001 
//STRIP001 	pHistory = new SwHistory;
//STRIP001 	DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint() );
//STRIP001 
//STRIP001 	nSetPos = pHistory->Count();
//STRIP001 
//STRIP001 	ULONG nNewPos = pStt->nNode.GetIndex();
//STRIP001 	nOffset = nSttNd - nNewPos;
//STRIP001 
//STRIP001 	if( pNd->GetpSwpHints() )
//STRIP001 		pHistory->CopyAttr( pNd->GetpSwpHints(), nNewPos, 0,
//STRIP001 							pNd->GetTxt().Len(), TRUE );
//STRIP001 
//STRIP001 	if( bSplitNext )
//STRIP001 	{
//STRIP001 		if( pNd->GetpSwAttrSet() )
//STRIP001 			pHistory->CopyFmtAttr( *pNd->GetpSwAttrSet(), nNewPos );
//STRIP001 		pHistory->Add( pNd->GetTxtColl(), nNewPos, ND_TEXTNODE );
//STRIP001 
//STRIP001 		SwTxtNode* pNext = pEnd->nNode.GetNode().GetTxtNode();
//STRIP001 		ULONG nTmp = pNext->GetIndex();
//STRIP001 		pHistory->CopyAttr( pNext->GetpSwpHints(), nTmp, 0,
//STRIP001 							pNext->GetTxt().Len(), TRUE );
//STRIP001 		if( pNext->GetpSwAttrSet() )
//STRIP001 			pHistory->CopyFmtAttr( *pNext->GetpSwAttrSet(), nTmp );
//STRIP001 		pHistory->Add( pNext->GetTxtColl(),nTmp, ND_TEXTNODE );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pHistory->Count() )
//STRIP001 		delete pHistory, pHistory = 0;
//STRIP001 
//STRIP001 	xub_StrLen nECnt = bSplitNext ? pNd->GetTxt().Len() : pEnd->nContent.GetIndex();
//STRIP001 	sOld = pNd->GetTxt().Copy( nSttCnt, nECnt - nSttCnt );
//STRIP001 }

//STRIP001 _UnReplaceData::~_UnReplaceData()
//STRIP001 {
//STRIP001 }

//STRIP001 void _UnReplaceData::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rIter.GetDoc();
//STRIP001 	SwPaM& rPam = *rIter.pAktPam;
//STRIP001 	rPam.DeleteMark();
//STRIP001 
//STRIP001 	SwTxtNode* pNd = pDoc->GetNodes()[ nSttNd - nOffset ]->GetTxtNode();
//STRIP001 	ASSERT( pNd, "Wo ist der TextNode geblieben?" )
//STRIP001 
//STRIP001 	SwAutoCorrExceptWord* pACEWord = pDoc->GetAutoCorrExceptWord();
//STRIP001 	if( pACEWord )
//STRIP001 	{
//STRIP001 		if( 1 == sIns.Len() && 1 == sOld.Len() )
//STRIP001 		{
//STRIP001 			SwPosition aPos( *pNd ); aPos.nContent.Assign( pNd, nSttCnt );
//STRIP001 			pACEWord->CheckChar( aPos, sOld.GetChar( 0 ) );
//STRIP001 		}
//STRIP001 		pDoc->SetAutoCorrExceptWord( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	SwIndex aIdx( pNd, nSttCnt );
//STRIP001 	if( nSttNd == nEndNd )
//STRIP001 	{
//STRIP001 		pNd->Erase( aIdx, sIns.Len() );
//STRIP001 /*		if( bSplitNext )
//STRIP001 		{
//STRIP001 			SwPosition aPos( *pNd, aIdx );
//STRIP001 			pDoc->SplitNode( aPos, FALSE );
//STRIP001 			pNd = pDoc->GetNodes()[ nSttNd - nOffset ]->GetTxtNode();
//STRIP001 			aIdx.Assign( pNd, nSttCnt );
//STRIP001 		}
//STRIP001 */	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rPam.GetPoint()->nNode = *pNd;
//STRIP001 		rPam.GetPoint()->nContent.Assign( pNd, nSttCnt );
//STRIP001 		rPam.SetMark();
//STRIP001 		rPam.GetPoint()->nNode = nEndNd - nOffset;
//STRIP001 		rPam.GetPoint()->nContent.Assign( rPam.GetCntntNode(), nEndCnt );
//STRIP001 
//STRIP001 		pDoc->DeleteAndJoin( rPam );
//STRIP001 		rPam.DeleteMark();
//STRIP001 		pNd = rPam.GetNode()->GetTxtNode();
//STRIP001 		ASSERT( pNd, "Wo ist der TextNode geblieben?" );
//STRIP001 		aIdx.Assign( pNd, nSttCnt );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bSplitNext )
//STRIP001 	{
//STRIP001 		SwPosition aPos( *pNd, aIdx );
//STRIP001 		pDoc->SplitNode( aPos, FALSE );
//STRIP001 		pNd = pDoc->GetNodes()[ nSttNd - nOffset ]->GetTxtNode();
//STRIP001 		aIdx.Assign( pNd, nSttCnt );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( sOld.Len() )
//STRIP001 		pNd->Insert( sOld, aIdx );
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		if( pNd->GetpSwpHints() )
//STRIP001 			pNd->ClearSwpHintsArr( FALSE );
//STRIP001 
//STRIP001 		pHistory->TmpRollback( pDoc, nSetPos, FALSE );
//STRIP001 		if( nSetPos )		// es gab Fussnoten/FlyFrames
//STRIP001 		{
//STRIP001 			// gibts ausser diesen noch andere ?
//STRIP001 			if( nSetPos < pHistory->Count() )
//STRIP001 			{
//STRIP001 				// dann sicher die Attribute anderen Attribute
//STRIP001 				SwHistory aHstr;
//STRIP001 				aHstr.Move( 0, pHistory, nSetPos );
//STRIP001 				pHistory->Rollback( pDoc );
//STRIP001 				pHistory->Move( 0, &aHstr );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pHistory->Rollback( pDoc );
//STRIP001 				DELETEZ( pHistory );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rPam.GetPoint()->nNode = nSttNd;
//STRIP001 	rPam.GetPoint()->nContent = aIdx;
//STRIP001 }

//STRIP001 void _UnReplaceData::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	BOOL bUndo = rDoc.DoesUndo();
//STRIP001 	rDoc.DoUndo( FALSE );
//STRIP001 
//STRIP001 	SwPaM& rPam = *rIter.pAktPam;
//STRIP001 	rPam.DeleteMark();
//STRIP001 	rPam.GetPoint()->nNode = nSttNd;
//STRIP001 
//STRIP001 	SwTxtNode* pNd = rPam.GetPoint()->nNode.GetNode().GetTxtNode();
//STRIP001 	ASSERT( pNd, "Wo ist der TextNode geblieben?" )
//STRIP001 	rPam.GetPoint()->nContent.Assign( pNd, nSttCnt );
//STRIP001 	rPam.SetMark();
//STRIP001 	if( bSplitNext )
//STRIP001 	{
//STRIP001 		rPam.GetPoint()->nNode = nSttNd + 1;
//STRIP001 		pNd = rPam.GetPoint()->nNode.GetNode().GetTxtNode();
//STRIP001 	}
//STRIP001 	rPam.GetPoint()->nContent.Assign( pNd, nSelEnd );
//STRIP001 
//STRIP001 	if( pHistory )
//STRIP001 	{
//STRIP001 		SwHistory* pSave = pHistory;
//STRIP001 		SwHistory aHst;
//STRIP001 		pHistory = &aHst;
//STRIP001 		DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint() );
//STRIP001 		nSetPos = pHistory->Count();
//STRIP001 
//STRIP001 		pHistory = pSave;
//STRIP001 		pHistory->Move( 0, &aHst );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pHistory = new SwHistory;
//STRIP001 		DelCntntIndex( *rPam.GetMark(), *rPam.GetPoint() );
//STRIP001 		nSetPos = pHistory->Count();
//STRIP001 		if( !nSetPos )
//STRIP001 			delete pHistory, pHistory = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	rDoc.Replace( rPam, sIns, bRegExp );
//STRIP001 	rPam.DeleteMark();
//STRIP001 	rDoc.DoUndo( bUndo );
//STRIP001 }

//STRIP001 void _UnReplaceData::SetEnd( const SwPaM& rPam )
//STRIP001 {
//STRIP001 	if( rPam.GetPoint()->nNode != rPam.GetMark()->nNode )
//STRIP001 	{
//STRIP001 		// es wurden mehrere Absaetze eingefuegt
//STRIP001 		const SwPosition* pEnd = rPam.End();
//STRIP001 		nEndNd = nOffset + pEnd->nNode.GetIndex();
//STRIP001 		nEndCnt = pEnd->nContent.GetIndex();
//STRIP001 	}
//STRIP001 }

/*  */


//STRIP001 SwUndoReRead::SwUndoReRead( const SwPaM& rPam, const SwGrfNode& rGrfNd )
//STRIP001 	: SwUndo( UNDO_REREAD ), nPos( rPam.GetPoint()->nNode.GetIndex() )
//STRIP001 {
//STRIP001 	SaveGraphicData( rGrfNd );
//STRIP001 }


//STRIP001 SwUndoReRead::~SwUndoReRead()
//STRIP001 {
//STRIP001 	delete pGrf;
//STRIP001 	delete pNm;
//STRIP001 	delete pFltr;
//STRIP001 }


//STRIP001 void SwUndoReRead::SetAndSave( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	SwGrfNode* pGrfNd = rDoc.GetNodes()[ nPos ]->GetGrfNode();
//STRIP001 
//STRIP001 	if( !pGrfNd )
//STRIP001 		return ;
//STRIP001 
//STRIP001 		// die alten Werte zwischen speichern
//STRIP001 	Graphic* pOldGrf = pGrf;
//STRIP001 	String* pOldNm = pNm;
//STRIP001 	String* pOldFltr = pFltr;
//STRIP001 	USHORT nOldMirr = nMirr;
//STRIP001 
//STRIP001 	SaveGraphicData( *pGrfNd );
//STRIP001 	if( pOldNm )
//STRIP001 	{
//STRIP001 		pGrfNd->ReRead( *pOldNm, pFltr ? *pFltr : aEmptyStr, 0, 0, TRUE );
//STRIP001 		delete pOldNm;
//STRIP001 		delete pOldFltr;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pGrfNd->ReRead( aEmptyStr, aEmptyStr, pOldGrf, 0, TRUE );
//STRIP001 		delete pOldGrf;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( RES_DONT_MIRROR_GRF != nOldMirr )
//STRIP001 		pGrfNd->SetAttr( SwMirrorGrf() );
//STRIP001 
//STRIP001 	rIter.pSelFmt = pGrfNd->GetFlyFmt();
//STRIP001 }


//STRIP001 void SwUndoReRead::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SetAndSave( rIter );
//STRIP001 }


//STRIP001 void SwUndoReRead::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SetAndSave( rIter );
//STRIP001 }


//STRIP001 void SwUndoReRead::SaveGraphicData( const SwGrfNode& rGrfNd )
//STRIP001 {
//STRIP001 	if( rGrfNd.IsGrfLink() )
//STRIP001 	{
//STRIP001 		pNm = new String;
//STRIP001 		pFltr = new String;
//STRIP001 		rGrfNd.GetFileFilterNms( pNm, pFltr );
//STRIP001 		pGrf = 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		((SwGrfNode&)rGrfNd).SwapIn( TRUE );
//STRIP001 		pGrf = new Graphic( rGrfNd.GetGrf() );
//STRIP001 		pNm = pFltr = 0;
//STRIP001 	}
//STRIP001 	nMirr = rGrfNd.GetSwAttrSet().GetMirrorGrf().GetValue();
//STRIP001 }

/*  */

//STRIP001 SwUndoInsertLabel::SwUndoInsertLabel( const SwLabelType eTyp,
//STRIP001 									const String &rTxt, const BOOL bBef,
//STRIP001 									const USHORT nId, const BOOL bCpyBorder )
//STRIP001 	: SwUndo( UNDO_INSERTLABEL ), eType( eTyp ), sText( rTxt ),
//STRIP001 	bBefore( bBef ), nFldId( nId ), aPos( 0, 0 ), nLayerId( 0 ),
//STRIP001 	bCpyBrd( bCpyBorder )
//STRIP001 {
//STRIP001 	bUndoKeep = FALSE;
//STRIP001 	OBJECT.pUndoFly = 0;
//STRIP001 	OBJECT.pUndoAttr = 0;
//STRIP001 }

//STRIP001 SwUndoInsertLabel::~SwUndoInsertLabel()
//STRIP001 {
//STRIP001 	if( LTYPE_OBJECT == eType || LTYPE_DRAW == eType )
//STRIP001 	{
//STRIP001 		delete OBJECT.pUndoFly;
//STRIP001 		delete OBJECT.pUndoAttr;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		delete NODE.pUndoInsNd;
//STRIP001 }

//STRIP001 void SwUndoInsertLabel::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 
//STRIP001 	if( LTYPE_OBJECT == eType || LTYPE_DRAW == eType )
//STRIP001 	{
//STRIP001 		ASSERT( OBJECT.pUndoAttr && OBJECT.pUndoFly, "Pointer nicht initialisiert" )
//STRIP001 		SwFrmFmt* pFmt;
//STRIP001 		SdrObject *pSdrObj;
//STRIP001 		if( OBJECT.pUndoAttr &&
//STRIP001 			0 != (pFmt = (SwFrmFmt*)OBJECT.pUndoAttr->GetFmt( rDoc )) &&
//STRIP001 			( LTYPE_DRAW != eType ||
//STRIP001 			  0 != (pSdrObj = pFmt->FindSdrObject()) ) )
//STRIP001 		{
//STRIP001 			OBJECT.pUndoAttr->Undo( rIter );
//STRIP001 			OBJECT.pUndoFly->Undo( rIter );
//STRIP001 			if( LTYPE_DRAW == eType )
//STRIP001 			{
//STRIP001 				pSdrObj->SetRelativePos( aPos );
//STRIP001 				pSdrObj->SetLayer( nLayerId );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( NODE.nNode )
//STRIP001 	{
//STRIP001 		if ( eType == LTYPE_TABLE && bUndoKeep )
//STRIP001 		{
//STRIP001 			SwTableNode *pNd = rDoc.GetNodes()[
//STRIP001 						rDoc.GetNodes()[NODE.nNode-1]->StartOfSectionIndex()]->GetTableNode();
//STRIP001 			if ( pNd )
//STRIP001 				pNd->GetTable().GetFrmFmt()->ResetAttr( RES_KEEP );
//STRIP001 		}
//STRIP001 		SwPaM aPam( *rIter.pAktPam->GetPoint() );
//STRIP001 		aPam.GetPoint()->nNode = NODE.nNode;
//STRIP001 		aPam.SetMark();
//STRIP001 		aPam.GetPoint()->nNode = NODE.nNode + 1;
//STRIP001 		NODE.pUndoInsNd = new SwUndoDelete( aPam, TRUE );
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwUndoInsertLabel::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 
//STRIP001 	if( LTYPE_OBJECT == eType || LTYPE_DRAW == eType )
//STRIP001 	{
//STRIP001 		ASSERT( OBJECT.pUndoAttr && OBJECT.pUndoFly, "Pointer nicht initialisiert" )
//STRIP001 		SwFrmFmt* pFmt;
//STRIP001 		SdrObject *pSdrObj;
//STRIP001 		if( OBJECT.pUndoAttr &&
//STRIP001 			0 != (pFmt = (SwFrmFmt*)OBJECT.pUndoAttr->GetFmt( rDoc )) &&
//STRIP001 			( LTYPE_DRAW != eType ||
//STRIP001 			  0 != (pSdrObj = pFmt->FindSdrObject()) ) )
//STRIP001 		{
//STRIP001 			OBJECT.pUndoFly->Redo( rIter );
//STRIP001 			OBJECT.pUndoAttr->Redo( rIter );
//STRIP001 			if( LTYPE_DRAW == eType )
//STRIP001 			{
//STRIP001 				pSdrObj->SetRelativePos( Point(0,0) );
//STRIP001 				pSdrObj->SetLayer( nLayerId );
//STRIP001 				if( pSdrObj->GetLayer() == rDoc.GetHellId() )
//STRIP001 					pSdrObj->SetLayer( rDoc.GetHeavenId() );
//STRIP001                 // OD 02.07.2003 #108784#
//STRIP001                 else if( pSdrObj->GetLayer() == rDoc.GetInvisibleHellId() )
//STRIP001                     pSdrObj->SetLayer( rDoc.GetInvisibleHeavenId() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( NODE.pUndoInsNd )
//STRIP001 	{
//STRIP001 		if ( eType == LTYPE_TABLE && bUndoKeep )
//STRIP001 		{
//STRIP001 			SwTableNode *pNd = rDoc.GetNodes()[
//STRIP001 						rDoc.GetNodes()[NODE.nNode-1]->StartOfSectionIndex()]->GetTableNode();
//STRIP001 			if ( pNd )
//STRIP001 				pNd->GetTable().GetFrmFmt()->SetAttr( SvxFmtKeepItem(TRUE) );
//STRIP001 		}
//STRIP001 		NODE.pUndoInsNd->Undo( rIter );
//STRIP001 		delete NODE.pUndoInsNd, NODE.pUndoInsNd = 0;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoInsertLabel::Repeat( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	const SwPosition& rPos = *rIter.pAktPam->GetPoint();
//STRIP001 
//STRIP001 	ULONG nIdx = 0;
//STRIP001 
//STRIP001 	SwCntntNode* pCNd = rPos.nNode.GetNode().GetCntntNode();
//STRIP001 	if( pCNd )
//STRIP001 		switch( eType )
//STRIP001 		{
//STRIP001 		case LTYPE_TABLE:
//STRIP001 			{
//STRIP001 				const SwTableNode* pTNd = pCNd->FindTableNode();
//STRIP001 				if( pTNd )
//STRIP001 					nIdx = pTNd->GetIndex();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case LTYPE_FLY:
//STRIP001 		case LTYPE_OBJECT:
//STRIP001 			{
//STRIP001 				SwFlyFrm* pFly;
//STRIP001 				SwCntntFrm *pCnt = pCNd->GetFrm();
//STRIP001 				if( pCnt && 0 != ( pFly = pCnt->FindFlyFrm() ) )
//STRIP001 					nIdx = pFly->GetFmt()->GetCntnt().GetCntntIdx()->GetIndex();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 	if( nIdx )
//STRIP001 	{
//STRIP001 		rDoc.InsertLabel( eType, sText, bBefore, nFldId, nIdx, bCpyBrd );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoInsertLabel::SetFlys( SwFrmFmt& rOldFly, SfxItemSet& rChgSet,
//STRIP001 								SwFrmFmt& rNewFly )
//STRIP001 {
//STRIP001 	if( LTYPE_OBJECT == eType || LTYPE_DRAW == eType )
//STRIP001 	{
//STRIP001 		_UndoFmtAttr aTmp( rOldFly, FALSE );
//STRIP001 		rOldFly.SetAttr( rChgSet );
//STRIP001 		if( aTmp.pUndo )
//STRIP001 			OBJECT.pUndoAttr = aTmp.pUndo;
//STRIP001 		OBJECT.pUndoFly = new SwUndoInsLayFmt( &rNewFly );
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoInsertLabel::SetDrawObj( const Point& rPos, BYTE nLId )
//STRIP001 {
//STRIP001 	if( LTYPE_DRAW == eType )
//STRIP001 	{
//STRIP001 		aPos = rPos;
//STRIP001 		nLayerId = nLId;
//STRIP001 	}
//STRIP001 }

}
