/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_docundo.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:42:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _SV_WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif

#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif

// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>
// auto strip #endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>		// fuer die UndoIds
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
// auto strip #ifndef _ROLBCK_HXX
// auto strip #include <rolbck.hxx>
// auto strip #endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
namespace binfilter {

USHORT SwDoc::nUndoActions = UNDO_ACTION_COUNT;		// anzahl von Undo-Action

// the undo array should never grow beyond this limit:
#define UNDO_ACTION_LIMIT (USHRT_MAX - 1000)


//STRIP001 SV_IMPL_PTRARR( SwUndoIds, SwUndoIdAndNamePtr )

//#define _SHOW_UNDORANGE
#ifdef _SHOW_UNDORANGE


//STRIP001 class UndoArrStatus : public WorkWindow
//STRIP001 {
//STRIP001 	USHORT nUndo, nUndoNds;
//STRIP001 	virtual void Paint( const Rectangle& );
//STRIP001 public:
//STRIP001 	UndoArrStatus();
//STRIP001 	void Set( USHORT, USHORT );
//STRIP001 };
//STRIP001 static UndoArrStatus* pUndoMsgWin = 0;


//STRIP001 UndoArrStatus::UndoArrStatus()
//STRIP001 	: WorkWindow( APP_GETAPPWINDOW() ), nUndo(0), nUndoNds(0)
//STRIP001 {
//STRIP001 	SetSizePixel( Size( 200, 100 ));
//STRIP001 	SetFont( Font( "Courier", Size( 0, 10 )) );
//STRIP001 	Show();
//STRIP001 }


//STRIP001 void UndoArrStatus::Set( USHORT n1, USHORT n2 )
//STRIP001 {
//STRIP001 	nUndo = n1; nUndoNds = n2;
//STRIP001 	Invalidate();
//STRIP001 }


//STRIP001 void UndoArrStatus::Paint( const Rectangle& )
//STRIP001 {
//STRIP001 	String s;
//STRIP001 	DrawRect( Rectangle( Point(0,0), GetOutputSize() ));
//STRIP001 	( s = "Undos: " ) += nUndo;
//STRIP001 	DrawText( Point( 0, 0 ), s );
//STRIP001 	( s = "UndoNodes: " ) += nUndoNds;
//STRIP001 	DrawText( Point( 0, 15 ), s );
//STRIP001 }

#endif


/*N*/ void SwDoc::AppendUndo( SwUndo* pUndo )
/*N*/ {
/*N*/ #ifdef COMPACT
/*N*/ 	DelUndoGroups( FALSE );		// nur die History loeschen !!
/*N*/ #endif
/*N*/ 
/*N*/ 	if( REDLINE_NONE == pUndo->GetRedlineMode() )
/*N*/ 		pUndo->SetRedlineMode( GetRedlineMode() );
/*N*/ 
/*N*/     // Unfortunately, the silly SvPtrArr can only store a little less than
/*N*/     // USHRT_MAX elements. Of course it doesn't see any necessity for asserting
/*N*/     // or even doing error handling. pUndos should definitely be replaced by an
/*N*/     // STL container that doesn't have this problem. cf #95884#
/*N*/     DBG_ASSERT( pUndos->Count() < USHRT_MAX - 16,
/*N*/                 "Writer will crash soon. I apologize for the inconvenience." );
/*N*/ 
/*N*/ 	pUndos->Insert( pUndo, nUndoPos );
/*N*/ 	++nUndoPos;
/*N*/ 	switch( pUndo->GetId() )
/*N*/ 	{
/*N*/ 	case UNDO_START:		++nUndoSttEnd;
/*N*/ 							break;
/*N*/ 
/*N*/ 	case UNDO_END:		    ASSERT( nUndoSttEnd, "Undo-Ende ohne Start" );
/*N*/ 							--nUndoSttEnd;
/*N*/ 							// kein break !!!
/*N*/ 	default:
/*N*/ 		if( pUndos->Count() != nUndoPos && UNDO_END != pUndo->GetId() )
/*N*/ 			ClearRedo();
/*N*/ 		else
/*N*/ 			ASSERT( pUndos->Count() == nUndoPos || UNDO_END == pUndo->GetId(),
/*N*/ 					"Redo history not deleted!" );
/*N*/ 		if( !nUndoSttEnd )
/*N*/ 			++nUndoCnt;
/*N*/ 		break;
/*N*/ 	}
/*N*/ 
/*N*/ #ifdef _SHOW_UNDORANGE
/*N*/ 	// zur Anzeige der aktuellen Undo-Groessen
/*N*/ 	if( !pUndoMsgWin )
/*N*/ 			pUndoMsgWin = new UndoArrStatus;
/*N*/ 	pUndoMsgWin->Set( pUndos->Count(), aUndoNodes.Count() );
/*N*/ #endif
/*N*/ 
/*N*/ 	// noch eine offene Klammerung, kann man sich den Rest schenken
/*N*/ 	if( nUndoSttEnd )
/*N*/ 		return;
/*N*/ 
/*N*/ 	// folgende Array-Grenzen muessen ueberwacht werden:
/*N*/ 	//	- Undo,				Grenze: fester Wert oder USHRT_MAX - 1000
/*N*/ 	//	- UndoNodes,		Grenze:  USHRT_MAX - 1000
/*N*/ 	//	- AttrHistory       Grenze:  USHRT_MAX - 1000
/*N*/     // (defined in UNDO_ACTION_LIMIT at the top of this file)
/*N*/ 
/*N*/ 	USHORT nEnde = UNDO_ACTION_LIMIT;
/*N*/ 
/*N*/ // nur zum Testen der neuen DOC-Member
/*N*/ #ifndef PRODUCT
/*N*/ {
/*N*/ 	USHORT nId, nUndosCnt = 0, nSttEndCnt = 0;
/*N*/ 	for( USHORT nCnt = 0; nCnt < nUndoPos; ++nCnt )
/*N*/ 	{
/*N*/ 		if( UNDO_START == ( nId = (*pUndos)[ nCnt ]->GetId() ))
/*N*/ 			++nSttEndCnt;
/*N*/ 		else if( UNDO_END == nId )
/*N*/ 			--nSttEndCnt;
/*N*/ 		if( !nSttEndCnt )
/*N*/ 			++nUndosCnt;
/*N*/ 	}
/*N*/ 	ASSERT( nSttEndCnt == nUndoSttEnd, "Start-Ende Count ungleich" );
/*N*/ 	ASSERT( nUndosCnt == nUndoCnt, "Undo Count ungleich" );
/*N*/ }
/*N*/ #endif
/*N*/ 
/*N*/ 	if( SwDoc::nUndoActions < nUndoCnt )
/*N*/ 		// immer 1/10 loeschen
/*N*/ 		//JP 23.09.95: oder wenn neu eingestellt wurde um die Differenz
/*N*/ 		//JP 29.5.2001: Task #83891#: remove only the overlapping actions
/*N*/ 		DelUndoObj( nUndoCnt - SwDoc::nUndoActions );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		USHORT nUndosCnt = nUndoCnt;
/*N*/ 			// immer 1/10 loeschen bis der "Ausloeser" behoben ist
/*N*/ 		while( aUndoNodes.Count() && nEnde < aUndoNodes.Count() )
/*?*/ 			DelUndoObj( nUndosCnt / 10 );
/*N*/ 	}
/*N*/ }



/*N*/ void SwDoc::ClearRedo()
/*N*/ {
/*N*/ 	if( DoesUndo() && nUndoPos != pUndos->Count() )
/*N*/ 	{
/*N*/ //?? why ??		if( !nUndoSttEnd )
/*N*/ 		{
/*N*/ 			// setze UndoCnt auf den neuen Wert
/*N*/ 			SwUndo* pUndo;
/*?*/ 			for( USHORT nCnt = pUndos->Count(); nUndoPos < nCnt; --nUndoCnt )
/*?*/ 				// Klammerung ueberspringen
/*?*/ 				if( UNDO_END == (pUndo = (*pUndos)[ --nCnt ])->GetId() )
/*?*/ 					nCnt -= ((SwUndoEnd*)pUndo)->GetSttOffset();
/*?*/ 		}
/*?*/ 
/*?*/ 		// loesche die Undo-Aktionen (immer von hinten !)
/*?*/ 		pUndos->DeleteAndDestroy( nUndoPos, pUndos->Count() - nUndoPos );
/*N*/ 	}
/*N*/ }


	// loescht die gesamten UndoObjecte
/*N*/ void SwDoc::DelAllUndoObj()
/*N*/ {
/*N*/ 	ClearRedo();
/*N*/ 
/*N*/ 	DoUndo( FALSE );
/*N*/ 
/*N*/ 	// Offene Undo-Klammerungen erhalten !!
/*N*/ 	SwUndo* pUndo;
/*N*/ 	USHORT nSize = pUndos->Count();
/*N*/ 	while( nSize )
/*N*/ 		if( UNDO_START != ( pUndo = (*pUndos)[ --nSize ] )->GetId() ||
/*N*/ 			((SwUndoStart*)pUndo)->GetEndOffset() )
/*N*/ 			// keine offenen Gruppierung ?
/*N*/ 			pUndos->DeleteAndDestroy( nSize, 1 );
/*N*/ 
/*N*/ 	nUndoCnt = 0;
/*N*/ 	nUndoPos = pUndos->Count();

/*
	while( nUndoPos )
		aUndos.DelDtor( --nUndoPos, 1 );
	nUndoCnt = nUndoSttEnd = nUndoPos = 0;
*/
/*N*/ 	nUndoSavePos = USHRT_MAX;
/*N*/ 	DoUndo( TRUE );
/*N*/ }


	// loescht alle UndoObjecte vom Anfang bis zum angegebenen Ende
/*N*/ BOOL SwDoc::DelUndoObj( USHORT nEnde )
/*N*/ {
/*N*/ 	if( !nEnde )					// sollte mal 0 uebergeben werden,
/*N*/ 	{
/*?*/ 		if( !pUndos->Count() )
/*?*/ 			return FALSE;
/*?*/ 		++nEnde;            		// dann korrigiere es auf 1
/*N*/ 	}
/*N*/ 
/*N*/ 	DoUndo( FALSE );
/*N*/ 
/*N*/ 	// pruefe erstmal, wo das Ende steht
/*N*/ 	USHORT nId = 0, nSttEndCnt = 0;
		USHORT nCnt = 0;
/*N*/ 	for( nCnt = 0; nEnde && nCnt < nUndoPos; ++nCnt )
/*N*/ 	{
/*N*/ 		if( UNDO_START == ( nId = (*pUndos)[ nCnt ]->GetId() ))
/*N*/ 			++nSttEndCnt;
/*N*/ 		else if( UNDO_END == nId )
/*N*/ 			--nSttEndCnt;
/*N*/ 		if( !nSttEndCnt )
/*N*/ 			--nEnde, --nUndoCnt;
/*N*/ 	}
/*N*/ 
/*N*/ 	ASSERT( nCnt < nUndoPos || nUndoPos == pUndos->Count(),
/*N*/ 			"Undo-Del-Ende liegt in einer Redo-Aktion" );
/*N*/ 
/*N*/ 	// dann setze ab Ende bis Undo-Ende bei allen Undo-Objecte die Werte um
/*N*/ 	nSttEndCnt = nCnt;			// Position merken
/*N*/ 	if( nUndoSavePos < nSttEndCnt )		// SavePos wird aufgegeben
/*N*/ 		nUndoSavePos = USHRT_MAX;
/*N*/ 	else if( nUndoSavePos != USHRT_MAX )
/*?*/ 		nUndoSavePos -= nSttEndCnt;
/*N*/ 
/*N*/ 	while( nSttEndCnt )
/*N*/ 		pUndos->DeleteAndDestroy( --nSttEndCnt, 1 );
/*N*/ 	nUndoPos = pUndos->Count();
/*N*/ 
/*N*/ 	DoUndo( TRUE );
/*N*/ 	return TRUE;
/*N*/ }

/**************** UNDO ******************/


//STRIP001 BOOL SwDoc::HasUndoId(USHORT nId) const
//STRIP001 {
//STRIP001 	USHORT nSize = nUndoPos;
//STRIP001 	SwUndo * pUndo;
//STRIP001 	while( nSize-- )
//STRIP001 		if( ( pUndo = (*pUndos)[nSize])->GetId() == nId ||
//STRIP001 			( UNDO_START == pUndo->GetId() &&
//STRIP001 				((SwUndoStart*)pUndo)->GetUserId() == nId )
//STRIP001 			|| ( UNDO_END == pUndo->GetId() &&
//STRIP001 				((SwUndoEnd*)pUndo)->GetUserId() == nId ) )
//STRIP001 		{
//STRIP001 			return TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }


//STRIP001 BOOL SwDoc::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if ( (rUndoIter.GetId()!=0) && (!HasUndoId(rUndoIter.GetId())) )
//STRIP001 	{
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 	if( !nUndoPos )
//STRIP001 	{
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SwUndo *pUndo = (*pUndos)[ --nUndoPos ];
//STRIP001 
//STRIP001 	SwRedlineMode eOld = GetRedlineMode();
//STRIP001 	SwRedlineMode eTmpMode = (SwRedlineMode)pUndo->GetRedlineMode();
//STRIP001 	if( (REDLINE_SHOW_MASK & eTmpMode) != (REDLINE_SHOW_MASK & eOld) &&
//STRIP001 		UNDO_START != pUndo->GetId() && UNDO_END != pUndo->GetId() )
//STRIP001 		SetRedlineMode( eTmpMode );
//STRIP001 
//STRIP001 	SetRedlineMode_intern( eTmpMode | REDLINE_IGNORE );
//STRIP001 	// Undo ausfuehren
//STRIP001 
//STRIP001 	// zum spaeteren ueberpruefen
//STRIP001 	USHORT nAktId = pUndo->GetId();
//STRIP001 	//JP 11.05.98: FlyFormate ueber die EditShell selektieren, nicht aus dem
//STRIP001 	//				Undo heraus
//STRIP001 	switch( nAktId )
//STRIP001 	{
//STRIP001 	case UNDO_START:
//STRIP001 	case UNDO_END:
//STRIP001 	case UNDO_INSDRAWFMT:
//STRIP001 		break;
//STRIP001 
//STRIP001 	default:
//STRIP001 		rUndoIter.ClearSelections();
//STRIP001 	}
//STRIP001 
//STRIP001 	pUndo->Undo( rUndoIter );
//STRIP001 
//STRIP001 	SetRedlineMode( eOld );
//STRIP001 
//STRIP001 	// Besonderheit von Undo-Replace (interne History)
//STRIP001 	if( UNDO_REPLACE == nAktId && ((SwUndoReplace*)pUndo)->nAktPos )
//STRIP001 	{
//STRIP001 		++nUndoPos;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Objekt aus History entfernen und zerstoeren
//STRIP001 	if( nUndoPos && !rUndoIter.bWeiter &&
//STRIP001 		UNDO_START == ( pUndo = (*pUndos)[ nUndoPos-1 ] )->GetId() )
//STRIP001 		--nUndoPos;
//STRIP001 
//STRIP001 	// JP 29.10.96: Start und End setzen kein Modify-Flag.
//STRIP001 	//				Sonst gibt es Probleme mit der autom. Aufnahme von Ausnahmen
//STRIP001 	//				bei der Autokorrektur
//STRIP001 	if( UNDO_START != nAktId && UNDO_END != nAktId )
//STRIP001 		SetModified();		// default: immer setzen, kann zurueck gesetzt werden
//STRIP001 
//STRIP001 #ifdef COMPACT
//STRIP001 
//STRIP001 	// in der Compact-Version gibt es nur ein einstufiges Undo. Ueber das
//STRIP001 	// Flag wird erkannt, wann ein Dokument als unveraendert gekennzeichnet
//STRIP001 	// werden kann; nach einer Aktion und deren Undo
//STRIP001 	// Bei mehr als einer Aktion ist das Dokument immer veraendert.
//STRIP001 
//STRIP001 // wird nicht mehr beneotigt oder ???		Member am DOC geloescht
//STRIP001 //	if( UNDO_FIRST == eUndoFlag )
//STRIP001 //	{
//STRIP001 //		ResetModified();
//STRIP001 //		eUndoFlag = UNDO_INIT;
//STRIP001 //	}
//STRIP001 
//STRIP001 #else
//STRIP001 	// ist die History leer und wurde nicht wegen Speichermangel
//STRIP001 	// verworfen, so kann das Dokument als unveraendert gelten
//STRIP001 	if( nUndoSavePos == nUndoPos )
//STRIP001 		ResetModified();
//STRIP001 #endif
//STRIP001 	return TRUE;
//STRIP001 }


// setzt Undoklammerung auf, liefert nUndoId der Klammerung


/*N*/ USHORT SwDoc::StartUndo( USHORT nUndoId )
/*N*/ {
/*N*/ 	if( !bUndo )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	if( !nUndoId )
/*N*/ 		nUndoId = UNDO_START;
/*N*/ 
/*N*/ 	AppendUndo( new SwUndoStart( nUndoId ));
/*N*/ 	return nUndoId;
/*N*/ }
// schliesst Klammerung der nUndoId, nicht vom UI benutzt


/*N*/ USHORT SwDoc::EndUndo(USHORT nUndoId)
/*N*/ {
/*N*/ 	USHORT nSize = nUndoPos;
/*N*/ 	if( !bUndo || !nSize-- )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	if( UNDO_START == nUndoId || !nUndoId )
/*N*/ 		nUndoId = UNDO_END;
/*N*/ 
/*N*/ 	SwUndo* pUndo = (*pUndos)[ nSize ];
/*N*/ 	if( UNDO_START == pUndo->GetId() )
/*N*/ 	{
/*N*/ 		// leere Start/End-Klammerung ??
/*N*/ 		pUndos->DeleteAndDestroy( nSize );
/*N*/ 		--nUndoPos;
/*N*/ 		--nUndoSttEnd;
/*N*/ 		return 0;
/*N*/ 	}
/*N*/ 
/*N*/ 	// exist above any redo objects? If yes, delete them
/*N*/ 	if( nUndoPos != pUndos->Count() )
/*N*/ 	{
/*N*/ 		// setze UndoCnt auf den neuen Wert
/*?*/ 		for( USHORT nCnt = pUndos->Count(); nUndoPos < nCnt; --nUndoCnt )
/*?*/ 			// Klammerung ueberspringen
/*?*/ 			if( UNDO_END == (pUndo = (*pUndos)[ --nCnt ])->GetId() )
/*?*/ 				nCnt -= ((SwUndoEnd*)pUndo)->GetSttOffset();
/*?*/ 
/*?*/ 		pUndos->DeleteAndDestroy( nUndoPos, pUndos->Count() - nUndoPos );
/*N*/ 	}
/*N*/ 
/*N*/ 	// suche den Anfang dieser Klammerung
/*N*/ 	USHORT nId;
/*N*/ 	while( nSize )
/*N*/ 		if( UNDO_START == ( nId = (pUndo = (*pUndos)[ --nSize ] )->GetId()) &&
/*N*/ 			!((SwUndoStart*)pUndo)->GetEndOffset() )
/*N*/ 			break;		// Start gefunden
/*N*/ 
/*N*/ 	if( nId != UNDO_START )
/*N*/ 	{
/*?*/ 		// kann eigentlich nur beim Abspielen von Macros passieren, die
/*?*/ 		// Undo/Redo/Repeat benutzen und die eine exitierende Selection
/*?*/ 		// durch Einfuegen loeschen
/*?*/ 		ASSERT( !this, "kein entsprechendes Ende gefunden" );
/*?*/ 		// kein entsprechenden Start gefunden -> Ende nicht einfuegen
/*?*/ 		// und die Member am Doc updaten
/*?*/ 
/*?*/ 		nUndoSttEnd = 0;
/*?*/ 		nUndoCnt = 0;
/*?*/ 		// setze UndoCnt auf den neuen Wert
/*?*/ 		SwUndo* pUndo;
/*?*/ 		for( USHORT nCnt = 0; nCnt < pUndos->Count(); ++nCnt, ++nUndoCnt )
/*?*/ 			// Klammerung ueberspringen
/*?*/ 			if( UNDO_START == (pUndo = (*pUndos)[ nCnt ])->GetId() )
/*?*/ 				nCnt += ((SwUndoStart*)pUndo)->GetEndOffset();
/*?*/ 		return 0;
/*?*/ 
/*N*/ 	}

	// Klammerung um eine einzelne Action muss nicht sein!
	// Aussnahme: es ist eine eigene ID definiert
/*N*/ 	if(  2 == pUndos->Count() - nSize &&
/*N*/ 		(UNDO_END == nUndoId || nUndoId == (*pUndos)[ nSize+1 ]->GetId() ))
/*N*/ 	{
/*N*/ 		pUndos->DeleteAndDestroy( nSize );
/*N*/ 		nUndoPos = pUndos->Count();
/*N*/ 		if( !--nUndoSttEnd )
/*N*/ 		{
/*N*/ 			++nUndoCnt;
/*N*/ 			if( SwDoc::nUndoActions < nUndoCnt )
/*N*/ 				// immer 1/10 loeschen
/*N*/ 				//JP 23.09.95: oder wenn neu eingestellt wurde um die Differenz
/*N*/ 				//JP 29.5.2001: Task #83891#: remove only the overlapping actions
/*N*/ 				DelUndoObj( nUndoCnt - SwDoc::nUndoActions );
/*N*/ 			else
/*N*/ 			{
/*N*/ 				USHORT nEnde = USHRT_MAX - 1000;
/*N*/ 				USHORT nUndosCnt = nUndoCnt;
/*N*/ 					// immer 1/10 loeschen bis der "Ausloeser" behoben ist
/*N*/ 				while( aUndoNodes.Count() && nEnde < aUndoNodes.Count() )
/*?*/ 					DelUndoObj( nUndosCnt / 10 );
/*N*/ 			}
/*N*/ 		}
/*N*/ 		return nUndoId;
/*N*/ 	}
/*N*/ 
/*N*/ 	// setze die Klammerung am Start/End-Undo
/*N*/ 	nSize = pUndos->Count() - nSize;
/*N*/ 	((SwUndoStart*)pUndo)->SetEndOffset( nSize );
/*N*/ 
/*N*/ 	SwUndoEnd* pUndoEnd = new SwUndoEnd( nUndoId );
/*N*/ 	pUndoEnd->SetSttOffset( nSize );
/*N*/ 
/*N*/ // nur zum Testen der Start/End-Verpointerung vom Start/End Undo
/*N*/ #ifndef PRODUCT
/*N*/ {
/*N*/ 	USHORT nEndCnt = 1, nCnt = pUndos->Count(), nId;
/*N*/ 	while( nCnt )
/*N*/ 	{
/*N*/ 		if( UNDO_START == ( nId = (*pUndos)[ --nCnt ]->GetId()) )
/*N*/ 		{
/*N*/ 			if( !nEndCnt )		// falls mal ein Start ohne Ende vorhanden ist
/*N*/ 				continue;
/*N*/ 			--nEndCnt;
/*N*/ 			if( !nEndCnt )		// hier ist der Anfang
/*N*/ 				break;
/*N*/ 		}
/*N*/ 		else if( UNDO_END == nId )
/*N*/ 			++nEndCnt;
/*N*/ 		else if( !nEndCnt )
/*N*/ 			break;
/*N*/ 	}
/*N*/ 	ASSERT( nCnt == pUndos->Count() - nSize, "Start-Ende falsch geklammert" );
/*N*/ }
/*N*/ #endif
/*N*/ 
/*N*/ 	AppendUndo( pUndoEnd );
/*N*/ 	return nUndoId;
/*N*/ }

// liefert die Id der letzten Undofaehigen Aktion zurueck oder 0
// fuellt ggf. VARARR mit User-UndoIds


/*N*/ USHORT SwDoc::GetUndoIds( String* pStr, SwUndoIds *pUndoIds) const
/*N*/ {
/*N*/ 	USHORT nSize = nUndoPos;
/*N*/ 	if ( nSize-- == 0 )
/*N*/ 		return 0;
/*N*/ 
/*N*/ 	USHORT nId;
/*N*/ 	SwUndo* pUndo;
/*N*/ 	String sTmp;
/*N*/ 	if( pUndoIds )
/*N*/ 		pStr = &sTmp;
/*N*/ 
/*N*/ 	do {
/*N*/ 		USHORT nUndoEndPos = USHRT_MAX;
/*N*/ 		if( UNDO_END == (nId = (pUndo = (*pUndos)[nSize])->GetId() ))
/*N*/ 		{
/*N*/ 			nUndoEndPos = nSize;
/*N*/ 			while( nSize &&
/*N*/ 				   UNDO_END == (nId = ((SwUndoEnd*)pUndo)->GetUserId()) )
/*N*/ 			{
/*N*/ 				nSize--;
/*N*/ 				if( UNDO_END != (nId = (pUndo = (*pUndos)[nSize])->GetId() ))
/*N*/ 					break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		switch( pUndo->GetId() )
/*N*/ 		{
/*N*/ 		case UNDO_START:
/*?*/ 			nId = ((SwUndoStart*)pUndo)->GetUserId();
/*?*/ 			break;
/*?*/ 		case UNDO_REDLINE:
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	nId = ((SwUndoRedline*)pUndo)->GetUserId();
/*?*/ 			break;
/*?*/ 		case UNDO_DRAWUNDO:
/*?*/ 			if( pStr )
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 *pStr = ((SwSdrUndo*)pUndo)->GetComment();
/*?*/ 			break;
/*?*/ 		}
/*N*/ 
/*N*/ 		if( !nSize && UNDO_END == nId )
/*N*/ 			nId = 0;
/*N*/ 		else if( pUndoIds )
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SwUndoIdAndName* pNew = new SwUndoIdAndName( nId, pStr );
//STRIP001 /*?*/ 			pUndoIds->Insert( pNew, pUndoIds->Count() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( USHRT_MAX != nUndoEndPos )
//STRIP001 /*?*/ 				nSize = nUndoEndPos - ((SwUndoEnd*)(*pUndos)[
//STRIP001 /*?*/ 											nUndoEndPos ])->GetSttOffset();
//STRIP001 /*?*/ 			if( !nSize-- )
//STRIP001 /*?*/ 				break;
/*N*/ 		}
/*N*/ 	} while( pUndoIds );
/*N*/ 	return nId;
/*N*/ }

#ifdef COMPACT

//STRIP001 BOOL SwDoc::DelUndoGroups( BOOL bDelUndoNds, BOOL bDelHistory )
//STRIP001 {
//STRIP001 	USHORT nEnd = 0, nStart = 0;
//STRIP001 	USHORT nSize = pUndos->GetSize();
//STRIP001 	SwUndo* pUndo;
//STRIP001 
//STRIP001 	if( !nSize )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	while( nSize-- )
//STRIP001 	{
//STRIP001 		 pUndo = (*pUndos)[ nSize ];
//STRIP001 		 if( UNDO_STD_END <= pUndo->GetId() || UNDO_END == pUndo->GetId() )
//STRIP001 			// es kann sich nur um ein Ende handeln
//STRIP001 			nEnd++;
//STRIP001 		 else if( UNDO_START == pUndo->GetId() )
//STRIP001 			nStart++;
//STRIP001 	}
//STRIP001 
//STRIP001 	// eine vollstaendige Gruppe ist, wenn nStart und nEnd gleich sind
//STRIP001 	if( nStart != nEnd )
//STRIP001 		return TRUE;
//STRIP001 
//STRIP001 	// jetzt kommt erst das eigentliche loeschen
//STRIP001 	if( bDelHistory )
//STRIP001 		pUndos->DelDtor( 0, pUndos->GetSize() );		// die UndoListe
//STRIP001 
//STRIP001 	// loesche das Undo-Nodes-Array
//STRIP001 	if( bDelUndoNds )
//STRIP001 	{
//STRIP001 		// es wird aus dem Undo-Array der gesamte Inhalt geloescht
//STRIP001 		SwNodeIndex aIdx( *aUndoNodes.GetEndOfContent().StartOfSectionNode(), 1 );
//STRIP001 		SwTxtNode * pTxtNd = 0;
//STRIP001 		if( aIdx.GetIndex() + 1 < aUndoNodes.GetEndOfContent().GetIndex() ||
//STRIP001 			0 == ( pTxtNd = aIdx.GetNode().GetTxtNode() ))
//STRIP001 		{
//STRIP001 			// loesche alle Nodes und suche oder erzeuge einen neuen TextNode
//STRIP001 			while( aIdx < aUndoNodes.GetEndOfContent().GetIndex() )
//STRIP001 			{
//STRIP001 				aUndoNodes.Delete( aIdx , 1 );
//STRIP001 				if( !pTxtNd && 0 != ( pTxtNd = aIdx.GetNode().GetTxtNode()))
//STRIP001 					aIdx++;
//STRIP001 			}
//STRIP001 			if( !pTxtNd )
//STRIP001 			{
//STRIP001 				// sollte eigentlich nie auftreten.
//STRIP001 				pTxtNd = aUndoNodes.MakeTxtNode( aIdx,
//STRIP001 									0, 0, 0, (*GetTxtFmtColls())[0] );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// es braucht nur noch der Inhalt aus dem Node geloescht werden
//STRIP001 		if( pTxtNd->Len() )
//STRIP001 		{
//STRIP001 			aIdx.Assign( pTxtNd, 0 );
//STRIP001 			pTxtNd->Erase( aIdx, pTxtNd->Len() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nUndoPos = pUndos->GetSize();
//STRIP001 
//STRIP001 	if( nUndoSavePos > nUndoPos )		// SavePos wird aufgegeben
//STRIP001 		nUndoSavePos = USHRT_MAX;
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
#endif

//STRIP001 sal_Bool SwDoc::HasTooManyUndos()
//STRIP001 {
//STRIP001     // AppendUndo checks the UNDO_ACTION_LIMIT, unless there's a nested undo.
//STRIP001     // So HasTooManyUndos() may only occur when undos are nested; else
//STRIP001     // AppendUndo has some sort of bug.
//STRIP001     DBG_ASSERT( (nUndoSttEnd != 0) || (pUndos->Count() < UNDO_ACTION_LIMIT),
//STRIP001                 "non-nested undos should have been handled in AppendUndo" );
//STRIP001     return (pUndos->Count() >= UNDO_ACTION_LIMIT);
//STRIP001 }


/**************** REDO ******************/


//STRIP001 BOOL SwDoc::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( rUndoIter.GetId() && !HasUndoId( rUndoIter.GetId() ) )
//STRIP001 	{
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 	if( nUndoPos == pUndos->Count() )
//STRIP001 	{
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SwUndo *pUndo = (*pUndos)[ nUndoPos++ ];
//STRIP001 
//STRIP001 	SwRedlineMode eOld = GetRedlineMode();
//STRIP001 	SwRedlineMode eTmpMode = (SwRedlineMode)pUndo->GetRedlineMode();
//STRIP001 	if( (REDLINE_SHOW_MASK & eTmpMode) != (REDLINE_SHOW_MASK & eOld) &&
//STRIP001 		UNDO_START != pUndo->GetId() && UNDO_END != pUndo->GetId() )
//STRIP001 		SetRedlineMode( eTmpMode );
//STRIP001 	SetRedlineMode_intern( eTmpMode | REDLINE_IGNORE );
//STRIP001 
//STRIP001 	//JP 11.05.98: FlyFormate ueber die EditShell selektieren, nicht aus dem
//STRIP001 	//				Undo heraus
//STRIP001 	if( UNDO_START != pUndo->GetId() && UNDO_END != pUndo->GetId() )
//STRIP001 		rUndoIter.ClearSelections();
//STRIP001 
//STRIP001 	pUndo->Redo( rUndoIter );
//STRIP001 
//STRIP001 	SetRedlineMode( eOld );
//STRIP001 
//STRIP001 	// Besonderheit von Undo-Replace (interne History)
//STRIP001 	if( UNDO_REPLACE == pUndo->GetId() &&
//STRIP001 		USHRT_MAX != ((SwUndoReplace*)pUndo)->nAktPos )
//STRIP001 	{
//STRIP001 		--nUndoPos;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( rUndoIter.bWeiter && nUndoPos >= pUndos->Count() )
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 
//STRIP001 	// ist die History leer und wurde nicht wegen Speichermangel
//STRIP001 	// verworfen, so kann das Dokument als unveraendert gelten
//STRIP001 	if( nUndoSavePos == nUndoPos )
//STRIP001 		ResetModified();
//STRIP001 	else
//STRIP001 		SetModified();
//STRIP001 	return TRUE;
//STRIP001 }


// liefert die Id der letzten Redofaehigen Aktion zurueck oder 0
// fuellt ggf. VARARR mit User-RedoIds


/*N*/ USHORT SwDoc::GetRedoIds( String* pStr, SwUndoIds *pRedoIds ) const
/*N*/ {
/*N*/ 	USHORT nSize, nId;
/*N*/ 	if( ( nSize = nUndoPos) == pUndos->Count() )
/*N*/ 		return 0;

/*?*/ 	SwUndo* pUndo;
/*?*/ 	String sTmp;
/*?*/ 	if( pRedoIds )
/*?*/ 		pStr = &sTmp;
/*?*/ 
/*?*/ 	do {
/*?*/ 
/*?*/ 		USHORT nUndoSttPos = USHRT_MAX;
/*?*/ 
/*?*/ 		if( UNDO_START == ( nId = ( pUndo = (*pUndos)[nSize] )->GetId() ) )
/*?*/ 			nUndoSttPos = nSize;
/*?*/ 
/*?*/ 		if( USHRT_MAX == nUndoSttPos ||  // no UndoStart
/*?*/ 			UNDO_START != ( nId = ((SwUndoStart*)pUndo)->GetUserId() ) )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( UNDO_REDLINE == nId )
//STRIP001 /*?*/ 				nId = ((SwUndoRedline*)pUndo)->GetUserId();
//STRIP001 /*?*/ 			else if( pStr && UNDO_DRAWUNDO == nId )
//STRIP001 /*?*/ 				*pStr = ((SwSdrUndo*)pUndo)->GetComment();
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	ASSERT( UNDO_END != nId, "falsches Ende der Undoklammerung!");
/*?*/ 
//STRIP001 /*?*/ 			// auf den vorm Ende der Klammerung
//STRIP001 /*?*/ 			nUndoSttPos = nSize;
//STRIP001 /*?*/ 			nSize += ((SwUndoStart*)pUndo)->GetEndOffset();
//STRIP001 /*?*/ 			while( nSize &&
//STRIP001 /*?*/ 					UNDO_END == ( nId = ( pUndo = (*pUndos)[ --nSize ] )->GetId()) &&
//STRIP001 /*?*/ 					UNDO_END == ( nId = ((SwUndoEnd*)pUndo)->GetUserId() ) )
//STRIP001 /*?*/ 				;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( !nSize )
//STRIP001 /*?*/ 				nId = 0;
//STRIP001 /*?*/ 			else if( pStr && UNDO_DRAWUNDO == nId )
//STRIP001 /*?*/ 				*pStr = ((SwSdrUndo*)pUndo)->GetComment();
//STRIP001 /*?*/ 			else if( UNDO_REDLINE == nId )
//STRIP001 /*?*/ 				nId = ((SwUndoRedline*)pUndo)->GetUserId();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			nSize = nUndoSttPos;
/*?*/ 		}
/*?*/ 
/*?*/ 		if( pRedoIds )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SwUndoIdAndName* pNew = new SwUndoIdAndName( nId, pStr );
//STRIP001 /*?*/ 			pRedoIds->Insert( pNew, pRedoIds->Count() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( USHRT_MAX != nUndoSttPos )
//STRIP001 /*?*/ 				nSize = nUndoSttPos +
//STRIP001 /*?*/ 					((SwUndoStart*)(*pUndos)[nUndoSttPos])->GetEndOffset();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( ++nSize >= pUndos->Count() )
//STRIP001 /*?*/ 				break;
/*?*/ 		}
/*?*/ 
/*?*/ 	} while( pRedoIds && nSize < pUndos->Count() );
/*?*/ 
/*?*/ 	return nId;
/*N*/ }

/**************** REPEAT ******************/


//STRIP001 BOOL SwDoc::Repeat( SwUndoIter& rUndoIter, USHORT nRepeatCnt )
//STRIP001 {
//STRIP001 	if( rUndoIter.GetId() && !HasUndoId( rUndoIter.GetId() ) )
//STRIP001 	{
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 	USHORT nSize = nUndoPos;
//STRIP001 	if( !nSize )
//STRIP001 	{
//STRIP001 		rUndoIter.bWeiter = FALSE;
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// dann suche jetzt ueber die End/Start-Gruppen die gueltige Repeat-Aktion
//STRIP001 	SwUndo *pUndo = (*pUndos)[ --nSize ];
//STRIP001 	if( UNDO_END == pUndo->GetId() )
//STRIP001 		nSize -= ((SwUndoEnd*)pUndo)->GetSttOffset();
//STRIP001 
//STRIP001 	USHORT nEndCnt = nUndoPos;
//STRIP001 	BOOL bOneUndo = nSize + 1 == nUndoPos;
//STRIP001 
//STRIP001 	SwPaM* pTmpCrsr = rUndoIter.pAktPam;
//STRIP001 	if( pTmpCrsr != pTmpCrsr->GetNext() || !bOneUndo )	// Undo-Klammerung aufbauen
//STRIP001 		StartUndo( 0 );
//STRIP001 	do {		// dann durchlaufe mal den gesamten Ring
//STRIP001 		for( USHORT nRptCnt = nRepeatCnt; nRptCnt > 0; --nRptCnt )
//STRIP001 		{
//STRIP001 			rUndoIter.pLastUndoObj = 0;
//STRIP001 			for( USHORT nCnt = nSize; nCnt < nEndCnt; ++nCnt )
//STRIP001 				(*pUndos)[ nCnt ]->Repeat( rUndoIter );		// Repeat ausfuehren
//STRIP001 		}
//STRIP001 	} while( pTmpCrsr !=
//STRIP001 		( rUndoIter.pAktPam = (SwPaM*)rUndoIter.pAktPam->GetNext() ));
//STRIP001 	if( pTmpCrsr != pTmpCrsr->GetNext() || !bOneUndo )
//STRIP001 		EndUndo( 0 );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// liefert die Id der letzten Repeatfaehigen Aktion zurueck oder 0
// fuellt ggf. VARARR mit User-RedoIds


//STRIP001 USHORT SwDoc::GetRepeatIds(String* pStr, SwUndoIds *pRepeatIds) const
//STRIP001 {
//STRIP001 	USHORT nRepeatId = GetUndoIds( pStr, pRepeatIds );
//STRIP001 	if( REPEAT_START <= nRepeatId && REPEAT_END > nRepeatId )
//STRIP001 		return nRepeatId;
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 SwUndo* SwDoc::RemoveLastUndo( USHORT nUndoId )
//STRIP001 {
//STRIP001 	SwUndo* pUndo = (*pUndos)[ nUndoPos - 1 ];
//STRIP001 	if( nUndoId == pUndo->GetId() && nUndoPos == pUndos->Count() )
//STRIP001 	{
//STRIP001 		if( !nUndoSttEnd )
//STRIP001 			--nUndoCnt;
//STRIP001 		--nUndoPos;
//STRIP001 		pUndos->Remove( nUndoPos, 1 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pUndo = 0;
//STRIP001 		ASSERT( !this, "falsches Undo-Object" );
//STRIP001 	}
//STRIP001 	return pUndo;
//STRIP001 }

//STRIP001 SwUndoIdAndName::SwUndoIdAndName( USHORT nId, const String* pStr )
//STRIP001 	: nUndoId( nId ), pUndoStr( pStr ? new String( *pStr ) : 0 )
//STRIP001 {
//STRIP001 }

//STRIP001 SwUndoIdAndName::~SwUndoIdAndName()
//STRIP001 {
//STRIP001 	delete pUndoStr;
//STRIP001 }



}
