/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fillctrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:14:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWSH_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
#pragma hdrstop

#include "dialogs.hrc"

#define ITEMID_COLOR_TABLE      SID_COLOR_TABLE
#define ITEMID_GRADIENT_LIST    SID_GRADIENT_LIST
#define ITEMID_HATCH_LIST       SID_HATCH_LIST
#define ITEMID_BITMAP_LIST      SID_BITMAP_LIST

#define DELAY_TIMEOUT			300

#define TMP_STR_BEGIN	'['
#define TMP_STR_END		']'

// auto strip #include "drawitem.hxx"

#ifndef _XDEF_HXX
#include "xdef.hxx"
#endif

#include "xattr.hxx"
// auto strip #include "xtable.hxx"
#include "fillctrl.hxx"
// auto strip #include "itemwin.hxx"
// auto strip #include "dialmgr.hxx"
#include "helpid.hrc"
namespace binfilter {

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFillToolBoxControl, XFillStyleItem );

/*************************************************************************
|*
|* SvxFillToolBoxControl
|*
\************************************************************************/

/*?*/ SvxFillToolBoxControl::SvxFillToolBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*?*/ 
/*?*/ 	SfxToolBoxControl( nId, rTbx, rBind ),
/*?*/ 
/*?*/ 	aColorForwarder		( SID_ATTR_FILL_COLOR, *this ),
/*?*/ 	aGradientForwarder	( SID_ATTR_FILL_GRADIENT, *this ),
/*?*/ 	aHatchForwarder		( SID_ATTR_FILL_HATCH, *this ),
/*?*/ 	aBitmapForwarder	( SID_ATTR_FILL_BITMAP, *this ),
/*?*/ 
/*?*/ 	pStyleItem		( NULL ),
/*?*/ 	pColorItem		( NULL ),
/*?*/ 	pGradientItem	( NULL ),
/*?*/ 	pHatchItem		( NULL ),
/*?*/ 	pBitmapItem		( NULL ),
/*?*/ 	pFillControl	( NULL ),
/*?*/ 	pFillAttrLB		( NULL ),
/*?*/ 	pFillTypeLB		( NULL ),
/*?*/ 
/*?*/ 	bUpdate			( FALSE ),
/*?*/     eLastXFS        ( XFILL_NONE )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	StartListening( rBind );
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 SvxFillToolBoxControl::~SvxFillToolBoxControl()
//STRIP001 {
//STRIP001 	delete pStyleItem;
//STRIP001 	delete pColorItem;
//STRIP001 	delete pGradientItem;
//STRIP001 	delete pHatchItem;
//STRIP001 	delete pBitmapItem;
/*?*/ }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxFillToolBoxControl::StateChanged(
//STRIP001 
//STRIP001 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	FASTBOOL bEnableControls = FALSE;
//STRIP001 
//STRIP001 
//STRIP001 	if( eState == SFX_ITEM_DISABLED )
//STRIP001 	{
//STRIP001 		if( nSID == SID_ATTR_FILL_STYLE )
//STRIP001 		{
//STRIP001 			pFillTypeLB->Disable();
//STRIP001 			pFillTypeLB->SetNoSelection();
//STRIP001 		}
//STRIP001 		pFillAttrLB->Disable();
//STRIP001 		pFillAttrLB->SetNoSelection();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( SFX_ITEM_AVAILABLE == eState )
//STRIP001 		{
//STRIP001 			if( nSID == SID_ATTR_FILL_STYLE )
//STRIP001 			{
//STRIP001 				delete pStyleItem;
//STRIP001 				pStyleItem = (XFillStyleItem*) pState->Clone();
//STRIP001 				pFillTypeLB->Enable();
//STRIP001 
//STRIP001 				eLastXFS = (XFillStyle) pFillTypeLB->GetSelectEntryPos();
//STRIP001 				bUpdate = TRUE;
//STRIP001 
//STRIP001 				XFillStyle eXFS = (XFillStyle)pStyleItem->GetValue();
//STRIP001 				pFillTypeLB->SelectEntryPos( eXFS );
//STRIP001 				pFillAttrLB->Enable();
//STRIP001 			}
//STRIP001 			else if( pStyleItem )
//STRIP001 			{
//STRIP001 				XFillStyle eXFS = (XFillStyle)pStyleItem->GetValue();
//STRIP001 
//STRIP001 				if( nSID == SID_ATTR_FILL_COLOR )
//STRIP001 				{
//STRIP001 					delete pColorItem;
//STRIP001 					pColorItem = (XFillColorItem*) pState->Clone();
//STRIP001 
//STRIP001 					if( eXFS == XFILL_SOLID )
//STRIP001 						bEnableControls = TRUE;
//STRIP001 				}
//STRIP001 				else if( nSID == SID_ATTR_FILL_GRADIENT )
//STRIP001 				{
//STRIP001 					delete pGradientItem;
//STRIP001 					pGradientItem = (XFillGradientItem*) pState->Clone();
//STRIP001 
//STRIP001 					if( eXFS == XFILL_GRADIENT )
//STRIP001 						bEnableControls = TRUE;
//STRIP001 				}
//STRIP001 				else if( nSID == SID_ATTR_FILL_HATCH )
//STRIP001 				{
//STRIP001 					delete pHatchItem;
//STRIP001 					pHatchItem = (XFillHatchItem*) pState->Clone();
//STRIP001 
//STRIP001 					if( eXFS == XFILL_HATCH )
//STRIP001 						bEnableControls = TRUE;
//STRIP001 				}
//STRIP001 				else if( nSID == SID_ATTR_FILL_BITMAP )
//STRIP001 				{
//STRIP001 					delete pBitmapItem;
//STRIP001 					pBitmapItem = (XFillBitmapItem*) pState->Clone();
//STRIP001 
//STRIP001 					if( eXFS == XFILL_BITMAP )
//STRIP001 						bEnableControls = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if( bEnableControls )
//STRIP001 			{
//STRIP001 				//pFillTypeLB->Enable();
//STRIP001 				pFillAttrLB->Enable();
//STRIP001 
//STRIP001 				bUpdate = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// leerer oder uneindeutiger Status
//STRIP001 			if( nSID == SID_ATTR_FILL_STYLE )
//STRIP001 			{
//STRIP001 				pFillTypeLB->SetNoSelection();
//STRIP001 				pFillAttrLB->Disable();
//STRIP001 				pFillAttrLB->SetNoSelection();
//STRIP001 				bUpdate = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				XFillStyle eXFS;
//STRIP001 				if( pStyleItem )
//STRIP001 					eXFS = (XFillStyle)pStyleItem->GetValue();
//STRIP001 				if( !pStyleItem ||
//STRIP001 					( nSID == SID_ATTR_FILL_COLOR	 && eXFS == XFILL_SOLID ) ||
//STRIP001 					( nSID == SID_ATTR_FILL_GRADIENT && eXFS == XFILL_GRADIENT ) ||
//STRIP001 					( nSID == SID_ATTR_FILL_HATCH 	 && eXFS == XFILL_HATCH ) ||
//STRIP001 					( nSID == SID_ATTR_FILL_BITMAP 	 && eXFS == XFILL_BITMAP ) )
//STRIP001 				{
//STRIP001 					pFillAttrLB->SetNoSelection();
//STRIP001 					//bUpdate = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 void SvxFillToolBoxControl::SFX_NOTIFY( SfxBroadcaster& rBC,
//STRIP001 									const TypeId& rBCType,
//STRIP001 									const SfxHint& rHint,
//STRIP001 									const TypeId& rHintType )
//STRIP001 {
//STRIP001 	const SfxSimpleHint *pSimpleHint = PTR_CAST(SfxSimpleHint, &rHint);
//STRIP001 
//STRIP001 	if( pStyleItem && pSimpleHint &&
//STRIP001 	  ( pSimpleHint->GetId() == SFX_HINT_UPDATEDONE ) &&
//STRIP001 		bUpdate )
//STRIP001 	{
//STRIP001 		bUpdate = FALSE;
//STRIP001 
//STRIP001 		XFillStyle eXFS = (XFillStyle)pStyleItem->GetValue();
//STRIP001 
//STRIP001 		// Pruefen, ob Fuellstil schon vorher aktiv war
//STRIP001 		//if( eTmpXFS != eXFS )
//STRIP001 		if( (XFillStyle) eLastXFS != eXFS )
//STRIP001 			pFillControl->SelectFillTypeHdl( NULL );
//STRIP001 			//eLastXFS = eXFS;
//STRIP001 
//STRIP001 		switch( eXFS )
//STRIP001 		{
//STRIP001 			case XFILL_NONE:
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_SOLID:
//STRIP001 			{
//STRIP001 				if ( pColorItem )
//STRIP001 				{
//STRIP001 					String aString( pColorItem->GetName() );
//STRIP001 					Color aColor = pColorItem->GetValue();
//STRIP001 
//STRIP001 					pFillAttrLB->SelectEntry( aString );
//STRIP001 
//STRIP001 					if ( pFillAttrLB->GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND ||
//STRIP001 						 pFillAttrLB->GetSelectEntryColor() != aColor )
//STRIP001 						pFillAttrLB->SelectEntry( aColor );
//STRIP001 
//STRIP001 					// NEU
//STRIP001 					// Pruefen, ob Eintrag nicht in der Liste ist
//STRIP001 					if( pFillAttrLB->GetSelectEntryPos() ==
//STRIP001 						LISTBOX_ENTRY_NOTFOUND ||
//STRIP001 						pFillAttrLB->GetSelectEntryColor() != aColor )
//STRIP001 					{
//STRIP001 						long nCount = pFillAttrLB->GetEntryCount();
//STRIP001 						String aTmpStr;
//STRIP001 						if( nCount > 0 )
//STRIP001 						{
//STRIP001 							//Letzter Eintrag wird auf temporaere Farbe geprueft
//STRIP001 							aTmpStr = pFillAttrLB->GetEntry( nCount - 1 );
//STRIP001 							if(  aTmpStr.GetChar(0) == TMP_STR_BEGIN &&
//STRIP001 								 aTmpStr.GetChar(aTmpStr.Len()-1) == TMP_STR_END )
//STRIP001 							{
//STRIP001 								pFillAttrLB->RemoveEntry( nCount - 1 );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						aTmpStr = TMP_STR_BEGIN;
//STRIP001 						aTmpStr += aString;
//STRIP001 						aTmpStr += TMP_STR_END;
//STRIP001 
//STRIP001 						//pFillAttrLB->SetUpdateMode( FALSE );
//STRIP001 						USHORT nPos = pFillAttrLB->InsertEntry( aColor, aTmpStr );
//STRIP001 						//pFillAttrLB->SetUpdateMode( TRUE );
//STRIP001 						pFillAttrLB->SelectEntryPos( nPos );
//STRIP001 					}
//STRIP001 					// NEU
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pFillAttrLB->SetNoSelection();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_GRADIENT:
//STRIP001 			{
//STRIP001 				if ( pGradientItem )
//STRIP001 				{
//STRIP001 					String aString( pGradientItem->GetName() );
//STRIP001 					pFillAttrLB->SelectEntry( aString );
//STRIP001 					// NEU
//STRIP001 					// Pruefen, ob Eintrag nicht in der Liste ist
//STRIP001 					if( pFillAttrLB->GetSelectEntry() != aString )
//STRIP001 					{
//STRIP001 						long nCount = pFillAttrLB->GetEntryCount();
//STRIP001 						String aTmpStr;
//STRIP001 						if( nCount > 0 )
//STRIP001 						{
//STRIP001 							//Letzter Eintrag wird auf temporaeren Eintrag geprueft
//STRIP001 							aTmpStr = pFillAttrLB->GetEntry( nCount - 1 );
//STRIP001 							if(  aTmpStr.GetChar(0) == TMP_STR_BEGIN &&
//STRIP001 								 aTmpStr.GetChar(aTmpStr.Len()-1) == TMP_STR_END )
//STRIP001 							{
//STRIP001 								pFillAttrLB->RemoveEntry( nCount - 1 );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						aTmpStr = TMP_STR_BEGIN;
//STRIP001 						aTmpStr += aString;
//STRIP001 						aTmpStr += TMP_STR_END;
//STRIP001 
//STRIP001 						XGradientEntry* pEntry = new XGradientEntry( pGradientItem->GetValue(), aTmpStr );
//STRIP001 						String aEmptyString = String();
//STRIP001  						XGradientList aGradientList( aEmptyString );
//STRIP001 						aGradientList.Insert( pEntry );
//STRIP001 						aGradientList.SetDirty( FALSE );
//STRIP001 						Bitmap* pBmp = aGradientList.CreateBitmapForUI( 0 );
//STRIP001 
//STRIP001 						if( pBmp )
//STRIP001 						{
//STRIP001 							( (ListBox*)pFillAttrLB )->InsertEntry( pEntry->GetName(), *pBmp );
//STRIP001 							pFillAttrLB->SelectEntryPos( pFillAttrLB->GetEntryCount() - 1 );
//STRIP001 							delete pBmp;
//STRIP001 						}
//STRIP001 
//STRIP001 						aGradientList.Remove( 0 );
//STRIP001 						delete pEntry;
//STRIP001 					}
//STRIP001 					// NEU
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pFillAttrLB->SetNoSelection();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_HATCH:
//STRIP001 			{
//STRIP001 				if ( pHatchItem )
//STRIP001 				{
//STRIP001 					String aString( pHatchItem->GetName() );
//STRIP001 					pFillAttrLB->SelectEntry( aString );
//STRIP001 					// NEU
//STRIP001 					// Pruefen, ob Eintrag nicht in der Liste ist
//STRIP001 					if( pFillAttrLB->GetSelectEntry() != aString )
//STRIP001 					{
//STRIP001 						long nCount = pFillAttrLB->GetEntryCount();
//STRIP001 						String aTmpStr;
//STRIP001 						if( nCount > 0 )
//STRIP001 						{
//STRIP001 							//Letzter Eintrag wird auf temporaeren Eintrag geprueft
//STRIP001 							aTmpStr = pFillAttrLB->GetEntry( nCount - 1 );
//STRIP001 							if(  aTmpStr.GetChar(0) == TMP_STR_BEGIN &&
//STRIP001 								 aTmpStr.GetChar(aTmpStr.Len()-1) == TMP_STR_END )
//STRIP001 							{
//STRIP001 								pFillAttrLB->RemoveEntry( nCount - 1 );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						aTmpStr = TMP_STR_BEGIN;
//STRIP001 						aTmpStr += aString;
//STRIP001 						aTmpStr += TMP_STR_END;
//STRIP001 
//STRIP001 						XHatchEntry* pEntry = new XHatchEntry( pHatchItem->GetValue(), aTmpStr );
//STRIP001 						String aEmptyString = String();
//STRIP001 						XHatchList aHatchList( aEmptyString );
//STRIP001 						aHatchList.Insert( pEntry );
//STRIP001 						aHatchList.SetDirty( FALSE );
//STRIP001 						Bitmap* pBmp = aHatchList.CreateBitmapForUI( 0 );
//STRIP001 
//STRIP001 						if( pBmp )
//STRIP001 						{
//STRIP001 							( (ListBox*)pFillAttrLB )->InsertEntry( pEntry->GetName(), *pBmp );
//STRIP001 							pFillAttrLB->SelectEntryPos( pFillAttrLB->GetEntryCount() - 1 );
//STRIP001 							delete pBmp;
//STRIP001 						}
//STRIP001 
//STRIP001 						aHatchList.Remove( 0 );
//STRIP001 						delete pEntry;
//STRIP001 					}
//STRIP001 					// NEU
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pFillAttrLB->SetNoSelection();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_BITMAP:
//STRIP001 			{
//STRIP001 				if ( pBitmapItem )
//STRIP001 					// &&
//STRIP001 					// SfxObjectShell::Current() 	&&
//STRIP001 					// SfxObjectShell::Current()->GetItem( SID_BITMAP_LIST ) )
//STRIP001 				{
//STRIP001 					String aString( pBitmapItem->GetName() );
//STRIP001 					// Bitmap aBitmap( pBitmapItem->GetValue() );
//STRIP001 
//STRIP001 					// SvxBitmapListItem aItem( *(const SvxBitmapListItem*)(
//STRIP001 					// 	SfxObjectShell::Current()->GetItem( SID_BITMAP_LIST ) ) );
//STRIP001 					pFillAttrLB->SelectEntry( aString );
//STRIP001 					// NEU
//STRIP001 					// Pruefen, ob Eintrag nicht in der Liste ist
//STRIP001 					if( pFillAttrLB->GetSelectEntry() != aString )
//STRIP001 					{
//STRIP001 						long nCount = pFillAttrLB->GetEntryCount();
//STRIP001 						String aTmpStr;
//STRIP001 						if( nCount > 0 )
//STRIP001 						{
//STRIP001 							//Letzter Eintrag wird auf temporaeren Eintrag geprueft
//STRIP001 							aTmpStr = pFillAttrLB->GetEntry( nCount - 1 );
//STRIP001 							if(  aTmpStr.GetChar(0) == TMP_STR_BEGIN &&
//STRIP001 								 aTmpStr.GetChar(aTmpStr.Len()-1) == TMP_STR_END )
//STRIP001 							{
//STRIP001 								pFillAttrLB->RemoveEntry( nCount - 1 );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						aTmpStr = TMP_STR_BEGIN;
//STRIP001 						aTmpStr += aString;
//STRIP001 						aTmpStr += TMP_STR_END;
//STRIP001 
//STRIP001 						XBitmapEntry* pEntry = new XBitmapEntry( pBitmapItem->GetValue(), aTmpStr );
//STRIP001 						XBitmapList aBitmapList( String::CreateFromAscii("TmpList") );
//STRIP001 						aBitmapList.Insert( pEntry );
//STRIP001 						aBitmapList.SetDirty( FALSE );
//STRIP001 						//Bitmap* pBmp = aBitmapList.GetBitmap( 0 );
//STRIP001 						//( (ListBox*)pFillAttrLB )->InsertEntry( pEntry->GetName(), *pBmp );
//STRIP001 						pFillAttrLB->Fill( &aBitmapList );
//STRIP001 						pFillAttrLB->SelectEntryPos( pFillAttrLB->GetEntryCount() - 1 );
//STRIP001 						aBitmapList.Remove( 0 );
//STRIP001 						delete pEntry;
//STRIP001 					}
//STRIP001 					// NEU
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pFillAttrLB->SetNoSelection();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				DBG_ERROR( "Nicht unterstuetzter Flaechentyp" );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	const SfxPoolItemHint *pPoolItemHint = PTR_CAST(SfxPoolItemHint, &rHint);
//STRIP001 
//STRIP001 	if( pPoolItemHint && pStyleItem )
//STRIP001 	{
//STRIP001 		XFillStyle eXFS = (XFillStyle) pStyleItem->GetValue();
//STRIP001 
//STRIP001 		// Die Listen haben sich geaendert ?
//STRIP001 		if( pPoolItemHint->GetObject()->ISA( SvxColorTableItem ) &&
//STRIP001 			eXFS == XFILL_SOLID )
//STRIP001 		{
//STRIP001 			Color aTmpColor( pFillAttrLB->GetSelectEntryColor() );
//STRIP001 			pFillAttrLB->Clear();
//STRIP001 			pFillAttrLB->Fill( ( (SvxColorTableItem*) pPoolItemHint->GetObject() )->GetColorTable() );
//STRIP001 			pFillAttrLB->SelectEntry( aTmpColor );
//STRIP001 		}
//STRIP001 		if( pPoolItemHint->GetObject()->ISA( SvxGradientListItem ) &&
//STRIP001 			eXFS == XFILL_GRADIENT )
//STRIP001 		{
//STRIP001 			String aString( pFillAttrLB->GetSelectEntry() );
//STRIP001 			pFillAttrLB->Clear();
//STRIP001 			pFillAttrLB->Fill( ( (SvxGradientListItem*) pPoolItemHint->GetObject() )->GetGradientList() );
//STRIP001 			pFillAttrLB->SelectEntry( aString );
//STRIP001 		}
//STRIP001 		if( pPoolItemHint->GetObject()->ISA( SvxHatchListItem ) &&
//STRIP001 			eXFS == XFILL_HATCH )
//STRIP001 		{
//STRIP001 			String aString( pFillAttrLB->GetSelectEntry() );
//STRIP001 			pFillAttrLB->Clear();
//STRIP001 			pFillAttrLB->Fill( ( (SvxHatchListItem*) pPoolItemHint->GetObject() )->GetHatchList() );
//STRIP001 			pFillAttrLB->SelectEntry( aString );
//STRIP001 		}
//STRIP001 		if( pPoolItemHint->GetObject()->ISA( SvxBitmapListItem ) &&
//STRIP001 			eXFS == XFILL_BITMAP )
//STRIP001 		{
//STRIP001 			String aString( pFillAttrLB->GetSelectEntry() );
//STRIP001 			pFillAttrLB->Clear();
//STRIP001 			pFillAttrLB->Fill( ( (SvxBitmapListItem*) pPoolItemHint->GetObject() )->GetBitmapList() );
//STRIP001 			pFillAttrLB->SelectEntry( aString );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //========================================================================
//STRIP001 
//STRIP001 Window* SvxFillToolBoxControl::CreateItemWindow( Window *pParent )
//STRIP001 {
//STRIP001 	if ( GetId() == SID_ATTR_FILL_STYLE )
//STRIP001 	{
//STRIP001 		pFillControl = new FillControl( pParent );
//STRIP001 		// Damit dem FillControl das SvxFillToolBoxControl bekannt ist
//STRIP001 		// (und um kompatibel zu bleiben)
//STRIP001 		pFillControl->SetData( this );
//STRIP001 
//STRIP001 		pFillAttrLB = (SvxFillAttrBox*)pFillControl->pLbFillAttr;
//STRIP001 		pFillTypeLB = (SvxFillTypeBox*)pFillControl->pLbFillType;
//STRIP001 
//STRIP001 		pFillAttrLB->SetUniqueId( HID_FILL_ATTR_LISTBOX );
//STRIP001 		pFillTypeLB->SetUniqueId( HID_FILL_TYPE_LISTBOX );
//STRIP001 
//STRIP001 		return pFillControl;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FillControl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FillControl::FillControl( Window* pParent, WinBits nStyle ) :
//STRIP001     Window( pParent, nStyle | WB_DIALOGCONTROL ),
//STRIP001     pLbFillType(new SvxFillTypeBox( this )),
//STRIP001     aLogicalFillSize(40,80),
//STRIP001     aLogicalAttrSize(50,80)
//STRIP001 {
//STRIP001     pLbFillAttr = new SvxFillAttrBox( this );
//STRIP001     Size aTypeSize(LogicToPixel(aLogicalFillSize, MAP_APPFONT));
//STRIP001     Size aAttrSize(LogicToPixel(aLogicalAttrSize, MAP_APPFONT));
//STRIP001     pLbFillType->SetSizePixel(aTypeSize);
//STRIP001     pLbFillAttr->SetSizePixel(aAttrSize);
//STRIP001     //to get the base height
//STRIP001     aTypeSize = pLbFillType->GetSizePixel();
//STRIP001     aAttrSize = pLbFillAttr->GetSizePixel();
//STRIP001     Point aAttrPnt = pLbFillAttr->GetPosPixel();
//STRIP001 	SetSizePixel(
//STRIP001 		Size( aAttrPnt.X() + aAttrSize.Width(),
//STRIP001 			  Max( aAttrSize.Height(), aTypeSize.Height() ) ) );
//STRIP001 
//STRIP001 	pLbFillType->SetSelectHdl( LINK( this, FillControl, SelectFillTypeHdl ) );
//STRIP001 	pLbFillAttr->SetSelectHdl( LINK( this, FillControl, SelectFillAttrHdl ) );
//STRIP001 
//STRIP001 	aDelayTimer.SetTimeout( DELAY_TIMEOUT );
//STRIP001 	aDelayTimer.SetTimeoutHdl( LINK( this, FillControl, DelayHdl ) );
//STRIP001 	aDelayTimer.Start();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 FillControl::~FillControl()
//STRIP001 {
//STRIP001 	delete pLbFillType;
//STRIP001 	delete pLbFillAttr;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( FillControl, DelayHdl, Timer *, pTimer )
//STRIP001 {
//STRIP001 	SelectFillTypeHdl( NULL );
//STRIP001 	( (SvxFillToolBoxControl*)GetData() )->GetBindings().Invalidate( SID_ATTR_FILL_STYLE );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( FillControl, DelayHdl, Timer *, pTimer )
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( FillControl, SelectFillTypeHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	XFillStyle  eXFS = (XFillStyle)pLbFillType->GetSelectEntryPos();
//STRIP001 
//STRIP001 	// Spaeter sollte eine Optimierung derart erfolgen, dass die
//STRIP001 	// Listen, bzw. Tables nur dann geloescht und wieder aufgebaut
//STRIP001 	// werden, wenn sich die Listen, bzw. Tables tatsaechlich geaendert
//STRIP001 	// haben (in den LBs natuerlich).
//STRIP001 
//STRIP001 	if ( ( pBox && !pBox->IsTravelSelect() ) || !pBox )
//STRIP001 	{
//STRIP001 		// Damit wir in folgendem Fall einen Status anzeigen koennen:
//STRIP001 		// Ein Typ wurde ausgewaehlt aber kein Attribut.
//STRIP001 		// Die Selektion hat genau die gleichen Attribute wie die vorherige.
//STRIP001 		SvxFillToolBoxControl* pControlerItem = (SvxFillToolBoxControl*)GetData();
//STRIP001 		if( pControlerItem )
//STRIP001 			pControlerItem->ClearCache();
//STRIP001 
//STRIP001 		pLbFillAttr->Clear();
//STRIP001 		SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 		switch( eXFS )
//STRIP001 		{
//STRIP001 			case XFILL_NONE:
//STRIP001 			{
//STRIP001 				pLbFillType->Selected();
//STRIP001 				SelectFillAttrHdl( pBox );
//STRIP001 				pLbFillAttr->Disable();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_SOLID:
//STRIP001 			{
//STRIP001 				if ( pSh && pSh->GetItem( SID_COLOR_TABLE ) )
//STRIP001 				{
//STRIP001 					SvxColorTableItem aItem( *(const SvxColorTableItem*)(
//STRIP001 						pSh->GetItem( SID_COLOR_TABLE ) ) );
//STRIP001 					pLbFillAttr->Enable();
//STRIP001 					pLbFillAttr->Fill( aItem.GetColorTable() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pLbFillAttr->Disable();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_GRADIENT:
//STRIP001 			{
//STRIP001 				if ( pSh && pSh->GetItem( SID_GRADIENT_LIST ) )
//STRIP001 				{
//STRIP001 					SvxGradientListItem aItem( *(const SvxGradientListItem*)(
//STRIP001 						pSh->GetItem( SID_GRADIENT_LIST ) ) );
//STRIP001 					pLbFillAttr->Enable();
//STRIP001 					pLbFillAttr->Fill( aItem.GetGradientList() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pLbFillAttr->Disable();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_HATCH:
//STRIP001 			{
//STRIP001 				if ( pSh && pSh->GetItem( SID_HATCH_LIST ) )
//STRIP001 				{
//STRIP001 					SvxHatchListItem aItem( *(const SvxHatchListItem*)(
//STRIP001 						pSh->GetItem( SID_HATCH_LIST ) ) );
//STRIP001 					pLbFillAttr->Enable();
//STRIP001 					pLbFillAttr->Fill( aItem.GetHatchList() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pLbFillAttr->Disable();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case XFILL_BITMAP:
//STRIP001 			{
//STRIP001 				if ( pSh && pSh->GetItem( SID_BITMAP_LIST ) )
//STRIP001 				{
//STRIP001 					SvxBitmapListItem aItem( *(const SvxBitmapListItem*)(
//STRIP001 						pSh->GetItem( SID_BITMAP_LIST ) ) );
//STRIP001 					pLbFillAttr->Enable();
//STRIP001 					pLbFillAttr->Fill( aItem.GetBitmapList() );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pLbFillAttr->Disable();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( eXFS != XFILL_NONE ) // Wurde schon erledigt
//STRIP001 		{
//STRIP001 			if ( pBox )
//STRIP001 				pLbFillType->Selected();
//STRIP001 
//STRIP001 			// release focus
//STRIP001             if ( pBox && pLbFillType->IsRelease() && SfxViewShell::Current()->GetWindow() )
//STRIP001 				SfxViewShell::Current()->GetWindow()->GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( FillControl, SelectFillAttrHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	XFillStyle eXFS = (XFillStyle)pLbFillType->GetSelectEntryPos();
//STRIP001 	XFillStyleItem aXFillStyleItem( eXFS );
//STRIP001 	BOOL bAction = pBox && !pLbFillAttr->IsTravelSelect();
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 	SfxDispatcher* pDisp = ( (SvxFillToolBoxControl*)GetData() )->GetBindings().GetDispatcher();
//STRIP001 	DBG_ASSERT( pDisp, "invalid Dispatcher" );
//STRIP001     if(bAction)
//STRIP001     {
//STRIP001         switch( eXFS )
//STRIP001         {
//STRIP001             case XFILL_NONE:
//STRIP001                 pDisp->Execute( SID_ATTR_FILL_STYLE, SFX_CALLMODE_RECORD, &aXFillStyleItem, 0L );
//STRIP001             break;
//STRIP001 
//STRIP001             case XFILL_SOLID:
//STRIP001             {
//STRIP001                 // NEU
//STRIP001                 //Eintrag wird auf temporaere Farbe geprueft
//STRIP001                 String aTmpStr = pLbFillAttr->GetSelectEntry();
//STRIP001                 if( aTmpStr.GetChar(0) == TMP_STR_BEGIN && aTmpStr.GetChar(aTmpStr.Len()-1) == TMP_STR_END )
//STRIP001                 {
//STRIP001                     aTmpStr.Erase( aTmpStr.Len()-1, 1 );
//STRIP001                     aTmpStr.Erase( 0, 1 );
//STRIP001                 }
//STRIP001 
//STRIP001                 XFillColorItem aXFillColorItem( aTmpStr, pLbFillAttr->GetSelectEntryColor() );
//STRIP001                 // NEU
//STRIP001                 pDisp->Execute(
//STRIP001                     SID_ATTR_FILL_COLOR, SFX_CALLMODE_RECORD, &aXFillColorItem, &aXFillStyleItem, 0L );
//STRIP001             }
//STRIP001             break;
//STRIP001             case XFILL_GRADIENT:
//STRIP001             {
//STRIP001                 USHORT nPos = pLbFillAttr->GetSelectEntryPos();
//STRIP001 
//STRIP001                 if ( nPos != LISTBOX_ENTRY_NOTFOUND && pSh && pSh->GetItem( SID_GRADIENT_LIST ) )
//STRIP001                 {
//STRIP001                     SvxGradientListItem aItem(
//STRIP001                         *(const SvxGradientListItem*)( pSh->GetItem( SID_GRADIENT_LIST ) ) );
//STRIP001 
//STRIP001                     if ( nPos < aItem.GetGradientList()->Count() )  // kein temp. Eintrag ?
//STRIP001                     {
//STRIP001                         XGradient aGradient = aItem.GetGradientList()->Get( nPos )->GetGradient();
//STRIP001                         XFillGradientItem aXFillGradientItem( pLbFillAttr->GetSelectEntry(), aGradient );
//STRIP001                         pDisp->Execute( SID_ATTR_FILL_GRADIENT, SFX_CALLMODE_RECORD,
//STRIP001                                         &aXFillGradientItem, &aXFillStyleItem, 0L );
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case XFILL_HATCH:
//STRIP001             {
//STRIP001                 USHORT nPos = pLbFillAttr->GetSelectEntryPos();
//STRIP001 
//STRIP001                 if ( nPos != LISTBOX_ENTRY_NOTFOUND && pSh && pSh->GetItem( SID_HATCH_LIST ) )
//STRIP001                 {
//STRIP001                     SvxHatchListItem aItem( *(const SvxHatchListItem*)( pSh->GetItem( SID_HATCH_LIST ) ) );
//STRIP001 
//STRIP001                     if ( nPos < aItem.GetHatchList()->Count() )  // kein temp. Eintrag ?
//STRIP001                     {
//STRIP001                         XHatch aHatch = aItem.GetHatchList()->Get( nPos )->GetHatch();
//STRIP001                         XFillHatchItem aXFillHatchItem( pLbFillAttr->GetSelectEntry(), aHatch );
//STRIP001                         pDisp->Execute( SID_ATTR_FILL_HATCH, SFX_CALLMODE_RECORD,
//STRIP001                                         &aXFillHatchItem, &aXFillStyleItem, 0L );
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case XFILL_BITMAP:
//STRIP001             {
//STRIP001                 USHORT nPos = pLbFillAttr->GetSelectEntryPos();
//STRIP001 
//STRIP001                 if ( nPos != LISTBOX_ENTRY_NOTFOUND && pSh && pSh->GetItem( SID_BITMAP_LIST ) )
//STRIP001                 {
//STRIP001                     SvxBitmapListItem aItem(
//STRIP001                         *(const SvxBitmapListItem*)( pSh->GetItem( SID_BITMAP_LIST ) ) );
//STRIP001 
//STRIP001                     if ( nPos < aItem.GetBitmapList()->Count() )  // kein temp. Eintrag ?
//STRIP001                     {
//STRIP001                         XOBitmap aXOBitmap = aItem.GetBitmapList()->Get( nPos )->GetXBitmap();
//STRIP001                         XFillBitmapItem aXFillBitmapItem( pLbFillAttr->GetSelectEntry(), aXOBitmap );
//STRIP001                         pDisp->Execute( SID_ATTR_FILL_BITMAP, SFX_CALLMODE_RECORD,
//STRIP001                                         &aXFillBitmapItem, &aXFillStyleItem, 0L );
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001         // release focus
//STRIP001         if ( pLbFillAttr->IsRelease()  && pBox && SfxViewShell::Current()->GetWindow() )
//STRIP001             SfxViewShell::Current()->GetWindow()->GrabFocus();
//STRIP001     }
//STRIP001 
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void FillControl::Resize()
//STRIP001 {
//STRIP001 	// Breite der beiden ListBoxen nicht 1/2 : 1/2, sondern 2/5 : 3/5
//STRIP001 	long nW = GetOutputSizePixel().Width() / 5;
//STRIP001 	long nH = 180;
//STRIP001 	long nSep = 0; // war vorher 4
//STRIP001 
//STRIP001 	pLbFillType->SetSizePixel( Size( nW * 2 - nSep, nH ) );
//STRIP001 	pLbFillAttr->SetPosSizePixel( Point( nW * 2 + nSep, 0 ), Size( nW * 3 - nSep, nH ) );
//STRIP001 }
//STRIP001 /* -----------------------------08.03.2002 15:04------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void FillControl::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001     {
//STRIP001         Size aTypeSize(LogicToPixel(aLogicalFillSize, MAP_APPFONT));
//STRIP001         Size aAttrSize(LogicToPixel(aLogicalAttrSize, MAP_APPFONT));
//STRIP001         pLbFillType->SetSizePixel(aTypeSize);
//STRIP001         pLbFillAttr->SetSizePixel(aAttrSize);
//STRIP001         //to get the base height
//STRIP001         aTypeSize = pLbFillType->GetSizePixel();
//STRIP001         aAttrSize = pLbFillAttr->GetSizePixel();
//STRIP001         Point aAttrPnt = pLbFillAttr->GetPosPixel();
//STRIP001 
//STRIP001         SetSizePixel(
//STRIP001             Size( aAttrPnt.X() + aAttrSize.Width(),
//STRIP001                 Max( aAttrSize.Height(), aTypeSize.Height() ) ) );
//STRIP001     }
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001 }

}
