/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_eschesdo.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:25:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <math.h>

#ifndef _ESCHESDO_HXX
#include "eschesdo.hxx"
#endif

#ifndef _SVDOBJ_HXX //autogen wg. SdrObject
#include "svdobj.hxx"
#endif

#ifndef _SVX_UNOSHAPE_HXX //autogen wg. SvxShape
#include "unoshape.hxx"
#endif

#ifndef _SV_OUTDEV_HXX //autogen wg. OutputDevice
#include <vcl/outdev.hxx>
#endif
#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SV_BITMAPEX_HXX //autogen wg. BitmapEx
#include <vcl/bitmapex.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen wg. Graphic
#include <vcl/graph.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

#ifndef _SVX_FMDPAGE_HXX //autogen wg. SvxFmDrawPage
#include <fmdpage.hxx>
#endif

#ifndef _TOOLKIT_UNOHLP_HXX //autogen wg. VCLXBitmap
#include <toolkit/unohlp.hxx>
#endif

#ifndef _COM_SUN_STAR_STYLE_VERTICALALIGNMENT_HPP_
#include <com/sun/star/style/VerticalAlignment.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_GRADIENT_HPP_
#include <com/sun/star/awt/Gradient.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_POINTSEQUENCE_HPP_
#include <com/sun/star/drawing/PointSequence.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_POINTSEQUENCESEQUENCE_HPP_
#include <com/sun/star/drawing/PointSequenceSequence.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_POLYPOLYGONBEZIERCOORDS_HPP_
#include <com/sun/star/drawing/PolyPolygonBezierCoords.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FLAGSEQUENCE_HPP_
#include <com/sun/star/drawing/FlagSequence.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_TEXTADJUST_HPP_
#include <com/sun/star/drawing/TextAdjust.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINEDASH_HPP_
#include <com/sun/star/drawing/LineDash.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_XTEXT_HPP_
#include <com/sun/star/text/XText.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_WRITINGMODE_HDL_
#include <com/sun/star/text/WritingMode.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_CIRCLEKIND_HPP_
#include <com/sun/star/drawing/CircleKind.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FILLSTYLE_HPP_
#include <com/sun/star/drawing/FillStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_TASK_XSTATUSINDICATOR_HPP_
#include <com/sun/star/task/XStatusIndicator.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_TEXTVERTICALADJUST_HPP_
#include <com/sun/star/drawing/TextVerticalAdjust.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_TEXTHORIZONTALADJUST_HPP_
#include <com/sun/star/drawing/TextHorizontalAdjust.hpp>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif

#ifndef _XCEPTION_HXX_ //autogen wg. TRY
#include <vos/xception.hxx>
#endif

#ifndef _FLTCALL_HXX
#include <svtools/fltcall.hxx>
#endif
#ifndef _SV_CVTGRF_HXX
#include <vcl/cvtgrf.hxx>
#endif
namespace binfilter {

using namespace ::vos;
using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::drawing;
using namespace ::com::sun::star::text;
using namespace ::com::sun::star::task;
using namespace ::com::sun::star::style;

//STRIP001 BOOL ConvertGDIMetaFileToEMF( const GDIMetaFile & rMTF, SvStream & rTargetStream,
//STRIP001 							  PFilterCallback pCallback, void * pCallerData );
//STRIP001 
//STRIP001 #define EES_MAP_FRACTION 1440	// 1440 dpi
//STRIP001 
//STRIP001 // ===================================================================
//STRIP001 
//STRIP001 ImplEESdrWriter::ImplEESdrWriter( EscherEx& rEx )
//STRIP001 		:
//STRIP001 		mpEscherEx				( &rEx ),
//STRIP001 		maMapModeSrc			( MAP_100TH_MM ),
//STRIP001 		// PowerPoint: 576 dpi, WinWord: 1440 dpi, Excel: 1440 dpi
//STRIP001 		maMapModeDest( MAP_INCH, Point(), Fraction( 1, EES_MAP_FRACTION ), Fraction( 1, EES_MAP_FRACTION ) ),
//STRIP001 		mbStatus				( FALSE ),
//STRIP001 //		mXModel					( rXModel ),
//STRIP001 //		mXStatusIndicator		( rXStatInd ),
//STRIP001 		mbStatusIndicator		( FALSE ),
//STRIP001 		mnPagesWritten			( 0 ),
//STRIP001 //		mnTxId					( 0x7a2f64 ),
//STRIP001 		mnShapeMasterTitle		( 0 ),
//STRIP001 		mnShapeMasterBody		( 0 ),
//STRIP001 		mpPicStrm				( NULL ),
//STRIP001 		mpHostAppData			( NULL )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 Point ImplEESdrWriter::ImplMapPoint( const Point& rPoint )
//STRIP001 {
//STRIP001 	return OutputDevice::LogicToLogic( rPoint, maMapModeSrc, maMapModeDest );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 Size ImplEESdrWriter::ImplMapSize( const Size& rSize )
//STRIP001 {
//STRIP001 	Size aRetSize( OutputDevice::LogicToLogic( rSize, maMapModeSrc, maMapModeDest ) );
//STRIP001 
//STRIP001 	if ( !aRetSize.Width() )
//STRIP001 		aRetSize.Width()++;
//STRIP001 	if ( !aRetSize.Height() )
//STRIP001 		aRetSize.Height()++;
//STRIP001 	return aRetSize;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void ImplEESdrWriter::ImplWriteTextBundle( ImplEESdrObject& rObj, EscherPropertyContainer& rPropOpt )
//STRIP001 {
//STRIP001 	if( rObj.ImplGetText() )
//STRIP001 	{
//STRIP001 		ESCHER_AnchorText	eAnchor = ESCHER_AnchorTop;
//STRIP001         ESCHER_txfl eFlow = ESCHER_txflHorzN;
//STRIP001         ESCHER_txDir eDir = ESCHER_txdirLTR;
//STRIP001 		UINT32				nTextAttr = 0x40004;	// rotate text with shape
//STRIP001 
//STRIP001         if ( rObj.ImplGetPropertyValue(
//STRIP001             ::rtl::OUString::createFromAscii("TextWritingMode") ) )
//STRIP001         {
//STRIP001             ::com::sun::star::text::WritingMode eMode;
//STRIP001             rObj.GetUsrAny() >>= eMode;
//STRIP001             switch (eMode)
//STRIP001             {
//STRIP001                 case ::com::sun::star::text::WritingMode_TB_RL:
//STRIP001                     //Well if it so happens that we are fliped 180 we can use
//STRIP001                     //this instead.
//STRIP001                     if (rObj.GetAngle() == 18000)
//STRIP001                         eFlow = ESCHER_txflBtoT;
//STRIP001                     else
//STRIP001                         eFlow = ESCHER_txflTtoBA;
//STRIP001                     break;
//STRIP001                 case ::com::sun::star::text::WritingMode_RL_TB:
//STRIP001                     eDir = ESCHER_txdirRTL;
//STRIP001                     break;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001 		if ( rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("TextVerticalAdjust") ) )
//STRIP001 		{
//STRIP001 			::com::sun::star::drawing::TextVerticalAdjust eVA;
//STRIP001 			rObj.GetUsrAny() >>= eVA;
//STRIP001 			switch ( eVA )
//STRIP001 			{
//STRIP001 				case 1 :	// ::com::sun::star::drawing::TextVerticalAdjust_CENTER :
//STRIP001 					eAnchor = ESCHER_AnchorMiddle;
//STRIP001 				break;
//STRIP001 
//STRIP001                 case 2 :	// ::com::sun::star::drawing::TextVerticalAdjust_BOTTOM :
//STRIP001 					eAnchor = ESCHER_AnchorBottom;
//STRIP001 				break;
//STRIP001 
//STRIP001 				default :
//STRIP001                 case 0 :	// ::com::sun::star::drawing::TextVerticalAdjust_TOP :
//STRIP001 					eAnchor = ESCHER_AnchorTop;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("TextHorizontalAdjust") ) )
//STRIP001 		{
//STRIP001 			::com::sun::star::drawing::TextHorizontalAdjust eTA;
//STRIP001 			rObj.GetUsrAny() >>= eTA;
//STRIP001 			switch ( eTA )
//STRIP001 			{
//STRIP001 				case 1 :	// ::com::sun::star::drawing::TextHorizontalAdjust_CENTER :
//STRIP001                 case 2 :	// ::com::sun::star::drawing::TextHorizontalAdjust_RIGHT :
//STRIP001                 case 0 :	// ::com::sun::star::drawing::TextHorizontalAdjust_LEFT :
//STRIP001 				{
//STRIP001 					switch( eAnchor )
//STRIP001 					{
//STRIP001 						case ESCHER_AnchorMiddle :
//STRIP001 							eAnchor = ESCHER_AnchorMiddleCentered;
//STRIP001 						break;
//STRIP001 						case ESCHER_AnchorBottom :
//STRIP001 							eAnchor = ESCHER_AnchorBottomCentered;
//STRIP001 						break;
//STRIP001 						case ESCHER_AnchorTop :
//STRIP001 							eAnchor = ESCHER_AnchorTopCentered;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001                 case 3 :	// ::com::sun::star::drawing::TextHorizontalAdjust_BLOCK :
//STRIP001  				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 /*
//STRIP001 		if ( ImplGetPropertyValue( L"TextFitToSize" ) )
//STRIP001 		{
//STRIP001 			if ( *( (INT16*)mAny.get() ) == 1 )
//STRIP001 			{
//STRIP001 				nTextAttr |= 0x10001;
//STRIP001 				rPropOpt.AddOpt( ESCHER_Prop_scaleText, ? );
//STRIP001 			}
//STRIP001 		}
//STRIP001 */
//STRIP001 
//STRIP001 		INT32 nLeft = rObj.ImplGetInt32PropertyValue( ::rtl::OUString::createFromAscii("TextLeftDistance"));
//STRIP001 		INT32 nTop = rObj.ImplGetInt32PropertyValue( ::rtl::OUString::createFromAscii("TextUpperDistance"));
//STRIP001 		INT32 nRight = rObj.ImplGetInt32PropertyValue( ::rtl::OUString::createFromAscii("TextRightDistance"));
//STRIP001 		INT32 nBottom = rObj.ImplGetInt32PropertyValue( ::rtl::OUString::createFromAscii("TextLowerDistance"));
//STRIP001 
//STRIP001 		if ( nLeft >= 200 )
//STRIP001 			nLeft -= 200;
//STRIP001 		if ( nRight >= 200 )
//STRIP001 			nRight -=200;
//STRIP001 
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_dxTextLeft, nLeft * 360 );
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_dxTextRight, nRight * 360 );
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_dyTextTop, nTop * 360 );
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_dyTextBottom, nBottom * 360 );
//STRIP001 
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_WrapText, ESCHER_WrapSquare );
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_AnchorText, eAnchor );
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_FitTextToShape, nTextAttr );
//STRIP001 		UINT32 nTxtBxId = mpEscherEx->QueryTextID( rObj.GetShapeRef(),
//STRIP001 													rObj.GetShapeId() );
//STRIP001 		rPropOpt.AddOpt( ESCHER_Prop_lTxid, nTxtBxId );
//STRIP001         rPropOpt.AddOpt( ESCHER_Prop_txflTextFlow, eFlow );
//STRIP001         rPropOpt.AddOpt( ESCHER_Prop_cdirFont, eDir );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void ImplEESdrWriter::ImplFlipBoundingBox( ImplEESdrObject& rObj, EscherPropertyContainer& rPropOpt,
//STRIP001 											const Point& rRefPoint )
//STRIP001 {
//STRIP001 	INT32 nAngle = rObj.GetAngle();
//STRIP001 	Rectangle aRect( rObj.GetRect() );
//STRIP001 
//STRIP001 	if ( nAngle < 0 )
//STRIP001 		nAngle = ( 36000 + nAngle ) % 36000;
//STRIP001 	else
//STRIP001 		nAngle = ( 36000 - ( nAngle % 36000 ) );
//STRIP001 
//STRIP001 	double fVal = (double)nAngle * F_PI18000;
//STRIP001 	double	fCos = cos( fVal );
//STRIP001 	double	fSin = sin( fVal );
//STRIP001 
//STRIP001 	double	nWidthHalf = (double) aRect.GetWidth() / 2;
//STRIP001 	double	nHeightHalf = (double) aRect.GetHeight() / 2;
//STRIP001 
//STRIP001 	double nXDiff = fCos * nWidthHalf + fSin * (-nHeightHalf);
//STRIP001 	double nYDiff = - ( fSin * nWidthHalf - fCos * ( -nHeightHalf ) );
//STRIP001 
//STRIP001 	aRect.Move( (sal_Int32)( -( nWidthHalf - nXDiff ) ), (sal_Int32)( - ( nHeightHalf + nYDiff ) ) );
//STRIP001 
//STRIP001 	nAngle *= 655;
//STRIP001 	nAngle += 0x8000;
//STRIP001 	nAngle &=~0xffff;									// nAngle auf volle Gradzahl runden
//STRIP001 	rPropOpt.AddOpt( ESCHER_Prop_Rotation, nAngle );
//STRIP001 
//STRIP001 	rObj.SetAngle( nAngle );
//STRIP001 	rObj.SetRect( aRect );
//STRIP001 }
//STRIP001 
//STRIP001 //	-----------------------------------------------------------------------
//STRIP001 
//STRIP001 #define ADD_SHAPE( nType, nFlags )								\
//STRIP001 {																\
//STRIP001 	nShapeType = nType;											\
//STRIP001 	nShapeID = mpEscherEx->GetShapeID();						\
//STRIP001 	rObj.SetShapeId( nShapeID );								\
//STRIP001 	mpEscherEx->AddShape( (UINT32)nType, (UINT32)nFlags, nShapeID );	\
//STRIP001 	rSolverContainer.AddShape( rObj.GetShapeRef(), nShapeID );	\
//STRIP001 }
//STRIP001 
//STRIP001 #define SHAPE_TEXT( bFill )											\
//STRIP001 {																	\
//STRIP001 	mpEscherEx->OpenContainer( ESCHER_SpContainer );				\
//STRIP001 	ADD_SHAPE( ESCHER_ShpInst_TextBox, 0xa00 );						\
//STRIP001 	if ( bFill )													\
//STRIP001 		aPropOpt.CreateFillProperties( rObj.mXPropSet, sal_True );	\
//STRIP001 	ImplWriteTextBundle( rObj, aPropOpt );							\
//STRIP001 }
//STRIP001 
//STRIP001 //Map from twips to export units, generally twips as well, only excel and word
//STRIP001 //export is happening here, so native units are export units, leave as
//STRIP001 //placeholder if required in future
//STRIP001 void ImplEESdrWriter::MapRect(ImplEESdrObject& rObj)
//STRIP001 {
//STRIP001 #if 0
//STRIP001     Rectangle aNewRect=rObj.GetRect();
//STRIP001     MapMode aOrig = maMapModeSrc;
//STRIP001     maMapModeSrc = MapMode( MAP_INCH, Point(),
//STRIP001         Fraction(1,EES_MAP_FRACTION), Fraction(1,EES_MAP_FRACTION));
//STRIP001     rObj.SetRect( ImplMapPoint(aNewRect.TopLeft()),
//STRIP001         ImplMapSize(aNewRect.GetSize()) );
//STRIP001     maMapModeSrc = aOrig;
//STRIP001 #endif
//STRIP001 }
//STRIP001 
//STRIP001 UINT32 ImplEESdrWriter::ImplWriteShape( ImplEESdrObject& rObj,
//STRIP001 								EscherSolverContainer& rSolverContainer,
//STRIP001 								ImplEESdrPageType ePageType )
//STRIP001 {
//STRIP001 	UINT32 nShapeID = 0;
//STRIP001 	UINT16 nShapeType = 0;
//STRIP001 	BOOL bAdditionalText = FALSE;
//STRIP001 	UINT32 nGrpShapeID = 0;
//STRIP001 
//STRIP001 	do {
//STRIP001 		mpHostAppData = mpEscherEx->StartShape( rObj.GetShapeRef() );
//STRIP001 		if ( mpHostAppData && mpHostAppData->DontWriteShape() )
//STRIP001 			break;
//STRIP001 
//STRIP001 		Point aTextRefPoint;
//STRIP001 
//STRIP001 		if( rObj.GetType().EqualsAscii( "drawing.Group" ))
//STRIP001 		{
//STRIP001 			Reference< XIndexAccess > xXIndexAccess( rObj.GetShapeRef(), UNO_QUERY );
//STRIP001 
//STRIP001 			if( xXIndexAccess.is() && 0 != xXIndexAccess->getCount() )
//STRIP001 			{
//STRIP001 				nShapeID = mpEscherEx->EnterGroup( &rObj.GetRect() );
//STRIP001 				nShapeType = ESCHER_ShpInst_Min;
//STRIP001 
//STRIP001 				for( UINT32 n = 0, nCnt = xXIndexAccess->getCount();
//STRIP001 						n < nCnt; ++n )
//STRIP001 				{
//STRIP001 					ImplEESdrObject aObj( *this, *(Reference< XShape >*)
//STRIP001 									xXIndexAccess->getByIndex( n ).getValue() );
//STRIP001 					if( aObj.IsValid() )
//STRIP001 						ImplWriteShape( aObj, rSolverContainer, ePageType );
//STRIP001 				}
//STRIP001 				mpEscherEx->LeaveGroup();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		rObj.SetAngle( rObj.ImplGetInt32PropertyValue( ::rtl::OUString::createFromAscii("RotateAngle") ));
//STRIP001 
//STRIP001 		if( ( rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("IsFontwork") ) &&
//STRIP001 			::cppu::any2bool( rObj.GetUsrAny() ) ) ||
//STRIP001 			rObj.GetType().EqualsAscii( "drawing.Measure" ) || rObj.GetType().EqualsAscii( "drawing.Caption" ) )
//STRIP001 		{
//STRIP001 /*
//STRIP001 			if( rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("BoundRect") ) )
//STRIP001 			{
//STRIP001 				::com::sun::star::awt::Rectangle aRect( *(::com::sun::star::awt::Rectangle*)rObj.GetUsrAny().getValue() );
//STRIP001 				rObj.SetRect( ImplMapPoint( Point( aRect.X, aRect.Y ) ),
//STRIP001 								ImplMapSize( Size( aRect.Width, aRect.Height ) ) );
//STRIP001 			}
//STRIP001 */
//STRIP001 			rObj.SetType( String( RTL_CONSTASCII_STRINGPARAM(
//STRIP001 								"drawing.dontknow" ),
//STRIP001 								RTL_TEXTENCODING_MS_1252 ));
//STRIP001 		}
//STRIP001 
//STRIP001 		const ::com::sun::star::awt::Size	aSize100thmm( rObj.GetShapeRef()->getSize() );
//STRIP001 		const ::com::sun::star::awt::Point	aPoint100thmm( rObj.GetShapeRef()->getPosition() );
//STRIP001 		Rectangle	aRect100thmm( Point( aPoint100thmm.X, aPoint100thmm.Y ), Size( aSize100thmm.Width, aSize100thmm.Height ) );
//STRIP001 		if ( !mpPicStrm )
//STRIP001 			mpPicStrm = mpEscherEx->QueryPicStream();
//STRIP001 		EscherPropertyContainer aPropOpt( (EscherGraphicProvider&)*mpEscherEx, mpPicStrm, aRect100thmm );
//STRIP001 		if ( rObj.GetType().EqualsAscii( "drawing.Rectangle" ))
//STRIP001 		{
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			sal_Int32 nRadius = (sal_Int32)rObj.ImplGetInt32PropertyValue(
//STRIP001 											::rtl::OUString::createFromAscii("CornerRadius"));
//STRIP001 			if( nRadius )
//STRIP001 			{
//STRIP001 				nRadius = ImplMapSize( Size( nRadius, 0 )).Width();
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_RoundRectangle, 0xa00 );	// Flags: Connector | HasSpt
//STRIP001 				INT32 nLenght = rObj.GetRect().GetWidth();
//STRIP001 				if ( nLenght > rObj.GetRect().GetHeight() )
//STRIP001 					nLenght = rObj.GetRect().GetHeight();
//STRIP001 				nLenght >>= 1;
//STRIP001 				if ( nRadius >= nLenght )
//STRIP001 					nRadius = 0x2a30;							// 0x2a30 ist PPTs maximum radius
//STRIP001 				else
//STRIP001 					nRadius = ( 0x2a30 * nRadius ) / nLenght;
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_adjustValue, nRadius );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_Rectangle, 0xa00 );			// Flags: Connector | HasSpt
//STRIP001 			}
//STRIP001 			aPropOpt.CreateFillProperties( rObj.mXPropSet, sal_True );
//STRIP001 			ImplWriteTextBundle( rObj, aPropOpt );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.Ellipse" ))
//STRIP001 		{
//STRIP001 			CircleKind	eCircleKind = CircleKind_FULL;
//STRIP001 			PolyStyle	ePolyKind;
//STRIP001 			if ( rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("CircleKind") ) )
//STRIP001 			{
//STRIP001 				eCircleKind = *( (CircleKind*)rObj.GetUsrAny().getValue() );
//STRIP001 				switch ( eCircleKind )
//STRIP001 				{
//STRIP001 					case CircleKind_SECTION :
//STRIP001 					{
//STRIP001 						ePolyKind = POLY_PIE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 					case CircleKind_ARC :
//STRIP001 					{
//STRIP001 						ePolyKind = POLY_ARC;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case CircleKind_CUT :
//STRIP001 					{
//STRIP001 						ePolyKind = POLY_CHORD;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					default:
//STRIP001 						eCircleKind = CircleKind_FULL;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if ( eCircleKind == CircleKind_FULL )
//STRIP001 			{
//STRIP001 				mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_Ellipse, 0xa00 );			// Flags: Connector | HasSpt
//STRIP001 				aPropOpt.CreateFillProperties( rObj.mXPropSet, sal_True );;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				INT32 nStartAngle, nEndAngle;
//STRIP001 				if ( !rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("CircleStartAngle") ) )
//STRIP001 					break;
//STRIP001 				nStartAngle = *( (INT32*)rObj.GetUsrAny().getValue() );
//STRIP001 				if( !rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("CircleEndAngle") ) )
//STRIP001 					break;
//STRIP001 				nEndAngle = *( (INT32*)rObj.GetUsrAny().getValue() );
//STRIP001 
//STRIP001 				Point aStart, aEnd, aCenter;
//STRIP001 				aStart.X() = (INT32)( ( cos( (double)( nStartAngle *
//STRIP001 												F_PI18000 ) ) * 100.0 ) );
//STRIP001 				aStart.Y() = - (INT32)( ( sin( (double)( nStartAngle *
//STRIP001 												F_PI18000 ) ) * 100.0 ) );
//STRIP001 				aEnd.X() = (INT32)( ( cos( (double)( nEndAngle *
//STRIP001 												F_PI18000 ) ) * 100.0 ) );
//STRIP001 				aEnd.Y() = - (INT32)( ( sin( (double)( nEndAngle *
//STRIP001 												F_PI18000 ) ) * 100.0 ) );
//STRIP001 				const Rectangle& rRect = aRect100thmm;
//STRIP001 				aCenter.X() = rRect.Left() + ( rRect.GetWidth() / 2 );
//STRIP001 				aCenter.Y() = rRect.Top() + ( rRect.GetHeight() / 2 );
//STRIP001 				aStart.X() += aCenter.X();
//STRIP001 				aStart.Y() += aCenter.Y();
//STRIP001 				aEnd.X() += aCenter.X();
//STRIP001 				aEnd.Y() += aCenter.Y();
//STRIP001 				Polygon aPolygon( rRect, aStart, aEnd, ePolyKind );
//STRIP001 				if( rObj.GetAngle() )
//STRIP001 				{
//STRIP001 					aPolygon.Rotate( rRect.TopLeft(), (sal_uInt16)( rObj.GetAngle() / 10 ) );
//STRIP001 					rObj.SetAngle( 0 );
//STRIP001 				}
//STRIP001 				mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_NotPrimitive, 0xa00 );		// Flags: Connector | HasSpt
//STRIP001 				::com::sun::star::awt::Rectangle aNewRect;
//STRIP001 				switch ( ePolyKind )
//STRIP001 				{
//STRIP001 					case POLY_PIE :
//STRIP001 					case POLY_CHORD :
//STRIP001 					{
//STRIP001 						aPropOpt.CreatePolygonProperties( rObj.mXPropSet, ESCHER_CREATEPOLYGON_POLYPOLYGON, sal_False, aNewRect, &aPolygon );
//STRIP001 						aPropOpt.CreateFillProperties( rObj.mXPropSet, sal_True  );
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case POLY_ARC :
//STRIP001 					{
//STRIP001 						aPropOpt.CreatePolygonProperties( rObj.mXPropSet, ESCHER_CREATEPOLYGON_POLYLINE, sal_False, aNewRect, &aPolygon );
//STRIP001 						aPropOpt.CreateLineProperties( rObj.mXPropSet, sal_False );
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				rObj.SetRect( Rectangle( ImplMapPoint( Point( aNewRect.X, aNewRect.Y ) ),
//STRIP001 											ImplMapSize( Size( aNewRect.Width, aNewRect.Height ) ) ) );
//STRIP001 			}
//STRIP001 			ImplWriteTextBundle( rObj, aPropOpt );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.Control" ))
//STRIP001 		{
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.Connector" ))
//STRIP001 		{
//STRIP001 			sal_uInt16 nSpType, nSpFlags;
//STRIP001 			::com::sun::star::awt::Rectangle aNewRect;
//STRIP001 			if ( aPropOpt.CreateConnectorProperties( rObj.GetShapeRef(),
//STRIP001 							rSolverContainer, aNewRect, nSpType, nSpFlags ) == sal_False )
//STRIP001 				break;
//STRIP001 			rObj.SetRect( Rectangle( ImplMapPoint( Point( aNewRect.X, aNewRect.Y ) ),
//STRIP001 										ImplMapSize( Size( aNewRect.Width, aNewRect.Height ) ) ) );
//STRIP001 
//STRIP001             mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( nSpType, nSpFlags );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.Measure" ))
//STRIP001 		{
//STRIP001 /*
//STRIP001 			if ( ImplGetPropertyValue( L"MeasureKind" ) )
//STRIP001 			{
//STRIP001 				mpEscherEx->EnterGroup( &maRect );
//STRIP001 				mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 				ImplWriteAny( ANY_FLAGS_LINE, FALSE );
//STRIP001 				UINT32 nFlags = 0xa00;											// Flags: Connector | HasSpt
//STRIP001 				if ( maRect.Top() > maRect.Bottom() )
//STRIP001 					nFlags |= 0x80;												// Flags: VertMirror
//STRIP001 				if ( maRect.Left() > maRect.Right() )
//STRIP001 					nFlags |= 0x40;												// Flags: HorzMirror
//STRIP001 
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_Line, nFlags );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_shapePath, ESCHER_ShapeComplex );
//STRIP001 				aPropOpt.CreateLineProperties( rObj.mXPropSet, sal_False );
//STRIP001 				mpEscherEx->EndCount( ESCHER_OPT, 3 );
//STRIP001 				maRect.Justify();
//STRIP001 				mpEscherEx->AddClientAnchor( maRect );
//STRIP001 				mpEscherEx->CloseContainer();			// ESCHER_SpContainer
//STRIP001 
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextHorizontalPosition" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextVerticalPosition" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureLineDistance" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureHelpLineOverhang" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureHelpLineDistance" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureHelpLine1Length" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureHelpLine2Length" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureBelowReferenceEdge" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextRotate90" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextUpsideDown" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureOverhang" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureUnit" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureScale" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureShowUnit" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureFormatString" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextAutoAngle" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextAutoAngleView" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextIsFixedAngle" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				if ( ImplGetPropertyValue( L"MeasureTextFixedAngle" ) )
//STRIP001 				{
//STRIP001 				}
//STRIP001 				mpEscherEx->LeaveGroup();
//STRIP001 			}
//STRIP001 */
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.Line" ))
//STRIP001 		{
//STRIP001 			::com::sun::star::awt::Rectangle aNewRect;
//STRIP001 			aPropOpt.CreatePolygonProperties( rObj.mXPropSet, ESCHER_CREATEPOLYGON_LINE, sal_False, aNewRect, NULL );
//STRIP001             MapRect(rObj);
//STRIP001 			if( rObj.ImplHasText() )
//STRIP001 			{
//STRIP001 				aTextRefPoint = rObj.GetRect().TopLeft();
//STRIP001 				bAdditionalText = TRUE;
//STRIP001 				nGrpShapeID = ImplEnterAdditionalTextGroup(	rObj.GetShapeRef(), &rObj.GetRect() );
//STRIP001 			}
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			const Rectangle& rRect = rObj.GetRect();
//STRIP001 			UINT32 nFlags = 0xa00;			// Flags: Connector | HasSpt
//STRIP001             if( aNewRect.Height < 0 )
//STRIP001 				nFlags |= 0x80;	  			// Flags: VertMirror
//STRIP001 			if( aNewRect.Width < 0 )
//STRIP001 				nFlags |= 0x40;				// Flags: HorzMirror
//STRIP001 
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_Line, nFlags );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_shapePath, ESCHER_ShapeComplex );
//STRIP001 			aPropOpt.CreateLineProperties( rObj.mXPropSet, sal_False );
//STRIP001 			rObj.SetAngle( 0 );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.PolyPolygon" ))
//STRIP001 		{
//STRIP001 			if( rObj.ImplHasText() )
//STRIP001 			{
//STRIP001 				nGrpShapeID = ImplEnterAdditionalTextGroup(	rObj.GetShapeRef(), &rObj.GetRect() );
//STRIP001 				bAdditionalText = TRUE;
//STRIP001 			}
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_NotPrimitive, 0xa00 );		// Flags: Connector | HasSpt
//STRIP001 			::com::sun::star::awt::Rectangle aNewRect;
//STRIP001 			aPropOpt.CreatePolygonProperties( rObj.mXPropSet, ESCHER_CREATEPOLYGON_POLYPOLYGON, sal_False, aNewRect, NULL );
//STRIP001             MapRect(rObj);
//STRIP001 			aPropOpt.CreateFillProperties( rObj.mXPropSet, sal_True );
//STRIP001 			rObj.SetAngle( 0 );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.PolyLine" ))
//STRIP001 		{
//STRIP001 			if( rObj.ImplHasText() )
//STRIP001 			{
//STRIP001 				nGrpShapeID = ImplEnterAdditionalTextGroup(	rObj.GetShapeRef(), &rObj.GetRect() );
//STRIP001 				bAdditionalText = TRUE;
//STRIP001 			}
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_NotPrimitive, 0xa00 );		// Flags: Connector | HasSpt
//STRIP001 			::com::sun::star::awt::Rectangle aNewRect;
//STRIP001 			aPropOpt.CreatePolygonProperties( rObj.mXPropSet, ESCHER_CREATEPOLYGON_POLYLINE, sal_False, aNewRect, NULL );
//STRIP001             MapRect(rObj);
//STRIP001 			aPropOpt.CreateLineProperties( rObj.mXPropSet, sal_False );
//STRIP001 			rObj.SetAngle( 0 );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.OpenBezier" ) )
//STRIP001 		{
//STRIP001 			if ( rObj.ImplHasText() )
//STRIP001 			{
//STRIP001 				nGrpShapeID = ImplEnterAdditionalTextGroup(	rObj.GetShapeRef(), &rObj.GetRect() );
//STRIP001 				bAdditionalText = TRUE;
//STRIP001 			}
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_NotPrimitive, 0xa00 );		// Flags: Connector | HasSpt
//STRIP001 			::com::sun::star::awt::Rectangle aNewRect;
//STRIP001 			aPropOpt.CreatePolygonProperties( rObj.mXPropSet, ESCHER_CREATEPOLYGON_POLYLINE, sal_True, aNewRect, NULL );
//STRIP001             MapRect(rObj);
//STRIP001 			aPropOpt.CreateLineProperties( rObj.mXPropSet, sal_False );
//STRIP001 			rObj.SetAngle( 0 );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.ClosedBezier" ) )
//STRIP001 		{
//STRIP001 			if ( rObj.ImplHasText() )
//STRIP001 			{
//STRIP001 				nGrpShapeID = ImplEnterAdditionalTextGroup(	rObj.GetShapeRef(), &rObj.GetRect() );
//STRIP001 				bAdditionalText = TRUE;
//STRIP001 			}
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_NotPrimitive, 0xa00 );		// Flags: Connector | HasSpt
//STRIP001 			::com::sun::star::awt::Rectangle aNewRect;
//STRIP001 			aPropOpt.CreatePolygonProperties( rObj.mXPropSet, ESCHER_CREATEPOLYGON_POLYPOLYGON, sal_True, aNewRect, NULL );
//STRIP001             MapRect(rObj);
//STRIP001 			aPropOpt.CreateFillProperties( rObj.mXPropSet, sal_True );
//STRIP001 			rObj.SetAngle( 0 );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.GraphicObject" ))
//STRIP001 		{
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 
//STRIP001 			// ein GraphicObject kann auch ein ClickMe Element sein
//STRIP001 			if( rObj.IsEmptyPresObj() && ( ePageType == NORMAL ) )
//STRIP001 			{
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_Rectangle, 0x220 );				// Flags: HaveAnchor | HaveMaster
//STRIP001 				UINT32 nTxtBxId = mpEscherEx->QueryTextID( rObj.GetShapeRef(),
//STRIP001 														rObj.GetShapeId() );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_lTxid, nTxtBxId );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_fNoFillHitTest, 0x10001 );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_fNoLineDrawDash, 0x10001 );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_hspMaster, mnShapeMasterBody );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if( rObj.ImplGetText() )
//STRIP001 				{
//STRIP001 					ADD_SHAPE( ESCHER_ShpInst_Rectangle, 0xa00 );			// Flags: Connector | HasSpt
//STRIP001 					if ( aPropOpt.CreateGraphicProperties( rObj.mXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "GraphicURL" ) ), sal_True ) )
//STRIP001 					{
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_WrapText, ESCHER_WrapNone );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_AnchorText, ESCHER_AnchorMiddle );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fNoFillHitTest, 0x140014 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fillBackColor, 0x8000000 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fNoLineDrawDash, 0x80000 );
//STRIP001 						ImplWriteTextBundle( rObj, aPropOpt );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					ADD_SHAPE( ESCHER_ShpInst_PictureFrame, 0xa00 );
//STRIP001 					if ( aPropOpt.CreateGraphicProperties( rObj.mXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "GraphicURL" ) ), sal_False, sal_True ) )
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_LockAgainstGrouping, 0x800080 );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii(  "drawing.Text" ))
//STRIP001 		{
//STRIP001 			SHAPE_TEXT( TRUE );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.Page" ))
//STRIP001 		{
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_Rectangle, 0xa00 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_LockAgainstGrouping, 0x40004 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fFillOK, 0x100001 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fNoFillHitTest, 0x110011 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fNoLineDrawDash, 0x90008 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fshadowObscured, 0x10001 );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.Frame" ))
//STRIP001 		{
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.OLE2" ))
//STRIP001 		{
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			if( rObj.IsEmptyPresObj() && ( ePageType == NORMAL ) )
//STRIP001 			{
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_Rectangle, 0x220 );				// Flags: HaveAnchor | HaveMaster
//STRIP001 				UINT32 nTxtBxId = mpEscherEx->QueryTextID( rObj.GetShapeRef(),
//STRIP001 														rObj.GetShapeId() );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_lTxid, nTxtBxId );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_fNoFillHitTest, 0x10001 );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_fNoLineDrawDash, 0x10001 );
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_hspMaster, mnShapeMasterBody );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				//2do: could be made an option in HostAppData whether OLE object should be written or not
//STRIP001 				BOOL bAppOLE = TRUE;
//STRIP001 				ADD_SHAPE( ESCHER_ShpInst_PictureFrame,
//STRIP001 					0xa00 | (bAppOLE ? SHAPEFLAG_OLESHAPE : 0) );
//STRIP001 				if ( aPropOpt.CreateGraphicProperties( rObj.mXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "MetaFile" ) ), sal_False ) )
//STRIP001 				{
//STRIP001 					if ( bAppOLE )
//STRIP001 					{	// snooped from Xcl hex dump, nobody knows the trouble I have seen
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_FitTextToShape,	0x00080008 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_pictureId,		0x00000001 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fillColor,		0x08000041 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fillBackColor,	0x08000041 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fNoFillHitTest,	0x00110010 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_lineColor,		0x08000040 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fNoLineDrawDash,0x00080008 );
//STRIP001 //						aPropOpt.AddOpt( ESCHER_Prop_fshadowObscured,0x00020000 );
//STRIP001 						aPropOpt.AddOpt( ESCHER_Prop_fPrint,			0x00080000 );
//STRIP001 					}
//STRIP001 					aPropOpt.AddOpt( ESCHER_Prop_LockAgainstGrouping, 0x800080 );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( '3' == rObj.GetType().GetChar(8 ) &&
//STRIP001 				 'D' == rObj.GetType().GetChar( 9 ) )	// drawing.3D
//STRIP001 		{
//STRIP001 			// SceneObject, CubeObject, SphereObject, LatheObject, ExtrudeObject, PolygonObject
//STRIP001 			if ( !rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("Bitmap") ) )
//STRIP001 				break;
//STRIP001 
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_PictureFrame, 0xa00 );
//STRIP001 
//STRIP001                 if ( aPropOpt.CreateGraphicProperties( rObj.mXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "Bitmap" ) ), sal_False ) )
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_LockAgainstGrouping, 0x800080 );
//STRIP001 		}
//STRIP001 		else if ( rObj.GetType().EqualsAscii( "drawing.dontknow" ))
//STRIP001 		{
//STRIP001 			rObj.SetAngle( 0 );
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			ADD_SHAPE( ESCHER_ShpInst_PictureFrame, 0xa00 );
//STRIP001 			if ( aPropOpt.CreateGraphicProperties( rObj.mXPropSet, String( RTL_CONSTASCII_USTRINGPARAM( "MetaFile" ) ), sal_False ) )
//STRIP001 				aPropOpt.AddOpt( ESCHER_Prop_LockAgainstGrouping, 0x800080 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		aPropOpt.CreateShadowProperties( rObj.mXPropSet );
//STRIP001 
//STRIP001 		if( USHRT_MAX != mpEscherEx->GetHellLayerId() &&
//STRIP001 			rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("LayerID") ) &&
//STRIP001 			(*((UINT16*)rObj.GetUsrAny().getValue()) ) == mpEscherEx->GetHellLayerId() )
//STRIP001 		{
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fPrint, 0x200020 );
//STRIP001 		}
//STRIP001 
//STRIP001 		{
//STRIP001 			Rectangle aRect( rObj.GetRect() );
//STRIP001 			aRect.Justify();
//STRIP001 			rObj.SetRect( aRect );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( rObj.GetAngle() )
//STRIP001 		{
//STRIP001 			if( rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("RotationPointX") ))
//STRIP001 			{
//STRIP001 				Point aRefPoint( *( (INT32*)rObj.GetUsrAny().getValue() ), 0 );
//STRIP001 				if( rObj.ImplGetPropertyValue( ::rtl::OUString::createFromAscii("RotationPointY") ))
//STRIP001 				{
//STRIP001 					aRefPoint.Y() = *( (INT32*)rObj.GetUsrAny().getValue() );
//STRIP001 					ImplFlipBoundingBox( rObj, aPropOpt, ImplMapPoint( aRefPoint ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aPropOpt.Commit( mpEscherEx->GetStream() );
//STRIP001 		if( mpEscherEx->GetGroupLevel() > 1 )
//STRIP001 		{
//STRIP001 			mpEscherEx->AddAtom( 16, ESCHER_ChildAnchor );
//STRIP001 			const Rectangle& rRect = rObj.GetRect();
//STRIP001 			mpEscherEx->GetStream() << (INT32)rRect.Left()
//STRIP001 									<< (INT32)rRect.Top()
//STRIP001 					   				<< (INT32)rRect.Right()
//STRIP001 									<< (INT32)rRect.Bottom();
//STRIP001 		}
//STRIP001 		if ( mpHostAppData )
//STRIP001 		{	//! with AdditionalText the App has to control whether these are written or not
//STRIP001 			mpHostAppData->WriteClientAnchor( *mpEscherEx, rObj.GetRect() );
//STRIP001 			mpHostAppData->WriteClientData( *mpEscherEx );
//STRIP001 			mpHostAppData->WriteClientTextbox( *mpEscherEx );
//STRIP001 		}
//STRIP001 		mpEscherEx->CloseContainer();		// ESCHER_SpContainer
//STRIP001 
//STRIP001 		if( bAdditionalText )
//STRIP001 		{
//STRIP001 			mpEscherEx->EndShape( nShapeType, nShapeID );
//STRIP001 			ImplWriteAdditionalText( rObj, aTextRefPoint );
//STRIP001 		}
//STRIP001 
//STRIP001 	} while ( 0 );
//STRIP001 
//STRIP001 	if ( bAdditionalText )
//STRIP001 		mpEscherEx->EndShape( ESCHER_ShpInst_Min, nGrpShapeID );
//STRIP001 	else
//STRIP001 		mpEscherEx->EndShape( nShapeType, nShapeID );
//STRIP001 	return nShapeID;
//STRIP001 }
//STRIP001 
//STRIP001 void ImplEESdrWriter::ImplWriteAdditionalText( ImplEESdrObject& rObj,
//STRIP001 												const Point& rTextRefPoint )
//STRIP001 {
//STRIP001 	UINT32 nShapeID = 0;
//STRIP001 	UINT16 nShapeType = 0;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		mpHostAppData = mpEscherEx->StartShape( rObj.GetShapeRef() );
//STRIP001 		if ( mpHostAppData && mpHostAppData->DontWriteShape() )
//STRIP001 			break;
//STRIP001 
//STRIP001 		const ::com::sun::star::awt::Size	aSize100thmm( rObj.GetShapeRef()->getSize() );
//STRIP001 		const ::com::sun::star::awt::Point	aPoint100thmm( rObj.GetShapeRef()->getPosition() );
//STRIP001 		Rectangle	aRect100thmm( Point( aPoint100thmm.X, aPoint100thmm.Y ), Size( aSize100thmm.Width, aSize100thmm.Height ) );
//STRIP001 		if ( !mpPicStrm )
//STRIP001 			mpPicStrm = mpEscherEx->QueryPicStream();
//STRIP001 		EscherPropertyContainer aPropOpt( (EscherGraphicProvider&)*mpEscherEx, mpPicStrm, aRect100thmm );
//STRIP001 		rObj.SetAngle( rObj.ImplGetInt32PropertyValue( ::rtl::OUString::createFromAscii("RotateAngle")));
//STRIP001 		INT32 nAngle = rObj.GetAngle();
//STRIP001 		if( rObj.GetType().EqualsAscii( "drawing.Line" ))
//STRIP001 		{
//STRIP001 //2do: this does not work right
//STRIP001 			double fDist = hypot( rObj.GetRect().GetWidth(),
//STRIP001 									rObj.GetRect().GetHeight() );
//STRIP001 			rObj.SetRect( Rectangle( rTextRefPoint,
//STRIP001 							Point( (sal_Int32)( rTextRefPoint.X() + fDist ), rTextRefPoint.Y() - 1 ) ) );
//STRIP001 
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			mpEscherEx->AddShape( ESCHER_ShpInst_TextBox, 0xa00 );
//STRIP001 			ImplWriteTextBundle( rObj, aPropOpt );
//STRIP001 
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fNoLineDrawDash, 0x90000 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fNoFillHitTest, 0x100000 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_FitTextToShape, 0x60006 );		// Size Shape To Fit Text
//STRIP001 			if ( nAngle < 0 )
//STRIP001 				nAngle = ( 36000 + nAngle ) % 36000;
//STRIP001 			if ( nAngle )
//STRIP001 				ImplFlipBoundingBox( rObj, aPropOpt, rObj.GetRect().TopLeft() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			mpEscherEx->OpenContainer( ESCHER_SpContainer );
//STRIP001 			nShapeID = mpEscherEx->GetShapeID();
//STRIP001 			mpEscherEx->AddShape( nShapeType = ESCHER_ShpInst_TextBox, 0xa00, nShapeID );
//STRIP001 			ImplWriteTextBundle( rObj, aPropOpt );
//STRIP001 
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fNoLineDrawDash, 0x90000 );
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_fNoFillHitTest, 0x100000 );
//STRIP001 
//STRIP001 			if( nAngle < 0 )
//STRIP001 				nAngle = ( 36000 + nAngle ) % 36000;
//STRIP001 			else
//STRIP001 				nAngle = ( 36000 - ( nAngle % 36000 ) );
//STRIP001 
//STRIP001 			nAngle *= 655;
//STRIP001 			nAngle += 0x8000;
//STRIP001 			nAngle &=~0xffff;	// nAngle auf volle Gradzahl runden
//STRIP001 			aPropOpt.AddOpt( ESCHER_Prop_Rotation, nAngle );
//STRIP001 			mpEscherEx->SetGroupSnapRect( mpEscherEx->GetGroupLevel(),
//STRIP001 											rObj.GetRect() );
//STRIP001 			mpEscherEx->SetGroupLogicRect( mpEscherEx->GetGroupLevel(),
//STRIP001 											rObj.GetRect() );
//STRIP001 		}
//STRIP001 		rObj.SetAngle( nAngle );
//STRIP001 		aPropOpt.Commit( mpEscherEx->GetStream() );
//STRIP001 
//STRIP001 		// write the childanchor
//STRIP001 		mpEscherEx->AddAtom( 16, ESCHER_ChildAnchor );
//STRIP001 		const Rectangle& rRect = rObj.GetRect();
//STRIP001 		mpEscherEx->GetStream() << (INT32)rRect.Left()
//STRIP001 								<< (INT32)rRect.Top()
//STRIP001 					   			<< (INT32)rRect.Right()
//STRIP001 								<< (INT32)rRect.Bottom();
//STRIP001 
//STRIP001 #if EES_WRITE_EPP
//STRIP001 		// ClientAnchor
//STRIP001 		mpEscherEx->AddClientAnchor( maRect );
//STRIP001 		// ClientTextbox
//STRIP001 		mpEscherEx->OpenContainer( ESCHER_ClientTextbox );
//STRIP001 		mpEscherEx->AddAtom( 4, EPP_TextHeaderAtom );
//STRIP001 		*mpStrm << (UINT32)EPP_TEXTTYPE_Other;								// Text in a Shape
//STRIP001 		ImplWriteTextStyleAtom();
//STRIP001 		mpEscherEx->CloseContainer();	// ESCHER_ClientTextBox
//STRIP001 #else // !EES_WRITE_EPP
//STRIP001 		if ( mpHostAppData )
//STRIP001 		{	//! the App has to control whether these are written or not
//STRIP001 			mpHostAppData->WriteClientAnchor( *mpEscherEx, rObj.GetRect() );
//STRIP001 			mpHostAppData->WriteClientData( *mpEscherEx );
//STRIP001 			mpHostAppData->WriteClientTextbox( *mpEscherEx );
//STRIP001 		}
//STRIP001 #endif // EES_WRITE_EPP
//STRIP001 		mpEscherEx->CloseContainer();	// ESCHER_SpContainer
//STRIP001 	} while ( 0 );
//STRIP001 	mpEscherEx->LeaveGroup();
//STRIP001 	mpEscherEx->EndShape( nShapeType, nShapeID );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 ImplEESdrWriter::ImplEnterAdditionalTextGroup( const Reference< XShape >& rShape,
//STRIP001 			const Rectangle* pBoundRect )
//STRIP001 {
//STRIP001 	mpHostAppData = mpEscherEx->EnterAdditionalTextGroup();
//STRIP001 	UINT32 nGrpId = mpEscherEx->EnterGroup( pBoundRect );
//STRIP001 	mpHostAppData = mpEscherEx->StartShape( rShape );
//STRIP001 	return nGrpId;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL ImplEESdrWriter::ImplInitPageValues()
//STRIP001 {
//STRIP001 	mnIndices = 0;
//STRIP001 	mnOutlinerCount = 0;				// die gliederungsobjekte muessen dem layout entsprechen,
//STRIP001 	mnEffectCount = 0;
//STRIP001 	mbIsTitlePossible = TRUE;			// bei mehr als einem title geht powerpoint in die knie
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void ImplEESdrWriter::ImplWritePage(
//STRIP001 			EscherSolverContainer& rSolverContainer,
//STRIP001 			ImplEESdrPageType ePageType, BOOL bBackGround )
//STRIP001 {
//STRIP001 	ImplInitPageValues();
//STRIP001 
//STRIP001 	UINT32 nLastPer = 0, nShapes = mXShapes->getCount();
//STRIP001 	for( UINT32 n = 0; n < nShapes; ++n )
//STRIP001 	{
//STRIP001 		UINT32 nPer = ( 5 * n ) / nShapes;
//STRIP001 		if( nPer != nLastPer )
//STRIP001 		{
//STRIP001 			nLastPer = nPer;
//STRIP001 			UINT32 nValue = mnPagesWritten * 5 + nPer;
//STRIP001 			if( nValue > mnStatMaxValue )
//STRIP001 				nValue = mnStatMaxValue;
//STRIP001 			if( mbStatusIndicator )
//STRIP001 				mXStatusIndicator->setValue( nValue );
//STRIP001 		}
//STRIP001 
//STRIP001 		ImplEESdrObject aObj( *this, *(Reference< XShape >*)
//STRIP001 									mXShapes->getByIndex( n ).getValue() );
//STRIP001 		if( aObj.IsValid() )
//STRIP001 		{
//STRIP001 			ImplWriteShape( aObj, rSolverContainer, ePageType );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	mnPagesWritten++;
//STRIP001 }
//STRIP001 
//STRIP001 // ===================================================================
//STRIP001 
//STRIP001 ImplEscherExSdr::ImplEscherExSdr( EscherEx& rEx )
//STRIP001 		:
//STRIP001 		ImplEESdrWriter( rEx ),
//STRIP001 		mpSdrPage( NULL ),
//STRIP001 		mpSolverContainer( NULL )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 ImplEscherExSdr::~ImplEscherExSdr()
//STRIP001 {
//STRIP001 	DBG_ASSERT( !mpSolverContainer, "ImplEscherExSdr::~ImplEscherExSdr: unwritten SolverContainer" );
//STRIP001 	delete mpSolverContainer;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxDrawPage* ImplEscherExSdr::ImplInitPage( const SdrPage& rPage )
//STRIP001 {
//STRIP001 	do
//STRIP001 	{
//STRIP001 		SvxDrawPage* pSvxDrawPage;
//STRIP001 		if ( mpSdrPage != &rPage || !mXDrawPage.is() )
//STRIP001 		{
//STRIP001 			// eventually write SolverContainer of current page, deletes the Solver
//STRIP001 			ImplFlushSolverContainer();
//STRIP001 
//STRIP001 			mpSdrPage = NULL;
//STRIP001 			// why not declare a const parameter if the object will not be modified?
//STRIP001 //			mXDrawPage = pSvxDrawPage = new SvxDrawPage( (SdrPage*) &rPage );
//STRIP001 			mXDrawPage = pSvxDrawPage = new SvxFmDrawPage( (SdrPage*) &rPage );
//STRIP001 			mXShapes = Reference< XShapes >::query( mXDrawPage );
//STRIP001 			if ( !mXShapes.is() )
//STRIP001 				break;
//STRIP001 			if ( !ImplInitPageValues() )	// ImplEESdrWriter
//STRIP001 				break;
//STRIP001 			mpSdrPage = &rPage;
//STRIP001 
//STRIP001 			mpSolverContainer = new EscherSolverContainer;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pSvxDrawPage = SvxDrawPage::getImplementation(mXDrawPage);
//STRIP001 
//STRIP001 		return pSvxDrawPage;
//STRIP001 	} while ( 0 );
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void ImplEscherExSdr::ImplExitPage()
//STRIP001 {
//STRIP001     // close all groups before the solver container is written
//STRIP001     while( mpEscherEx->GetGroupLevel() )
//STRIP001         mpEscherEx->LeaveGroup();
//STRIP001 
//STRIP001 	ImplFlushSolverContainer();
//STRIP001 	mpSdrPage = NULL;	// reset page for next init
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void ImplEscherExSdr::ImplFlushSolverContainer()
//STRIP001 {
//STRIP001 	if ( mpSolverContainer )
//STRIP001 	{
//STRIP001 		mpSolverContainer->WriteSolver( mpEscherEx->GetStream() );
//STRIP001 		delete mpSolverContainer;
//STRIP001 		mpSolverContainer = NULL;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void ImplEscherExSdr::ImplWriteCurrentPage()
//STRIP001 {
//STRIP001 	DBG_ASSERT( mpSolverContainer, "ImplEscherExSdr::ImplWriteCurrentPage: no SolverContainer" );
//STRIP001 	ImplWritePage( *mpSolverContainer, NORMAL );
//STRIP001 	ImplExitPage();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 ImplEscherExSdr::ImplWriteTheShape( ImplEESdrObject& rObj )
//STRIP001 {
//STRIP001 	DBG_ASSERT( mpSolverContainer, "ImplEscherExSdr::ImplWriteShape: no SolverContainer" );
//STRIP001 	return ImplWriteShape( rObj, *mpSolverContainer, NORMAL );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ===================================================================
//STRIP001 
//STRIP001 void EscherEx::AddSdrPage( const SdrPage& rPage )
//STRIP001 {
//STRIP001 	if ( mpImplEscherExSdr->ImplInitPage( rPage ) )
//STRIP001 		mpImplEscherExSdr->ImplWriteCurrentPage();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherEx::AddSdrObject( const SdrObject& rObj )
//STRIP001 {
//STRIP001 	ImplEESdrObject aObj( *mpImplEscherExSdr, rObj );
//STRIP001 	if( aObj.IsValid() )
//STRIP001 		return mpImplEscherExSdr->ImplWriteTheShape( aObj );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::EndSdrObjectPage()
//STRIP001 {
//STRIP001 	mpImplEscherExSdr->ImplExitPage();
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 EscherExHostAppData* EscherEx::StartShape( const Reference< XShape >& rShape )
//STRIP001 {
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 void EscherEx::EndShape( UINT16 nShapeType, UINT32 nShapeID )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream* EscherEx::QueryPicStream()
//STRIP001 {
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 UINT32 EscherEx::QueryTextID( const Reference< XShape >&, UINT32 )
//STRIP001 {
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 // add an dummy rectangle shape into the escher stream
//STRIP001 UINT32 EscherEx::AddDummyShape( const SdrObject& rObj )
//STRIP001 {
//STRIP001 	OpenContainer( ESCHER_SpContainer );
//STRIP001 	UINT32 nShapeID = GetShapeID();
//STRIP001 	AddShape( ESCHER_ShpInst_Rectangle, 0xa00, nShapeID );
//STRIP001 //??	aSolverContainer.AddShape( mXShape, nShapeID );
//STRIP001 	CloseContainer();
//STRIP001 
//STRIP001 	return nShapeID;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 // static
//STRIP001 const SdrObject* EscherEx::GetSdrObject( const Reference< XShape >& rShape )
//STRIP001 {
//STRIP001 	const SdrObject* pRet = 0;
//STRIP001 	const SvxShape* pSvxShape = SvxShape::getImplementation( rShape );
//STRIP001 	DBG_ASSERT( pSvxShape, "EscherEx::GetSdrObject: no SvxShape" );
//STRIP001 	if( pSvxShape )
//STRIP001 	{
//STRIP001 		pRet = pSvxShape->GetSdrObject();
//STRIP001 		DBG_ASSERT( pRet, "EscherEx::GetSdrObject: no SdrObj" );
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -------------------------------------------------------------------
//STRIP001 
//STRIP001 ImplEESdrObject::ImplEESdrObject( ImplEscherExSdr& rEx,
//STRIP001 									const SdrObject& rObj )
//STRIP001 	: mbValid( FALSE ), mbPresObj( FALSE ), mbEmptyPresObj( FALSE ),
//STRIP001 	mnShapeId( 0 ), mnAngle( 0 ), mnTextSize( 0 )
//STRIP001 {
//STRIP001 	SdrPage* pPage = rObj.GetPage();
//STRIP001 	DBG_ASSERT( pPage, "ImplEESdrObject::ImplEESdrObject: no SdrPage" );
//STRIP001 	if( pPage )
//STRIP001 	{
//STRIP001 		SvxDrawPage* pSvxDrawPage = rEx.ImplInitPage( *pPage );
//STRIP001 		if( pSvxDrawPage )
//STRIP001 		{
//STRIP001 			// why not declare a const parameter if the object will
//STRIP001 			// not be modified?
//STRIP001 			mXShape = uno::Reference< drawing::XShape >::query( ((SdrObject*)&rObj)->getUnoShape() );;
//STRIP001 			Init( rEx );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ImplEESdrObject::ImplEESdrObject( ImplEESdrWriter& rEx,
//STRIP001 									const Reference< XShape >& rShape )
//STRIP001 	: mbValid( FALSE ), mbPresObj( FALSE ), mbEmptyPresObj( FALSE ),
//STRIP001 	mnShapeId( 0 ), mnAngle( 0 ), mXShape( rShape ),
//STRIP001 	mnTextSize( 0 )
//STRIP001 {
//STRIP001 	Init( rEx );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 ImplEESdrObject::~ImplEESdrObject()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 void ImplEESdrObject::Init( ImplEESdrWriter& rEx )
//STRIP001 {
//STRIP001 	mXPropSet = Reference< XPropertySet >::query( mXShape );
//STRIP001 	if( mXPropSet.is() )
//STRIP001 	{
//STRIP001 		static const sal_Char aPrefix[] = "com.sun.star.";
//STRIP001 		static const xub_StrLen nPrefix = sizeof(aPrefix)-1;
//STRIP001 		SetRect( rEx.ImplMapPoint( Point( mXShape->getPosition().X, mXShape->getPosition().Y ) ),
//STRIP001 				 rEx.ImplMapSize( Size( mXShape->getSize().Width, mXShape->getSize().Height ) ) );
//STRIP001 		mType = String( mXShape->getShapeType() );
//STRIP001 		mType.Erase( 0, nPrefix );	// strip "com.sun.star."
//STRIP001 		xub_StrLen nPos = mType.SearchAscii( "Shape" );
//STRIP001 		mType.Erase( nPos, 5 );
//STRIP001 
//STRIP001 		static const OUString sPresStr(::rtl::OUString::createFromAscii("IsPresentationObject"));
//STRIP001 		static const OUString sEmptyPresStr(::rtl::OUString::createFromAscii("IsEmptyPresentationObject"));
//STRIP001 
//STRIP001 		if( ImplGetPropertyValue( sPresStr ) )
//STRIP001 			mbPresObj = ::cppu::any2bool( mAny );
//STRIP001 
//STRIP001 		if( mbPresObj && ImplGetPropertyValue( sEmptyPresStr ) )
//STRIP001 			mbEmptyPresObj = ::cppu::any2bool( mAny );
//STRIP001 
//STRIP001 		mbValid = TRUE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //BOOL ImplEESdrObject::ImplGetPropertyValue( const OUString& rString )
//STRIP001 BOOL ImplEESdrObject::ImplGetPropertyValue( const sal_Unicode* rString )
//STRIP001 {
//STRIP001 	BOOL bRetValue = FALSE;
//STRIP001 	if( mbValid )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			mAny = mXPropSet->getPropertyValue( rString );
//STRIP001 			if( mAny.hasValue() )
//STRIP001 				bRetValue = TRUE;
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::uno::Exception& )
//STRIP001 		{
//STRIP001 			bRetValue = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 
//STRIP001 #ifdef USED
//STRIP001 BOOL ImplEESdrObject::ImplGetPropertyValue( const Reference< XPropertySet >& rXPropSet,
//STRIP001 											const OUString& rString )
//STRIP001 {
//STRIP001 	BOOL bRetValue = FALSE;
//STRIP001 	if( mbValid )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			mAny = rXPropSet->getPropertyValue( rString );
//STRIP001 			if( 0 != mAny.get() )
//STRIP001 				bRetValue = TRUE;
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::uno::Exception& )
//STRIP001 		{
//STRIP001 			bRetValue = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRetValue;
//STRIP001 }
//STRIP001 #endif
//STRIP001 
//STRIP001 void ImplEESdrObject::SetRect( const Point& rPos, const Size& rSz )
//STRIP001 {
//STRIP001 	maRect = Rectangle( rPos, rSz );
//STRIP001 }
//STRIP001 
//STRIP001 const SdrObject* ImplEESdrObject::GetSdrObject() const
//STRIP001 {
//STRIP001 	return EscherEx::GetSdrObject( mXShape );
//STRIP001 }
//STRIP001 
//STRIP001 //  laedt und konvertiert text aus shape, ergebnis ist mnTextSize gespeichert
//STRIP001 UINT32 ImplEESdrObject::ImplGetText()
//STRIP001 {
//STRIP001 	Reference< XText > xXText( mXShape, UNO_QUERY );
//STRIP001 	mnTextSize = 0;
//STRIP001 	if( xXText.is() )
//STRIP001 		mnTextSize = xXText->getString().getLength();
//STRIP001 	return mnTextSize;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL ImplEESdrObject::ImplHasText() const
//STRIP001 {
//STRIP001 	Reference< XText > xXText( mXShape, UNO_QUERY );
//STRIP001 	return xXText.is() && xXText->getString().getLength();
//STRIP001 }

}
