/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fntctl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:23:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <string> // HACK: prevent conflict between STLPORT and Workshop headern

// auto strip #ifndef _STDMENU_HXX //autogen
// auto strip #include <svtools/stdmenu.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
#pragma hdrstop

#define ITEMID_FONT		1
#define ITEMID_FONTLIST	2

// auto strip #include "fntctl.hxx"		// ITEMID_FONT muss vorher definiert sein!
#include "svxids.hrc"

// auto strip #ifndef _SVX_FLSTITEM_HXX //autogen
// auto strip #include "flstitem.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FONTITEM_HXX //autogen
// auto strip #include "fontitem.hxx"
// auto strip #endif
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//STRIP001 SFX_IMPL_MENU_CONTROL(SvxFontMenuControl, SvxFontItem);

//--------------------------------------------------------------------

/*	[Beschreibung]

	Ctor; setzt den Select-Handler am Men"u und tr"agt das Men"u
	in seinen Parent ein.
*/

//STRIP001 SvxFontMenuControl::SvxFontMenuControl
//STRIP001 (
//STRIP001 	USHORT 			nId,
//STRIP001 	Menu&			rMenu,
//STRIP001 	SfxBindings&	rBindings
//STRIP001 ) :
//STRIP001 	pMenu	( new FontNameMenu ),
//STRIP001 	rParent	( rMenu )
//STRIP001 {
//STRIP001 	rMenu.SetPopupMenu( nId, pMenu );
//STRIP001 	pMenu->SetSelectHdl( LINK( this, SvxFontMenuControl, MenuSelect ) );
//STRIP001 	StartListening( rBindings );
//STRIP001 	FillMenu();
//STRIP001 }

//--------------------------------------------------------------------

/*	[Beschreibung]

	F"ullt das Men"u mit den aktuellen Fonts aus der Fontlist
	der DocumentShell.
*/

//STRIP001 void SvxFontMenuControl::FillMenu()
//STRIP001 {
//STRIP001 	SfxObjectShell *pDoc = SfxObjectShell::Current();
//STRIP001 
//STRIP001 	if ( pDoc )
//STRIP001 	{
//STRIP001 		const SvxFontListItem* pFonts =
//STRIP001 			(const SvxFontListItem*)pDoc->GetItem( SID_ATTR_CHAR_FONTLIST );
//STRIP001 		const FontList* pList = pFonts ? pFonts->GetFontList(): 0;
//STRIP001 		DBG_ASSERT( pList, "Kein Fonts gefunden" );
//STRIP001 		pMenu->Fill( pList );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

/*	[Beschreibung]

	Statusbenachrichtigung;
	f"ullt ggf. das Men"u mit den aktuellen Fonts aus der Fontlist
	der DocumentShell.
	Ist die Funktionalit"at disabled, wird der entsprechende
	Men"ueintrag im Parentmen"u disabled, andernfalls wird er enabled.
	Der aktuelle Font wird mit einer Checkmark versehen.
*/

//STRIP001 void SvxFontMenuControl::StateChanged(
//STRIP001 
//STRIP001 	USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 
//STRIP001 {
//STRIP001 	rParent.EnableItem( GetId(), SFX_ITEM_DISABLED != eState );
//STRIP001 
//STRIP001 	if ( SFX_ITEM_AVAILABLE == eState )
//STRIP001 	{
//STRIP001 		if ( !pMenu->GetItemCount() )
//STRIP001 			FillMenu();
//STRIP001 		const SvxFontItem* pFontItem = PTR_CAST( SvxFontItem, pState );
//STRIP001 		String aFont;
//STRIP001 
//STRIP001 		if ( pFontItem )
//STRIP001 			aFont = pFontItem->GetFamilyName();
//STRIP001 		pMenu->SetCurName( aFont );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------

/*	[Beschreibung]

	Statusbenachrichtigung "uber Bindings;  bei DOCCHANGED
	wird das Men"u mit den aktuellen Fonts aus der Fontlist
	der DocumentShell gef"ullt.
*/

//STRIP001 void SvxFontMenuControl::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 								 const SfxHint& rHint, const TypeId& rHintType )
//STRIP001 {
//STRIP001 	if ( rHint.Type() != TYPE(SfxSimpleHint) &&
//STRIP001 		 ( (SfxSimpleHint&)rHint ).GetId() == SFX_HINT_DOCCHANGED )
//STRIP001 		FillMenu();
//STRIP001 }

//--------------------------------------------------------------------

/*	[Beschreibung]

	Select-Handler des Men"us; der Name des selektierten Fonts
	wird in einem SvxFontItem verschickt. Das F"ullen mit den
	weiteren Fontinformationen mu\s durch die Applikation geschehen.
*/

//STRIP001 IMPL_LINK_INLINE_START( SvxFontMenuControl, MenuSelect, FontNameMenu *, pMen )
//STRIP001 {
//STRIP001 	SvxFontItem aItem( GetId() );
//STRIP001 	aItem.GetFamilyName() = pMen->GetCurName();
//STRIP001 	GetBindings().GetDispatcher()->Execute( GetId(), SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxFontMenuControl, MenuSelect, FontNameMenu *, pMen )

//--------------------------------------------------------------------

/*	[Beschreibung]

	Dtor; gibt das Men"u frei.
*/

//STRIP001 SvxFontMenuControl::~SvxFontMenuControl()
//STRIP001 {
//STRIP001 	delete pMenu;
//STRIP001 }

//--------------------------------------------------------------------

/*	[Beschreibung]

	Gibt das Men"u zur"uck
*/

//STRIP001 PopupMenu* SvxFontMenuControl::GetPopup() const
//STRIP001 {
//STRIP001 	return pMenu;
//STRIP001 }



}
