/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_galobj.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:56:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS

#include <tools/rcid.h>
// auto strip #include <tools/vcompat.hxx>
// auto strip #include <vcl/virdev.hxx>
// auto strip #include <svtools/itempool.hxx>
// auto strip #include "fmmodel.hxx"
// auto strip #include "fmview.hxx"
// auto strip #include "fmpage.hxx"
#include "gallery.hrc"
// auto strip #include "galmisc.hxx"
// auto strip #include "galobj.hxx"
namespace binfilter {

// -------------
// - SgaObject -
// -------------

//STRIP001 SgaObject::SgaObject() :
//STRIP001 		bIsValid    ( FALSE ),
//STRIP001 		bIsThumbBmp	( TRUE )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SgaObject::CreateThumb( const Graphic& rGraphic )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( rGraphic.GetType() == GRAPHIC_BITMAP )
//STRIP001 	{
//STRIP001 		BitmapEx    aBmpEx( rGraphic.GetBitmapEx() );
//STRIP001 		Size        aBmpSize( aBmpEx.GetSizePixel() );
//STRIP001 
//STRIP001 		if( aBmpSize.Width() && aBmpSize.Height() )
//STRIP001 		{
//STRIP001 			const Color	aWhite( COL_WHITE );
//STRIP001 
//STRIP001 		    if( aBmpEx.GetPrefMapMode().GetMapUnit() != MAP_PIXEL && 
//STRIP001 		        aBmpEx.GetPrefSize().Width() > 0 && 
//STRIP001 		        aBmpEx.GetPrefSize().Height() > 0 )
//STRIP001 		    {
//STRIP001 		        Size aLogSize( OutputDevice::LogicToLogic( aBmpEx.GetPrefSize(), aBmpEx.GetPrefMapMode(), MAP_100TH_MM ) );
//STRIP001 		        
//STRIP001 		        if( aLogSize.Width() > 0 && aLogSize.Height() > 0 )
//STRIP001 		        {
//STRIP001 		            double  fFactorLog = static_cast< double >( aLogSize.Width() ) / aLogSize.Height();
//STRIP001 		            double  fFactorPix = static_cast< double >( aBmpSize.Width() ) / aBmpSize.Height();
//STRIP001         		    
//STRIP001 		            if( fFactorPix > fFactorLog )
//STRIP001 		                aBmpSize.Width() = FRound( aBmpSize.Height() * fFactorLog );
//STRIP001 		            else
//STRIP001 		                aBmpSize.Height() = FRound( aBmpSize.Width() / fFactorLog );
//STRIP001         		    
//STRIP001 		            aBmpEx.SetSizePixel( aBmpSize );
//STRIP001 		        }
//STRIP001 		    }
//STRIP001 
//STRIP001 			aThumbBmp = aBmpEx.GetBitmap( &aWhite );
//STRIP001 
//STRIP001 			if( ( aBmpSize.Width() <= S_THUMB ) && ( aBmpSize.Height() <= S_THUMB ) )
//STRIP001 			{
//STRIP001 				aThumbBmp.Convert( BMP_CONVERSION_8BIT_COLORS );
//STRIP001 				bRet = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				const float	fFactor  = (float) aBmpSize.Width() / aBmpSize.Height();
//STRIP001 				const Size	aNewSize( Max( (long) (fFactor < 1. ? S_THUMB * fFactor : S_THUMB), 8L ),
//STRIP001 									  Max( (long) (fFactor < 1. ? S_THUMB : S_THUMB / fFactor), 8L ) );
//STRIP001 
//STRIP001 				if( aThumbBmp.Scale( (double) aNewSize.Width() / aBmpSize.Width(),
//STRIP001 									 (double) aNewSize.Height() / aBmpSize.Height(), BMP_SCALE_INTERPOLATE ) )
//STRIP001 				{
//STRIP001 					aThumbBmp.Convert( BMP_CONVERSION_8BIT_COLORS );
//STRIP001 					bRet = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( rGraphic.GetType() == GRAPHIC_GDIMETAFILE )
//STRIP001 	{
//STRIP001 		const Size aPrefSize( rGraphic.GetPrefSize() );
//STRIP001 		const double fFactor  = (double)aPrefSize.Width() / (double)aPrefSize.Height();
//STRIP001         Size aSize( S_THUMB, S_THUMB );
//STRIP001 		if ( fFactor < 1.0 )
//STRIP001 			aSize.Width() = (sal_Int32)( S_THUMB * fFactor );
//STRIP001 		else
//STRIP001 			aSize.Height() = (sal_Int32)( S_THUMB / fFactor );
//STRIP001 
//STRIP001         aThumbBmp = rGraphic.GetBitmap( &aSize );
//STRIP001 
//STRIP001 		if( !aThumbBmp.IsEmpty() )
//STRIP001 		{
//STRIP001 			aThumbBmp.Convert( BMP_CONVERSION_8BIT_COLORS );
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObject::WriteData( SvStream& rOut ) const
//STRIP001 {
//STRIP001 	static const UINT32 nInventor = COMPAT_FORMAT( 'S', 'G', 'A', '3' );
//STRIP001 
//STRIP001 	rOut << nInventor << (UINT16) 0x0004 << GetVersion() << (UINT16) GetObjKind();
//STRIP001 	rOut << bIsThumbBmp;
//STRIP001 
//STRIP001 	if( bIsThumbBmp )
//STRIP001 	{
//STRIP001 		const USHORT	nOldCompressMode = rOut.GetCompressMode();
//STRIP001 		const ULONG		nOldVersion = rOut.GetVersion();
//STRIP001 
//STRIP001 		rOut.SetCompressMode( COMPRESSMODE_ZBITMAP );
//STRIP001 		rOut.SetVersion( SOFFICE_FILEFORMAT_50 );
//STRIP001 
//STRIP001 		rOut << aThumbBmp;
//STRIP001 
//STRIP001 		rOut.SetVersion( nOldVersion );
//STRIP001 		rOut.SetCompressMode( nOldCompressMode );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rOut << aThumbMtf;
//STRIP001 
//STRIP001 	rOut << ByteString( aURL.GetMainURL( INetURLObject::NO_DECODE ), RTL_TEXTENCODING_UTF8 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObject::ReadData(SvStream& rIn, UINT16& rReadVersion )
//STRIP001 {
//STRIP001 	ByteString	aTmpStr;
//STRIP001 	UINT32		nTmp32;
//STRIP001 	UINT16		nTmp16;
//STRIP001 
//STRIP001 	rIn >> nTmp32 >> nTmp16 >> rReadVersion >> nTmp16 >> bIsThumbBmp;
//STRIP001 
//STRIP001 	if( bIsThumbBmp )
//STRIP001 		rIn >> aThumbBmp;
//STRIP001 	else
//STRIP001 		rIn >> aThumbMtf;
//STRIP001 
//STRIP001 	rIn >> aTmpStr; aURL = INetURLObject( String( aTmpStr.GetBuffer(), RTL_TEXTENCODING_UTF8 ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 const String SgaObject::GetTitle() const
//STRIP001 {
//STRIP001 	String aReturnValue( aTitle );
//STRIP001 	if ( !getenv( "GALLERY_SHOW_PRIVATE_TITLE" ) )
//STRIP001 	{
//STRIP001 		if ( aReturnValue.GetTokenCount( ':' ) == 3 )
//STRIP001 		{
//STRIP001 			String		aPrivateInd  ( aReturnValue.GetToken( 0, ':' ) );
//STRIP001 			String		aResourceName( aReturnValue.GetToken( 1, ':' ) );
//STRIP001 			sal_Int32	nResId		 ( aReturnValue.GetToken( 2, ':' ).ToInt32() );
//STRIP001 			if ( aReturnValue.GetToken( 0, ':' ).EqualsAscii( "private" ) &&
//STRIP001 				aResourceName.Len() && ( nResId > 0 ) && ( nResId < 0x10000 ) )
//STRIP001 			{
//STRIP001 				ByteString aMgrName( aResourceName, RTL_TEXTENCODING_UTF8 );
//STRIP001 				aMgrName += ByteString::CreateFromInt32( SOLARUPD );
//STRIP001 				ResMgr* pResMgr = ResMgr::CreateResMgr( aMgrName.GetBuffer(),
//STRIP001 							Application::GetSettings().GetUILanguage() );
//STRIP001 				if ( pResMgr )
//STRIP001 				{
//STRIP001 					ResId aResId( (sal_uInt16)nResId, pResMgr );
//STRIP001 					aResId.SetRT( RSC_STRING );
//STRIP001 					if ( pResMgr->IsAvailable( aResId ) )
//STRIP001 					{
//STRIP001 						aReturnValue = String( aResId );
//STRIP001 					}
//STRIP001 					delete pResMgr;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aReturnValue;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObject::SetTitle( const String& rTitle )
//STRIP001 {
//STRIP001 	aTitle = rTitle;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& operator<<( SvStream& rOut, const SgaObject& rObj )
//STRIP001 {
//STRIP001 	rObj.WriteData( rOut );
//STRIP001 	return rOut;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& operator>>( SvStream& rIn, SgaObject& rObj )
//STRIP001 {
//STRIP001 	UINT16 nReadVersion;
//STRIP001 
//STRIP001 	rObj.ReadData( rIn, nReadVersion );
//STRIP001 	rObj.bIsValid = ( rIn.GetError() == ERRCODE_NONE );
//STRIP001 
//STRIP001 	return rIn;
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------
//STRIP001 // - SgaObjectBmp -
//STRIP001 // ----------------
//STRIP001 
//STRIP001 SgaObjectBmp::SgaObjectBmp()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectBmp::SgaObjectBmp( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	Graphic aGraphic;
//STRIP001 	String	aFilter;
//STRIP001 
//STRIP001 	if ( SGA_IMPORT_NONE != GalleryGraphicImport( rURL, aGraphic, aFilter ) )
//STRIP001 		Init( aGraphic, rURL );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectBmp::SgaObjectBmp( const Graphic& rGraphic, const INetURLObject& rURL, const String& rFormat )
//STRIP001 {
//STRIP001 	if( FileExists( rURL ) )
//STRIP001 		Init( rGraphic, rURL );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObjectBmp::Init( const Graphic& rGraphic, const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	aURL = rURL;
//STRIP001 	bIsValid = CreateThumb( rGraphic );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObjectBmp::WriteData( SvStream& rOut ) const
//STRIP001 {
//STRIP001 	String	aDummyStr;
//STRIP001 	char	aDummy[ 10 ];
//STRIP001 
//STRIP001 	// Version setzen
//STRIP001 	SgaObject::WriteData( rOut );
//STRIP001 	rOut.Write( aDummy, 10 );
//STRIP001 	rOut << ByteString( aDummyStr, RTL_TEXTENCODING_UTF8 ) << ByteString( aTitle, RTL_TEXTENCODING_UTF8 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObjectBmp::ReadData( SvStream& rIn, UINT16& rReadVersion )
//STRIP001 {
//STRIP001 	ByteString aTmpStr;
//STRIP001 
//STRIP001 	SgaObject::ReadData( rIn, rReadVersion );
//STRIP001 	rIn.SeekRel( 10 ); // 16, 16, 32, 16
//STRIP001 	rIn >> aTmpStr; // dummy
//STRIP001 
//STRIP001 	if( rReadVersion >= 5 )
//STRIP001 	{
//STRIP001 		rIn >> aTmpStr; aTitle = String( aTmpStr.GetBuffer(), RTL_TEXTENCODING_UTF8 );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------
//STRIP001 // - SgaObjectSound -
//STRIP001 // ------------------
//STRIP001 
//STRIP001 SgaObjectSound::SgaObjectSound() :
//STRIP001 	eSoundType( SOUND_STANDARD )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectSound::SgaObjectSound( const INetURLObject& rURL ) :
//STRIP001 	eSoundType( SOUND_STANDARD )
//STRIP001 {
//STRIP001 	if( FileExists( rURL ) )
//STRIP001 	{
//STRIP001 		aURL = rURL;
//STRIP001 		aThumbBmp = Bitmap( Size( 1, 1 ), 1 );
//STRIP001 		bIsValid = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bIsValid = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectSound::~SgaObjectSound()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 Bitmap SgaObjectSound::GetThumbBmp() const
//STRIP001 {
//STRIP001 	USHORT nId;
//STRIP001 
//STRIP001 	switch( eSoundType )
//STRIP001 	{
//STRIP001 		case( SOUND_COMPUTER ): nId = RID_SVXBMP_GALLERY_SOUND_1; break;
//STRIP001 		case( SOUND_MISC ): nId = RID_SVXBMP_GALLERY_SOUND_2; break;
//STRIP001 		case( SOUND_MUSIC ): nId = RID_SVXBMP_GALLERY_SOUND_3; break;
//STRIP001 		case( SOUND_NATURE ): nId = RID_SVXBMP_GALLERY_SOUND_4; break;
//STRIP001 		case( SOUND_SPEECH ): nId = RID_SVXBMP_GALLERY_SOUND_5; break;
//STRIP001 		case( SOUND_TECHNIC ): nId = RID_SVXBMP_GALLERY_SOUND_6; break;
//STRIP001 		case( SOUND_ANIMAL ): nId = RID_SVXBMP_GALLERY_SOUND_7; break;
//STRIP001 
//STRIP001 		// standard
//STRIP001 		default:
//STRIP001 			nId = RID_SVXBMP_GALLERY_SOUND_0;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return Bitmap( GAL_RESID( nId ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObjectSound::WriteData( SvStream& rOut ) const
//STRIP001 {
//STRIP001 	SgaObject::WriteData( rOut );
//STRIP001 	rOut << (UINT16) eSoundType << ByteString( aTitle, RTL_TEXTENCODING_UTF8 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObjectSound::ReadData( SvStream& rIn, UINT16& rReadVersion )
//STRIP001 {
//STRIP001 	SgaObject::ReadData( rIn, rReadVersion );
//STRIP001 
//STRIP001 	if( rReadVersion >= 5 )
//STRIP001 	{
//STRIP001 		ByteString	aTmpStr;
//STRIP001 		UINT16		nTmp16;
//STRIP001 
//STRIP001 		rIn >> nTmp16; eSoundType = (GalSoundType) nTmp16;
//STRIP001 
//STRIP001 		if( rReadVersion >= 6 )
//STRIP001 		{
//STRIP001 			rIn >> aTmpStr; aTitle = String( aTmpStr.GetBuffer(), RTL_TEXTENCODING_UTF8 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------
//STRIP001 // - SgaObjectAnim -
//STRIP001 // -----------------
//STRIP001 
//STRIP001 SgaObjectAnim::SgaObjectAnim()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectAnim::SgaObjectAnim( const Graphic& rGraphic, 
//STRIP001 							  const INetURLObject& rURL, 
//STRIP001 							  const String& rFormatName )
//STRIP001 {
//STRIP001 	aURL = rURL;
//STRIP001 	bIsValid = CreateThumb( rGraphic );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------
//STRIP001 // - SgaObjectINet -
//STRIP001 // -----------------
//STRIP001 
//STRIP001 SgaObjectINet::SgaObjectINet()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectINet::SgaObjectINet( const Graphic& rGraphic, const INetURLObject& rURL, const String& rFormatName ) :
//STRIP001 			SgaObjectAnim	( rGraphic, rURL, rFormatName )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------
//STRIP001 // - SgaObjectSvDraw -
//STRIP001 // -------------------
//STRIP001 
//STRIP001 SgaObjectSvDraw::SgaObjectSvDraw()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectSvDraw::SgaObjectSvDraw( const FmFormModel& rModel, const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	aURL = rURL;
//STRIP001 	bIsValid = CreateThumb( rModel );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 SgaObjectSvDraw::SgaObjectSvDraw( SvStream& rIStm, const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	FmFormModel	aModel;
//STRIP001 
//STRIP001 	aModel.GetItemPool().FreezeIdRanges();
//STRIP001 	
//STRIP001     if( GallerySvDrawImport( rIStm, aModel ) )
//STRIP001 	{
//STRIP001 		aURL = rURL;
//STRIP001 		bIsValid = CreateThumb( aModel );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SgaObjectSvDraw::CreateThumb( const FmFormModel& rModel )
//STRIP001 {
//STRIP001 	Graphic		aGraphic;
//STRIP001 	ImageMap	aImageMap;
//STRIP001 	BOOL		bRet = FALSE;
//STRIP001 
//STRIP001 	if ( CreateIMapGraphic( rModel, aGraphic, aImageMap ) )
//STRIP001 		bRet = SgaObject::CreateThumb( aGraphic );
//STRIP001 	else
//STRIP001 	{
//STRIP001         VirtualDevice aVDev;
//STRIP001 
//STRIP001         aVDev.SetOutputSizePixel( Size( S_THUMB, S_THUMB ) );
//STRIP001 
//STRIP001         if( bRet = DrawCentered( &aVDev, rModel ) )
//STRIP001         {
//STRIP001             aThumbBmp = aVDev.GetBitmap( Point(), aVDev.GetOutputSizePixel() );
//STRIP001 	        aThumbBmp.Convert( BMP_CONVERSION_8BIT_COLORS );
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SgaObjectSvDraw::DrawCentered( OutputDevice* pOut, const FmFormModel& rModel )
//STRIP001 {
//STRIP001     const FmFormPage*   pPage = static_cast< const FmFormPage* >( rModel.GetPage( 0 ) );
//STRIP001     BOOL                bRet = FALSE;
//STRIP001 
//STRIP001     if( pOut && pPage )
//STRIP001     {
//STRIP001         const Rectangle aObjRect( pPage->GetAllObjBoundRect() );
//STRIP001         const Size      aOutSizePix( pOut->GetOutputSizePixel() );
//STRIP001 
//STRIP001         if( aObjRect.GetWidth() && aObjRect.GetHeight() && aOutSizePix.Width() > 2 && aOutSizePix.Height() > 2 )
//STRIP001         {
//STRIP001             FmFormView      aView( const_cast< FmFormModel* >( &rModel ), pOut );
//STRIP001             MapMode	        aMap( rModel.GetScaleUnit() );
//STRIP001             Rectangle       aDrawRectPix( Point( 1, 1 ), Size( aOutSizePix.Width() - 2, aOutSizePix.Height() - 2 ) );
//STRIP001             const double    fFactor  = (double) aObjRect.GetWidth() / aObjRect.GetHeight();
//STRIP001             Fraction        aFrac( FRound( fFactor < 1. ? aDrawRectPix.GetWidth() * fFactor : aDrawRectPix.GetWidth() ), 
//STRIP001                                    pOut->LogicToPixel( aObjRect.GetSize(), aMap ).Width() );
//STRIP001 
//STRIP001             aMap.SetScaleX( aFrac );
//STRIP001             aMap.SetScaleY( aFrac );
//STRIP001 
//STRIP001             const Size aDrawSize( pOut->PixelToLogic( aDrawRectPix.GetSize(), aMap ) );
//STRIP001             Point aOrigin( pOut->PixelToLogic( aDrawRectPix.TopLeft(), aMap ) );
//STRIP001 
//STRIP001             aOrigin.X() += ( ( aDrawSize.Width() - aObjRect.GetWidth() ) >> 1 ) - aObjRect.Left();
//STRIP001             aOrigin.Y() += ( ( aDrawSize.Height() - aObjRect.GetHeight() ) >> 1 ) - aObjRect.Top();
//STRIP001             aMap.SetOrigin( aOrigin );
//STRIP001     
//STRIP001             aView.SetPageVisible( FALSE );
//STRIP001             aView.SetBordVisible( FALSE );
//STRIP001             aView.SetGridVisible( FALSE );
//STRIP001             aView.SetHlplVisible( FALSE );
//STRIP001             aView.SetGlueVisible( FALSE );
//STRIP001 
//STRIP001             pOut->Push();
//STRIP001             pOut->SetMapMode( aMap );
//STRIP001             aView.ShowPage( const_cast< FmFormPage* >( pPage ), Point() );
//STRIP001             aView.InitRedraw( pOut, Rectangle( pOut->PixelToLogic( Point() ), pOut->GetOutputSize() ) );
//STRIP001             pOut->Pop();
//STRIP001 
//STRIP001             bRet = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObjectSvDraw::WriteData( SvStream& rOut ) const
//STRIP001 {
//STRIP001 	SgaObject::WriteData( rOut );
//STRIP001 	rOut << ByteString( aTitle, RTL_TEXTENCODING_UTF8 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SgaObjectSvDraw::ReadData( SvStream& rIn, UINT16& rReadVersion )
//STRIP001 {
//STRIP001 	SgaObject::ReadData( rIn, rReadVersion );
//STRIP001 
//STRIP001 	if( rReadVersion >= 5 )
//STRIP001 	{
//STRIP001 		ByteString aTmpStr;
//STRIP001 		rIn >> aTmpStr; aTitle = String( aTmpStr.GetBuffer(), RTL_TEXTENCODING_UTF8 );
//STRIP001 	}
//STRIP001 }
}
