/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tbxform.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:50:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

// auto strip #ifndef _REF_HXX
// auto strip #include <tools/ref.hxx>
// auto strip #endif
// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SV_TOOLBOX_HXX //autogen
// auto strip #include <vcl/toolbox.hxx>
// auto strip #endif
// auto strip #ifndef _SV_FIXED_HXX //autogen
// auto strip #include <vcl/fixed.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FMITEMS_HXX //autogen
// auto strip #include "fmitems.hxx"
// auto strip #endif

// auto strip #ifndef _TOOLS_INTN_HXX //autogen
// auto strip #include <tools/intn.hxx>
// auto strip #endif

// auto strip #ifndef _SV_SOUND_HXX //autogen
// auto strip #include <vcl/sound.hxx>
// auto strip #endif

#pragma hdrstop

// auto strip #ifndef _SVX_DIALMGR_HXX
// auto strip #include "dialmgr.hxx"
// auto strip #endif
#ifndef _SVX_DIALOGS_HRC
#include "dialogs.hrc"
#endif

// auto strip #ifndef _TBXCTL_HXX
// auto strip #include "tbxctl.hxx"
// auto strip #endif

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#ifndef _TBXDRAW_HXX
#include "tbxdraw.hxx"
#endif
#ifndef _SVX_TBXFORM_HXX
#include "tbxform.hxx"
#endif
#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif
// auto strip #ifndef _SVX_FMITEMS_HXX
// auto strip #include "fmitems.hxx"
// auto strip #endif
#ifndef _SVX_FMHELP_HRC
#include "fmhelp.hrc"
#endif

#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
// auto strip #ifndef _SFXVIEWSH_HXX
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
namespace binfilter {

//========================================================================
// class FmInputRecordNoDialog
//========================================================================

//STRIP001 FmInputRecordNoDialog::FmInputRecordNoDialog(Window * pParent)
//STRIP001 	:ModalDialog( pParent, SVX_RES(RID_SVX_DLG_INPUTRECORDNO))
//STRIP001 	,m_aLabel(this, ResId(1))
//STRIP001 	,m_aRecordNo(this, ResId(1))
//STRIP001 	,m_aOk(this, ResId(1))
//STRIP001 	,m_aCancel(this, ResId(1))
//STRIP001 {
//STRIP001 	m_aRecordNo.SetMin(1);
//STRIP001 	m_aRecordNo.SetMax(0x7FFFFFFF);
//STRIP001 	m_aRecordNo.SetStrictFormat(TRUE);
//STRIP001 	m_aRecordNo.SetDecimalDigits(0);
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }

//========================================================================
// class SvxFmAbsRecWin
//========================================================================

// -----------------------------------------------------------------------
//STRIP001 SvxFmAbsRecWin::SvxFmAbsRecWin( Window* _pParent, SfxToolBoxControl* _pController )
//STRIP001 	:NumericField( _pParent, WB_BORDER )
//STRIP001 	,m_pController(_pController)
//STRIP001 {
//STRIP001 	SetMin(1);
//STRIP001 	SetFirst(1);
//STRIP001 	SetSpinSize(1);
//STRIP001 	SetSizePixel( Size(70,19) );
//STRIP001 
//STRIP001 	SetDecimalDigits(0);
//STRIP001 	SetStrictFormat(TRUE);
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 SvxFmAbsRecWin::~SvxFmAbsRecWin()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 void SvxFmAbsRecWin::FirePosition( sal_Bool _bForce )
//STRIP001 {
//STRIP001 	if ( _bForce || ( GetText() != GetSavedValue() ) )
//STRIP001 	{
//STRIP001 		INT32 nRecord = GetValue();
//STRIP001 		if (nRecord < GetMin() || nRecord > GetMax())
//STRIP001 		{
//STRIP001 			Sound::Beep();
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxInt32Item aPositionParam( FN_PARAM_1, nRecord );
//STRIP001 
//STRIP001 		m_pController->GetBindings().GetDispatcher()->Execute( SID_FM_RECORD_ABSOLUTE, SFX_CALLMODE_RECORD, &aPositionParam, 0L );
//STRIP001 
//STRIP001 		// to update our content we explicitly call StateChanged : a simple Invalidate(m_nId) is insufficient
//STRIP001 		// as our StateChanged won't be called if entered a invalid position which didn't cause the cursor
//STRIP001 		// to be moved.
//STRIP001 		SfxPoolItem* pState = NULL;
//STRIP001 		SfxItemState eState = m_pController->GetBindings().QueryState(m_pController->GetId(), pState);
//STRIP001 		((SfxControllerItem*)m_pController)->StateChanged(m_pController->GetId(), eState, pState);
//STRIP001 		delete pState;
//STRIP001 
//STRIP001 		SaveValue();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 void SvxFmAbsRecWin::LoseFocus()
//STRIP001 {
//STRIP001 	FirePosition( sal_False );
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 void SvxFmAbsRecWin::KeyInput( const KeyEvent& rKeyEvent )
//STRIP001 {
//STRIP001 	if( rKeyEvent.GetKeyCode() == KEY_RETURN && GetText().Len() )
//STRIP001 		FirePosition( sal_True );
//STRIP001 	else
//STRIP001 		NumericField::KeyInput( rKeyEvent );
//STRIP001 }


//========================================================================
// class SvxFmConfigWin
//========================================================================
//STRIP001 DBG_NAME(SvxFmConfigWin)
//STRIP001 SvxFmConfigWin::SvxFmConfigWin( USHORT nId, ResId aRIdWin, ResId aRIdTbx, SfxBindings& rBindings )
//STRIP001 	:SfxPopupWindow( nId, aRIdWin, rBindings )
//STRIP001 	,aTbx( this, GetBindings(), aRIdTbx )
//STRIP001 {
//STRIP001 	DBG_CTOR(SvxFmConfigWin,NULL);
//STRIP001 	aTbx.Initialize();
//STRIP001 
//STRIP001 	ToolBox& rBox = aTbx.GetToolBox();
//STRIP001 	aSelectLink = rBox.GetSelectHdl();
//STRIP001 	rBox.SetSelectHdl( LINK(this, SvxFmConfigWin, TbxSelectHdl) );
//STRIP001 	Size aSize = aTbx.CalcWindowSizePixel();
//STRIP001 	rBox.SetSizePixel( aSize );
//STRIP001 	SetOutputSizePixel( aSize );
//STRIP001 	FreeResource();
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 SvxFmConfigWin::~SvxFmConfigWin()
//STRIP001 {
//STRIP001 	DBG_DTOR(SvxFmConfigWin,NULL);
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 void SvxFmConfigWin::PopupModeEnd()
//STRIP001 {
//STRIP001 	aTbx.GetToolBox().EndSelection();
//STRIP001 	SfxPopupWindow::PopupModeEnd();
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 void SvxFmConfigWin::Update()
//STRIP001 {
//STRIP001 	ToolBox *pBox = &aTbx.GetToolBox();
//STRIP001 	aTbx.Activate( pBox );
//STRIP001 	aTbx.Deactivate( pBox );
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 IMPL_LINK( SvxFmConfigWin, TbxSelectHdl, ToolBox*, pBox )
//STRIP001 {
//STRIP001 	if ( IsInPopupMode() )
//STRIP001 		EndPopupMode();
//STRIP001 
//STRIP001 	aSelectLink.Call( &aTbx.GetToolBox() );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//========================================================================
// class SvxFmTbxCtlConfig
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlConfig, SfxUInt16Item );

//-----------------------------------------------------------------------
/*N*/ SvxFmTbxCtlConfig::SvxFmTbxCtlConfig( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings)
/*N*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*N*/ 	,nLastSlot( 0 )
/*N*/ {
/*N*/ }

//-----------------------------------------------------------------------
/*N*/ void SvxFmTbxCtlConfig::StateChanged(USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if (nSID == SID_FM_CONFIG)
/*N*/ 	{
/*N*/ 		UINT16 nSlot   = 0;
/*N*/ 		if (eState >= SFX_ITEM_AVAILABLE)
/*N*/ 			nSlot = ((SfxUInt16Item*)pState)->GetValue();
/*N*/ 
/*N*/ 		switch( nSlot )
/*N*/ 		{
/*N*/ 			case SID_FM_PUSHBUTTON:
/*N*/ 			case SID_FM_RADIOBUTTON:
/*N*/ 			case SID_FM_CHECKBOX:
/*N*/ 			case SID_FM_FIXEDTEXT:
/*N*/ 			case SID_FM_GROUPBOX:
/*N*/ 			case SID_FM_LISTBOX:
/*N*/ 			case SID_FM_COMBOBOX:
/*N*/ 			case SID_FM_URLBUTTON:
/*N*/ 			case SID_FM_EDIT:
/*N*/ 			case SID_FM_DBGRID:
/*N*/ 			case SID_FM_IMAGEBUTTON:
/*N*/ 			case SID_FM_IMAGECONTROL:
/*N*/ 			case SID_FM_FILECONTROL:
/*N*/ 			case SID_FM_DATEFIELD:
/*N*/ 			case SID_FM_TIMEFIELD:
/*N*/ 			case SID_FM_NUMERICFIELD:
/*N*/ 			case SID_FM_CURRENCYFIELD:
/*N*/ 			case SID_FM_PATTERNFIELD:
/*N*/ 			case SID_FM_DESIGN_MODE:
/*N*/ 			case SID_FM_FORMATTEDFIELD:
/*N*/ 			{	// set a new image, matching to this slot
/*N*/                 SfxViewFrame* pFrame = GetBindings().GetDispatcher()->GetFrame();
/*N*/ 				GetToolBox().SetItemImage( SID_FM_CONFIG, pFrame->GetImageManager()->GetImage( nSlot, GetToolBox().GetDisplayBackground().GetColor().IsDark() ) );
/*N*/ 				nLastSlot = nSlot;
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	SfxToolBoxControl::StateChanged( nSID, eState,pState );
/*N*/ }

//-----------------------------------------------------------------------
//STRIP001 SfxPopupWindowType SvxFmTbxCtlConfig::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return( nLastSlot == 0 ? SFX_POPUPWINDOW_ONCLICK : SFX_POPUPWINDOW_ONTIMEOUT );
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 SfxPopupWindow* SvxFmTbxCtlConfig::CreatePopupWindow()
//STRIP001 {
//STRIP001 	if ( GetId() == SID_FM_CONFIG )
//STRIP001 	{
//STRIP001 		SvxFmConfigWin* pWin = new SvxFmConfigWin( GetId(), SVX_RES( RID_SVXTBX_FORM ),
//STRIP001 								  SVX_RES( TBX_FORM ), GetBindings() );
//STRIP001 		pWin->StartPopupMode( &GetToolBox(), TRUE );
//STRIP001 		pWin->StartSelection();
//STRIP001 		pWin->Show();
//STRIP001 
//STRIP001 		return pWin;
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 void SvxFmTbxCtlConfig::Select( USHORT nModifier )
//STRIP001 {
//STRIP001 	//////////////////////////////////////////////////////////////////////
//STRIP001 	// Click auf den Button SID_FM_CONFIG in der ObjectBar
//STRIP001 	if (nLastSlot)
//STRIP001 		GetBindings().GetDispatcher()->Execute( nLastSlot );
//STRIP001 }


//========================================================================
// class SvxFmTbxCtlAbsRec
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlAbsRec, SfxInt32Item );
//STRIP001 DBG_NAME(SvxFmTbxCtlAbsRec)
//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlAbsRec::SvxFmTbxCtlAbsRec( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlAbsRec,NULL);
/*?*/ }

//-----------------------------------------------------------------------
//STRIP001 SvxFmTbxCtlAbsRec::~SvxFmTbxCtlAbsRec()
//STRIP001 {
//STRIP001 	DBG_DTOR(SvxFmTbxCtlAbsRec,NULL);
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 void SvxFmTbxCtlAbsRec::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	USHORT 				nId = GetId();
//STRIP001 	ToolBox*			pToolBox = &GetToolBox();
//STRIP001 	SvxFmAbsRecWin*		pWin = (SvxFmAbsRecWin*)( pToolBox->GetItemWindow(nId) );
//STRIP001 
//STRIP001 	DBG_ASSERT( pWin, "Control not found!" );
//STRIP001 
//STRIP001 	if (pState)
//STRIP001 	{
//STRIP001 		const SfxInt32Item* pItem = PTR_CAST( SfxInt32Item, pState );
//STRIP001 		DBG_ASSERT( pItem, "SvxFmTbxCtlAbsRec::StateChanged: invalid item!" );
//STRIP001 		pWin->SetValue( pItem ? pItem->GetValue() : -1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bEnable = SFX_ITEM_DISABLED != eState && pState;
//STRIP001 	if (!bEnable)
//STRIP001 		pWin->SetText(String());
//STRIP001 
//STRIP001 	//////////////////////////////////////////////////////////////////////
//STRIP001 	// Enablen/disablen des Fensters
//STRIP001 	pToolBox->EnableItem(nId, bEnable);
//STRIP001 	SfxToolBoxControl::StateChanged( nSID, eState,pState );
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 Window* SvxFmTbxCtlAbsRec::CreateItemWindow( Window* pParent )
//STRIP001 {
//STRIP001 	SvxFmAbsRecWin* pWin = new SvxFmAbsRecWin( pParent, this );
//STRIP001 	pWin->SetUniqueId( UID_ABSOLUTE_RECORD_WINDOW );
//STRIP001 	return pWin;
//STRIP001 }


//========================================================================
// SvxFmTbxCtlRecText
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlRecText, SfxBoolItem );
//STRIP001 DBG_NAME(SvxFmTbxCtlRecText)
//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlRecText::SvxFmTbxCtlRecText( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlRecText,NULL);
/*?*/ }

//-----------------------------------------------------------------------
//STRIP001 SvxFmTbxCtlRecText::~SvxFmTbxCtlRecText()
//STRIP001 {
//STRIP001 	DBG_DTOR(SvxFmTbxCtlRecText,NULL);
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 Window*	SvxFmTbxCtlRecText::CreateItemWindow( Window* pParent )
//STRIP001 {
//STRIP001 	XubString aText( SVX_RES(RID_STR_REC_TEXT) );
//STRIP001 	FixedText* pFixedText = new FixedText( pParent );
//STRIP001 	Size aSize( pFixedText->GetTextWidth( aText ), pFixedText->GetTextHeight( ) );
//STRIP001 	pFixedText->SetText( aText );
//STRIP001 	aSize.Width() += 6;
//STRIP001 	pFixedText->SetSizePixel( aSize );
//STRIP001 
//STRIP001 	return pFixedText;
//STRIP001 }


//========================================================================
// SvxFmTbxCtlRecFromText
//========================================================================

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlRecFromText, SfxBoolItem );
//STRIP001 DBG_NAME(SvxFmTbxCtlRecFromText)
//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlRecFromText::SvxFmTbxCtlRecFromText( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlRecFromText,NULL);
/*?*/ }

//-----------------------------------------------------------------------
//STRIP001 SvxFmTbxCtlRecFromText::~SvxFmTbxCtlRecFromText()
//STRIP001 {
//STRIP001 	DBG_DTOR(SvxFmTbxCtlRecFromText,NULL);
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 Window*	SvxFmTbxCtlRecFromText::CreateItemWindow( Window* pParent )
//STRIP001 {
//STRIP001 	XubString aText( SVX_RES(RID_STR_REC_FROM_TEXT) );
//STRIP001 	FixedText* pFixedText = new FixedText( pParent, WB_CENTER );
//STRIP001 	Size aSize( pFixedText->GetTextWidth( aText ), pFixedText->GetTextHeight( ) );
//STRIP001 	aSize.Width() += 12;
//STRIP001 	pFixedText->SetText( aText );
//STRIP001 	pFixedText->SetSizePixel( aSize );
//STRIP001 
//STRIP001 	return pFixedText;
//STRIP001 }


//========================================================================
// SvxFmTbxCtlRecTotal
//========================================================================
//STRIP001 DBG_NAME(SvxFmTbxCtlRecTotal)
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlRecTotal, SfxStringItem );

//-----------------------------------------------------------------------
/*?*/ SvxFmTbxCtlRecTotal::SvxFmTbxCtlRecTotal( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ 	,pFixedText( NULL )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	DBG_CTOR(SvxFmTbxCtlRecTotal,NULL);
/*?*/ }

//-----------------------------------------------------------------------
//STRIP001 SvxFmTbxCtlRecTotal::~SvxFmTbxCtlRecTotal()
//STRIP001 {
//STRIP001 	DBG_DTOR(SvxFmTbxCtlRecTotal,NULL);
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 Window*	SvxFmTbxCtlRecTotal::CreateItemWindow( Window* pParent )
//STRIP001 {
//STRIP001 	pFixedText = new FixedText( pParent );
//STRIP001 	String aSample("123456", sizeof("123456"));
//STRIP001 	Size aSize( pFixedText->GetTextWidth( aSample ), pFixedText->GetTextHeight( ) );
//STRIP001 	aSize.Width() += 12;
//STRIP001 	pFixedText->SetSizePixel( aSize );
//STRIP001 	return pFixedText;
//STRIP001 }

//-----------------------------------------------------------------------
//STRIP001 void SvxFmTbxCtlRecTotal::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
//STRIP001 {
//STRIP001 	//////////////////////////////////////////////////////////////////////
//STRIP001 	// Setzen des FixedTextes
//STRIP001 	if (GetId() != SID_FM_RECORD_TOTAL)
//STRIP001 		return;
//STRIP001 
//STRIP001 	XubString aText;
//STRIP001 	if (pState)
//STRIP001 		aText = ((SfxStringItem*)pState)->GetValue();
//STRIP001 	else
//STRIP001 		aText = '?';
//STRIP001 
//STRIP001 	pFixedText->SetText( aText );
//STRIP001 	pFixedText->Update();
//STRIP001 	pFixedText->Flush();
//STRIP001 
//STRIP001 	SfxToolBoxControl::StateChanged( nSID, eState,pState );
//STRIP001 }

/*
//========================================================================
// SvxFmTbxCtlRecTotal
//========================================================================
SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxCtlFilterText, SfxBoolItem );

//-----------------------------------------------------------------------
SvxFmTbxCtlFilterText::SvxFmTbxCtlFilterText( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
	:SfxToolBoxControl( nId, rTbx, rBindings )
	,pFixedText( NULL )
	,aText(SVX_RES(RID_STR_FORM_FILTERED))
{
}

//-----------------------------------------------------------------------
SvxFmTbxCtlFilterText::~SvxFmTbxCtlFilterText()
{
}

//-----------------------------------------------------------------------
Window*	SvxFmTbxCtlFilterText::CreateItemWindow( Window* pParent )
{
	pFixedText = new FixedText( pParent );
	Size aSize = pFixedText->GetTextSize( aText );
	aSize.Width() += 6;
	pFixedText->SetSizePixel( aSize );

	return pFixedText;
}

//-----------------------------------------------------------------------
void SvxFmTbxCtlFilterText::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
{
	//////////////////////////////////////////////////////////////////////
	// Setzen des FixedTextes
	if (GetId() != SID_FM_FORM_FILTERED)
		return;

	if (pState && ((SfxBoolItem*)pState)->GetValue())
		pFixedText->SetText( aText );
	else
		pFixedText->SetText( "" );

	SfxToolBoxControl::StateChanged( nSID, eState,pState );
}	  */

//========================================================================
// SvxFmTbxNextRec
//========================================================================
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxNextRec, SfxBoolItem );

//-----------------------------------------------------------------------
/*?*/ SvxFmTbxNextRec::SvxFmTbxNextRec( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	rTbx.SetItemBits(nId, rTbx.GetItemBits(nId) | TIB_REPEAT);
//STRIP001 
//STRIP001 	AllSettings	aSettings = rTbx.GetSettings();
//STRIP001 	MouseSettings aMouseSettings = aSettings.GetMouseSettings();
//STRIP001 	aMouseSettings.SetButtonRepeat(aMouseSettings.GetButtonRepeat() / 4);
//STRIP001 	aSettings.SetMouseSettings(aMouseSettings);
//STRIP001 	rTbx.SetSettings(aSettings, TRUE);
/*?*/ }

//========================================================================
// SvxFmTbxPrevRec
//========================================================================
/*N*/ SFX_IMPL_TOOLBOX_CONTROL( SvxFmTbxPrevRec, SfxBoolItem );

//-----------------------------------------------------------------------
/*?*/ SvxFmTbxPrevRec::SvxFmTbxPrevRec( USHORT nId, ToolBox& rTbx, SfxBindings& rBindings )
/*?*/ 	:SfxToolBoxControl( nId, rTbx, rBindings )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	rTbx.SetItemBits(nId, rTbx.GetItemBits(nId) | TIB_REPEAT);
//STRIP001 
//STRIP001 	/*AllSettings	aSettings = rTbx.GetSettings();
//STRIP001 	MouseSettings aMouseSettings = aSettings.GetMouseSettings();
//STRIP001 	aMouseSettings.SetButtonRepeat(aMouseSettings.GetButtonRepeat() / 2);
//STRIP001 	aSettings.SetMouseSettings(aMouseSettings);
//STRIP001 	rTbx.SetSettings(aSettings, TRUE);*/
/*?*/ }


}
