/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hldocntp.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:47:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "hldocntp.hxx"

#ifndef _SFXVIEWFRM_HXX
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef _SFX_OBJFAC_HXX
#include <bf_sfx2/docfac.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_
#include <com/sun/star/uno/Sequence.h>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif
//#ifndef _SV_SYSTEM_HXX
//#include <vcl/system.hxx>
//#endif
#ifndef _SV_IMAGE_HXX
#include <vcl/image.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_DYNAMICMENUOPTIONS_HXX
#include <svtools/dynamicmenuoptions.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX 
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _UNOTOOLS_UCBHELPER_HXX
#include <unotools/ucbhelper.hxx>
#endif

#include "hyperdlg.hrc"

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef  _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::ui::dialogs;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 
//STRIP001 using namespace ::rtl;
//STRIP001 using namespace ::com::sun::star;
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Data-struct for documenttypes in listbox
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 struct DocumentTypeData
//STRIP001 {
//STRIP001 	String aStrURL;
//STRIP001 	String aStrExt;
//STRIP001 	DocumentTypeData (String aURL, String aExt) : aStrURL(aURL), aStrExt(aExt)
//STRIP001 	{}
//STRIP001 };
//STRIP001 
//STRIP001 sal_Bool SvxHyperlinkNewDocTp::ImplGetURLObject( const String& rPath, const String& rBase, INetURLObject& aURLObject ) const
//STRIP001 {
//STRIP001     sal_Bool bIsValidURL = rPath.Len() != 0;
//STRIP001     if ( bIsValidURL )
//STRIP001     {
//STRIP001         aURLObject.SetURL( rPath );
//STRIP001         if ( aURLObject.GetProtocol() == INET_PROT_NOT_VALID )      // test if the source is already a valid url
//STRIP001         {                                                           // if not we have to create a url from a physical file name
//STRIP001             String aNewURL;
//STRIP001             if ( !rBase.Len() )
//STRIP001                 utl::LocalFileHelper::ConvertPhysicalNameToURL( rPath, aNewURL );
//STRIP001             else
//STRIP001                 utl::LocalFileHelper::ConvertSystemPathToURL( rPath, rBase, aNewURL );
//STRIP001             if ( aNewURL.Len() )
//STRIP001                 aURLObject = INetURLObject( aNewURL );
//STRIP001             else
//STRIP001             {
//STRIP001                 aURLObject.SetSmartURL( SvtPathOptions().GetWorkPath() );
//STRIP001 			    if( !aURLObject.hasFinalSlash() )
//STRIP001 				    aURLObject.setFinalSlash();
//STRIP001 			    aURLObject.Append( rPath );
//STRIP001             }
//STRIP001         }
//STRIP001         bIsValidURL = aURLObject.GetProtocol() != INET_PROT_NOT_VALID;
//STRIP001         if ( bIsValidURL )
//STRIP001         {
//STRIP001             String aBase( aURLObject.getName( INetURLObject::LAST_SEGMENT, sal_False ) );
//STRIP001             if ( ( aBase.Len() == 0 ) || ( aBase.GetChar( 0 ) == '.' ) )
//STRIP001                 bIsValidURL = sal_False;
//STRIP001         }
//STRIP001         if ( bIsValidURL )
//STRIP001         {
//STRIP001         	sal_Int16 nPos = maLbDocTypes.GetSelectEntryPos();
//STRIP001 	        if ( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001                 aURLObject.SetExtension( ((DocumentTypeData*)maLbDocTypes.GetEntryData( nPos ))->aStrExt );
//STRIP001         }
//STRIP001 
//STRIP001     }
//STRIP001     return bIsValidURL;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Contructor / Destructor
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 SvxHyperlinkNewDocTp::SvxHyperlinkNewDocTp ( Window *pParent, const SfxItemSet& rItemSet)
//STRIP001 :	maGrpNewDoc		( this, ResId (GRP_NEWDOCUMENT) ),
//STRIP001 	maRbtEditNow	( this, ResId (RB_EDITNOW) ),
//STRIP001 	maRbtEditLater	( this, ResId (RB_EDITLATER) ),
//STRIP001 	maFtPath		( this, ResId (FT_PATH_NEWDOC) ),
//STRIP001 	maCbbPath		( this, INET_PROT_FILE ),
//STRIP001 	maFtDocTypes	( this, ResId (FT_DOCUMENT_TYPES) ),
//STRIP001 	maLbDocTypes	( this, ResId (LB_DOCUMENT_TYPES) ),
//STRIP001 	maBtCreate		( this, ResId (BTN_CREATE) ),
//STRIP001 	SvxHyperlinkTabPageBase ( pParent, SVX_RES( RID_SVXPAGE_HYPERLINK_NEWDOCUMENT ),
//STRIP001 	                          rItemSet )
//STRIP001 {
//STRIP001 	// Set HC bitmaps and disable display of bitmap names.
//STRIP001 	maBtCreate.SetModeImage( Image( ResId( IMG_CREATE_HC ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001     maBtCreate.EnableTextDisplay (FALSE);
//STRIP001 
//STRIP001 	InitStdControls();
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	SetExchangeSupport ();
//STRIP001 
//STRIP001 	maCbbPath.SetPosSizePixel ( LogicToPixel( Point( COL_2 , 25 ), MAP_APPFONT ),
//STRIP001 		                        LogicToPixel( Size ( 176 - COL_DIFF, 60), MAP_APPFONT ) );
//STRIP001 	maCbbPath.Show();
//STRIP001 	maCbbPath.SetBaseURL(SvtPathOptions().GetWorkPath());
//STRIP001 //	maCbbPath.SetHelpId( HID_HYPERDLG_DOC_PATH );
//STRIP001 
//STRIP001 	// set defaults
//STRIP001 	maRbtEditNow.Check();
//STRIP001 
//STRIP001 	maBtCreate.SetClickHdl		  ( LINK ( this, SvxHyperlinkNewDocTp, ClickNewHdl_Impl ) );
//STRIP001 
//STRIP001 	FillDocumentList ();
//STRIP001 }
//STRIP001 
//STRIP001 SvxHyperlinkNewDocTp::~SvxHyperlinkNewDocTp ()
//STRIP001 {
//STRIP001 	for ( int n=0; n<maLbDocTypes.GetEntryCount(); n++ )
//STRIP001 	{
//STRIP001 		DocumentTypeData* pTypeData = (DocumentTypeData*)
//STRIP001 			                          maLbDocTypes.GetEntryData ( n );
//STRIP001 		delete pTypeData;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Fill the all dialog-controls except controls in groupbox "more..."
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SvxHyperlinkNewDocTp::FillDlgFields ( String& aStrURL )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 #define INTERNETSHORTCUT_ID_TAG       "InternetShortcut"
//STRIP001 #define INTERNETSHORTCUT_TITLE_TAG    "Title"
//STRIP001 #define INTERNETSHORTCUT_TARGET_TAG   "Target"
//STRIP001 #define INTERNETSHORTCUT_FOLDER_TAG   "Folder"
//STRIP001 #define INTERNETSHORTCUT_URL_TAG      "URL"
//STRIP001 #define INTERNETSHORTCUT_ICONID_TAG	  "IconIndex"
//STRIP001 
//STRIP001 void SvxHyperlinkNewDocTp::ReadURLFile( const String& rFile, String& rTitle, String& rURL, sal_Int32& rIconId, BOOL* pShowAsFolder )
//STRIP001 {
//STRIP001 	// Open file
//STRIP001 	Config aCfg( rFile );
//STRIP001 	aCfg.SetGroup( INTERNETSHORTCUT_ID_TAG );
//STRIP001 
//STRIP001 	// read URL
//STRIP001 	rURL = aCfg.ReadKey( ByteString( RTL_CONSTASCII_STRINGPARAM( INTERNETSHORTCUT_URL_TAG) ), RTL_TEXTENCODING_ASCII_US );
//STRIP001 	SvtPathOptions aPathOpt;
//STRIP001 	rURL = aPathOpt.SubstituteVariable( rURL );
//STRIP001 
//STRIP001 	// read target
//STRIP001 	if ( pShowAsFolder )
//STRIP001 	{
//STRIP001 		String aTemp( aCfg.ReadKey( ByteString( RTL_CONSTASCII_STRINGPARAM( INTERNETSHORTCUT_TARGET_TAG ) ), RTL_TEXTENCODING_ASCII_US ) );
//STRIP001 		*pShowAsFolder = aTemp == String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( INTERNETSHORTCUT_FOLDER_TAG ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// read image-ID
//STRIP001 	String aStrIconId( aCfg.ReadKey( ByteString( RTL_CONSTASCII_STRINGPARAM( INTERNETSHORTCUT_ICONID_TAG ) ), RTL_TEXTENCODING_ASCII_US ) );
//STRIP001 	rIconId = aStrIconId.ToInt32();
//STRIP001 
//STRIP001 	// read title
//STRIP001 	String aLangStr = aPathOpt.SubstituteVariable( DEFINE_CONST_UNICODE("$(vlang)") );
//STRIP001 	ByteString aLang( aLangStr, RTL_TEXTENCODING_UTF8 );
//STRIP001 	ByteString aGroup = INTERNETSHORTCUT_ID_TAG;
//STRIP001 	( ( aGroup += '-' ) += aLang ) += ".W";
//STRIP001 	aCfg.SetGroup( aGroup );
//STRIP001 	rTitle = String( aCfg.ReadKey( INTERNETSHORTCUT_TITLE_TAG ), RTL_TEXTENCODING_UTF7 );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxHyperlinkNewDocTp::FillDocumentList ()
//STRIP001 {
//STRIP001 	EnterWait();
//STRIP001 
//STRIP001     uno::Sequence< uno::Sequence< beans::PropertyValue > >
//STRIP001         aDynamicMenuEntries( SvtDynamicMenuOptions().GetMenu( E_NEWMENU ) );
//STRIP001 
//STRIP001 	sal_uInt32 i, nCount = aDynamicMenuEntries.getLength();
//STRIP001     for ( i = 0; i < nCount; i++ )
//STRIP001     {
//STRIP001         uno::Sequence< beans::PropertyValue >& rDynamicMenuEntry = aDynamicMenuEntries[ i ];
//STRIP001 
//STRIP001         ::rtl::OUString aDocumentUrl, aTitle, aImageId, aTargetName;
//STRIP001 
//STRIP001    	    for ( int i = 0; i < rDynamicMenuEntry.getLength(); i++ )
//STRIP001 	    {
//STRIP001 		    if ( rDynamicMenuEntry[ i ].Name == DYNAMICMENU_PROPERTYNAME_URL )
//STRIP001                 rDynamicMenuEntry[ i ].Value >>= aDocumentUrl;
//STRIP001 		    else if ( rDynamicMenuEntry[i].Name == DYNAMICMENU_PROPERTYNAME_TITLE )
//STRIP001                 rDynamicMenuEntry[i].Value >>= aTitle;
//STRIP001 		    else if ( rDynamicMenuEntry[i].Name == DYNAMICMENU_PROPERTYNAME_IMAGEIDENTIFIER )
//STRIP001 			    rDynamicMenuEntry[i].Value >>= aImageId;
//STRIP001 		    else if ( rDynamicMenuEntry[i].Name == DYNAMICMENU_PROPERTYNAME_TARGETNAME )
//STRIP001 			    rDynamicMenuEntry[i].Value >>= aTargetName;
//STRIP001 	    }
//STRIP001 
//STRIP001 		// Insert into listbox
//STRIP001         if ( aDocumentUrl.getLength() )
//STRIP001         {
//STRIP001 			if ( aDocumentUrl.equalsAscii( "private:factory/simpress?slot=10425" ) )				// SJ: #106216# do not start 
//STRIP001 				aDocumentUrl = String( RTL_CONSTASCII_USTRINGPARAM( "private:factory/simpress" ) );	// the AutoPilot for impress
//STRIP001 
//STRIP001 		    const SfxObjectFactory* pFactory = SfxObjectFactory::GetFactory ( aDocumentUrl );
//STRIP001 		    if ( pFactory )
//STRIP001 		    {
//STRIP001 			    // insert doc-name and image
//STRIP001 
//STRIP001                 String aTitleName( aTitle );
//STRIP001 				aTitleName.Erase( aTitleName.Search( (sal_Unicode)'~' ), 1 );
//STRIP001 
//STRIP001 			    sal_Int16 nPos = maLbDocTypes.InsertEntry ( aTitleName );
//STRIP001 
//STRIP001 			    // insert private-url and default-extension as user-data
//STRIP001 			    String aStrDefExt( pFactory->GetFilter ( 0 )->GetDefaultExtension () );
//STRIP001 			    DocumentTypeData *pTypeData = new DocumentTypeData ( aDocumentUrl,
//STRIP001 											      aStrDefExt.Copy( 2, aStrDefExt.Len() ) );
//STRIP001 			    maLbDocTypes.SetEntryData ( nPos, pTypeData );
//STRIP001 		    }
//STRIP001         }
//STRIP001     }
//STRIP001 	maLbDocTypes.SelectEntryPos ( 0 );
//STRIP001 
//STRIP001 	LeaveWait();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* retrieve and prepare data from dialog-fields
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkNewDocTp::GetCurentItemData ( String& aStrURL, String& aStrName,
//STRIP001 											   String& aStrIntName, String& aStrFrame,
//STRIP001 											   SvxLinkInsertMode& eMode )
//STRIP001 {
//STRIP001 	// get data from dialog-controls
//STRIP001 	aStrURL = maCbbPath.GetText();
//STRIP001     INetURLObject aURL;
//STRIP001     if ( ImplGetURLObject( aStrURL, maCbbPath.GetBaseURL(), aURL ) )
//STRIP001     {
//STRIP001         aStrURL     = aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001     }
//STRIP001 
//STRIP001 	GetDataFromCommonFields( aStrName, aStrIntName, aStrFrame, eMode );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* static method to create Tabpage
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IconChoicePage* SvxHyperlinkNewDocTp::Create( Window* pWindow, const SfxItemSet& rItemSet )
//STRIP001 {
//STRIP001 	return( new SvxHyperlinkNewDocTp( pWindow, rItemSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Set initial focus
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkNewDocTp::SetInitFocus()
//STRIP001 {
//STRIP001 	maCbbPath.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ask page whether an insert is possible
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxHyperlinkNewDocTp::AskApply()
//STRIP001 {
//STRIP001     INetURLObject aINetURLObject;
//STRIP001     sal_Bool bRet = ImplGetURLObject( maCbbPath.GetText(), maCbbPath.GetBaseURL(), aINetURLObject );
//STRIP001     if ( !bRet )
//STRIP001     {
//STRIP001 	    WarningBox aWarning( this, WB_OK, SVX_RESSTR(RID_SVXSTR_HYPDLG_NOVALIDFILENAME) );
//STRIP001 	    aWarning.Execute();
//STRIP001     }
//STRIP001     return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Any action to do after apply-button is pressed
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkNewDocTp::DoApply ()
//STRIP001 {
//STRIP001 	EnterWait();
//STRIP001 
//STRIP001 	// get data from dialog-controls
//STRIP001 	String aStrNewName = maCbbPath.GetText();
//STRIP001 
//STRIP001 	if ( aStrNewName == aEmptyStr )
//STRIP001 		aStrNewName = maStrInitURL;
//STRIP001 
//STRIP001 	///////////////////////////////////////////////////////
//STRIP001 	// create a real URL-String
//STRIP001 
//STRIP001     INetURLObject aURL;
//STRIP001     if ( ImplGetURLObject( aStrNewName, maCbbPath.GetBaseURL(), aURL ) )
//STRIP001     {
//STRIP001 
//STRIP001 	    ///////////////////////////////////////////////////////
//STRIP001 	    // create Document
//STRIP001 
//STRIP001 	    aStrNewName = aURL.GetURLPath( INetURLObject::NO_DECODE );
//STRIP001 	    SfxViewFrame *pViewFrame = NULL;
//STRIP001 	    try
//STRIP001 	    {
//STRIP001 			bool bCreate = true;
//STRIP001 
//STRIP001 			// check if file exists, warn before we overwrite it
//STRIP001 			{
//STRIP001 				::com::sun::star::uno::Reference < ::com::sun::star::task::XInteractionHandler > xHandler;
//STRIP001 				SvStream* pIStm = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ, xHandler );
//STRIP001 
//STRIP001 				sal_Bool bOk = pIStm && ( pIStm->GetError() == 0);
//STRIP001 
//STRIP001 				if( pIStm )
//STRIP001 					delete pIStm;
//STRIP001 
//STRIP001 				if( bOk )
//STRIP001 				{
//STRIP001 					WarningBox aWarning( this, WB_YES_NO, SVX_RESSTR(RID_SVXSTR_HYPERDLG_QUERYOVERWRITE) );
//STRIP001 					bCreate = aWarning.Execute() == BUTTON_YES;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bCreate )
//STRIP001 			{
//STRIP001 				// current document
//STRIP001 				SfxViewFrame* pCurrentDocFrame = SFX_APP()->GetViewFrame();
//STRIP001 
//STRIP001 				if ( aStrNewName != aEmptyStr )
//STRIP001 				{
//STRIP001 					// get private-url
//STRIP001 					int nPos = maLbDocTypes.GetSelectEntryPos();
//STRIP001 					if( nPos == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 						nPos=0;
//STRIP001 					String aStrDocName ( ( ( DocumentTypeData* )
//STRIP001 										 maLbDocTypes.GetEntryData( nPos ) )->aStrURL );
//STRIP001 
//STRIP001 					// create items
//STRIP001 					SfxStringItem aName( SID_FILE_NAME, aStrDocName );
//STRIP001 					SfxStringItem aReferer( SID_REFERER, UniString::CreateFromAscii(
//STRIP001 												RTL_CONSTASCII_STRINGPARAM( "private:user" ) ) );
//STRIP001 					SfxStringItem aFrame( SID_TARGETNAME, UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "_blank" ) ) );
//STRIP001 					//SfxBoolItem aFrame( SID_OPEN_NEW_VIEW, TRUE );
//STRIP001 
//STRIP001 					String aStrFlags ( sal_Unicode('S') );
//STRIP001 					if ( maRbtEditLater.IsChecked() )
//STRIP001 					{
//STRIP001 						aStrFlags += sal_Unicode('H');
//STRIP001 					}
//STRIP001 					SfxStringItem aFlags (SID_OPTIONS, aStrFlags);
//STRIP001 
//STRIP001 					// open url
//STRIP001 					const SfxPoolItem* pReturn = GetDispatcher()->Execute( SID_OPENDOC,
//STRIP001 																		   SFX_CALLMODE_SYNCHRON,
//STRIP001 																		   &aName, &aFlags,
//STRIP001 																		   &aFrame, &aReferer, 0L );
//STRIP001 
//STRIP001 					// save new doc
//STRIP001 					const SfxViewFrameItem *pItem = PTR_CAST( SfxViewFrameItem, pReturn );	// SJ: pReturn is NULL if the Hyperlink
//STRIP001 					if ( pItem )															// creation is cancelled #106216#
//STRIP001 					{
//STRIP001 						pViewFrame = pItem->GetFrame();
//STRIP001 						if (pViewFrame)
//STRIP001 						{
//STRIP001 							//SfxViewFrame *pViewFrame = pFrame->GetCurrentViewFrame();
//STRIP001 							SfxStringItem aNewName( SID_FILE_NAME, aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 							pViewFrame->GetDispatcher()->Execute( SID_SAVEASDOC,
//STRIP001 																  SFX_CALLMODE_SYNCHRON,
//STRIP001 																  &aNewName, 0L );
//STRIP001 
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( maRbtEditNow.IsChecked() )
//STRIP001 				{
//STRIP001 					pCurrentDocFrame->ToTop();
//STRIP001 				}
//STRIP001 			}
//STRIP001 	    }
//STRIP001 	    catch( uno::Exception )
//STRIP001 	    {
//STRIP001 	    }
//STRIP001 
//STRIP001 	    if ( pViewFrame && maRbtEditLater.IsChecked() )
//STRIP001 	    {
//STRIP001 		    SfxObjectShell* pObjShell = pViewFrame->GetObjectShell();
//STRIP001 		    pObjShell->DoClose();
//STRIP001 	    }
//STRIP001     }
//STRIP001 
//STRIP001 	LeaveWait();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Click on imagebutton : new
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkNewDocTp, ClickNewHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001     ::rtl::OUString						aService( RTL_CONSTASCII_USTRINGPARAM( FOLDER_PICKER_SERVICE_NAME ) );
//STRIP001     Reference < XMultiServiceFactory >	xFactory( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 	Reference < XFolderPicker >			xFolderPicker( xFactory->createInstance( aService ), UNO_QUERY );
//STRIP001 
//STRIP001 	String				aStrURL;
//STRIP001 	String				aTempStrURL( maCbbPath.GetText() );
//STRIP001 	utl::LocalFileHelper::ConvertSystemPathToURL( aTempStrURL, maCbbPath.GetBaseURL(), aStrURL );
//STRIP001 
//STRIP001 	String				aStrPath = aStrURL;
//STRIP001 	BOOL				bZeroPath = ( aStrPath.Len() == 0 );
//STRIP001 	BOOL				bHandleFileName = bZeroPath;	// when path has length of 0, then the rest should always be handled
//STRIP001 														//	as file name, otherwise we do not yet know
//STRIP001 
//STRIP001 	if( bZeroPath )
//STRIP001 		aStrPath = SvtPathOptions().GetWorkPath();
//STRIP001 	else if( !::utl::UCBContentHelper::IsFolder( aStrURL ) )
//STRIP001 		bHandleFileName = TRUE;
//STRIP001 
//STRIP001     xFolderPicker->setDisplayDirectory( aStrPath );
//STRIP001 
//STRIP001 	if( xFolderPicker->execute() == ExecutableDialogResults::OK )
//STRIP001 	{
//STRIP001 		sal_Char const	sSlash[] = "/";
//STRIP001 
//STRIP001 		INetURLObject	aURL( aStrURL, INET_PROT_FILE );
//STRIP001 		String			aStrName;
//STRIP001 		if( bHandleFileName )
//STRIP001 			aStrName = bZeroPath? aTempStrURL : aURL.getName();
//STRIP001 
//STRIP001 		maCbbPath.SetBaseURL( xFolderPicker->getDirectory() );
//STRIP001 		String			aStrTmp( xFolderPicker->getDirectory() );
//STRIP001 
//STRIP001 		if( aStrTmp.GetChar( aStrTmp.Len() - 1 ) != sSlash[0] )
//STRIP001 			aStrTmp.AppendAscii( sSlash );
//STRIP001 
//STRIP001 		// append old file name
//STRIP001 		if( bHandleFileName )
//STRIP001 			aStrTmp += aStrName;
//STRIP001 
//STRIP001 		INetURLObject	aNewURL( aStrTmp );
//STRIP001 
//STRIP001 		if( aStrName.Len() > 0 && aNewURL.getExtension().Len() > 0 &&
//STRIP001 			maLbDocTypes.GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			// get private-url
//STRIP001 			int nPos = maLbDocTypes.GetSelectEntryPos();
//STRIP001 			aNewURL.setExtension( ( ( DocumentTypeData* ) maLbDocTypes.GetEntryData( nPos ) )->aStrExt );
//STRIP001 		}
//STRIP001 
//STRIP001         if( aNewURL.GetProtocol() == INET_PROT_FILE )
//STRIP001         {
//STRIP001             utl::LocalFileHelper::ConvertURLToSystemPath( aNewURL.GetMainURL( INetURLObject::NO_DECODE ), aStrTmp );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             aStrTmp = aNewURL.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001         }
//STRIP001 
//STRIP001 		maCbbPath.SetText ( aStrTmp );
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
}
