/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fntctrl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:42:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SFXVIEWSH_HXX
#include <bf_sfx2/viewsh.hxx>		// SfxViewShell
#endif
#ifndef _SFX_PRINTER_HXX
#include <bf_sfx2/printer.hxx>		// SfxPrinter
#endif
#ifndef _SV_METRIC_HXX //autogen
#include <vcl/metric.hxx>
#endif
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

#ifndef _COM_SUN_STAR_I18N_XBREAKITERATOR_HPP_
#include <com/sun/star/i18n/XBreakIterator.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COM_SUN_STAR_I18N_SCRIPTTYPE_HDL_
#include <com/sun/star/i18n/ScriptType.hdl>
#endif

#ifndef _SVSTDARR_HXX
#define _SVSTDARR_USHORTS
#define _SVSTDARR_ULONGS
#define _SVSTDARR_XUB_STRLEN
#include <svtools/svstdarr.hxx>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif

#pragma hdrstop

#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif

#include "fntctrl.hxx"
#include "dialogs.hrc"
#define TEXT_WIDTH	20
namespace binfilter {

//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::i18n;
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // small helper functions to set fonts
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 namespace
//STRIP001 {
//STRIP001 	void scaleFontWidth(Font& _rFont,const OutputDevice& rOutDev,long& _n100PercentFont)
//STRIP001 	{
//STRIP001 		_rFont.SetWidth( 0 );
//STRIP001 		_n100PercentFont = rOutDev.GetFontMetric( _rFont ).GetWidth();
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------
//STRIP001 	void initFont(Font& _rFont)
//STRIP001 	{
//STRIP001 		_rFont.SetTransparent(TRUE);
//STRIP001 		_rFont.SetAlign(ALIGN_BASELINE);
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------
//STRIP001 	void setFontSize(Font& _rFont)
//STRIP001 	{
//STRIP001 		Size aSize( _rFont.GetSize() );
//STRIP001         aSize.Height() = ( aSize.Height() * 3 ) / 5;
//STRIP001         aSize.Width() = ( aSize.Width() * 3 ) / 5;
//STRIP001         _rFont.SetSize( aSize );
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------
//STRIP001 	void calcFontHeightAnyAscent(OutputDevice* _pWin,Font& _rFont,long& _nHeight,long& _nAscent)
//STRIP001 	{
//STRIP001         if ( !_nHeight )
//STRIP001         {
//STRIP001             _pWin->SetFont( _rFont );
//STRIP001             FontMetric aMetric( _pWin->GetFontMetric() );
//STRIP001             _nHeight = aMetric.GetLineHeight();
//STRIP001             _nAscent = aMetric.GetAscent();
//STRIP001         }
//STRIP001 	}
//STRIP001 	// -----------------------------------------------------------------------
//STRIP001 	void setFont( const SvxFont& rNewFont, SvxFont& rImplFont )
//STRIP001 	{
//STRIP001 		rImplFont = rNewFont;
//STRIP001 		rImplFont.SetTransparent( TRUE );
//STRIP001 		rImplFont.SetAlign( ALIGN_BASELINE );
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 // class FontPrevWin_Impl -----------------------------------------------
//STRIP001 
//STRIP001 class FontPrevWin_Impl
//STRIP001 {
//STRIP001 	friend class SvxFontPrevWindow;
//STRIP001 
//STRIP001 	SvxFont         				aFont;
//STRIP001 	Printer*        				pPrinter;
//STRIP001 	BOOL            				bDelPrinter;
//STRIP001 
//STRIP001 	Reference < XBreakIterator >	xBreak;
//STRIP001 	SvULongs						aTextWidth;
//STRIP001 	SvXub_StrLens					aScriptChg;
//STRIP001 	SvUShorts						aScriptType;
//STRIP001 	SvxFont							aCJKFont;
//STRIP001 	SvxFont							aCTLFont;
//STRIP001 	String							aText;
//STRIP001 	String							aScriptText;
//STRIP001 	Color*							pColor;
//STRIP001 	Color*							pBackColor;
//STRIP001 	long							nAscent;
//STRIP001 	sal_Unicode						cStartBracket;
//STRIP001 	sal_Unicode						cEndBracket;
//STRIP001 
//STRIP001 	long							n100PercentFontWidth;		// initial -1 -> not set yet
//STRIP001 	long							n100PercentFontWidthCJK;
//STRIP001 	long							n100PercentFontWidthCTL;
//STRIP001 	UINT16							nFontWidthScale;
//STRIP001 
//STRIP001 	BOOL							bSelection		: 1,
//STRIP001 									bGetSelection   : 1,
//STRIP001 									bUseResText     : 1,
//STRIP001 									bTwoLines       : 1;
//STRIP001 
//STRIP001 	void				_CheckScript();
//STRIP001 public:
//STRIP001 	inline FontPrevWin_Impl() :
//STRIP001 		pPrinter( NULL ), bDelPrinter( FALSE ),
//STRIP001         cStartBracket( 0 ), cEndBracket( 0 ), pColor( NULL ), pBackColor( 0 ), nFontWidthScale( 100 ),
//STRIP001         bSelection( FALSE ), bGetSelection( FALSE ), bUseResText( FALSE ),
//STRIP001         bTwoLines( FALSE )
//STRIP001 		{
//STRIP001 			Invalidate100PercentFontWidth();
//STRIP001 		}
//STRIP001 
//STRIP001 	inline ~FontPrevWin_Impl()
//STRIP001 	{
//STRIP001         delete pColor;
//STRIP001         delete pBackColor;
//STRIP001         if( bDelPrinter )
//STRIP001 			delete pPrinter;
//STRIP001 	}
//STRIP001 
//STRIP001 	void				CheckScript();
//STRIP001     Size				CalcTextSize( OutputDevice* pWin, OutputDevice* pPrt, SvxFont &rFont );
//STRIP001     void				DrawPrev( OutputDevice* pWin, Printer* pPrt, Point &rPt, SvxFont &rFont );
//STRIP001 
//STRIP001 	BOOL				SetFontWidthScale( UINT16 nScaleInPercent );
//STRIP001 	inline void			Invalidate100PercentFontWidth();
//STRIP001 	inline BOOL			Is100PercentFontWidthValid() const;
//STRIP001 	void				ScaleFontWidth( const OutputDevice& rOutDev );
//STRIP001 							// scales rNonCJKFont and aCJKFont depending on nFontWidthScale and
//STRIP001 							//  sets the 100%-Font-Widths
//STRIP001 };
//STRIP001 
//STRIP001 void FontPrevWin_Impl::CheckScript()
//STRIP001 {
//STRIP001 	if( aText != aScriptText )
//STRIP001 		_CheckScript();
//STRIP001 }
//STRIP001 
//STRIP001 inline void FontPrevWin_Impl::Invalidate100PercentFontWidth()
//STRIP001 {
//STRIP001 	n100PercentFontWidth = n100PercentFontWidthCJK = n100PercentFontWidthCTL = -1;
//STRIP001 }
//STRIP001 
//STRIP001 inline BOOL FontPrevWin_Impl::Is100PercentFontWidthValid() const
//STRIP001 {
//STRIP001 	DBG_ASSERT(	( n100PercentFontWidth == -1 && n100PercentFontWidthCJK == -1 ) ||
//STRIP001 				( n100PercentFontWidth != -1 && n100PercentFontWidthCJK != -1 ) ||
//STRIP001 				( n100PercentFontWidth == -1 && n100PercentFontWidthCTL == -1 ) ||
//STRIP001 				( n100PercentFontWidth != -1 && n100PercentFontWidthCTL != -1 ),
//STRIP001 				"*FontPrevWin_Impl::Is100PercentFontWidthValid(): 100PercentFontWidth's not synchronous" );
//STRIP001 	return n100PercentFontWidth != -1;
//STRIP001 }
//STRIP001 
//STRIP001 // class FontPrevWin_Impl -----------------------------------------------
//STRIP001 
//STRIP001 /*-----------------19.7.2001 08:44------------------
//STRIP001  * void FontPrevWin_Impl::_CheckScript()
//STRIP001  * evalutates the scripttypes of the actual string.
//STRIP001  * Afterwards the positions of script change are notified in aScriptChg,
//STRIP001  * the scripttypes in aScriptType.
//STRIP001  * The aTextWidth array will be filled with zero.
//STRIP001  * --------------------------------------------------*/
//STRIP001 
//STRIP001 void FontPrevWin_Impl::_CheckScript()
//STRIP001 {
//STRIP001     aScriptText = aText;
//STRIP001     USHORT nCnt = aScriptChg.Count();
//STRIP001     if( nCnt )
//STRIP001     {
//STRIP001         aScriptChg.Remove( 0, nCnt );
//STRIP001         aScriptType.Remove( 0, nCnt );
//STRIP001         aTextWidth.Remove( 0, nCnt );
//STRIP001         nCnt = 0;
//STRIP001     }
//STRIP001     if( !xBreak.is() )
//STRIP001     {
//STRIP001         Reference< XMultiServiceFactory > xMSF = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001         xBreak = Reference< XBreakIterator >(xMSF->createInstance(
//STRIP001 				::rtl::OUString::createFromAscii( "com.sun.star.i18n.BreakIterator" ) ),UNO_QUERY);
//STRIP001     }
//STRIP001     if( xBreak.is() )
//STRIP001     {
//STRIP001         USHORT nScript = xBreak->getScriptType( aText, 0 );
//STRIP001         USHORT nChg = 0;
//STRIP001         if( ScriptType::WEAK == nScript )
//STRIP001         {
//STRIP001             nChg = (xub_StrLen)xBreak->endOfScript( aText, nChg, nScript );
//STRIP001             if( nChg < aText.Len() )
//STRIP001                 nScript = xBreak->getScriptType( aText, nChg );
//STRIP001             else
//STRIP001                 nScript = ScriptType::LATIN;
//STRIP001         }
//STRIP001 
//STRIP001         do
//STRIP001         {
//STRIP001             nChg = (xub_StrLen)xBreak->endOfScript( aText, nChg, nScript );
//STRIP001             aScriptChg.Insert( nChg, nCnt );
//STRIP001             aScriptType.Insert( nScript, nCnt );
//STRIP001             aTextWidth.Insert( ULONG(0), nCnt++ );
//STRIP001 
//STRIP001             if( nChg < aText.Len() )
//STRIP001                 nScript = xBreak->getScriptType( aText, nChg );
//STRIP001             else
//STRIP001                 break;
//STRIP001         } while( TRUE );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------19.7.2001 08:48------------------
//STRIP001  * Size FontPrevWin_Impl::CalcTextSize(..)
//STRIP001  * fills the aTextWidth array with the text width of every part
//STRIP001  * of the actual string without a script change inside.
//STRIP001  * For Latin parts the given rFont will be used,
//STRIP001  * for Asian parts the aCJKFont.
//STRIP001  * The returned size contains the whole string.
//STRIP001  * The member nAscent is calculated to the maximal ascent of all used fonts.
//STRIP001  * --------------------------------------------------*/
//STRIP001 
//STRIP001 Size FontPrevWin_Impl::CalcTextSize( OutputDevice* pWin, OutputDevice* pPrinter,
//STRIP001     SvxFont &rFont )
//STRIP001 {
//STRIP001     USHORT nScript;
//STRIP001     USHORT nIdx = 0;
//STRIP001     xub_StrLen nStart = 0;
//STRIP001     xub_StrLen nEnd;
//STRIP001     USHORT nCnt = aScriptChg.Count();
//STRIP001     if( nCnt )
//STRIP001     {
//STRIP001         nEnd = aScriptChg[ nIdx ];
//STRIP001         nScript = aScriptType[ nIdx ];
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         nEnd = aText.Len();
//STRIP001         nScript = ScriptType::LATIN;
//STRIP001     }
//STRIP001     long nTxtWidth = 0;
//STRIP001     long nCJKHeight = 0;
//STRIP001 	long nCTLHeight = 0;
//STRIP001     long nHeight = 0;
//STRIP001     nAscent = 0;
//STRIP001     long nCJKAscent = 0;
//STRIP001 	long nCTLAscent = 0;
//STRIP001     do
//STRIP001     {
//STRIP001         SvxFont& rFnt = (nScript==ScriptType::ASIAN) ? aCJKFont : ((nScript==ScriptType::COMPLEX) ? aCTLFont : rFont);
//STRIP001         ULONG nWidth = rFnt.GetTxtSize( pPrinter, aText, nStart, nEnd-nStart ).
//STRIP001                        Width();
//STRIP001         aTextWidth[ nIdx++ ] = nWidth;
//STRIP001         nTxtWidth += nWidth;
//STRIP001 		switch(nScript)
//STRIP001 		{
//STRIP001 			case ScriptType::ASIAN:
//STRIP001 				calcFontHeightAnyAscent(pWin,aCJKFont,nCJKHeight,nCJKAscent);
//STRIP001 				break;
//STRIP001 			case ScriptType::COMPLEX:
//STRIP001 				calcFontHeightAnyAscent(pWin,aCTLFont,nCTLHeight,nCTLAscent);
//STRIP001 				break;
//STRIP001 			default:
//STRIP001 				calcFontHeightAnyAscent(pWin,rFont,nHeight,nAscent);
//STRIP001 		}
//STRIP001 
//STRIP001         if( nEnd < aText.Len() && nIdx < nCnt )
//STRIP001         {
//STRIP001             nStart = nEnd;
//STRIP001             nEnd = aScriptChg[ nIdx ];
//STRIP001             nScript = aScriptType[ nIdx ];
//STRIP001         }
//STRIP001         else
//STRIP001             break;
//STRIP001     }
//STRIP001     while( TRUE );
//STRIP001     nHeight -= nAscent;
//STRIP001     nCJKHeight -= nCJKAscent;
//STRIP001 	nCTLHeight -= nCTLAscent;
//STRIP001     if( nHeight < nCJKHeight )
//STRIP001         nHeight = nCJKHeight;
//STRIP001     if( nAscent < nCJKAscent )
//STRIP001         nAscent = nCJKAscent;
//STRIP001 	if( nHeight < nCTLHeight )
//STRIP001         nHeight = nCTLHeight;
//STRIP001     if( nAscent < nCTLAscent )
//STRIP001         nAscent = nCTLAscent;
//STRIP001     nHeight += nAscent;
//STRIP001 
//STRIP001     Size aTxtSize( nTxtWidth, nHeight );
//STRIP001     return aTxtSize;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------19.7.2001 08:54------------------
//STRIP001  * void FontPrevWin_Impl::DrawPrev(..)
//STRIP001  * calls SvxFont::DrawPrev(..) for every part of the string without a script
//STRIP001  * change inside, for Asian parts the aCJKFont will be used, otherwise the
//STRIP001  * given rFont.
//STRIP001  * --------------------------------------------------*/
//STRIP001 
//STRIP001 void FontPrevWin_Impl::DrawPrev( OutputDevice* pWin, Printer* pPrinter,
//STRIP001     Point &rPt, SvxFont &rFont )
//STRIP001 {
//STRIP001     Font aOldFont = pPrinter->GetFont();
//STRIP001     USHORT nScript;
//STRIP001     USHORT nIdx = 0;
//STRIP001     xub_StrLen nStart = 0;
//STRIP001     xub_StrLen nEnd;
//STRIP001     USHORT nCnt = aScriptChg.Count();
//STRIP001     if( nCnt )
//STRIP001     {
//STRIP001         nEnd = aScriptChg[ nIdx ];
//STRIP001         nScript = aScriptType[ nIdx ];
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         nEnd = aText.Len();
//STRIP001         nScript = ScriptType::LATIN;
//STRIP001     }
//STRIP001     do
//STRIP001     {
//STRIP001         SvxFont& rFnt = (nScript==ScriptType::ASIAN) ? aCJKFont : ((nScript==ScriptType::COMPLEX) ? aCTLFont : rFont);
//STRIP001         pPrinter->SetFont( rFnt );
//STRIP001 
//STRIP001         rFnt.DrawPrev( pWin, pPrinter, rPt, aText, nStart, nEnd - nStart );
//STRIP001 
//STRIP001         rPt.X() += aTextWidth[ nIdx++ ];
//STRIP001         if( nEnd < aText.Len() && nIdx < nCnt )
//STRIP001         {
//STRIP001             nStart = nEnd;
//STRIP001             nEnd = aScriptChg[ nIdx ];
//STRIP001             nScript = aScriptType[ nIdx ];
//STRIP001         }
//STRIP001         else
//STRIP001             break;
//STRIP001     }
//STRIP001     while( TRUE );
//STRIP001 	pPrinter->SetFont( aOldFont );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL FontPrevWin_Impl::SetFontWidthScale( UINT16 nScale )
//STRIP001 {
//STRIP001 	if( nFontWidthScale != nScale )
//STRIP001 	{
//STRIP001 		nFontWidthScale = nScale;
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void FontPrevWin_Impl::ScaleFontWidth( const OutputDevice& rOutDev )
//STRIP001 {
//STRIP001 	if( !Is100PercentFontWidthValid() )
//STRIP001 	{
//STRIP001 		scaleFontWidth(aFont,rOutDev,n100PercentFontWidth);
//STRIP001 		scaleFontWidth(aCJKFont,rOutDev,n100PercentFontWidthCJK);
//STRIP001 		scaleFontWidth(aCTLFont,rOutDev,n100PercentFontWidthCTL);
//STRIP001 	}
//STRIP001 
//STRIP001 	aFont.SetWidth( n100PercentFontWidth * nFontWidthScale / 100 );
//STRIP001 	aCJKFont.SetWidth( n100PercentFontWidthCJK * nFontWidthScale / 100 );
//STRIP001 	aCTLFont.SetWidth( n100PercentFontWidthCTL * nFontWidthScale / 100 );
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxFontPrevWindow -----------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::InitSettings( BOOL bForeground, BOOL bBackground )
//STRIP001 {
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 
//STRIP001 	if ( bForeground )
//STRIP001 	{
//STRIP001 		svtools::ColorConfig aColorConfig;
//STRIP001 		Color aTextColor( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 
//STRIP001 		if ( IsControlForeground() )
//STRIP001 			aTextColor = GetControlForeground();
//STRIP001 		SetTextColor( aTextColor );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bBackground )
//STRIP001 	{
//STRIP001 		if ( IsControlBackground() )
//STRIP001 			SetBackground( GetControlBackground() );
//STRIP001 		else
//STRIP001 			SetBackground( rStyleSettings.GetWindowColor() );
//STRIP001 	}
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxFontPrevWindow::SvxFontPrevWindow( Window* pParent, const ResId& rId ) :
//STRIP001 
//STRIP001 	Window     ( pParent, rId )
//STRIP001 {
//STRIP001 	pImpl = new FontPrevWin_Impl;
//STRIP001 	SfxViewShell* pSh = SfxViewShell::Current();
//STRIP001 
//STRIP001 	if ( pSh )
//STRIP001 		pImpl->pPrinter = pSh->GetPrinter();
//STRIP001 
//STRIP001 	if ( !pImpl->pPrinter )
//STRIP001 	{
//STRIP001 		pImpl->pPrinter = new Printer;
//STRIP001 		pImpl->bDelPrinter = TRUE;
//STRIP001 	}
//STRIP001 	SetMapMode( MapMode( MAP_TWIP ) );
//STRIP001 	initFont(pImpl->aFont);
//STRIP001 	initFont(pImpl->aCJKFont);
//STRIP001 	initFont(pImpl->aCTLFont);
//STRIP001 	InitSettings( TRUE, TRUE );
//STRIP001     SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxFontPrevWindow::~SvxFontPrevWindow()
//STRIP001 {
//STRIP001     delete pImpl;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 SvxFont& SvxFontPrevWindow::GetCTLFont()
//STRIP001 {
//STRIP001     return pImpl->aCTLFont;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxFont& SvxFontPrevWindow::GetCJKFont()
//STRIP001 {
//STRIP001     return pImpl->aCJKFont;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001 	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
//STRIP001 		InitSettings( TRUE, FALSE );
//STRIP001 	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001 		InitSettings( FALSE, TRUE );
//STRIP001 
//STRIP001 	Window::StateChanged( nType );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings( TRUE, TRUE );
//STRIP001 	else
//STRIP001 		Window::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 SvxFont& SvxFontPrevWindow::GetFont()
//STRIP001 {
//STRIP001 	pImpl->Invalidate100PercentFontWidth();		// because the user might change the size
//STRIP001 	return pImpl->aFont;
//STRIP001 }
//STRIP001 
//STRIP001 const SvxFont& SvxFontPrevWindow::GetFont() const
//STRIP001 {
//STRIP001 	return pImpl->aFont;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::SetFont( const SvxFont& rOutFont )
//STRIP001 {
//STRIP001 	setFont( rOutFont, pImpl->aFont );
//STRIP001 
//STRIP001 	pImpl->Invalidate100PercentFontWidth();
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::SetFont( const SvxFont& rNormalOutFont, const SvxFont& rCJKOutFont, const SvxFont& rCTLFont )
//STRIP001 {
//STRIP001 	setFont( rNormalOutFont, pImpl->aFont );
//STRIP001 	setFont( rCJKOutFont, pImpl->aCJKFont );
//STRIP001 	setFont( rCTLFont, pImpl->aCTLFont );
//STRIP001 
//STRIP001 
//STRIP001 	pImpl->Invalidate100PercentFontWidth();
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::SetCJKFont( const SvxFont &rCJKOutFont )
//STRIP001 {
//STRIP001 	setFont( rCJKOutFont, pImpl->aCJKFont );
//STRIP001 
//STRIP001 	pImpl->Invalidate100PercentFontWidth();
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 void SvxFontPrevWindow::SetCTLFont( const SvxFont &rCTLOutFont )
//STRIP001 {
//STRIP001 	setFont( rCTLOutFont, pImpl->aCTLFont );
//STRIP001 
//STRIP001 	pImpl->Invalidate100PercentFontWidth();
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::SetColor(const Color &rColor)
//STRIP001 {
//STRIP001 	delete pImpl->pColor;
//STRIP001 	pImpl->pColor = new Color( rColor );
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::SetBackColor(const Color &rColor)
//STRIP001 {
//STRIP001     delete pImpl->pBackColor;
//STRIP001     pImpl->pBackColor = new Color( rColor );
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::UseResourceText( BOOL bUse )
//STRIP001 {
//STRIP001 	pImpl->bUseResText = bUse;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Printer* pPrinter = pImpl->pPrinter;
//STRIP001 	SvxFont& rFont = pImpl->aFont;
//STRIP001 
//STRIP001     if ( pImpl->bUseResText )
//STRIP001 		pImpl->aText = GetText();
//STRIP001 	else if ( !pImpl->bSelection )
//STRIP001 	{
//STRIP001 		SfxViewShell* pSh = SfxViewShell::Current();
//STRIP001 
//STRIP001 		if ( pSh && !pImpl->bGetSelection )
//STRIP001 		{
//STRIP001 			pImpl->aText = pSh->GetSelectionText();
//STRIP001 			pImpl->bGetSelection = TRUE;
//STRIP001 			pImpl->bSelection = pImpl->aText.Len() != 0;
//STRIP001 
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !pImpl->bSelection )
//STRIP001 			pImpl->aText = rFont.GetName();
//STRIP001 
//STRIP001 		if ( !pImpl->aText.Len() )
//STRIP001 			pImpl->aText = GetText();
//STRIP001 
//STRIP001         // remove line feeds and carriage returns from string
//STRIP001         bool bNotEmpty = false;
//STRIP001         for ( int i = 0; i < pImpl->aText.Len(); ++i )
//STRIP001         {
//STRIP001             if ( 0xa == pImpl->aText.GetChar( i ) ||
//STRIP001                  0xd == pImpl->aText.GetChar( i ) )
//STRIP001                  pImpl->aText.SetChar( i, ' ' );
//STRIP001             else
//STRIP001                 bNotEmpty = true;
//STRIP001         }
//STRIP001         if ( !bNotEmpty )
//STRIP001 			pImpl->aText = GetText();
//STRIP001 
//STRIP001 		if ( pImpl->aText.Len() > (TEXT_WIDTH-1) )
//STRIP001 			pImpl->aText.Erase( pImpl->aText.Search( sal_Unicode( ' ' ), TEXT_WIDTH ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// calculate text width scaling
//STRIP001 	pImpl->ScaleFontWidth( *this/*, rFont*/ );
//STRIP001 
//STRIP001     pImpl->CheckScript();
//STRIP001     Size aTxtSize = pImpl->CalcTextSize( this, pPrinter, rFont );
//STRIP001 
//STRIP001 	const Size aLogSize( GetOutputSize() );
//STRIP001 
//STRIP001 	long nX = aLogSize.Width()  / 2 - aTxtSize.Width() / 2;
//STRIP001 	long nY = aLogSize.Height() / 2 - aTxtSize.Height() / 2;
//STRIP001 
//STRIP001     if ( nY + pImpl->nAscent > aLogSize.Height() )
//STRIP001         nY = aLogSize.Height() - pImpl->nAscent;
//STRIP001 
//STRIP001     if ( pImpl->pBackColor )
//STRIP001 	{
//STRIP001         Rectangle aRect( Point( 0, 0 ), aLogSize );
//STRIP001 		Color aLineCol = GetLineColor();
//STRIP001 		Color aFillCol = GetFillColor();
//STRIP001 		SetLineColor();
//STRIP001         SetFillColor( *pImpl->pBackColor );
//STRIP001 		DrawRect( aRect );
//STRIP001 		SetLineColor( aLineCol );
//STRIP001 		SetFillColor( aFillCol );
//STRIP001 	}
//STRIP001     if ( pImpl->pColor )
//STRIP001 	{
//STRIP001 		Rectangle aRect( Point( nX, nY ), aTxtSize );
//STRIP001 		Color aLineCol = GetLineColor();
//STRIP001 		Color aFillCol = GetFillColor();
//STRIP001 		SetLineColor();
//STRIP001 		SetFillColor( *pImpl->pColor );
//STRIP001 		DrawRect( aRect );
//STRIP001 		SetLineColor( aLineCol );
//STRIP001 		SetFillColor( aFillCol );
//STRIP001 	}
//STRIP001 
//STRIP001     long nStdAscent = pImpl->nAscent;
//STRIP001 	nY += nStdAscent;
//STRIP001 
//STRIP001 	if(pImpl->bTwoLines)
//STRIP001 	{
//STRIP001 		SvxFont aSmallFont( rFont );
//STRIP001 		Size aOldSize = pImpl->aCJKFont.GetSize();
//STRIP001 		setFontSize(aSmallFont);
//STRIP001 		setFontSize(pImpl->aCJKFont);
//STRIP001 
//STRIP001 		long nStartBracketWidth = 0;
//STRIP001 		long nEndBracketWidth = 0;
//STRIP001 		long nTextWidth = 0;
//STRIP001 		if(pImpl->cStartBracket)
//STRIP001 		{
//STRIP001 			String sBracket(pImpl->cStartBracket);
//STRIP001 			nStartBracketWidth = rFont.GetTxtSize( pPrinter, sBracket ).Width();
//STRIP001 		}
//STRIP001 		if(pImpl->cEndBracket)
//STRIP001 		{
//STRIP001 			String sBracket(pImpl->cEndBracket);
//STRIP001 			nEndBracketWidth = rFont.GetTxtSize( pPrinter, sBracket ).Width();
//STRIP001 		}
//STRIP001         nTextWidth = pImpl->CalcTextSize( this, pPrinter, aSmallFont ).Width();
//STRIP001 		long nResultWidth = nStartBracketWidth;
//STRIP001 		nResultWidth += nEndBracketWidth;
//STRIP001 		nResultWidth += nTextWidth;
//STRIP001 
//STRIP001 		long nX = (aLogSize.Width() - nResultWidth) / 2;
//STRIP001 		DrawLine( Point( 0,  nY ), Point( nX, nY ) );
//STRIP001 		DrawLine( Point( nX + nResultWidth, nY ), Point( aLogSize.Width(), nY ) );
//STRIP001 
//STRIP001         long nSmallAscent = pImpl->nAscent;
//STRIP001 		long nOffset = (nStdAscent - nSmallAscent ) / 2;
//STRIP001 
//STRIP001 		if(pImpl->cStartBracket)
//STRIP001 		{
//STRIP001 			String sBracket(pImpl->cStartBracket);
//STRIP001 			rFont.DrawPrev( this, pPrinter, Point( nX, nY - nOffset - 4), sBracket );
//STRIP001 			nX += nStartBracketWidth;
//STRIP001 		}
//STRIP001 
//STRIP001         Point aTmpPoint1( nX, nY - nSmallAscent - 2 );
//STRIP001         Point aTmpPoint2( nX, nY );
//STRIP001         pImpl->DrawPrev( this, pPrinter, aTmpPoint1, aSmallFont );
//STRIP001         pImpl->DrawPrev( this, pPrinter, aTmpPoint2, aSmallFont );
//STRIP001 
//STRIP001 		nX += nTextWidth;
//STRIP001 		if(pImpl->cEndBracket)
//STRIP001 		{
//STRIP001             Point aTmpPoint( nX + 1, nY - nOffset - 4);
//STRIP001 			String sBracket(pImpl->cEndBracket);
//STRIP001 			rFont.DrawPrev( this, pPrinter, aTmpPoint, sBracket );
//STRIP001 		}
//STRIP001         pImpl->aCJKFont.SetSize( aOldSize );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Color aLineCol = GetLineColor();
//STRIP001 
//STRIP001 		SetLineColor( rFont.GetColor() );
//STRIP001 		DrawLine( Point( 0,  nY ), Point( nX, nY ) );
//STRIP001 		DrawLine( Point( nX + aTxtSize.Width(), nY ), Point( aLogSize.Width(), nY ) );
//STRIP001 
//STRIP001 		SetLineColor( aLineCol );
//STRIP001 
//STRIP001         Point aTmpPoint( nX, nY );
//STRIP001         pImpl->DrawPrev( this, pPrinter, aTmpPoint, rFont );
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------04.12.00 16:26--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 BOOL SvxFontPrevWindow::IsTwoLines() const
//STRIP001 {
//STRIP001 	return pImpl->bTwoLines;
//STRIP001 }
//STRIP001 /* -----------------------------04.12.00 16:26--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFontPrevWindow::SetTwoLines(BOOL bSet)
//STRIP001 {
//STRIP001 	pImpl->bTwoLines = bSet;}
//STRIP001 
//STRIP001 /* -----------------------------04.12.00 16:26--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxFontPrevWindow::SetBrackets(sal_Unicode cStart, sal_Unicode cEnd)
//STRIP001 {
//STRIP001 	pImpl->cStartBracket = cStart;
//STRIP001 	pImpl->cEndBracket = cEnd;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::SetFontWidthScale( UINT16 n )
//STRIP001 {
//STRIP001 	if( pImpl->SetFontWidthScale( n ) )
//STRIP001 		Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxFontPrevWindow::AutoCorrectFontColor( void )
//STRIP001 {
//STRIP001 	Color	aFontColor( GetTextColor() );
//STRIP001 
//STRIP001 	if( COL_AUTO == pImpl->aFont.GetColor().GetColor() )
//STRIP001 		pImpl->aFont.SetColor( aFontColor );
//STRIP001 
//STRIP001 	if( COL_AUTO == pImpl->aCJKFont.GetColor().GetColor() )
//STRIP001 		pImpl->aCJKFont.SetColor( aFontColor );
//STRIP001 
//STRIP001 	if( COL_AUTO == pImpl->aCTLFont.GetColor().GetColor() )
//STRIP001 		pImpl->aCTLFont.SetColor( aFontColor );
//STRIP001 }
}
