/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_connect.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:38:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#pragma hdrstop


#define _SVX_CONNECT_CXX

#include "svdoedge.hxx"
#include "svdattr.hxx"
#include "svdattrx.hxx"
#include "svdview.hxx"

#include "connctrl.hxx"
#include "connect.hxx"
#include "connect.hrc"
#include "dialmgr.hxx"
#include "dlgutil.hxx"

#include "dialogs.hrc"
namespace binfilter {

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SDRATTR_EDGE_FIRST,
//STRIP001 	SDRATTR_EDGE_LAST,
//STRIP001 	0
//STRIP001 };

/*************************************************************************
|*
|* Dialog zum Aendern von Konnektoren (Connectors)
|*
\************************************************************************/

//STRIP001 SvxConnectionDialog::SvxConnectionDialog( Window* pParent, const SfxItemSet& rInAttrs,
//STRIP001 								const SdrView* pSdrView ) :
//STRIP001 		SfxSingleTabDialog( pParent, rInAttrs, RID_SVXPAGE_CONNECTION )
//STRIP001 {
//STRIP001 	SvxConnectionPage* pPage = new SvxConnectionPage( this, rInAttrs );
//STRIP001 
//STRIP001 	pPage->SetView( pSdrView );
//STRIP001 	pPage->Construct();
//STRIP001 
//STRIP001 	SetTabPage( pPage );
//STRIP001 	SetText( pPage->GetText() );
//STRIP001 }

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

//STRIP001 SvxConnectionDialog::~SvxConnectionDialog()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* Seite zum Aendern von Konnektoren (Connectors)
|*
\************************************************************************/

//STRIP001 SvxConnectionPage::SvxConnectionPage( Window* pWindow, const SfxItemSet& rInAttrs ) :
//STRIP001 				SfxTabPage		( pWindow, ResId( RID_SVXPAGE_CONNECTION, DIALOG_MGR() ),
//STRIP001 								  rInAttrs ),
//STRIP001 
//STRIP001 		rOutAttrs				( rInAttrs ),
//STRIP001 		aAttrSet				( *rInAttrs.GetPool() ),
//STRIP001 
//STRIP001 		aFtType      			( this, ResId( FT_TYPE ) ),
//STRIP001 		aLbType					( this, ResId( LB_TYPE ) ),
//STRIP001 
//STRIP001 		aFlDistance  			( this, ResId( FL_DISTANCE ) ),
//STRIP001 		aFtHorz1    			( this, ResId( FT_HORZ_1 ) ),
//STRIP001 		aMtrFldHorz1    		( this, ResId( MTR_FLD_HORZ_1 ) ),
//STRIP001 		aFtHorz2    			( this, ResId( FT_HORZ_2 ) ),
//STRIP001 		aMtrFldHorz2    		( this, ResId( MTR_FLD_HORZ_2 ) ),
//STRIP001 		aFtVert1    			( this, ResId( FT_VERT_1 ) ),
//STRIP001 		aMtrFldVert1    		( this, ResId( MTR_FLD_VERT_1 ) ),
//STRIP001 		aFtVert2    			( this, ResId( FT_VERT_2 ) ),
//STRIP001 		aMtrFldVert2    		( this, ResId( MTR_FLD_VERT_2 ) ),
//STRIP001 
//STRIP001 		aFlDelta     			( this, ResId( FL_DELTA ) ),
//STRIP001 		aFtLine1				( this, ResId( FT_LINE_1 ) ),
//STRIP001 		aMtrFldLine1			( this, ResId( MTR_FLD_LINE_1 ) ),
//STRIP001 		aFtLine2				( this, ResId( FT_LINE_2 ) ),
//STRIP001 		aMtrFldLine2			( this, ResId( MTR_FLD_LINE_2 ) ),
//STRIP001 		aFtLine3				( this, ResId( FT_LINE_3 ) ),
//STRIP001 		aMtrFldLine3			( this, ResId( MTR_FLD_LINE_3 ) ),
//STRIP001 
//STRIP001 		aCtlPreview				( this, ResId( CTL_PREVIEW ), rInAttrs )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	eUnit = pPool->GetMetric( SDRATTR_EDGENODE1HORZDIST );
//STRIP001 
//STRIP001 	FillTypeLB();
//STRIP001 
//STRIP001 	const FieldUnit eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 	SetFieldUnit( aMtrFldHorz1, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldHorz2, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldVert1, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldVert2, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldLine1, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldLine2, eFUnit );
//STRIP001 	SetFieldUnit( aMtrFldLine3, eFUnit );
//STRIP001 	if( eFUnit == FUNIT_MM )
//STRIP001 	{
//STRIP001 		aMtrFldHorz1.SetSpinSize( 50 );
//STRIP001 		aMtrFldHorz2.SetSpinSize( 50 );
//STRIP001 		aMtrFldVert1.SetSpinSize( 50 );
//STRIP001 		aMtrFldVert2.SetSpinSize( 50 );
//STRIP001 		aMtrFldLine1.SetSpinSize( 50 );
//STRIP001 		aMtrFldLine2.SetSpinSize( 50 );
//STRIP001 		aMtrFldLine3.SetSpinSize( 50 );
//STRIP001 	}
//STRIP001 
//STRIP001 	// disable 3D border
//STRIP001 	aCtlPreview.SetBorderStyle(WINDOW_BORDER_MONO);
//STRIP001 
//STRIP001 	Link aLink( LINK( this, SvxConnectionPage, ChangeAttrHdl_Impl ) );
//STRIP001 	aMtrFldHorz1.SetModifyHdl( aLink );
//STRIP001 	aMtrFldVert1.SetModifyHdl( aLink );
//STRIP001 	aMtrFldHorz2.SetModifyHdl( aLink );
//STRIP001 	aMtrFldVert2.SetModifyHdl( aLink );
//STRIP001 	aMtrFldLine1.SetModifyHdl( aLink );
//STRIP001 	aMtrFldLine2.SetModifyHdl( aLink );
//STRIP001 	aMtrFldLine3.SetModifyHdl( aLink );
//STRIP001 	aLbType.SetSelectHdl( aLink );
//STRIP001 }

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

//STRIP001 SvxConnectionPage::~SvxConnectionPage()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* Liest uebergebenen Item-Set
|*
\************************************************************************/

//STRIP001 void __EXPORT SvxConnectionPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pItem = GetItem( rAttrs, SDRATTR_EDGENODE1HORZDIST );
//STRIP001 	const SfxItemPool* pPool = rAttrs.GetPool();
//STRIP001 
//STRIP001 	// SdrEdgeNode1HorzDistItem
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGENODE1HORZDIST );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrEdgeNode1HorzDistItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldHorz1, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldHorz1.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	aMtrFldHorz1.SaveValue();
//STRIP001 
//STRIP001 	// SdrEdgeNode2HorzDistItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGENODE2HORZDIST );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGENODE2HORZDIST );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrEdgeNode2HorzDistItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldHorz2, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldHorz2.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	aMtrFldHorz2.SaveValue();
//STRIP001 
//STRIP001 	// SdrEdgeNode1VertDistItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGENODE1VERTDIST );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGENODE1VERTDIST );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrEdgeNode1VertDistItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldVert1, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldVert1.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	aMtrFldVert1.SaveValue();
//STRIP001 
//STRIP001 	// SdrEdgeNode2VertDistItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGENODE2VERTDIST );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGENODE2VERTDIST );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrEdgeNode2VertDistItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldVert2, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldVert2.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	aMtrFldVert2.SaveValue();
//STRIP001 
//STRIP001 	// SdrEdgeLine1DeltaItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGELINE1DELTA );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGELINE1DELTA );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrEdgeLine1DeltaItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldLine1, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldLine1.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	aMtrFldLine1.SaveValue();
//STRIP001 
//STRIP001 	// SdrEdgeLine2DeltaItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGELINE2DELTA );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGELINE2DELTA );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrEdgeLine2DeltaItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldLine2, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldLine2.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	aMtrFldLine2.SaveValue();
//STRIP001 
//STRIP001 	// SdrEdgeLine3DeltaItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGELINE3DELTA );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGELINE3DELTA );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		long nValue = ( ( const SdrEdgeLine3DeltaItem* )pItem )->GetValue();
//STRIP001 		SetMetricValue( aMtrFldLine3, nValue, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrFldLine3.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	aMtrFldLine3.SaveValue();
//STRIP001 
//STRIP001 	// SdrEdgeLineDeltaAnzItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGELINEDELTAANZ );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGELINEDELTAANZ );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		UINT16 nValue = ( ( const SdrEdgeLineDeltaAnzItem* )pItem )->GetValue();
//STRIP001 		if( nValue <= 2 )
//STRIP001 		{
//STRIP001 			aFtLine3.Enable( FALSE );
//STRIP001 			aMtrFldLine3.Enable( FALSE );
//STRIP001 			aMtrFldLine3.SetEmptyFieldValue();
//STRIP001 		}
//STRIP001 		if( nValue <= 1 )
//STRIP001 		{
//STRIP001 			aFtLine2.Enable( FALSE );
//STRIP001 			aMtrFldLine2.Enable( FALSE );
//STRIP001 			aMtrFldLine2.SetEmptyFieldValue();
//STRIP001 		}
//STRIP001 		if( nValue == 0 )
//STRIP001 		{
//STRIP001 			aFtLine1.Enable( FALSE );
//STRIP001 			aMtrFldLine1.Enable( FALSE );
//STRIP001 			aMtrFldLine1.SetEmptyFieldValue();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// SdrEdgeKindItem
//STRIP001 	pItem = GetItem( rAttrs, SDRATTR_EDGEKIND );
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGEKIND );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		USHORT nValue = ( ( const SdrEdgeKindItem* )pItem )->GetValue();
//STRIP001 		aLbType.SelectEntryPos( nValue );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aLbType.SetNoSelection();
//STRIP001 	aLbType.SaveValue();
//STRIP001 }

/*************************************************************************
|*
|* Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\************************************************************************/

//STRIP001 BOOL SvxConnectionPage::FillItemSet( SfxItemSet& rAttrs)
//STRIP001 {
//STRIP001 	BOOL	 bModified = FALSE;
//STRIP001 	INT32	 nValue;
//STRIP001 
//STRIP001 	if( aMtrFldHorz1.GetText() != aMtrFldHorz1.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldHorz1, eUnit );
//STRIP001 		rAttrs.Put( SdrEdgeNode1HorzDistItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldHorz2.GetText() != aMtrFldHorz2.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldHorz2, eUnit );
//STRIP001 		rAttrs.Put( SdrEdgeNode2HorzDistItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldVert1.GetText() != aMtrFldVert1.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldVert1, eUnit );
//STRIP001 		rAttrs.Put( SdrEdgeNode1VertDistItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldVert2.GetText() != aMtrFldVert2.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldVert2, eUnit );
//STRIP001 		rAttrs.Put( SdrEdgeNode2VertDistItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldLine1.GetText() != aMtrFldLine1.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldLine1, eUnit );
//STRIP001 		rAttrs.Put( SdrEdgeLine1DeltaItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldLine2.GetText() != aMtrFldLine2.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldLine2, eUnit );
//STRIP001 		rAttrs.Put( SdrEdgeLine2DeltaItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aMtrFldLine3.GetText() != aMtrFldLine3.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = GetCoreValue( aMtrFldLine3, eUnit );
//STRIP001 		rAttrs.Put( SdrEdgeLine3DeltaItem( nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	USHORT nPos = aLbType.GetSelectEntryPos();
//STRIP001 	if( nPos != aLbType.GetSavedValue() )
//STRIP001 	{
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			rAttrs.Put( SdrEdgeKindItem( (SdrEdgeKind) nPos ) );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bModified );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxConnectionPage::Construct()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 
//STRIP001 	aCtlPreview.SetView( pView );
//STRIP001 	aCtlPreview.Construct();
//STRIP001 }

/*************************************************************************
|*
|* Erzeugt die Seite
|*
\************************************************************************/

//STRIP001 SfxTabPage* SvxConnectionPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	return( new SvxConnectionPage( pWindow, rAttrs ) );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 USHORT*	SvxConnectionPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pRanges );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxConnectionPage, ChangeAttrHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( p == &aMtrFldHorz1 )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldHorz1, eUnit );
//STRIP001 		aAttrSet.Put( SdrEdgeNode1HorzDistItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldHorz2 )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldHorz2, eUnit );
//STRIP001 		aAttrSet.Put( SdrEdgeNode2HorzDistItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldVert1 )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldVert1, eUnit );
//STRIP001 		aAttrSet.Put( SdrEdgeNode1VertDistItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldVert2 )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldVert2, eUnit );
//STRIP001 		aAttrSet.Put( SdrEdgeNode2VertDistItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldLine1 )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldLine1, eUnit );
//STRIP001 		aAttrSet.Put( SdrEdgeLine1DeltaItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldLine2 )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldLine2, eUnit );
//STRIP001 		aAttrSet.Put( SdrEdgeLine2DeltaItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( p == &aMtrFldLine3 )
//STRIP001 	{
//STRIP001 		INT32 nValue = GetCoreValue( aMtrFldLine3, eUnit );
//STRIP001 		aAttrSet.Put( SdrEdgeLine3DeltaItem( nValue ) );
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if( p == &aLbType )
//STRIP001 	{
//STRIP001 		USHORT nPos = aLbType.GetSelectEntryPos();
//STRIP001 		if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 			aAttrSet.Put( SdrEdgeKindItem( (SdrEdgeKind) nPos ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	aCtlPreview.SetAttributes( aAttrSet );
//STRIP001 
//STRIP001 	if( p == &aLbType )
//STRIP001 	{
//STRIP001 		// Anzahl der Linienversaetze ermitteln
//STRIP001 		USHORT nCount = aCtlPreview.GetLineDeltaAnz();
//STRIP001 
//STRIP001 		aFtLine3.Enable( nCount > 2 );
//STRIP001 		aMtrFldLine3.Enable( nCount > 2 );
//STRIP001 		if( nCount > 2 )
//STRIP001 			aMtrFldLine3.SetValue( aMtrFldLine3.GetValue() );
//STRIP001 		else
//STRIP001 			aMtrFldLine3.SetEmptyFieldValue();
//STRIP001 
//STRIP001 		aFtLine2.Enable( nCount > 1 );
//STRIP001 		aMtrFldLine2.Enable( nCount > 1 );
//STRIP001 		if( nCount > 1 )
//STRIP001 			aMtrFldLine2.SetValue( aMtrFldLine2.GetValue() );
//STRIP001 		else
//STRIP001 			aMtrFldLine2.SetEmptyFieldValue();
//STRIP001 
//STRIP001 		aFtLine1.Enable( nCount > 0 );
//STRIP001 		aMtrFldLine1.Enable( nCount > 0 );
//STRIP001 		if( nCount > 0 )
//STRIP001 			aMtrFldLine1.SetValue( aMtrFldLine1.GetValue() );
//STRIP001 		else
//STRIP001 			aMtrFldLine1.SetEmptyFieldValue();
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void SvxConnectionPage::FillTypeLB()
//STRIP001 {
//STRIP001 	// ListBox mit Verbindernamen fuellen
//STRIP001 	const SfxPoolItem* pItem = GetItem( rOutAttrs, SDRATTR_EDGEKIND );
//STRIP001 	const SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 
//STRIP001 	if( !pItem )
//STRIP001 		pItem = &pPool->GetDefaultItem( SDRATTR_EDGEKIND );
//STRIP001 	if( pItem )
//STRIP001 	{
//STRIP001 		const SdrEdgeKindItem* pEdgeKindItem = (const SdrEdgeKindItem*) pItem;
//STRIP001 		USHORT nCount = pEdgeKindItem->GetValueCount();
//STRIP001 		String aStr;
//STRIP001 
//STRIP001 		for( USHORT i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			aStr = pEdgeKindItem->GetValueTextByPos( i );
//STRIP001 			aLbType.InsertEntry( aStr );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


}
