/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_exptypes.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:18:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

// auto strip #ifndef _WINDOW_HXX //autogen
// auto strip #include <vcl/window.hxx>
// auto strip #endif
// auto strip #ifndef _FIXED_HXX //autogen
// auto strip #include <vcl/fixed.hxx>
// auto strip #endif
// auto strip #ifndef _BIGINT_HXX //autogen
// auto strip #include <tools/bigint.hxx>
// auto strip #endif
#if SUPD<613//MUSTINI
// auto strip #ifndef _SFXINIMGR_HXX //autogen
// auto strip #include <svtools/iniman.hxx>
// auto strip #endif
#endif
// auto strip #ifndef INCLUDED_RTL_MATH_HXX
// auto strip #include <rtl/math.hxx>
// auto strip #endif
// auto strip #ifndef _DATETIME_HXX
// auto strip #include <tools/datetime.hxx>
// auto strip #endif
// auto strip #ifndef INCLUDED_SVTOOLS_SYSLOCALE_HXX
// auto strip #include <svtools/syslocale.hxx>
// auto strip #endif

#pragma hdrstop

// auto strip #ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif

#include "sfx.hrc"
// auto strip #include "exptypes.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "app.hxx"
namespace binfilter {

// Hilfsfunktionen -------------------------------------------------------

//STRIP001 String CreateSizeText( ULONG nSize, BOOL bExtraBytes, BOOL bSmartExtraBytes )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	siehe exptypes.hxx
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	String aUnitStr = ' ';
//STRIP001 	aUnitStr += String( SfxResId(STR_BYTES) );
//STRIP001 	ULONG nSize1 = nSize;
//STRIP001 	ULONG nSize2 = nSize1;
//STRIP001 	ULONG nMega = 1024 * 1024;
//STRIP001 	ULONG nGiga = nMega * 1024;
//STRIP001 	double fSize = nSize;
//STRIP001 	int nDec = 0;
//STRIP001 	BOOL bGB = FALSE;
//STRIP001 
//STRIP001 	if ( nSize1 >= 10000 && nSize1 < nMega )
//STRIP001 	{
//STRIP001 		nSize1 /= 1024;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_KB) );
//STRIP001 		fSize /= 1024;
//STRIP001 		nDec = 0;
//STRIP001 	}
//STRIP001 	else if ( nSize1 >= nMega && nSize1 < nGiga )
//STRIP001 	{
//STRIP001 		nSize1 /= nMega;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_MB) );
//STRIP001 		fSize /= nMega;
//STRIP001 		nDec = 2;
//STRIP001 	}
//STRIP001 	else if ( nSize1 >= nGiga )
//STRIP001 	{
//STRIP001 		nSize1 /= nGiga;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_GB) );
//STRIP001 		bGB = TRUE;
//STRIP001 		fSize /= nGiga;
//STRIP001 		nDec = 3;
//STRIP001 	}
//STRIP001 	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
//STRIP001 	String aSizeStr( rLocaleWrapper.getNum( nSize1, 0 ) );
//STRIP001 	aSizeStr += aUnitStr;
//STRIP001 	if ( bExtraBytes && ( nSize1 < nSize2 ) )
//STRIP001 	{
//STRIP001         aSizeStr = ::rtl::math::doubleToUString( fSize,
//STRIP001                 rtl_math_StringFormat_F, nDec,
//STRIP001                 rLocaleWrapper.getNumDecimalSep().GetChar(0) );
//STRIP001 		aSizeStr += aUnitStr;
//STRIP001 
//STRIP001 		aSizeStr += DEFINE_CONST_UNICODE(" (");
//STRIP001 		aSizeStr += rLocaleWrapper.getNum( nSize2, 0 );
//STRIP001 		aSizeStr += ' ';
//STRIP001 		aSizeStr += String( SfxResId(STR_BYTES) );
//STRIP001 		aSizeStr += ')';
//STRIP001 	}
//STRIP001 	else if ( bGB && bSmartExtraBytes )
//STRIP001 	{
//STRIP001 		nSize1 = nSize / nMega;
//STRIP001 		aSizeStr = DEFINE_CONST_UNICODE(" (");
//STRIP001 		aSizeStr += rLocaleWrapper.getNum( nSize1, 0 );
//STRIP001 		aSizeStr += aUnitStr;
//STRIP001 		aSizeStr += ')';
//STRIP001 	}
//STRIP001 	return aSizeStr;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String ExtendedCreateSizeText( const BigInt& nSize, BOOL bExtraBytes, BOOL bSmartExtraBytes )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	siehe exptypes.hxx
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	String aUnitStr( ' ' );
//STRIP001 	BigInt nSize1 = nSize;
//STRIP001 	BigInt nSize2 = nSize1;
//STRIP001 	String aSecondUnitStr( ' ' );
//STRIP001 	BOOL bGB = FALSE;
//STRIP001 	ULONG nMega = 1024 * 1024;
//STRIP001 	ULONG nGiga = nMega * 1024;
//STRIP001 
//STRIP001 	static const BigInt nTenKB( 10000 );
//STRIP001 	static const BigInt nOneMB( nMega );
//STRIP001 	static const BigInt nOneGB( nGiga );
//STRIP001 
//STRIP001 	if ( nSize1 >= nTenKB && nSize1 < nOneMB )
//STRIP001 	{
//STRIP001 		nSize1 /= 1024;
//STRIP001 		aUnitStr += String( SfxResId( STR_KB ) );
//STRIP001 	}
//STRIP001 	else if ( nSize1 >= nOneMB && nSize1 < nOneGB )
//STRIP001 	{
//STRIP001 		nSize1 /= nMega;
//STRIP001 		aUnitStr += String( SfxResId( STR_MB ) );
//STRIP001 		nSize2 /= 1024;
//STRIP001 		aSecondUnitStr += String( SfxResId( STR_KB ) );
//STRIP001 	}
//STRIP001 	else if ( nSize1 >= nOneGB )
//STRIP001 	{
//STRIP001 		nSize1 /= nGiga;
//STRIP001 		aUnitStr += String( SfxResId( STR_GB ) );
//STRIP001 		nSize2 /= nMega;
//STRIP001 		aSecondUnitStr += String( SfxResId( STR_KB ) );
//STRIP001 		bGB = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( 1 == aUnitStr.Len() )
//STRIP001 		aUnitStr += String( SfxResId( STR_BYTES ) );
//STRIP001 	if ( 1 == aSecondUnitStr.Len() )
//STRIP001 		aSecondUnitStr += String( SfxResId( STR_BYTES ) );
//STRIP001 	aSecondUnitStr += ')';
//STRIP001 	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
//STRIP001 	String aSizeStr( rLocaleWrapper.getNum( nSize1, 0 ) );
//STRIP001 	aSizeStr += aUnitStr;
//STRIP001 	if( bExtraBytes )
//STRIP001 	{
//STRIP001 		aSizeStr += DEFINE_CONST_UNICODE(" (");
//STRIP001 		( aSizeStr += rLocaleWrapper.getNum( nSize2, 0 ) ) += aSecondUnitStr;
//STRIP001 	}
//STRIP001 	else if( bGB && bSmartExtraBytes )
//STRIP001 	{
//STRIP001 		nSize1 = nSize;
//STRIP001 		nSize1 /= nMega;
//STRIP001 		aSizeStr += DEFINE_CONST_UNICODE(" (");
//STRIP001 		aSizeStr += rLocaleWrapper.getNum( nSize1, 0 );
//STRIP001 		aSizeStr += String( SfxResId( STR_MB ));
//STRIP001 		aSizeStr += ')';
//STRIP001 	}
//STRIP001 	return aSizeStr;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String CreateKBText( ULONG nSize )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	siehe exptypes.hxx
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	ULONG nKBSize = nSize;
//STRIP001 	nKBSize /= 1024;
//STRIP001 	if ( !nKBSize&& nSize )
//STRIP001 		nKBSize = 1;
//STRIP001 	String aSize =  String::CreateFromInt32( nKBSize );
//STRIP001 	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
//STRIP001 	if ( aSize.Len() > 3 )
//STRIP001 		aSize.Insert( rLocaleWrapper.getNumThousandSep(), aSize.Len() - 3 );
//STRIP001 	if ( aSize.Len() > 7 )
//STRIP001 		aSize.Insert( rLocaleWrapper.getNumThousandSep(), aSize.Len() - 7 );
//STRIP001 
//STRIP001 	aSize += ' ';
//STRIP001 	aSize += String( SfxResId( STR_KB ) );
//STRIP001 	return aSize;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String ConvertWithTilde( const String& rTxt )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	siehe exptypes.hxx
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	USHORT i = 0;
//STRIP001 	String aTmp;
//STRIP001 
//STRIP001 	while ( i < rTxt.Len() )
//STRIP001 	{
//STRIP001 		if ( rTxt.GetChar(i) == '~' )
//STRIP001 			aTmp += '~';
//STRIP001 		aTmp += rTxt.GetChar(i++);
//STRIP001 	}
//STRIP001 	return aTmp;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void CreateDateTimeText( const DateTime& rDT, String& rText )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	siehe exptypes.hxx
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	const LocaleDataWrapper& rLocaleWrapper = SvtSysLocale().GetLocaleData();
//STRIP001 	rText = rLocaleWrapper.getDate( rDT );
//STRIP001 	( rText += DEFINE_CONST_UNICODE(", ") ) += rLocaleWrapper.getTime( rDT );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 #if SUPD<613//MUSTINI
//STRIP001 
//STRIP001 String GetAddressToken( USHORT nToken, SfxIniManager* pMgr )
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	siehe exptypes.hxx
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	if ( !pMgr )
//STRIP001 		pMgr = SFX_INIMANAGER();
//STRIP001 	String aAddress = pMgr->Get( SFX_KEY_USER_ADDRESS );
//STRIP001 	String aToken;
//STRIP001 	USHORT i = 0, nTxt = 0;
//STRIP001 
//STRIP001 	while ( i < aAddress.Len() )
//STRIP001 	{
//STRIP001 		while ( i < aAddress.Len() && aAddress.GetChar(i) != '#' )
//STRIP001 		{
//STRIP001 			if ( aAddress.GetChar(i) == '\\' )
//STRIP001 				i++;
//STRIP001 			aToken += aAddress.GetChar(i++);
//STRIP001 		}
//STRIP001 
//STRIP001 		// aAddress[i] == '#' oder am Ende, also eine Position weiter gehen
//STRIP001 		i++;
//STRIP001 
//STRIP001 		if ( nToken == nTxt )
//STRIP001 			break;
//STRIP001 		else if ( i >= aAddress.Len() )
//STRIP001 		{
//STRIP001 			aToken.Erase();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aToken.Erase();
//STRIP001 			nTxt++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aToken;
//STRIP001 }
//STRIP001 #endif//MUSTINI
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Trim_And_Test_Text( Window& rWnd )
//STRIP001 /*
//STRIP001   [Beschreibung]
//STRIP001   Die Methode entfernt die ueberfluessigen Zeichen des Textes des Fensters
//STRIP001   und prueft, ob er mehr als 0 Zeichen hat.
//STRIP001 
//STRIP001   [Rueckgabewert]
//STRIP001   FALSE  - 0 Zeichen lang
//STRIP001   ...
//STRIP001   */
//STRIP001 {
//STRIP001 	String aTxt( rWnd.GetText() );
//STRIP001 	aTxt.EraseTrailingChars();
//STRIP001 	aTxt.EraseLeadingChars();
//STRIP001 	return aTxt.Len() > 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String CreateExactSizeText( ULONG nSize )
//STRIP001 {
//STRIP001 	String aUnitStr = ' ';
//STRIP001 	aUnitStr += String( SfxResId(STR_BYTES) );
//STRIP001 	double fSize = nSize;
//STRIP001 	int nDec = 0;
//STRIP001 	ULONG nMega = 1024 * 1024;
//STRIP001 	ULONG nGiga = nMega * 1024;
//STRIP001 
//STRIP001 	if ( nSize >= 10000 && nSize < nMega )
//STRIP001 	{
//STRIP001 		fSize /= 1024;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_KB) );
//STRIP001 		nDec = 0;
//STRIP001 	}
//STRIP001 	else if ( nSize >= nMega && nSize < nGiga )
//STRIP001 	{
//STRIP001 		fSize /= nMega;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_MB) );
//STRIP001 		nDec = 2;
//STRIP001 	}
//STRIP001 	else if ( nSize >= nGiga )
//STRIP001 	{
//STRIP001 		fSize /= nGiga;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_GB) );
//STRIP001 		nDec = 3;
//STRIP001 	}
//STRIP001     String aSizeStr( ::rtl::math::doubleToUString( fSize,
//STRIP001                 rtl_math_StringFormat_F, nDec,
//STRIP001                 SvtSysLocale().GetLocaleData().getNumDecimalSep().GetChar(0) ));
//STRIP001 	aSizeStr += aUnitStr;
//STRIP001 	return aSizeStr;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String CreateExactSizeText( const BigInt& rSize )
//STRIP001 {
//STRIP001 	String aUnitStr = ' ';
//STRIP001 	aUnitStr += String( SfxResId(STR_BYTES) );
//STRIP001 	int nDec = 0;
//STRIP001 	BigInt nSize = rSize;
//STRIP001 	double fSize = nSize;
//STRIP001 
//STRIP001 	ULONG nMega = 1024 * 1024;
//STRIP001 	ULONG nGiga = nMega * 1024;
//STRIP001 	static const BigInt nTenKB( 10000 );
//STRIP001 	static const BigInt nOneMB( nMega );
//STRIP001 	static const BigInt nOneGB( nGiga );
//STRIP001 
//STRIP001 	if ( nSize >= nTenKB && nSize < nOneMB )
//STRIP001 	{
//STRIP001 		fSize /= 1024;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_KB) );
//STRIP001 		nDec = 0;
//STRIP001 	}
//STRIP001 	else if ( nSize >= nOneMB && nSize < nOneGB )
//STRIP001 	{
//STRIP001 		fSize /= nMega;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_MB) );
//STRIP001 		nDec = 2;
//STRIP001 	}
//STRIP001 	else if ( nSize >= nOneGB )
//STRIP001 	{
//STRIP001 		fSize /= nGiga;
//STRIP001 		aUnitStr = ' ';
//STRIP001 		aUnitStr += String( SfxResId(STR_GB) );
//STRIP001 		nDec = 3;
//STRIP001 	}
//STRIP001     String aSizeStr( ::rtl::math::doubleToUString( fSize,
//STRIP001                 rtl_math_StringFormat_F, nDec,
//STRIP001                 SvtSysLocale().GetLocaleData().getNumDecimalSep().GetChar(0) ));
//STRIP001 	aSizeStr += aUnitStr;
//STRIP001 	return aSizeStr;
//STRIP001 }

}
