/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_cfgimex.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:40:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SVSTDARR_ULONGS_DECL
#define _SVSTDARR_ULONGS
// auto strip #include <svtools/svstdarr.hxx>
#endif

#pragma hdrstop

#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif

#include "cfgmgr.hxx"
// auto strip #include "cfgitem.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "mnumgr.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxmgr.hxx"
#include "tbxconf.hxx"
// auto strip #include "imgmgr.hxx"
#include "sfx.hrc"
#include "cfgimpl.hxx"
#include "accmgr.hxx"
#include "stbmgr.hxx"
#include "evntconf.hxx"
// auto strip #include "objface.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

/*N*/ static const char pHeader[] = "Star Framework Config File";
/*N*/ #define CFG_STREAM_BUFFER_SIZE  5000
/*N*/ static const USHORT nVersion = 26;
/*N*/ static const char cCtrlZ = 26;
/*N*/ 
/*N*/ static const USHORT nTypesCount = 82;
/*N*/ const char* pStreamNames[] =
/*N*/ {
/*N*/     "statusbar.xml",
/*N*/     "mathstatusbar.xml",
/*N*/     "chartstatusbar.xml",
/*N*/     "calcstatusbar.xml",
/*N*/     "drawstatusbar.xml",
/*N*/     "writerstatusbar.xml",
/*N*/     "globalkeybinding.xml",
/*N*/     "mathkeybinding.xml",
/*N*/     "chartkeybinding.xml",
/*N*/     "calckeybinding.xml",
/*N*/     "impresskeybinding.xml",
/*N*/     "drawkeybinding.xml",
/*N*/     "writerkeybinding.xml",
/*N*/     "webkeybinding.xml",
/*N*/     "defaultmenubar.xml",
/*N*/     "mathmenubar.xml",
/*N*/     "chartmenubar.xml",
/*N*/     "calcmenubar.xml",
/*N*/     "impressmenubar.xml",
/*N*/     "drawmenubar.xml",
/*N*/     "writermenubar.xml",
/*N*/     "webmenubar.xml",
/*N*/     "fullscreenbar.xml",
/*N*/     "functionbar.xml",
/*N*/     "formsnavigationbar.xml",
/*N*/     "formsfilterbar.xml",
/*N*/     "mathtoolbar.xml",
/*N*/     "chartobjectbar.xml",
/*N*/     "charttoolbar.xml",
/*N*/     "calctextobjectbar.xml",
/*N*/     "calcformsobjectbar.xml",
/*N*/     "calcdrawobjectbar.xml",
/*N*/     "calcgrapicobjectbar.xml",
/*N*/     "calcformatobjectbar.xml",
/*N*/     "calcpreviewbar.xml",
/*N*/     "calctoolbar.xml",
/*N*/     "drawbezierobjectbar.xml",
/*N*/     "drawgluepointsobjectbar.xml",
/*N*/     "impressgraphicobjectbar.xml",
/*N*/     "drawdrawingobjectbar.xml",
/*N*/     "impresstextobjectbar.xml",
/*N*/     "drawtextobjectbar.xml",
/*N*/     "impresstoolbar.xml",
/*N*/     "impressoptionsbar.xml",
/*N*/     "impresscommontaskbar.xml",
/*N*/     "drawtoolbar.xml",
/*N*/     "drawoptionsbar.xml",
/*N*/     "drawgraphicobjectbar.xml",
/*N*/     "impressoutlinetoolbar.xml",
/*N*/     "impressslideviewtoolbar.xml",
/*N*/     "impressslideviewobjectbar.xml",
/*N*/     "writerbezierobjectbar.xml",
/*N*/     "writerdrawingobjectbar.xml",
/*N*/     "writerformsobjectbar.xml",
/*N*/     "writerdrawtextobjectbar.xml",
/*N*/     "writerframeobjectbar.xml",
/*N*/     "writergraphicobjectbar.xml",
/*N*/     "writernumobjectbar.xml",
/*N*/     "writeroleobjectbar.xml",
/*N*/     "writertableobjectbar.xml",
/*N*/     "writertextobjectbar.xml",
/*N*/     "writerpreviewobjectbar.xml",
/*N*/     "websourceviewobjectbar.xml",
/*N*/     "websourceviewtoolbar.xml",
/*N*/     "webtextobjectbar.xml",
/*N*/     "writertoolbar.xml",
/*N*/     "webframeobjectbar.xml",
/*N*/     "webgraphicobjectbar.xml",
/*N*/     "weboleobjectbar.xml",
/*N*/     "webtoolbar.xml",
/*N*/     "imagelist.xml",
/*N*/     "toolboxlayout.xml",
/*N*/     "eventbindings.xml",
/*N*/     "eventbindings.xml",
/*N*/ 	"macrobar.xml",
/*N*/ 	"basicstatusbar.xml",
/*N*/ 	"writerglobalmenubar.xml",
/*N*/ 	"basicmenubar.xml",
/*N*/ 	"writerviewerbar.xml",
/*N*/ 	"calcviewerbar.xml",
/*N*/ 	"impressviewerbar.xml",
/*N*/ 	"drawviewerbar.xml"
/*N*/ };

/*N*/ const USHORT pTypes[] =
/*N*/ {
/*N*/     4,
/*N*/     20816,
/*N*/     30002,
/*N*/     26005,
/*N*/     23007,
/*N*/     20013,
/*N*/     1,
/*N*/     20815,
/*N*/     20080,
/*N*/     26006,
/*N*/     23005,
/*N*/     23008,
/*N*/     20017,
/*N*/     20020,
/*N*/     261,
/*N*/     20814,
/*N*/     20081,
/*N*/     26007,
/*N*/     23006,
/*N*/     23009,
/*N*/     20016,
/*N*/     20019,
/*N*/     558,
/*N*/     560,
/*N*/     18003,
/*N*/     18004,
/*N*/     20050,
/*N*/     30001,
/*N*/     30513,
/*N*/     25005,
/*N*/     25047,
/*N*/     25053,
/*N*/     25054,
/*N*/     25001,
/*N*/     25006,
/*N*/     25035,
/*N*/     23015,
/*N*/     23019,
/*N*/     23030,
/*N*/     23013,
/*N*/     23016,
/*N*/     23028,
/*N*/     23011,
/*N*/     23020,
/*N*/     23021,
/*N*/     23025,
/*N*/     23026,
/*N*/     23027,
/*N*/     23017,
/*N*/     23012,
/*N*/     23014,
/*N*/     23283,
/*N*/     23269,
/*N*/     23299,
/*N*/     23270,
/*N*/     23267,
/*N*/     23268,
/*N*/     23271,
/*N*/     23272,
/*N*/     23266,
/*N*/     23265,
/*N*/     20631,
/*N*/     23282,
/*N*/     20402,
/*N*/     20403,
/*N*/     23273,
/*N*/     20408,
/*N*/     20410,
/*N*/     20411,
/*N*/     20412,
/*N*/     6,
/*N*/     9,
/*N*/     10,
/*N*/     11,
/*N*/ 	14850,
/*N*/ 	30805,
/*N*/ 	20029,
/*N*/ 	14851,
/*N*/ 	23310,
/*N*/ 	25000,
/*N*/ 	23023,
/*N*/ 	23024
/*N*/ };

/*N*/ BOOL SfxConfigManagerImExport_Impl::HasConfiguration( SotStorage& rStorage )
/*N*/ {
/*N*/     return rStorage.IsStream( String::CreateFromAscii(pHeader) );
/*N*/ }

/*N*/ USHORT SfxConfigManagerImExport_Impl::Import( SotStorage* pInStorage, SotStorage* pStorage )
/*N*/ {
/*N*/ 	SotStorageStreamRef aStr =
/*N*/         pInStorage->OpenSotStream( String::CreateFromAscii(pHeader), STREAM_STD_READ );
/*N*/ 	if ( aStr->GetError() )
/*N*/ 		return SfxConfigManager::ERR_OPEN;
/*N*/ 
/*N*/ 	SvStream* pStream = aStr;
/*N*/ 	pStream->SetVersion( SOFFICE_FILEFORMAT_40 );
/*N*/ 	pStream->SetBufferSize( CFG_STREAM_BUFFER_SIZE );
/*N*/ 	pStream->Seek(0);
/*N*/ 	USHORT nRet = SfxConfigManager::ERR_NO;
/*N*/ 
/*N*/ 	// check header
/*N*/ 	const unsigned nLen = strlen( pHeader );
/*N*/ 	char *pBuf = new char[nLen+1];
/*N*/ 	pStream->Read( pBuf, nLen );
/*N*/ 	pBuf[nLen] = 0;
/*N*/ 	if( strcmp( pBuf, pHeader ) )
/*N*/ 	{
/*N*/ 		delete pBuf;
/*?*/ 		return SfxConfigManager::ERR_FILETYPE;
/*N*/ 	}
/*N*/ 
/*N*/ 	delete pBuf;
/*N*/ 
/*N*/ 	// compare version
/*N*/ 	char c;
/*N*/ 	USHORT nFileVersion;
/*N*/ 	(*pStream) >> c;					// skip ASCII 26 (CTRL-Z)
/*N*/ 	(*pStream) >> nFileVersion;
/*N*/ 	if( nFileVersion != nVersion )
/*N*/ 	{
/*?*/ 		return SfxConfigManager::ERR_VERSION;
/*N*/ 	}
/*N*/ 
/*N*/ 	// get position of directory
/*N*/ 	long lDirPos, lStart = pStream->Tell();
/*N*/ 	(*pStream) >> lDirPos;
/*N*/ 	pStream->Seek(lDirPos);
/*N*/ 
/*N*/ 	// get number of items
/*N*/ 	USHORT nCount;
/*N*/ 	(*pStream) >> nCount;
/*N*/ 
/*N*/ 	// read in directory and convert items
/*N*/ 	for( USHORT i=0; i < nCount; ++i )
/*N*/ 	{
/*N*/ 		SfxConfigItem_Impl* pItem = new SfxConfigItem_Impl;
/*N*/ 		pItemArr->Insert( pItem, pItemArr->Count() );
/*N*/ 
/*N*/ 		// retrieve type of item and human readable name
/*N*/ 		long lLength, lPos;	            // dummies
/*N*/         (*pStream) >> pItem->nType >> lPos >> lLength;
/*N*/ 		pItem->bDefault = ( lPos == -1L );
/*N*/         pStream->ReadByteString( pItem->aName );
/*N*/         if ( pStream->GetError() )
/*N*/         {
/*?*/             pItem->bDefault = TRUE;
/*?*/             return SfxConfigManager::ERR_READ;
/*N*/         }
/*N*/ 
/*N*/ 		// convert into new format
/*N*/         if ( !pItem->bDefault )
/*N*/         {
/*N*/             // stream name for new format
/*N*/             pItem->aStreamName = GetStreamName( pItem->nType );
/*N*/             if ( pItem->aStreamName.Len() )
/*N*/             {
/*N*/                 long lOldPos = pStream->Tell();
/*N*/                 pStream->Seek( lPos );
/*N*/ 
/*N*/                 // check for correct type id, inequality is allowed for userdef toolboxes
/*N*/                 USHORT nType;
/*N*/                 (*pStream) >> nType;
/*N*/                 BOOL bOk = ( nType == pItem->nType ||
/*N*/                             1294 <= nType && nType <= 1301 &&
/*N*/                             1294 <= pItem->nType && pItem->nType <= 1301 );
/*N*/ 
/*N*/                 if ( !bOk || !ImportItem( pItem, pStream, pStorage ) )
/*N*/                 {
/*?*/                     pItem->bDefault = TRUE;
/*?*/                     nRet = SfxConfigManager::ERR_IMPORT;
/*N*/                 }
/*N*/ 
/*N*/                 pStream->Seek( lOldPos );
/*N*/             }
/*N*/             else
/*N*/             {
/*N*/                 DBG_ERROR("Couldn't convert old configuration!");
/*N*/                 // force error message that saving this document would lose some configuration information
/*N*/             }
/*N*/         }
/*N*/ 
/*N*/         if ( !pItem->aStreamName.Len() )
/*N*/ 		{
/*N*/             // no real config item anymore
/*N*/ 			delete pItem;
/*N*/ 			pItemArr->Remove( pItemArr->Count() - 1 );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return nRet;
/*N*/ }

/*N*/ BOOL SfxConfigManagerImExport_Impl::ImportItem( SfxConfigItem_Impl* pItem, SvStream* pStream, SotStorage* pStor )
/*N*/ {
/*N*/ 	BOOL bRet = TRUE;
/*N*/ 	switch ( pItem->nType )
/*N*/ 	{
/*N*/     	// Statusbars
/*N*/     	case SFX_ITEMTYPE_STATBAR :     // Global
/*N*/     	case 20816 :        			// Math
/*N*/     	case 30002 :      				// Chart
/*N*/     	case 26005 :                    // Calc
/*N*/     	case 23007 :                    // Impress/Draw
/*N*/     	case 20013 :                    // Writer/WriterWeb
/*N*/ 		{
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/ 				bOK = SfxStatusBarManager::Import( *pStream, *xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	// Accels
/*N*/     	case SFX_ITEMTYPE_ACCEL :		// Global
/*N*/ 		case 20815 :        			// Math
/*N*/         case 20080 :        			// Chart
/*N*/         case 26006 :        			// Calc
/*N*/         case 20017 :        			// Impress
/*N*/         case 20020 :        			// Draw
/*N*/         case 23005 :        			// Writer
/*N*/         case 23008 :        			// WriterWeb
/*N*/         {
/*?*/             SfxAcceleratorManager aMgr( pItem->nType, NULL );
/*?*/             int nRet = aMgr.Load( *pStream );
/*?*/             if ( nRet == SfxConfigItem::ERR_OK )
/*?*/                 bRet = aMgr.Store( *pStor );
/*?*/ 			break;
/*N*/         }
/*N*/ 
/*N*/     	// Menues
/*N*/     	case 20814 :        			// Math
/*N*/     	case 20081 :       				// Chart
/*N*/         case 26007 :        			// Calc
/*N*/         case 23006 :        			// Impress
/*N*/         case 23009 :        			// Draw
/*N*/         case 20016 :        			// Writer
/*N*/         case 20019 :        			// WriterWeb
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 BOOL bOK = FALSE;
//STRIP001 /*?*/ 			MenuBar* pMenu = (MenuBar*) SfxMenuManager::LoadMenu( *pStream );
//STRIP001 /*?*/ 			if ( pMenu )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SotStorageStreamRef xStream =
//STRIP001 /*?*/                     	pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001 /*?*/ 				if ( !xStream->GetError() )
//STRIP001 /*?*/ 					bOK = SfxMenuBarManager::StoreMenuBar( *xStream, pMenu );
//STRIP001 /*?*/ 				delete pMenu;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if ( bRet )
//STRIP001 /*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	// Toolboxes
/*N*/         case 558 :                      // Fullscreenbar
/*N*/         case 560 :                    	// Functionbar
/*N*/         case 18003 :                    // FormularNavigationbar
/*N*/         case 18004 :                    // FormularFilterbar
/*N*/         case 20050 :                    // MathToolbar
/*N*/     	case 30001 :                    // ChartObjectbar
/*N*/     	case 30513 :                    // ChartToolbar
/*N*/     	case 25005 :                    // CalcTextObjectbar
/*N*/     	case 25047 :                    // CalcFormObjectbar
/*N*/     	case 25053 :                    // CalcDrawObjectbar
/*N*/     	case 25054 :                    // CalcGraphicObjectbar
/*N*/     	case 25001 :                    // CalcFormatObjectbar
/*N*/     	case 25006 :                    // CalcPreviewObjectbar
/*N*/     	case 25035 :                    // CalcToolbar
/*N*/ 		case 23015 :                    // DrawBezierObjectbar
/*N*/         case 23019 :                    // DrawGluepointsObjectbar
/*N*/         case 23030 :                    // ImpressGraphicObjectbar
/*N*/         case 23013 :                    // DrawDrawingObjectbar
/*N*/         case 23016 :                    // ImpressTextObjectbar
/*N*/         case 23028 :                    // DrawTextObjectbar
/*N*/         case 23011 :                    // ImpressToolbar
/*N*/         case 23020 :                    // ImpressOptionsbar
/*N*/         case 23021 :                    // ImpressCommontaskbar
/*N*/         case 23025 :                    // DrawToolbar
/*N*/         case 23026 :                    // DrawOptionsbar
/*N*/         case 23027 :                    // DrawGraphicObjectbar
/*N*/         case 23017 :                    // OutlineToolbar
/*N*/         case 23012 :                    // SlideViewToolbar
/*N*/         case 23014 :                    // SlideViewObjectbar
/*N*/         case 23283 :                    // WriterBezierObjectbar
/*N*/         case 23269 :                    // WriterDrawObjectbar
/*N*/         case 23299 :                    // WriterFormularObjectbar
/*N*/         case 23270 :                    // WriterDrawTextObjectbar
/*N*/         case 23267 :                    // WriterFrameObjectbar
/*N*/         case 23268 :                    // WriterGraphicObjectbar
/*N*/         case 23271 :                    // WriterNumObjectbar
/*N*/         case 23272 :                    // WriterOleObjectbar
/*N*/         case 23266 :                    // WriterTableObjectbar
/*N*/         case 23265 :                    // WriterTextObjectbar
/*N*/         case 20631 :                    // WriterPagePreviewObjectbar
/*N*/         case 23282 :                    // WriterWebSourceViewObjectbar
/*N*/         case 20402 :                    // WriterWebSourceViewToolbox
/*N*/         case 20403 :                    // WriterWebTextObjectbar
/*N*/         case 23273 :                    // WriterToolbox
/*N*/         case 20408 :                    // WriterWebFrameObjectbar
/*N*/         case 20410 :                    // WriterWebGraphicObjectbar
/*N*/         case 20411 :                    // WriterWebOleObjectbar
/*N*/         case 20412 :                    // WriterWebToolbar ????????????????????
/*N*/ 		{
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/ 				bOK = SfxToolBoxManager::Import( *pStream, *xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_IMAGELIST :
/*N*/ 		{
/*?*/ 			BOOL bOK = SfxImageManager::Import( *pStream, *pStor );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_TOOLBOXCONFIG :
/*N*/ 		{
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/ 				bOK = SfxToolBoxConfig::Import( *pStream, *xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_APPEVENTCONFIG :
/*N*/         {
/*?*/ 			BOOL bOK = FALSE;
/*?*/ 			SotStorageStreamRef xStream =
/*?*/             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 			if ( !xStream->GetError() )
/*?*/                 bOK = SfxEventConfiguration::Import( *pStream, xStream );
/*?*/ 			if ( bRet )
/*?*/ 				bRet = bOK;
/*N*/             break;
/*N*/         }
/*N*/ 
/*N*/     	case SFX_ITEMTYPE_DOCEVENTCONFIG :
/*N*/         {
/*N*/             BOOL bOK = SfxEventConfiguration::Import( *pStream, NULL, pObjShell );
/*N*/ 			if ( bRet )
/*N*/ 				bRet = bOK;
/*N*/ 			break;
/*N*/         }
/*N*/ 
/*N*/     	default:
/*?*/         	if ( pItem->nType >= SFX_ITEMTYPE_INTERFACE_START && pItem->nType <= SFX_ITEMTYPE_INTERFACE_END )
/*?*/         	{
/*?*/         	}
/*?*/         	else if ( pItem->nType >= RID_SFX_TOOLBOX_START + 10 && pItem->nType <= RID_SFX_TOOLBOX_START + 17 )
/*?*/         	{
/*?*/ 				// user defined toolboxes
/*?*/ 				BOOL bOK = FALSE;
/*?*/ 				SotStorageStreamRef xStream =
/*?*/             			pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READWRITE | STREAM_TRUNC );
/*?*/ 				if ( !xStream->GetError() )
/*?*/ 					bOK = SfxToolBoxManager::Import( *pStream, *xStream );
/*?*/ 				if ( bRet )
/*?*/ 					bRet = bOK;
/*?*/         	}
/*?*/ #ifdef  DBG_UTIL
/*?*/ 			else
/*?*/ 			{
/*?*/ 				ByteString aMsg("SfxConfigManager: ConfigItem will not be imported : ");
/*?*/ 				aMsg += ByteString::CreateFromInt32( pItem->nType );
/*?*/ 				DBG_TRACE( aMsg.GetBuffer() );
/*?*/ 			}
/*?*/ #endif
/*?*/ 			break;
/*?*/ 	}
/*?*/ 
/*N*/ 	return bRet;
/*N*/ }

/*?*/ USHORT SfxConfigManagerImExport_Impl::Export( SotStorage* pStor, SotStorage *pOut )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     // try to adjust old item names
//STRIP001     for( USHORT nItem = 0; nItem<pItemArr->Count(); ++nItem )
//STRIP001     {
//STRIP001         SfxConfigItem_Impl* pItem = (*pItemArr)[nItem];
//STRIP001         if ( !pItem->aName.Len() )
//STRIP001             pItem->aName = GetItemName( pItem->nType );
//STRIP001     }
//STRIP001 
//STRIP001     // open the stream for the old configuration format
//STRIP001     SotStorageStreamRef aStr =
//STRIP001         pOut->OpenSotStream( String::CreateFromAscii(pHeader), STREAM_STD_READWRITE | STREAM_TRUNC );
//STRIP001 	if ( aStr->GetError() )
//STRIP001 		return SfxConfigManager::ERR_OPEN;
//STRIP001 
//STRIP001 	SvStream* pStream = aStr;
//STRIP001 	pStream->SetVersion( SOFFICE_FILEFORMAT_40 );
//STRIP001 	pStream->SetBufferSize( CFG_STREAM_BUFFER_SIZE );
//STRIP001 
//STRIP001 	USHORT nRet = SfxConfigManager::ERR_NO;
//STRIP001 
//STRIP001 	// write header
//STRIP001 	pStream->Write( pHeader, strlen(pHeader) );
//STRIP001 	(*pStream) << cCtrlZ << nVersion;
//STRIP001 
//STRIP001     // write a placeholder for the directory pointer and remember its position
//STRIP001 	long lStart = pStream->Tell();
//STRIP001 	(*pStream) << lStart;
//STRIP001 
//STRIP001 	// write all items into the file and remember the starting position of each item
//STRIP001 	USHORT nCount = (*pItemArr).Count();
//STRIP001 
//STRIP001     // special treatment for ToolBoxConfig in presence of user defined toolboxes ( see below )
//STRIP001     USHORT nTbxCfgItem = nCount;
//STRIP001     BOOL bTbxCfgIsDefault = TRUE;
//STRIP001 
//STRIP001     // directory of config stream will contain the position and length values, the latter one will be
//STRIP001     // calculated by the difference of the position and the position of the successor
//STRIP001     // so for the last item a dummy successor is added to aDir
//STRIP001     SvULongs aDir( nCount+1, 1 );
//STRIP001 	for( USHORT i=0; i<nCount; i++ )
//STRIP001 	{
//STRIP001 		SfxConfigItem_Impl *pItem = (*pItemArr)[i];
//STRIP001         if ( pItem->nType == SFX_ITEMTYPE_TOOLBOXCONFIG )
//STRIP001         {
//STRIP001             // remember index of this item, because it will be needed below
//STRIP001             nTbxCfgItem = i;
//STRIP001 
//STRIP001             // remember old bDefault, because it must be set to non-default for exporting ( temporarily, see below )
//STRIP001             // and export is required if user defined toolboxes are present
//STRIP001             bTbxCfgIsDefault = pItem->bDefault;
//STRIP001         }
//STRIP001 
//STRIP001         // remember file position
//STRIP001         aDir.Insert( pStream->Tell(), i );
//STRIP001 
//STRIP001         // write data only if it's not the default configuration
//STRIP001         if ( !pItem->bDefault )
//STRIP001         {
//STRIP001             // write data for plausibility check
//STRIP001             (*pStream) << pItem->nType;
//STRIP001 
//STRIP001             if ( !ExportItem( pItem, pStor, pStream ) )
//STRIP001             {
//STRIP001                 // export failed, stop writing
//STRIP001                 nRet = SfxConfigManager::ERR_EXPORT;
//STRIP001                 break;
//STRIP001             }
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001     if ( pIFaceConfig )
//STRIP001     {
//STRIP001         // if there are some userdefined toolboxes, a ToolboxConfig must be exported also
//STRIP001         SfxConfigItem_Impl *pItem=NULL;
//STRIP001         if ( nTbxCfgItem < nCount )
//STRIP001             // get the current item for it
//STRIP001             pItem = (*pItemArr)[nTbxCfgItem];
//STRIP001 
//STRIP001         if ( !pItem || pItem->bDefault )
//STRIP001         {
//STRIP001             // if there is no item or the old one is a default item, a new item must be added
//STRIP001             // ( because the stream of the ToolboxConfig will be written behind all items written so far
//STRIP001             // and aDir's file positions must be in ascending order )
//STRIP001             if ( pItem )
//STRIP001             {
//STRIP001                 // ToolBoxConfig gets a new entry, so remove old one ( temporarily, see below )
//STRIP001                 // it's a default entry, so its does not disturb aDir's positions!
//STRIP001                 pItemArr->Remove( nTbxCfgItem );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 // create a new entry
//STRIP001                 pItem = new SfxConfigItem_Impl;
//STRIP001                 pItem->nType = SFX_ITEMTYPE_TOOLBOXCONFIG;
//STRIP001                 nCount++;
//STRIP001             }
//STRIP001 
//STRIP001             // append the new item ( temporarily, see below )
//STRIP001             pItemArr->Insert( pItem, pItemArr->Count() );
//STRIP001 
//STRIP001             // get the starting position in the stream
//STRIP001             aDir.Insert( pStream->Tell(), nCount-1 );
//STRIP001 
//STRIP001             // only non-default items will be exported, change flag ( temporarily, see below )
//STRIP001             pItem->bDefault = FALSE;
//STRIP001 
//STRIP001             // write data for plausibility check
//STRIP001             (*pStream) << pItem->nType;
//STRIP001 
//STRIP001             // no inputstream for export, because there is no configuration in the storage, because
//STRIP001             // it's a default configuration for 6.0 format
//STRIP001             if ( !SfxToolBoxConfig::Export( NULL, *pStream ) )
//STRIP001                 nRet = SfxConfigManager::ERR_EXPORT;
//STRIP001         }
//STRIP001 
//STRIP001         // if there are some userdefined toolboxes, they must be exported in an interface configuration
//STRIP001         pItem = new SfxConfigItem_Impl;
//STRIP001         pItem->nType = pIFaceConfig->GetType();
//STRIP001         pItem->bDefault = FALSE;
//STRIP001         nCount++;
//STRIP001 
//STRIP001         // insert new item ( temporarily, see below )
//STRIP001 		pItemArr->Insert( pItem, pItemArr->Count() );
//STRIP001 
//STRIP001             // get the starting position in the stream
//STRIP001         aDir.Insert( pStream->Tell(), nCount-1 );
//STRIP001 
//STRIP001         // write data for plausibility check
//STRIP001         (*pStream) << pItem->nType;
//STRIP001 
//STRIP001         // store the interface configuration that will cover all user defined toolbox registrations
//STRIP001         if ( !pIFaceConfig->Store(*pStream) )
//STRIP001             nRet = SfxConfigManager::ERR_EXPORT;
//STRIP001     }
//STRIP001 
//STRIP001     if ( nRet == SfxConfigManager::ERR_NO )
//STRIP001     {
//STRIP001         // directory is stored behind the items
//STRIP001         long lDirPos = pStream->Tell();
//STRIP001         aDir.Insert( lDirPos, nCount );          // last element for calculation of differences
//STRIP001 
//STRIP001         // write position of directory into file ( use space of placeholder )
//STRIP001         pStream->Seek( lStart );
//STRIP001         (*pStream) << lDirPos;
//STRIP001 
//STRIP001         // write directory
//STRIP001         pStream->Seek( lDirPos );
//STRIP001         (*pStream) << nCount;
//STRIP001         for( i=0; i<nCount; i++ )
//STRIP001         {
//STRIP001             SfxConfigItem_Impl *pItem = (*pItemArr)[i];
//STRIP001             if ( pItem->bDefault )
//STRIP001                 // ignore file position stored in aDir, because default configurations are not written
//STRIP001                 *pStream << pItem->nType << -1L << 0L;
//STRIP001             else
//STRIP001                 *pStream << pItem->nType << aDir[i] << ( aDir[i+1] - aDir[i] );
//STRIP001             pStream->WriteByteString( pItem->aName );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if ( pIFaceConfig )
//STRIP001     {
//STRIP001         // restore original array
//STRIP001         // first remove last inserted entry for the additional interface configuration
//STRIP001         delete pItemArr->GetObject( --nCount );
//STRIP001         pItemArr->Remove( nCount );
//STRIP001 
//STRIP001         // now repair entry for ToolBoxConfig
//STRIP001         if ( nTbxCfgItem < nCount )
//STRIP001         {
//STRIP001             // already existed before
//STRIP001             if ( bTbxCfgIsDefault )
//STRIP001             {
//STRIP001                 // was default before, reinsert at previous position and reset to default
//STRIP001                 SfxConfigItem_Impl *pItem = pItemArr->GetObject( nCount-1 );
//STRIP001                 pItemArr->Remove( nCount-1 );
//STRIP001                 pItemArr->Insert( pItem, nTbxCfgItem );
//STRIP001                 pItem->bDefault = TRUE;
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             // was inserted while exportin, remove
//STRIP001             delete pItemArr->GetObject( --nCount );
//STRIP001             pItemArr->Remove( nCount );
//STRIP001         }
//STRIP001 
//STRIP001         DELETEZ( pIFaceConfig );
//STRIP001     }
//STRIP001 
//STRIP001 	return nRet;
/*?*/ }

/*?*/ BOOL SfxConfigManagerImExport_Impl::ExportItem( SfxConfigItem_Impl *pItem, SotStorage* pStor, SvStream* pStream )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 
//STRIP001 	BOOL bRet = TRUE;
//STRIP001 	switch ( pItem->nType )
//STRIP001 	{
//STRIP001     	// Statusbars
//STRIP001     	case SFX_ITEMTYPE_STATBAR :     // Global
//STRIP001     	case 20816 :        			// Math
//STRIP001     	case 30002 :      				// Chart
//STRIP001     	case 26005 :                    // Calc
//STRIP001     	case 23007 :                    // Impress/Draw
//STRIP001     	case 20013 :                    // Writer/WriterWeb
//STRIP001 		{
//STRIP001 			BOOL bOK = FALSE;
//STRIP001 			SotStorageStreamRef xStream =
//STRIP001             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
//STRIP001 			if ( !xStream->GetError() )
//STRIP001 				bOK = SfxStatusBarManager::Export( *xStream, *pStream );
//STRIP001 			if ( bRet )
//STRIP001 				bRet = bOK;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001     	// Accels
//STRIP001     	case SFX_ITEMTYPE_ACCEL :		// Global
//STRIP001 		case 20815 :        			// Math
//STRIP001         case 20080 :        			// Chart
//STRIP001         case 26006 :        			// Calc
//STRIP001         case 20017 :        			// Impress
//STRIP001         case 20020 :        			// Draw
//STRIP001         case 23005 :        			// Writer
//STRIP001         case 23008 :        			// WriterWeb
//STRIP001         {
//STRIP001             SfxAcceleratorManager aMgr( pItem->nType, NULL );
//STRIP001             int nRet = aMgr.Load( *pStor );
//STRIP001             if ( nRet == SfxConfigItem::ERR_OK )
//STRIP001                 bRet = aMgr.Store( *pStream );
//STRIP001 			break;
//STRIP001         }
//STRIP001 
//STRIP001     	// Menues
//STRIP001     	case 20814 :        			// Math
//STRIP001     	case 20081 :       				// Chart
//STRIP001         case 26007 :        			// Calc
//STRIP001         case 23006 :        			// Impress
//STRIP001         case 23009 :        			// Draw
//STRIP001         case 20016 :        			// Writer
//STRIP001         case 20019 :        			// WriterWeb
//STRIP001 		{
//STRIP001 			BOOL bOK = FALSE;
//STRIP001 			SotStorageStreamRef xStream =
//STRIP001                     pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
//STRIP001 			if ( !xStream->GetError() )
//STRIP001 			{
//STRIP001 				MenuBar* pMenu = SfxMenuBarManager::LoadMenuBar( *xStream );
//STRIP001                 bOK = SfxMenuManager::StoreMenu( *pStream, pMenu, pObjShell->GetModule() );
//STRIP001 				delete pMenu;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bRet )
//STRIP001 				bRet = bOK;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001     	// Toolboxes
//STRIP001         case 558 :                      // Fullscreenbar
//STRIP001         case 560 :                    	// Functionbar
//STRIP001         case 18003 :                    // FormularNavigationbar
//STRIP001         case 18004 :                    // FormularFilterbar
//STRIP001         case 20050 :                    // MathToolbar
//STRIP001     	case 30001 :                    // ChartObjectbar
//STRIP001     	case 30513 :                    // ChartToolbar
//STRIP001     	case 25005 :                    // CalcTextObjectbar
//STRIP001     	case 25047 :                    // CalcFormObjectbar
//STRIP001     	case 25053 :                    // CalcDrawObjectbar
//STRIP001     	case 25054 :                    // CalcGraphicObjectbar
//STRIP001     	case 25001 :                    // CalcFormatObjectbar
//STRIP001     	case 25006 :                    // CalcPreviewObjectbar
//STRIP001     	case 25035 :                    // CalcToolbar
//STRIP001 		case 23015 :                    // DrawBezierObjectbar
//STRIP001         case 23019 :                    // DrawGluepointsObjectbar
//STRIP001         case 23030 :                    // ImpressGraphicObjectbar
//STRIP001         case 23013 :                    // DrawDrawingObjectbar
//STRIP001         case 23016 :                    // ImpressTextObjectbar
//STRIP001         case 23028 :                    // DrawTextObjectbar
//STRIP001         case 23011 :                    // ImpressToolbar
//STRIP001         case 23020 :                    // ImpressOptionsbar
//STRIP001         case 23021 :                    // ImpressCommontaskbar
//STRIP001         case 23025 :                    // DrawToolbar
//STRIP001         case 23026 :                    // DrawOptionsbar
//STRIP001         case 23027 :                    // DrawGraphicObjectbar
//STRIP001         case 23017 :                    // OutlineToolbar
//STRIP001         case 23012 :                    // SlideViewToolbar
//STRIP001         case 23014 :                    // SlideViewObjectbar
//STRIP001         case 23283 :                    // WriterBezierObjectbar
//STRIP001         case 23269 :                    // WriterDrawObjectbar
//STRIP001         case 23299 :                    // WriterFormularObjectbar
//STRIP001         case 23270 :                    // WriterDrawTextObjectbar
//STRIP001         case 23267 :                    // WriterFrameObjectbar
//STRIP001         case 23268 :                    // WriterGraphicObjectbar
//STRIP001         case 23271 :                    // WriterNumObjectbar
//STRIP001         case 23272 :                    // WriterOleObjectbar
//STRIP001         case 23266 :                    // WriterTableObjectbar
//STRIP001         case 23265 :                    // WriterTextObjectbar
//STRIP001         case 20631 :                    // WriterPagePreviewObjectbar
//STRIP001         case 23282 :                    // WriterWebSourceViewObjectbar
//STRIP001         case 20402 :                    // WriterWebSourceViewToolbox
//STRIP001         case 20403 :                    // WriterWebTextObjectbar
//STRIP001         case 23273 :                    // WriterToolbox
//STRIP001         case 20408 :                    // WriterWebFrameObjectbar
//STRIP001         case 20410 :                    // WriterWebGraphicObjectbar
//STRIP001         case 20411 :                    // WriterWebOleObjectbar
//STRIP001         case 20412 :                    // WriterWebToolbar ????????????????????
//STRIP001 		{
//STRIP001 			BOOL bOK = FALSE;
//STRIP001 			SotStorageStreamRef xStream =
//STRIP001             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
//STRIP001 			if ( !xStream->GetError() )
//STRIP001 				bOK = SfxToolBoxManager::Export( *xStream, *pStream );
//STRIP001 			if ( bRet )
//STRIP001 				bRet = bOK;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001     	case SFX_ITEMTYPE_IMAGELIST :
//STRIP001 		{
//STRIP001 			BOOL bOK = SfxImageManager::Export( *pStor, *pStream );
//STRIP001 			if ( bRet )
//STRIP001 				bRet = bOK;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001     	case SFX_ITEMTYPE_TOOLBOXCONFIG :
//STRIP001 		{
//STRIP001 			BOOL bOK = FALSE;
//STRIP001 			SotStorageStreamRef xStream =
//STRIP001             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
//STRIP001 			if ( !xStream->GetError() )
//STRIP001                 bOK = SfxToolBoxConfig::Export( xStream, *pStream );
//STRIP001 			if ( bRet )
//STRIP001 				bRet = bOK;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001     	case SFX_ITEMTYPE_APPEVENTCONFIG :
//STRIP001 		{
//STRIP001 			BOOL bOK = FALSE;
//STRIP001 			SotStorageStreamRef xStream =
//STRIP001             		pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
//STRIP001 			if ( !xStream->GetError() )
//STRIP001                 bOK = SfxEventConfiguration::Export( xStream, *pStream );
//STRIP001 			if ( bRet )
//STRIP001 				bRet = bOK;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001     	case SFX_ITEMTYPE_DOCEVENTCONFIG :
//STRIP001         {
//STRIP001             BOOL bOK = SfxEventConfiguration::Export( NULL, *pStream, pObjShell );
//STRIP001 			if ( bRet )
//STRIP001 				bRet = bOK;
//STRIP001 			break;
//STRIP001         }
//STRIP001 
//STRIP001     	default:
//STRIP001             if ( pItem->nType >= RID_SFX_TOOLBOX_START + 10 && pItem->nType <= RID_SFX_TOOLBOX_START + 17 )
//STRIP001         	{
//STRIP001 				// user defined toolboxes
//STRIP001                 BOOL bOK = FALSE;
//STRIP001                 SotStorageStreamRef xStream =
//STRIP001                         pStor->OpenSotStream( pItem->aStreamName, STREAM_STD_READ );
//STRIP001                 if ( !xStream->GetError() )
//STRIP001                     bOK = SfxToolBoxManager::Export( *xStream, *pStream );
//STRIP001                 if ( bRet )
//STRIP001                     bRet = bOK;
//STRIP001 
//STRIP001                 // now register in global context to save later
//STRIP001                 if ( !pIFaceConfig )
//STRIP001                     pIFaceConfig = new SfxIFConfig_Impl;
//STRIP001                 USHORT nPos = SFX_OBJECTBAR_USERDEF1 + pItem->nType - RID_SFX_TOOLBOX_START - 10;
//STRIP001                 pIFaceConfig->RegisterObjectBar( nPos, pItem->nType, 0, NULL );
//STRIP001         	}
//STRIP001 
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
/*?*/ }

/*?*/ String SfxConfigManagerImExport_Impl::GetItemName( USHORT nType )
/*?*/ {
/*?*/     return String();
/*?*/ }

/*N*/ String SfxConfigManagerImExport_Impl::GetStreamName( USHORT nType )
/*N*/ {
/*N*/     if ( nType >= SFX_ITEMTYPE_INTERFACE_START && nType <= SFX_ITEMTYPE_INTERFACE_END && nType != RID_DEFAULTMENU )
/*N*/     {
/*?*/         // accidently the old default menu interfered with the interface ID area
/*?*/         if ( nType != RID_DEFAULTMENU )
/*?*/             DBG_ERROR("Obsolete configitem!");
/*?*/         return String();
/*N*/     }
/*N*/     else if ( nType >= RID_SFX_TOOLBOX_START + 10 && nType <= RID_SFX_TOOLBOX_START + 17 )
/*N*/     {
/*?*/         ByteString aStr("userdeftoolbox");
/*?*/         aStr += ByteString::CreateFromInt32( nType - ( RID_SFX_TOOLBOX_START + 9 ) );
/*?*/         aStr += ".xml";
/*?*/         return String( aStr, RTL_TEXTENCODING_UTF8 );
/*N*/     }
/*N*/ 
/*N*/     for ( USHORT n=0; n<nTypesCount; n++ )
/*N*/     {
/*N*/         if ( pTypes[n] == nType )
/*N*/             return String::CreateFromAscii( pStreamNames[n] );
/*N*/     }
/*?*/ 
/*?*/     OSL_ENSURE(false, "Unknown configitem!");
/*?*/     return String();
/*N*/ }

/*?*/ USHORT SfxConfigManagerImExport_Impl::GetType( const String& rStreamName )
/*?*/ {
/*NBFF*/     ByteString aCmp( rStreamName, RTL_TEXTENCODING_ASCII_US );
/*NBFF*/ 
/*NBFF*/     if ( !aCmp.CompareTo( "userdeftoolbox", 14 ) )
/*NBFF*/         return (USHORT) ( RID_SFX_TOOLBOX_START + 9 + aCmp.Copy( 14 ).ToInt32() );
/*NBFF*/ 
/*NBFF*/     for ( USHORT n=0; n<nTypesCount; n++ )
/*NBFF*/         if ( !strcmp( aCmp.GetBuffer(), pStreamNames[n] ) )
/*NBFF*/             return pTypes[n];
/*NBFF*/ 
/*?*/     return 0;
/*?*/ }

}
