/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsi.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:40:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_COLOR			ATTR_ANIMATION_COLOR
// auto strip #ifndef _XTABLE_HXX
// auto strip #include <bf_svx/xtable.hxx>
// auto strip #endif
#include "sdattr.hxx"
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _EEITEM_HXX //autogen
// auto strip #include <bf_svx/eeitem.hxx>
// auto strip #endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
// auto strip #ifndef _SVDITER_HXX //autogen
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_COLRITEM_HXX //autogen
// auto strip #include <bf_svx/colritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
#ifndef _SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif
// auto strip #ifndef _SVDUNDO_HXX //autogen
// auto strip #include <bf_svx/svdundo.hxx>
// auto strip #endif
// auto strip #ifndef _E3D_VIEW3D_HXX //autogen
// auto strip #include <bf_svx/view3d.hxx>
// auto strip #endif

// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_FLOAT3D_HXX
// auto strip #include <bf_svx/float3d.hxx>
// auto strip #endif
#ifndef _SVX_F3DCHILD_HXX
#include <bf_svx/f3dchild.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC //autogen
#include <bf_svx/dialogs.hrc>
#endif

// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"

#include "drviewsh.hxx"
// auto strip #include "drawdoc.hxx"
#include "docshell.hxx"
// auto strip #include "efctchld.hxx"
#include "effect.hxx"
// auto strip #include "anminfo.hxx"
// auto strip #include "unoaprms.hxx"                 // Undo-Action
// auto strip #include "sdundogr.hxx"                 // Undo Gruppe
//STRIP001 #include "preview.hxx"
// auto strip #include "prevchld.hxx"
//#include "3dchld.hxx"
//#include "3dfloat.hxx"
#include "drawview.hxx"
// auto strip #include "sdwindow.hxx"
namespace binfilter {

using namespace ::com::sun::star;

#define ATTR_MISSING    0       // Attribut nicht verfuegbar
#define ATTR_MIXED      1       // Attribut uneindeutig (bei Mehrfachselektion)
#define ATTR_SET        2       // Attribut eindeutig

#define ITEMVALUE(ItemSet,Id,Cast)	((const Cast&)(ItemSet).Get(Id)).GetValue()

/*************************************************************************
|*
|* SfxRequests fuer EffekteWindow bearbeiten
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::ExecEffectWin( SfxRequest& rReq )
/*N*/ {
/*N*/ 	CheckLineTo (rReq);
/*N*/ 
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 
/*N*/ 	switch( nSId )
/*N*/ 	{
/*?*/ 		case SID_EFFECT_INIT:
/*?*/ 		{
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			USHORT nId = SdEffectChildWindow::GetChildWindowId();
//STRIP001 /*?*/ 			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
//STRIP001 /*?*/ 			if( pWindow )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SdEffectWin* pEffectWin = (SdEffectWin*)( pWindow->GetWindow() );
//STRIP001 /*?*/ 				if( pEffectWin )
//STRIP001 /*?*/ 					pEffectWin->InitColorLB( pDoc );
//STRIP001 /*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_EFFECT_STATE:
/*?*/ 		{
/*?*/ 			UpdateEffectWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_EFFECT_ASSIGN:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 AssignFromEffectWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		// Diawechsel-Window
/*?*/ 		case SID_SLIDE_CHANGE_STATE:
/*?*/ 		{
/*?*/ 			UpdateSlideChangeWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_SLIDE_CHANGE_ASSIGN:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 AssignFromSlideChangeWindow();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_3D_INIT:
/*?*/ 		{
/*?*/ 			USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*?*/ 			SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*?*/ 			if( pWindow )
/*?*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = (Svx3DWin*)( pWindow->GetWindow() );
//STRIP001 /*?*/ 				if( p3DWin )
//STRIP001 /*?*/ 					p3DWin->InitColorLB( pDoc );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*N*/ 		case SID_3D_STATE:
/*N*/ 		{
/*N*/ 			Update3DWindow();
/*N*/ 		}
/*N*/ 		break;
/*?*/ 
/*?*/ 		case SID_3D_ASSIGN:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 AssignFrom3DWindow();
/*?*/ 		}
/*?*/ 		break;
/*N*/ 
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Statuswerte fuer EffekteWindow zurueckgeben
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::GetEffectWinState( SfxItemSet& rSet )
/*N*/ {
/*N*/ 	UINT32 nState = EFFECT_STATE_NONE;
/*N*/ 
/*N*/ 	const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*N*/ 	ULONG nCount = rMarkList.GetMarkCount();
/*N*/ 
/*N*/ 	if( nCount > 0 )
/*N*/ 	{
/*?*/ 		nState |= EFFECT_COUNT;
/*?*/ 
/*?*/ 		// Genau zwei Objekte ? -> Pfadeffekt moeglich ?
/*?*/ 		if( nCount == 2 )
/*?*/ 		{
/*?*/ 			SdrObject* pObject1 = rMarkList.GetMark(0)->GetObj();
/*?*/ 			SdrObject* pObject2 = rMarkList.GetMark(1)->GetObj();
/*?*/ 			SdrObjKind eKind1   = (SdrObjKind)pObject1->GetObjIdentifier();
/*?*/ 			SdrObjKind eKind2   = (SdrObjKind)pObject2->GetObjIdentifier();
/*?*/ 			//SdAnimationInfo* pInfo1 = pDoc->GetAnimationInfo(pObject1);
/*?*/ 			//SdAnimationInfo* pInfo2 = pDoc->GetAnimationInfo(pObject2);
/*?*/ 			//SdAnimationInfo* pInfo  = NULL;
/*?*/ 
/*?*/ 			if( ( ( pObject1->GetObjInventor() == SdrInventor &&
/*?*/ 				  ( eKind1 == OBJ_LINE) || (eKind1 == OBJ_PLIN) || (eKind1 == OBJ_PATHLINE) ) ||
/*?*/ 				  ( pObject2->GetObjInventor() == SdrInventor &&
/*?*/ 				  ( eKind2 == OBJ_LINE) || (eKind2 == OBJ_PLIN) || (eKind2 == OBJ_PATHLINE) ) ) &&
/*?*/ 				( pObject1->GetUpGroup() == pObject2->GetUpGroup() ) )
/*?*/ 			{
/*?*/ 				nState |= EFFECT_PATH;
/*?*/ 			}
/*?*/ 		}
/*?*/ 	}
/*N*/ 	rSet.Put( SfxUInt32Item( SID_EFFECT_STATE, nState ) );
/*N*/ }

/*************************************************************************
|*
|* EffekteWindow updaten
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::UpdateEffectWindow()
/*N*/ {
/*N*/ 	USHORT nId = SdEffectChildWindow::GetChildWindowId();
/*N*/ 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*N*/ 	if( pWindow )
/*N*/ 	{
		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		SdEffectWin* pEffectWin = (SdEffectWin*) pWindow->GetWindow();
//STRIP001 /*?*/ 		const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 /*?*/ 		ULONG nCount = rMarkList.GetMarkCount();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( pEffectWin && pEffectWin->IsUpdateMode() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/             if( nCount )
//STRIP001 /*?*/             {
//STRIP001 /*?*/ 			    // Der Code stammt aus fuoaprms.cxx und
//STRIP001 /*?*/ 			    // sollte verallgemeinert werden !!!
//STRIP001 /*?*/ 			    ULONG nObject	= 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    short nAnimationSet     = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nEffectSet        = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nTextEffectSet    = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nSpeedSet         = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nFadeColorSet     = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nFadeOutSet       = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nInvisibleSet     = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nSoundOnSet       = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nSoundFileSet     = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nPlayFullSet      = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nClickActionSet   = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nBookmarkSet      = ATTR_MISSING;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    short nSecondEffectSet      = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nSecondSpeedSet       = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nSecondSoundOnSet     = ATTR_MISSING;
//STRIP001 /*?*/ 			    short nSecondPlayFullSet    = ATTR_MISSING;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		    //    BOOL bDontKnow   = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 											    // defaulten (fuer Undo-Aktion)
//STRIP001 /*?*/ 			    presentation::AnimationEffect eEffect         = presentation::AnimationEffect_NONE;
//STRIP001 /*?*/ 			    presentation::AnimationEffect eTextEffect     = presentation::AnimationEffect_NONE;
//STRIP001 /*?*/ 			    presentation::AnimationSpeed  eSpeed          = presentation::AnimationSpeed_MEDIUM;
//STRIP001 /*?*/ 			    BOOL            bActive         = FALSE;
//STRIP001 /*?*/ 			    BOOL            bFadeOut        = FALSE;
//STRIP001 /*?*/ 			    Color           aFadeColor      = COL_LIGHTGRAY;
//STRIP001 /*?*/ 			    BOOL            bInvisible      = FALSE;
//STRIP001 /*?*/ 			    BOOL            bSoundOn        = FALSE;
//STRIP001 /*?*/ 			    String          aSound;
//STRIP001 /*?*/ 			    BOOL            bPlayFull       = FALSE;
//STRIP001 /*?*/ 			    presentation::ClickAction     eClickAction    = presentation::ClickAction_NONE;
//STRIP001 /*?*/ 			    String          aBookmark;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    presentation::AnimationEffect eSecondEffect   = presentation::AnimationEffect_NONE;
//STRIP001 /*?*/ 			    presentation::AnimationSpeed  eSecondSpeed    = presentation::AnimationSpeed_MEDIUM;
//STRIP001 /*?*/ 			    BOOL            bSecondSoundOn  = FALSE;
//STRIP001 /*?*/ 			    BOOL            bSecondPlayFull = FALSE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    SdAnimationInfo* pInfo;
//STRIP001 /*?*/ 			    SdrMark* pMark;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    // das erste Objekt untersuchen
//STRIP001 /*?*/ 			    pMark = rMarkList.GetMark(0);
//STRIP001 /*?*/ 			    SdrObject* pObject = pMark->GetObj();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    // find out, if there is any object, which contain text
//STRIP001 /*?*/ 			    BOOL bHasText = FALSE;
//STRIP001 /*?*/ 			    if( pObject->ISA(SdrTextObj) && ((SdrTextObj*)pObject)->HasText() && !((SdrTextObj*)pObject)->IsFontwork() )
//STRIP001 /*?*/ 				    bHasText = bHasText || TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 /*?*/ 			    if( pInfo )
//STRIP001 /*?*/ 			    {
//STRIP001 /*?*/ 				    bActive             = pInfo->bActive;
//STRIP001 /*?*/ 				    nAnimationSet       = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    eEffect             = pInfo->eEffect;
//STRIP001 /*?*/ 				    nEffectSet          = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    eTextEffect         = pInfo->eTextEffect;
//STRIP001 /*?*/ 				    nTextEffectSet      = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    eSpeed              = pInfo->eSpeed;
//STRIP001 /*?*/ 				    nSpeedSet           = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    bFadeOut            = pInfo->bDimPrevious;
//STRIP001 /*?*/ 				    nFadeOutSet         = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    aFadeColor          = pInfo->aDimColor;
//STRIP001 /*?*/ 				    nFadeColorSet       = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    bInvisible          = pInfo->bDimHide;
//STRIP001 /*?*/ 				    nInvisibleSet       = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    bSoundOn            = pInfo->bSoundOn;
//STRIP001 /*?*/ 				    nSoundOnSet         = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    aSound              = pInfo->aSoundFile;
//STRIP001 /*?*/ 				    nSoundFileSet       = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    bPlayFull           = pInfo->bPlayFull;
//STRIP001 /*?*/ 				    nPlayFullSet        = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    eClickAction        = pInfo->eClickAction;
//STRIP001 /*?*/ 				    nClickActionSet     = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    aBookmark           = pInfo->aBookmark;
//STRIP001 /*?*/ 				    nBookmarkSet        = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    eSecondEffect       = pInfo->eSecondEffect;
//STRIP001 /*?*/ 				    nSecondEffectSet    = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    eSecondSpeed        = pInfo->eSecondSpeed;
//STRIP001 /*?*/ 				    nSecondSpeedSet     = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    bSecondSoundOn      = pInfo->bSecondSoundOn;
//STRIP001 /*?*/ 				    nSecondSoundOnSet   = ATTR_SET;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    bSecondPlayFull     = pInfo->bSecondPlayFull;
//STRIP001 /*?*/ 				    nSecondPlayFullSet  = ATTR_SET;
//STRIP001 /*?*/ 			    }
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    // ggfs. weitere Objekte untersuchen
//STRIP001 /*?*/ 			    for( nObject = 1; nObject < nCount; nObject++ )
//STRIP001 /*?*/ 			    {
//STRIP001 /*?*/ 				    pMark = rMarkList.GetMark( nObject );
//STRIP001 /*?*/ 				    SdrObject* pObject = pMark->GetObj();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    if( pObject->ISA(SdrTextObj) && ((SdrTextObj*)pObject)->HasText() && !((SdrTextObj*)pObject)->IsFontwork() )
//STRIP001 /*?*/ 					    bHasText = bHasText || TRUE;
//STRIP001 /*?*/ 				    
//STRIP001 /*?*/ 				    pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 /*?*/ 				    if( pInfo )
//STRIP001 /*?*/ 				    {
//STRIP001 /*?*/ 					    if( bActive != pInfo->bActive )
//STRIP001 /*?*/ 						    nAnimationSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( eEffect != pInfo->eEffect )
//STRIP001 /*?*/ 						    nEffectSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( eTextEffect != pInfo->eTextEffect )
//STRIP001 /*?*/ 						    nTextEffectSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( eSpeed != pInfo->eSpeed )
//STRIP001 /*?*/ 						    nSpeedSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( bFadeOut != pInfo->bDimPrevious )
//STRIP001 /*?*/ 						    nFadeOutSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( aFadeColor != pInfo->aDimColor )
//STRIP001 /*?*/ 						    nFadeColorSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( bInvisible != pInfo->bDimHide )
//STRIP001 /*?*/ 						    nInvisibleSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( bSoundOn != pInfo->bSoundOn )
//STRIP001 /*?*/ 						    nSoundOnSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( aSound != pInfo->aSoundFile )
//STRIP001 /*?*/ 						    nSoundFileSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( bPlayFull != pInfo->bPlayFull )
//STRIP001 /*?*/ 						    nPlayFullSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( eClickAction != pInfo->eClickAction )
//STRIP001 /*?*/ 						    nClickActionSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( aBookmark != pInfo->aBookmark )
//STRIP001 /*?*/ 						    nBookmarkSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( eSecondEffect != pInfo->eSecondEffect )
//STRIP001 /*?*/ 						    nSecondEffectSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( eSecondSpeed != pInfo->eSecondSpeed )
//STRIP001 /*?*/ 						    nSecondSpeedSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( bSecondSoundOn != pInfo->bSecondSoundOn )
//STRIP001 /*?*/ 						    nSecondSoundOnSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if( bSecondPlayFull != pInfo->bSecondPlayFull )
//STRIP001 /*?*/ 						    nSecondPlayFullSet = ATTR_MIXED;
//STRIP001 /*?*/ 				    }
//STRIP001 /*?*/ 				    else
//STRIP001 /*?*/ 				    {
//STRIP001 /*?*/ 					    if (nAnimationSet == ATTR_SET && bActive == TRUE)
//STRIP001 /*?*/ 						    nAnimationSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nEffectSet == ATTR_SET && eEffect != presentation::AnimationEffect_NONE)
//STRIP001 /*?*/ 						    nEffectSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nTextEffectSet == ATTR_SET && eTextEffect != presentation::AnimationEffect_NONE)
//STRIP001 /*?*/ 						    nTextEffectSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nSpeedSet == ATTR_SET)
//STRIP001 /*?*/ 						    nSpeedSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nFadeOutSet == ATTR_SET && bFadeOut == TRUE)
//STRIP001 /*?*/ 						    nFadeOutSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nFadeColorSet == ATTR_SET)
//STRIP001 /*?*/ 						    nFadeColorSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nInvisibleSet == ATTR_SET && bInvisible == TRUE)
//STRIP001 /*?*/ 						    nInvisibleSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nSoundOnSet == ATTR_SET && bSoundOn == TRUE)
//STRIP001 /*?*/ 						    nSoundOnSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nSoundFileSet == ATTR_SET)
//STRIP001 /*?*/ 						    nSoundFileSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nPlayFullSet == ATTR_SET && bPlayFull == TRUE)
//STRIP001 /*?*/ 						    nPlayFullSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nClickActionSet == ATTR_SET && eClickAction != presentation::ClickAction_NONE)
//STRIP001 /*?*/ 						    nClickActionSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nBookmarkSet == ATTR_SET)
//STRIP001 /*?*/ 						    nBookmarkSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nSecondEffectSet == ATTR_SET && eSecondEffect != presentation::AnimationEffect_NONE)
//STRIP001 /*?*/ 						    nSecondEffectSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nSecondSpeedSet == ATTR_SET)
//STRIP001 /*?*/ 						    nSecondSpeedSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nSecondSoundOnSet == ATTR_SET && bSecondSoundOn == TRUE)
//STRIP001 /*?*/ 						    nSecondSoundOnSet = ATTR_MIXED;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					    if (nSecondPlayFullSet == ATTR_SET && bSecondPlayFull == TRUE)
//STRIP001 /*?*/ 						    nSecondPlayFullSet = ATTR_MIXED;
//STRIP001 /*?*/ 				    }
//STRIP001 /*?*/ 			    }
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    // Genau zwei Objekte mit Pfadeffekt? Dann gilt nur die Animationsinfo
//STRIP001 /*?*/ 			    // am bewegten Objekt.
//STRIP001 /*?*/ 			    if (nCount == 2)
//STRIP001 /*?*/ 			    {
//STRIP001 /*?*/ 				    SdrObject* pObject1 = rMarkList.GetMark(0)->GetObj();
//STRIP001 /*?*/ 				    SdrObject* pObject2 = rMarkList.GetMark(1)->GetObj();
//STRIP001 /*?*/ 				    SdrObjKind eKind1   = (SdrObjKind)pObject1->GetObjIdentifier();
//STRIP001 /*?*/ 				    SdrObjKind eKind2   = (SdrObjKind)pObject2->GetObjIdentifier();
//STRIP001 /*?*/ 				    SdAnimationInfo* pInfo1 = pDoc->GetAnimationInfo(pObject1);
//STRIP001 /*?*/ 				    SdAnimationInfo* pInfo2 = pDoc->GetAnimationInfo(pObject2);
//STRIP001 /*?*/ 				    SdAnimationInfo* pInfo  = NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    if (pObject1->GetObjInventor() == SdrInventor &&
//STRIP001 /*?*/ 					    ((eKind1 == OBJ_LINE) ||                        // 2-Punkt-Linie
//STRIP001 /*?*/ 						    (eKind1 == OBJ_PLIN) ||                        // Polygon
//STRIP001 /*?*/ 						    (eKind1 == OBJ_PATHLINE))                &&    // Bezier-Kurve
//STRIP001 /*?*/ 					    (pInfo2 && pInfo2->eEffect == presentation::AnimationEffect_PATH))
//STRIP001 /*?*/ 				    {
//STRIP001 /*?*/ 					    pInfo = pInfo2;
//STRIP001 /*?*/ 				    }
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    if (pObject2->GetObjInventor() == SdrInventor &&
//STRIP001 /*?*/ 					    ((eKind2 == OBJ_LINE) ||                        // 2-Punkt-Linie
//STRIP001 /*?*/ 						    (eKind2 == OBJ_PLIN) ||                        // Polygon
//STRIP001 /*?*/ 						    (eKind2 == OBJ_PATHLINE))                &&    // Bezier-Kurve
//STRIP001 /*?*/ 					    (pInfo1 && pInfo1->eEffect == presentation::AnimationEffect_PATH))
//STRIP001 /*?*/ 				    {
//STRIP001 /*?*/ 					    pInfo = pInfo1;
//STRIP001 /*?*/ 				    }
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				    if (pInfo)
//STRIP001 /*?*/ 				    {
//STRIP001 /*?*/ 					    bActive         = pInfo->bActive;          nAnimationSet       = ATTR_SET;
//STRIP001 /*?*/ 					    eEffect         = pInfo->eEffect;          nEffectSet          = ATTR_SET;
//STRIP001 /*?*/ 					    eTextEffect     = pInfo->eTextEffect;      nTextEffectSet      = ATTR_SET;
//STRIP001 /*?*/ 					    eSpeed          = pInfo->eSpeed;           nSpeedSet           = ATTR_SET;
//STRIP001 /*?*/ 					    bFadeOut        = pInfo->bDimPrevious;     nFadeOutSet         = ATTR_SET;
//STRIP001 /*?*/ 					    aFadeColor      = pInfo->aDimColor;        nFadeColorSet       = ATTR_SET;
//STRIP001 /*?*/ 					    bInvisible      = pInfo->bDimHide;         nInvisibleSet       = ATTR_SET;
//STRIP001 /*?*/ 					    bSoundOn        = pInfo->bSoundOn;         nSoundOnSet         = ATTR_SET;
//STRIP001 /*?*/ 					    aSound          = pInfo->aSoundFile;       nSoundFileSet       = ATTR_SET;
//STRIP001 /*?*/ 					    bPlayFull       = pInfo->bPlayFull;        nPlayFullSet        = ATTR_SET;
//STRIP001 /*?*/ 					    eClickAction    = pInfo->eClickAction;     nClickActionSet     = ATTR_SET;
//STRIP001 /*?*/ 					    aBookmark       = pInfo->aBookmark;        nBookmarkSet        = ATTR_SET;
//STRIP001 /*?*/ 					    eSecondEffect   = pInfo->eSecondEffect;    nSecondEffectSet    = ATTR_SET;
//STRIP001 /*?*/ 					    eSecondSpeed    = pInfo->eSecondSpeed;     nSecondSpeedSet     = ATTR_SET;
//STRIP001 /*?*/ 					    bSecondSoundOn  = pInfo->bSecondSoundOn;   nSecondSoundOnSet   = ATTR_SET;
//STRIP001 /*?*/ 					    bSecondPlayFull = pInfo->bSecondPlayFull;  nSecondPlayFullSet  = ATTR_SET;
//STRIP001 /*?*/ 				    }
//STRIP001 /*?*/ 			    }
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    // ItemSet fuer Dialog fuellen
//STRIP001 /*?*/ 			    SfxItemSet aSet(pDoc->GetPool(), ATTR_ANIMATION_START, ATTR_ACTION_END, 0);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    // das Set besetzen
//STRIP001 /*?*/ 			    if (nAnimationSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put( SfxBoolItem( ATTR_ANIMATION_ACTIVE, bActive));
//STRIP001 /*?*/ 			    else if (nAnimationSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_ACTIVE);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_ACTIVE, FALSE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nEffectSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ANIMATION_EFFECT, eEffect));
//STRIP001 /*?*/ 			    else if (nEffectSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem( ATTR_ANIMATION_EFFECT );
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ANIMATION_EFFECT, presentation::AnimationEffect_NONE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if( bHasText )
//STRIP001 /*?*/ 			    {
//STRIP001 /*?*/ 				    if (nTextEffectSet == ATTR_SET)
//STRIP001 /*?*/ 					    aSet.Put(SfxAllEnumItem(ATTR_ANIMATION_TEXTEFFECT, eTextEffect));
//STRIP001 /*?*/ 				    else if (nTextEffectSet == ATTR_MIXED)
//STRIP001 /*?*/ 					    aSet.InvalidateItem( ATTR_ANIMATION_TEXTEFFECT );
//STRIP001 /*?*/ 				    else
//STRIP001 /*?*/ 					    aSet.Put(SfxAllEnumItem(ATTR_ANIMATION_TEXTEFFECT, presentation::AnimationEffect_NONE));
//STRIP001 /*?*/ 			    }
//STRIP001 /*?*/                 else
//STRIP001 /*?*/                     aSet.DisableItem( ATTR_ANIMATION_TEXTEFFECT );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nSpeedSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ANIMATION_SPEED, eSpeed));
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_SPEED);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nFadeOutSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_FADEOUT, bFadeOut));
//STRIP001 /*?*/ 			    else if (nFadeOutSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_FADEOUT);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_FADEOUT, FALSE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nFadeColorSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SvxColorItem(aFadeColor, ATTR_ANIMATION_COLOR));
//STRIP001 /*?*/ 			    else if (nFadeColorSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_COLOR);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SvxColorItem( RGB_Color( COL_LIGHTGRAY ), ATTR_ANIMATION_COLOR));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nInvisibleSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_INVISIBLE, bInvisible));
//STRIP001 /*?*/ 			    else if (nInvisibleSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_INVISIBLE);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_INVISIBLE, FALSE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nSoundOnSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_SOUNDON, bSoundOn));
//STRIP001 /*?*/ 			    else if (nSoundOnSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_SOUNDON);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_SOUNDON, FALSE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nSoundFileSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxStringItem(ATTR_ANIMATION_SOUNDFILE, aSound));
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_SOUNDFILE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nPlayFullSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_PLAYFULL, bPlayFull));
//STRIP001 /*?*/ 			    else if (nPlayFullSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ANIMATION_PLAYFULL);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ANIMATION_PLAYFULL, FALSE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nClickActionSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ACTION, eClickAction));
//STRIP001 /*?*/ 			    else if (nClickActionSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ACTION);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ACTION, presentation::ClickAction_NONE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nBookmarkSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxStringItem(ATTR_ACTION_FILENAME, aBookmark));
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ACTION_FILENAME);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nSecondEffectSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ACTION_EFFECT, eSecondEffect));
//STRIP001 /*?*/ 			    else if (nSecondEffectSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem( ATTR_ACTION_EFFECT );
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ACTION_EFFECT, presentation::AnimationEffect_NONE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nSecondSpeedSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxAllEnumItem(ATTR_ACTION_EFFECTSPEED, eSecondSpeed));
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ACTION_EFFECTSPEED);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nSecondSoundOnSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ACTION_SOUNDON, bSecondSoundOn));
//STRIP001 /*?*/ 			    else if (nSecondSoundOnSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ACTION_SOUNDON);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ACTION_SOUNDON, FALSE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    if (nSecondPlayFullSet == ATTR_SET)
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ACTION_PLAYFULL, bSecondPlayFull));
//STRIP001 /*?*/ 			    else if (nPlayFullSet == ATTR_MIXED)
//STRIP001 /*?*/ 				    aSet.InvalidateItem(ATTR_ACTION_PLAYFULL);
//STRIP001 /*?*/ 			    else
//STRIP001 /*?*/ 				    aSet.Put(SfxBoolItem(ATTR_ACTION_PLAYFULL, FALSE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    //rSet.Put( SfxSetItem( SID_EFFECT_STATE, aSet ) );
//STRIP001 /*?*/ 			    pEffectWin->Update( aSet );
//STRIP001 /*?*/             }
//STRIP001 /*?*/ 		    else
//STRIP001 /*?*/ 		    {
//STRIP001 /*?*/ 			    SfxItemSet aSet(pDoc->GetPool(), ATTR_ANIMATION_EFFECT, ATTR_ANIMATION_TEXTEFFECT, 0);
//STRIP001 /*?*/ 			    aSet.Put(SfxAllEnumItem(ATTR_ANIMATION_EFFECT, presentation::AnimationEffect_NONE));
//STRIP001 /*?*/ 			    aSet.Put(SfxAllEnumItem(ATTR_ANIMATION_TEXTEFFECT, presentation::AnimationEffect_NONE));
//STRIP001 /*?*/ 			    pEffectWin->Update( aSet );
//STRIP001 /*?*/ 		    }
//STRIP001 /*?*/         }
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Vom EffekteWindow zuweisen
|*
\************************************************************************/

//STRIP001 void SdDrawViewShell::AssignFromEffectWindow()
//STRIP001 {
//STRIP001 	bInEffectAssignment = TRUE;
//STRIP001 
//STRIP001 	USHORT nId = SdEffectChildWindow::GetChildWindowId();
//STRIP001 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
//STRIP001 	if( pWindow )
//STRIP001 	{
//STRIP001 		GetViewFrame()->GetBindings().InvalidateAll( TRUE );
//STRIP001 
//STRIP001 		SdEffectWin* pEffectWin = (SdEffectWin*) pWindow->GetWindow();
//STRIP001 		const SdrMarkList& rMarkList = pDrView->GetMarkList();
//STRIP001 		ULONG nCount = rMarkList.GetMarkCount();
//STRIP001 		if( pEffectWin && nCount > 0 )
//STRIP001 		{
//STRIP001 			// Der Code stammt aus fuoaprms.cxx und
//STRIP001 			// sollte verallgemeinert werden !!!
//STRIP001 			ULONG nObject	= 0;
//STRIP001 
//STRIP001 			SfxUndoManager* pUndoMgr = GetViewFrame()->GetObjectShell()->
//STRIP001 										GetUndoManager();
//STRIP001 
//STRIP001 			short nAnimationSet     = ATTR_MISSING;
//STRIP001 			short nEffectSet        = ATTR_MISSING;
//STRIP001 			short nTextEffectSet    = ATTR_MISSING;
//STRIP001 			short nSpeedSet         = ATTR_MISSING;
//STRIP001 			short nFadeColorSet     = ATTR_MISSING;
//STRIP001 			short nFadeOutSet       = ATTR_MISSING;
//STRIP001 			short nInvisibleSet     = ATTR_MISSING;
//STRIP001 			short nSoundOnSet       = ATTR_MISSING;
//STRIP001 			short nSoundFileSet     = ATTR_MISSING;
//STRIP001 			short nPlayFullSet      = ATTR_MISSING;
//STRIP001 			short nClickActionSet   = ATTR_MISSING;
//STRIP001 			short nBookmarkSet      = ATTR_MISSING;
//STRIP001 
//STRIP001 			short nSecondEffectSet      = ATTR_MISSING;
//STRIP001 			short nSecondSpeedSet       = ATTR_MISSING;
//STRIP001 			short nSecondSoundOnSet     = ATTR_MISSING;
//STRIP001 			short nSecondPlayFullSet    = ATTR_MISSING;
//STRIP001 
//STRIP001 											// defaulten (fuer Undo-Aktion)
//STRIP001 			presentation::AnimationEffect eEffect         = presentation::AnimationEffect_NONE;
//STRIP001 			presentation::AnimationEffect eTextEffect     = presentation::AnimationEffect_NONE;
//STRIP001 			presentation::AnimationSpeed  eSpeed          = presentation::AnimationSpeed_MEDIUM;
//STRIP001 			BOOL            bActive         = FALSE;
//STRIP001 			BOOL            bFadeOut        = FALSE;
//STRIP001 			Color           aFadeColor      = COL_LIGHTGRAY;
//STRIP001 			BOOL            bInvisible      = FALSE;
//STRIP001 			BOOL            bSoundOn        = FALSE;
//STRIP001 			String          aSound;
//STRIP001 			BOOL            bPlayFull       = FALSE;
//STRIP001 			presentation::ClickAction     eClickAction    = presentation::ClickAction_NONE;
//STRIP001 			String          aBookmark;
//STRIP001 
//STRIP001 			presentation::AnimationEffect eSecondEffect   = presentation::AnimationEffect_NONE;
//STRIP001 			presentation::AnimationSpeed  eSecondSpeed    = presentation::AnimationSpeed_MEDIUM;
//STRIP001 			BOOL            bSecondSoundOn  = FALSE;
//STRIP001 			BOOL            bSecondPlayFull = FALSE;
//STRIP001 
//STRIP001 
//STRIP001 			SdAnimationInfo* pInfo = NULL;
//STRIP001 
//STRIP001 			SfxItemSet aSet(pDoc->GetPool(), ATTR_ANIMATION_START, ATTR_ACTION_END, 0);
//STRIP001 			pEffectWin->GetAttr( aSet );
//STRIP001 
//STRIP001 			// Auswertung des ItemSets
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_ACTIVE) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				bActive = ((SfxBoolItem&)aSet.Get(ATTR_ANIMATION_ACTIVE)).GetValue();
//STRIP001 				nAnimationSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nAnimationSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_EFFECT) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				eEffect = (presentation::AnimationEffect)((SfxAllEnumItem&) aSet.
//STRIP001 							Get(ATTR_ANIMATION_EFFECT)).GetValue();
//STRIP001 				nEffectSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nEffectSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_TEXTEFFECT) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				eTextEffect = (presentation::AnimationEffect)((SfxAllEnumItem&) aSet.
//STRIP001 							   Get(ATTR_ANIMATION_TEXTEFFECT)).GetValue();
//STRIP001 				nTextEffectSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nTextEffectSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_SPEED) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				eSpeed  = (presentation::AnimationSpeed)((SfxAllEnumItem&) aSet.
//STRIP001 							Get(ATTR_ANIMATION_SPEED)).GetValue();
//STRIP001 				nSpeedSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nSpeedSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_FADEOUT) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				bFadeOut = ((SfxBoolItem&)aSet.Get(ATTR_ANIMATION_FADEOUT)).GetValue();
//STRIP001 				nFadeOutSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nFadeOutSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_INVISIBLE) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				bInvisible = ((SfxBoolItem&)aSet.Get(ATTR_ANIMATION_INVISIBLE)).GetValue();
//STRIP001 				nInvisibleSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nInvisibleSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_SOUNDON) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				bSoundOn = ((SfxBoolItem&)aSet.Get(ATTR_ANIMATION_SOUNDON)).GetValue();
//STRIP001 				nSoundOnSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nSoundOnSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_SOUNDFILE) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				aSound =  ((SfxStringItem&)aSet.Get(ATTR_ANIMATION_SOUNDFILE)).GetValue();
//STRIP001 				nSoundFileSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nSoundFileSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_COLOR) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				aFadeColor = ((SvxColorItem&)aSet.Get(ATTR_ANIMATION_COLOR)).GetValue();
//STRIP001 				nFadeColorSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nFadeColorSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ANIMATION_PLAYFULL) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				bPlayFull = ((SfxBoolItem&)aSet.Get(ATTR_ANIMATION_PLAYFULL)).GetValue();
//STRIP001 				nPlayFullSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nPlayFullSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ACTION) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				eClickAction = (presentation::ClickAction)((SfxAllEnumItem&)aSet.
//STRIP001 							Get(ATTR_ACTION)).GetValue();
//STRIP001 				nClickActionSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nClickActionSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ACTION_FILENAME) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				aBookmark = ((SfxStringItem&)aSet.
//STRIP001 								Get(ATTR_ACTION_FILENAME)).GetValue();
//STRIP001 				nBookmarkSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nBookmarkSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ACTION_EFFECT) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				eSecondEffect = (presentation::AnimationEffect)((SfxAllEnumItem&) aSet.
//STRIP001 							Get(ATTR_ACTION_EFFECT)).GetValue();
//STRIP001 				nSecondEffectSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nSecondEffectSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ACTION_EFFECTSPEED) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				eSecondSpeed  = (presentation::AnimationSpeed)((SfxAllEnumItem&) aSet.
//STRIP001 							Get(ATTR_ACTION_EFFECTSPEED)).GetValue();
//STRIP001 				nSecondSpeedSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nSecondSpeedSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ACTION_SOUNDON) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				bSecondSoundOn = ((SfxBoolItem&)aSet.Get(ATTR_ACTION_SOUNDON)).GetValue();
//STRIP001 				nSecondSoundOnSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nSecondSoundOnSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			if (aSet.GetItemState(ATTR_ACTION_PLAYFULL) == SFX_ITEM_SET)
//STRIP001 			{
//STRIP001 				bSecondPlayFull = ((SfxBoolItem&)aSet.Get(ATTR_ACTION_PLAYFULL)).GetValue();
//STRIP001 				nSecondPlayFullSet = ATTR_SET;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nSecondPlayFullSet = ATTR_MISSING;
//STRIP001 
//STRIP001 			// Wenn irgendwelche Attribute ausgewaehlt wurden
//STRIP001 			if (nEffectSet         == ATTR_SET  ||
//STRIP001 				nTextEffectSet     == ATTR_SET  ||
//STRIP001 				nSpeedSet          == ATTR_SET  ||
//STRIP001 				nAnimationSet      == ATTR_SET  ||
//STRIP001 				nFadeOutSet        == ATTR_SET  ||
//STRIP001 				nFadeColorSet      == ATTR_SET  ||
//STRIP001 				nInvisibleSet      == ATTR_SET  ||
//STRIP001 				nSoundOnSet        == ATTR_SET  ||
//STRIP001 				nSoundFileSet      == ATTR_SET  ||
//STRIP001 				nPlayFullSet       == ATTR_SET  ||
//STRIP001 				nClickActionSet    == ATTR_SET  ||
//STRIP001 				nBookmarkSet       == ATTR_SET  ||
//STRIP001 				nSecondEffectSet   == ATTR_SET  ||
//STRIP001 				nSecondSpeedSet    == ATTR_SET  ||
//STRIP001 				nSecondSoundOnSet  == ATTR_SET  ||
//STRIP001 				nSecondPlayFullSet == ATTR_SET)
//STRIP001 			{
//STRIP001 				// String fuer Undo-Group und List-Action
//STRIP001 				String aComment(SdResId(STR_UNDO_ANIMATION));
//STRIP001 
//STRIP001 				// bei 'an Kurve entlang' gibt's noch eine extra UndoAction, darum
//STRIP001 				// hier klammern
//STRIP001 				pUndoMgr->EnterListAction(aComment, aComment);
//STRIP001 
//STRIP001 				// Undo Gruppe erzeugen
//STRIP001 				SdUndoGroup* pUndoGroup = new SdUndoGroup(pDoc);
//STRIP001 				pUndoGroup->SetComment(aComment);
//STRIP001 
//STRIP001 
//STRIP001 				// fuer den Pfad-Effekt einige Dinge merken
//STRIP001 				SdrObject*  pRunningObj = NULL;
//STRIP001 				SdrPathObj* pPath       = NULL;
//STRIP001 				if( eEffect == presentation::AnimationEffect_PATH &&
//STRIP001 					nEffectSet == ATTR_SET &&
//STRIP001 					nCount == 2 )
//STRIP001 				{
//STRIP001 					//DBG_ASSERT(nCount == 2, "dieser Effekt braucht genau 2 selektierte Objekte");
//STRIP001 					SdrObject* pObject1 = rMarkList.GetMark(0)->GetObj();
//STRIP001 					SdrObject* pObject2 = rMarkList.GetMark(1)->GetObj();
//STRIP001 					SdrObjKind eKind1   = (SdrObjKind)pObject1->GetObjIdentifier();
//STRIP001 					SdrObjKind eKind2   = (SdrObjKind)pObject2->GetObjIdentifier();
//STRIP001 
//STRIP001 					if (pObject1->GetObjInventor() == SdrInventor &&
//STRIP001 						((eKind1 == OBJ_LINE) ||        // 2-Punkt-Linie
//STRIP001 						 (eKind1 == OBJ_PLIN) ||        // Polygon
//STRIP001 						 (eKind1 == OBJ_PATHLINE)))     // Bezier-Kurve
//STRIP001 					{
//STRIP001 						pPath = (SdrPathObj*)pObject1;
//STRIP001 						pRunningObj = pObject2;
//STRIP001 					}
//STRIP001 
//STRIP001 					if (pObject2->GetObjInventor() == SdrInventor &&
//STRIP001 						((eKind2 == OBJ_LINE) ||        // 2-Punkt-Linie
//STRIP001 						 (eKind2 == OBJ_PLIN) ||        // Polygon
//STRIP001 						 (eKind2 == OBJ_PATHLINE)))     // Bezier-Kurve
//STRIP001 					{
//STRIP001 						pPath = (SdrPathObj*)pObject2;
//STRIP001 						pRunningObj = pObject1;
//STRIP001 					}
//STRIP001 
//STRIP001 					//DBG_ASSERT(pPath, "keine Kurve gefunden");
//STRIP001 					if( pPath )
//STRIP001 					{
//STRIP001 						// das laufende Objekt auf das Kurvenende schieben
//STRIP001 						Rectangle aCurRect(pRunningObj->GetLogicRect());
//STRIP001 						Point     aCurCenter(aCurRect.Center());
//STRIP001 						const XPolyPolygon& rXPP = pPath->GetPathPoly();
//STRIP001 						USHORT nNoOfXPoly = rXPP.Count();
//STRIP001 						const XPolygon& rXPoly = rXPP.GetObject(nNoOfXPoly - 1);
//STRIP001 						USHORT nPoints = rXPoly.GetPointCount();
//STRIP001 						Point aNewCenter(rXPoly[nPoints - 1]);
//STRIP001 						Size aDistance(aNewCenter.X() - aCurCenter.X(),
//STRIP001 									   aNewCenter.Y() - aCurCenter.Y());
//STRIP001 						pRunningObj->Move(aDistance);
//STRIP001 
//STRIP001 						SdrUndoMoveObj* pUndoAction = new SdrUndoMoveObj(*pRunningObj,
//STRIP001 																		 aDistance);
//STRIP001 						pUndoMgr->AddUndoAction(pUndoAction);
//STRIP001 					}
//STRIP001 					// Effect wird wieder auf DontCare gesetzt
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nEffectSet = ATTR_MISSING;
//STRIP001 						eEffect	   = presentation::AnimationEffect_NONE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				for (nObject = 0; nObject < nCount; nObject++)
//STRIP001 				{
//STRIP001 					SdrObject* pObject = rMarkList.GetMark(nObject)->GetObj();
//STRIP001 
//STRIP001 					pInfo = pDoc->GetAnimationInfo(pObject);
//STRIP001 
//STRIP001 					BOOL bCreated = FALSE;
//STRIP001 					if( !pInfo )
//STRIP001 					{
//STRIP001 						pInfo = new SdAnimationInfo(pDoc);
//STRIP001 						pObject->InsertUserData( pInfo );
//STRIP001 						bCreated = TRUE;
//STRIP001 					}
//STRIP001 
//STRIP001 					// das Pfadobjekt fuer 'an Kurve entlang'?
//STRIP001 					if (eEffect == presentation::AnimationEffect_PATH && pObject == pPath)
//STRIP001 					{
//STRIP001 						SdAnimationPrmsUndoAction* pAction = new SdAnimationPrmsUndoAction
//STRIP001 														(pDoc, pObject, bCreated);
//STRIP001 						pAction->SetActive(pInfo->bActive, pInfo->bActive);
//STRIP001 						pAction->SetEffect(pInfo->eEffect, pInfo->eEffect);
//STRIP001 						pAction->SetTextEffect(pInfo->eTextEffect, pInfo->eTextEffect);
//STRIP001 						pAction->SetSpeed(pInfo->eSpeed, pInfo->eSpeed);
//STRIP001 						pAction->SetDim(pInfo->bDimPrevious, pInfo->bDimPrevious);
//STRIP001 						pAction->SetDimColor(pInfo->aDimColor, pInfo->aDimColor);
//STRIP001 						pAction->SetDimHide(pInfo->bDimHide, pInfo->bDimHide);
//STRIP001 						pAction->SetSoundOn(pInfo->bSoundOn, pInfo->bSoundOn);
//STRIP001 						pAction->SetSound(pInfo->aSoundFile, pInfo->aSoundFile);
//STRIP001 						pAction->SetPlayFull(pInfo->bPlayFull, pInfo->bPlayFull);
//STRIP001 						pAction->SetPathObj(pInfo->pPathObj, pInfo->pPathObj);
//STRIP001 						pAction->SetClickAction(pInfo->eClickAction, pInfo->eClickAction);
//STRIP001 						pAction->SetBookmark(pInfo->aBookmark, pInfo->aBookmark);
//STRIP001 						pAction->SetInvisibleInPres(pInfo->bInvisibleInPresentation, TRUE);
//STRIP001 						pAction->SetVerb(pInfo->nVerb, pInfo->nVerb);
//STRIP001 						pAction->SetPresOrder(pInfo->nPresOrder, pInfo->nPresOrder);
//STRIP001 						pAction->SetSecondEffect(pInfo->eSecondEffect, pInfo->eSecondEffect);
//STRIP001 						pAction->SetSecondSpeed(pInfo->eSecondSpeed, pInfo->eSecondSpeed);
//STRIP001 						pAction->SetSecondSoundOn(pInfo->bSecondSoundOn, pInfo->bSecondSoundOn);
//STRIP001 						pAction->SetSecondPlayFull(pInfo->bSecondPlayFull, pInfo->bSecondPlayFull);
//STRIP001 						pUndoGroup->AddAction(pAction);
//STRIP001 
//STRIP001 						pInfo->bInvisibleInPresentation = TRUE;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 
//STRIP001 						// Undo-Action mit alten und neuen Groessen erzeugen
//STRIP001 						SdAnimationPrmsUndoAction* pAction = new SdAnimationPrmsUndoAction
//STRIP001 														(pDoc, pObject, bCreated);
//STRIP001 						pAction->SetActive(pInfo->bActive, bActive);
//STRIP001 						pAction->SetEffect(pInfo->eEffect, eEffect);
//STRIP001 						pAction->SetTextEffect(pInfo->eTextEffect, eTextEffect);
//STRIP001 						pAction->SetSpeed(pInfo->eSpeed, eSpeed);
//STRIP001 						pAction->SetDim(pInfo->bDimPrevious, bFadeOut);
//STRIP001 						pAction->SetDimColor(pInfo->aDimColor, aFadeColor);
//STRIP001 						pAction->SetDimHide(pInfo->bDimHide, bInvisible);
//STRIP001 						pAction->SetSoundOn(pInfo->bSoundOn, bSoundOn);
//STRIP001 						pAction->SetSound(pInfo->aSoundFile, aSound);
//STRIP001 						pAction->SetPlayFull(pInfo->bPlayFull, bPlayFull);
//STRIP001 						pAction->SetPathObj(pInfo->pPathObj, pPath);
//STRIP001 						pAction->SetClickAction(pInfo->eClickAction, eClickAction);
//STRIP001 						pAction->SetBookmark(pInfo->aBookmark, aBookmark);
//STRIP001 						pAction->SetInvisibleInPres(pInfo->bInvisibleInPresentation,
//STRIP001 													pInfo->bInvisibleInPresentation);
//STRIP001 						pAction->SetVerb(pInfo->nVerb, (USHORT)(pInfo->aBookmark).ToInt32());
//STRIP001 						pAction->SetPresOrder(pInfo->nPresOrder, pInfo->nPresOrder);
//STRIP001 						pAction->SetSecondEffect(pInfo->eSecondEffect, eSecondEffect);
//STRIP001 						pAction->SetSecondSpeed(pInfo->eSecondSpeed, eSecondSpeed);
//STRIP001 						pAction->SetSecondSoundOn(pInfo->bSecondSoundOn, bSecondSoundOn);
//STRIP001 						pAction->SetSecondPlayFull(pInfo->bSecondPlayFull,bSecondPlayFull);
//STRIP001 						pUndoGroup->AddAction(pAction);
//STRIP001 
//STRIP001 						// neue Werte am Infoblock des Objekts eintragen
//STRIP001 						if (nAnimationSet == ATTR_SET)
//STRIP001 							pInfo->bActive = bActive;
//STRIP001 
//STRIP001 						if (nEffectSet == ATTR_SET)
//STRIP001 							pInfo->eEffect = eEffect;
//STRIP001 
//STRIP001 						if (nTextEffectSet == ATTR_SET)
//STRIP001 							pInfo->eTextEffect = eTextEffect;
//STRIP001 
//STRIP001 						if (nSpeedSet == ATTR_SET)
//STRIP001 							pInfo->eSpeed = eSpeed;
//STRIP001 
//STRIP001 						if (nFadeOutSet == ATTR_SET)
//STRIP001 							pInfo->bDimPrevious = bFadeOut;
//STRIP001 
//STRIP001 						if (nFadeColorSet == ATTR_SET)
//STRIP001 							pInfo->aDimColor = aFadeColor;
//STRIP001 
//STRIP001 						if (nInvisibleSet == ATTR_SET)
//STRIP001 							pInfo->bDimHide = bInvisible;
//STRIP001 
//STRIP001 						if (nSoundOnSet == ATTR_SET)
//STRIP001 							pInfo->bSoundOn = bSoundOn;
//STRIP001 
//STRIP001 						if (nSoundFileSet == ATTR_SET)
//STRIP001 							pInfo->aSoundFile = aSound;
//STRIP001 
//STRIP001 						if (nPlayFullSet == ATTR_SET)
//STRIP001 							pInfo->bPlayFull = bPlayFull;
//STRIP001 
//STRIP001 						if (nClickActionSet == ATTR_SET)
//STRIP001 							pInfo->eClickAction = eClickAction;
//STRIP001 
//STRIP001 						if (nBookmarkSet == ATTR_SET)
//STRIP001 							pInfo->aBookmark = aBookmark;
//STRIP001 
//STRIP001 						if (nSecondEffectSet == ATTR_SET)
//STRIP001 							pInfo->eSecondEffect = eSecondEffect;
//STRIP001 
//STRIP001 						if (nSecondSpeedSet == ATTR_SET)
//STRIP001 							pInfo->eSecondSpeed = eSecondSpeed;
//STRIP001 
//STRIP001 						if (nSecondSoundOnSet == ATTR_SET)
//STRIP001 							pInfo->bSecondSoundOn = bSecondSoundOn;
//STRIP001 
//STRIP001 						if (nSecondPlayFullSet == ATTR_SET)
//STRIP001 							pInfo->bSecondPlayFull = bSecondPlayFull;
//STRIP001 
//STRIP001 						// noch ein paar Spezialitaeten
//STRIP001 						if (eEffect == presentation::AnimationEffect_PATH && nEffectSet == ATTR_SET)
//STRIP001 							pInfo->SetPath(pPath);
//STRIP001 						else
//STRIP001 							pInfo->SetPath(NULL);
//STRIP001 
//STRIP001 						if (eClickAction == presentation::ClickAction_VERB)
//STRIP001 							pInfo->nVerb = (USHORT)(aBookmark.ToInt32());
//STRIP001 				
//STRIP001 						pInfo->bInvisibleInPresentation = FALSE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				// Undo Gruppe dem Undo Manager uebergeben
//STRIP001 				pUndoMgr->AddUndoAction(pUndoGroup);
//STRIP001 				pUndoMgr->LeaveListAction();
//STRIP001 
//STRIP001 				// Model geaendert
//STRIP001 				pDoc->SetChanged();
//STRIP001 
//STRIP001 				/*******************************************************
//STRIP001 				|* ggfs. in Preview anzeigen
//STRIP001 				\******************************************************/
//STRIP001 				SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
//STRIP001 				
//STRIP001                 if( pPreviewChildWindow && ePageKind != PK_HANDOUT )
//STRIP001 				{
//STRIP001 					SdPreviewWin* pPreviewWin = (SdPreviewWin*) pPreviewChildWindow->GetWindow();
//STRIP001 					
//STRIP001                     if( pPreviewWin && pPreviewWin->GetDoc() == pDoc )
//STRIP001 					{
//STRIP001 						for( nObject = 0; nObject < nCount; nObject++ )
//STRIP001 						{
//STRIP001                             if( rMarkList.GetMark( nObject ) )
//STRIP001                             {
//STRIP001 							    SdrObject* pObject = rMarkList.GetMark( nObject )->GetObj();
//STRIP001 
//STRIP001                                 if( pObject )
//STRIP001                                 {
//STRIP001 							        pInfo = pDoc->GetAnimationInfo( pObject );
//STRIP001 							        
//STRIP001                                     if( pInfo && !( eEffect == presentation::AnimationEffect_PATH && pObject == pPath ) )
//STRIP001     						            pPreviewWin->HideAndAnimateObject( pObject );
//STRIP001                                 }
//STRIP001                             }
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	bInEffectAssignment = FALSE;
//STRIP001 	GetViewFrame()->GetBindings().InvalidateAll( TRUE );
//STRIP001 }

/*************************************************************************
|*
|* 3D - Assign / Update
|*
\************************************************************************/
/*N*/ void SdDrawViewShell::Update3DWindow()
/*N*/ {
/*N*/ 	USHORT nId = Svx3DChildWindow::GetChildWindowId();
/*N*/ 	SfxChildWindow* pWindow = GetViewFrame()->GetChildWindow( nId );
/*N*/ 	if( pWindow )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Svx3DWin* p3DWin = (Svx3DWin*) pWindow->GetWindow();
//STRIP001 /*?*/ 		if( p3DWin && p3DWin->IsUpdateMode() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			SfxItemSet aTmpItemSet = pView->Get3DAttributes();
//STRIP001 /*?*/ 			p3DWin->Update( aTmpItemSet );
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ }

/*----------------------------------------------------------------------------*/

#pragma optimize ( "", off )

//STRIP001 void SdDrawViewShell::AssignFrom3DWindow()
//STRIP001 {
//STRIP001 	USHORT nId = Svx3DChildWindow::GetChildWindowId();
//STRIP001 	SfxChildWindow* pWin = GetViewFrame()->GetChildWindow( nId );
//STRIP001 	if( pWin )
//STRIP001 	{
//STRIP001 		Svx3DWin* p3DWin = (Svx3DWin*) pWin->GetWindow();
//STRIP001 		if( p3DWin )
//STRIP001 		{
//STRIP001 			if(!pView->IsPresObjSelected())
//STRIP001 			{
//STRIP001 				SfxItemSet aSet( pDoc->GetPool(),
//STRIP001 					SDRATTR_START,	SDRATTR_END,
//STRIP001 					0, 0);
//STRIP001 				p3DWin->GetAttr( aSet );
//STRIP001 
//STRIP001 				// Eigene UNDO-Klammerung auch um die Wandlung in 3D
//STRIP001 				pView->BegUndo(String(SdResId(STR_UNDO_APPLY_3D_FAVOURITE)));
//STRIP001 
//STRIP001 				if(pView->IsConvertTo3DObjPossible())
//STRIP001 				{
//STRIP001 					// Nur TextAttribute zuweisen
//STRIP001 					SfxItemSet aTextSet( pDoc->GetPool(),
//STRIP001 						EE_ITEMS_START,	EE_ITEMS_END, 0 );
//STRIP001 					aTextSet.Put( aSet, FALSE );
//STRIP001 					pView->SetAttributes( aTextSet );
//STRIP001 
//STRIP001 					// Text in 3D umwandeln
//STRIP001 					USHORT nSId = SID_CONVERT_TO_3D;
//STRIP001 					SfxBoolItem aItem( nSId, TRUE );
//STRIP001 					GetViewFrame()->GetDispatcher()->Execute( 
//STRIP001 						nSId, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001 					// Feststellen, ob ein FILL_Attribut gesetzt ist.
//STRIP001 					// Falls nicht, Fuellattribut hart setzen
//STRIP001 					XFillStyle eFillStyle = ITEMVALUE( aSet, XATTR_FILLSTYLE, XFillStyleItem );
//STRIP001 					if(eFillStyle == XFILL_NONE)
//STRIP001 						aSet.Put(XFillStyleItem (XFILL_SOLID));
//STRIP001 
//STRIP001 					// remove some 3DSCENE attributes since these were
//STRIP001 					// created by convert to 3D and may not be changed
//STRIP001 					// to the defaults again.
//STRIP001 					aSet.ClearItem(SDRATTR_3DSCENE_DISTANCE);
//STRIP001 					aSet.ClearItem(SDRATTR_3DSCENE_FOCAL_LENGTH);
//STRIP001 					aSet.ClearItem(SDRATTR_3DOBJ_DEPTH);
//STRIP001 				}
//STRIP001 
//STRIP001 				// Attribute zuweisen
//STRIP001 				pView->Set3DAttributes( aSet );
//STRIP001 
//STRIP001 				// Ende UNDO
//STRIP001 				pView->EndUndo();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				InfoBox(pWindow, String(SdResId(STR_ACTION_NOTPOSSIBLE))).Execute();
//STRIP001 			}
//STRIP001 
//STRIP001 			// Focus zurueckholen
//STRIP001 			pWindow->GrabFocus();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

#pragma optimize ( "", on )


}
