/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mover.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:56:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//STRIP001 #ifndef _SD_MOVER_HXX
//STRIP001 #define _SD_MOVER_HXX

//STRIP001 #include "movedef.hxx"
//STRIP001 #include "sdmtf.hxx"
//STRIP001 #include "speedctl.hxx"

// -----------------
// - SdBitmapMover -
// -----------------

//STRIP001 class XPolyPolygon;
//STRIP001 class GDIMetaFile;
//STRIP001 class FuSlideShow;
//STRIP001 class SdMetaFile;

//STRIP001 class SdBitmapMover
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FuSlideShow*		pFuSlideShow;
//STRIP001 	Window* 			pWin;
//STRIP001 	List*				pListOfImages;
//STRIP001 	OutputDevice*		pInitDev;
//STRIP001 	BitmapEx*			pTopLayer;
//STRIP001 	SdMetaFile**		ppTopMtf;
//STRIP001 	Polygon*			pPolygon;
//STRIP001 	Marker				aObjStartMarker;
//STRIP001 	Marker				aObjEndMarker;
//STRIP001 	Region				aClip;
//STRIP001 	ULONG				nMulti;
//STRIP001 	ULONG				nMagic;
//STRIP001 	MoveSpeed			eSpeed;
//STRIP001 	MoverSpeedControl	aCtrl;
//STRIP001 	double				mfStartScaleX;
//STRIP001 	double				mfStartScaleY;
//STRIP001 	double				mfEndScaleX;
//STRIP001 	double				mfEndScaleY;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						SdBitmapMover( Window* pWindow, FuSlideShow* pFu );
//STRIP001 	virtual				~SdBitmapMover();
//STRIP001 						
//STRIP001 	void				SetPath( const XPolyPolygon& rXPolyPolygon, 
//STRIP001 								 const double* pStartScaleX = NULL, const double* pEndScaleX = NULL,
//STRIP001 								 const double* pStartScaleY = NULL, const double* pEndScaleY = NULL );
//STRIP001 	void				SetPath( const Point& rStart, const Point& rEnd,
//STRIP001 								 const double* pStartScaleX = NULL, const double* pEndScaleX = NULL,
//STRIP001 								 const double* pStartScaleY = NULL, const double* pEndScaleY = NULL );
//STRIP001 						
//STRIP001 						// oberen Layer ueber TopLayer-BitmapEx zeichen
//STRIP001 	void				SetGraphicInfo ( OutputDevice* pInitDevice, BitmapEx* _pTopLayer )
//STRIP001 						{
//STRIP001 							pInitDev = pInitDevice;
//STRIP001 							pTopLayer = _pTopLayer;
//STRIP001 							ppTopMtf = NULL; 
//STRIP001 						}
//STRIP001 						
//STRIP001 						// oberen Layer ueber Metafile ab dem Ende-Marker zeichen
//STRIP001 	void				SetGraphicInfo( OutputDevice* pInitDevice, SdMetaFile** _ppTopMtf, 
//STRIP001 										const Marker& rObjStartMarker, const Marker& rObjEndMarker )
//STRIP001 						{
//STRIP001 							pInitDev = pInitDevice;
//STRIP001 							pTopLayer = NULL;
//STRIP001 							ppTopMtf = _ppTopMtf;
//STRIP001 							aObjStartMarker = rObjStartMarker;
//STRIP001 							aObjEndMarker = rObjEndMarker; 
//STRIP001 						}
//STRIP001 						
//STRIP001 	void				SetWindow (Window* pWindow) { pWin = pWindow; }
//STRIP001 	Window* 			GetWindow() const { return pWin; }
//STRIP001 						
//STRIP001 	void				SetSpeed( MoveSpeed eNewSpeed, ULONG nNewMulti = 1UL) { eSpeed = eNewSpeed; nMulti = nNewMulti; }
//STRIP001 	MoveSpeed			GetSpeed() const { return eSpeed; }
//STRIP001 						
//STRIP001 	void				SetClipRegion(const Region& rR) { aClip = rR; }
//STRIP001 	Region				GetClipRegion() const { return aClip; }
//STRIP001 						
//STRIP001 	void				SetListOfImages(List* pList) { pListOfImages = pList; }
//STRIP001 	void				Terminate() { aCtrl.Terminate(); nMagic = 0UL; }
//STRIP001 						
//STRIP001 public:					
//STRIP001 						
//STRIP001 	BOOL				Move();
//STRIP001 };


//STRIP001 #endif // _SD_MOVER_HXX

