/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_effcthlp.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:53:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
// auto strip #include <com/sun/star/presentation/AnimationEffect.hpp>
// auto strip #endif

#include <time.h>			// fuer clock_t, clock(), CLOCKS_PER_SEC

// auto strip #include <bf_svx/gallery.hxx>
// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif

// auto strip #ifndef _XTABLE_HXX //autogen
// auto strip #include <bf_svx/xtable.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

// auto strip #include <svtools/pathoptions.hxx>

// auto strip #include "effect.hxx"
#include "effect.hrc"
#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
// auto strip #include "sdattr.hxx"
// auto strip #include "sdresid.hxx"
// auto strip #include "sdview.hxx"
#include "drawdoc.hxx"
// auto strip #include "filedlg.hxx"
namespace binfilter {


using namespace ::com::sun::star;

// -----------------------------------------------------------------------

//STRIP001 void SdEffectWin::SetAnimationEffect( presentation::AnimationEffect eAE, ValueSet* pValueSet )
//STRIP001 {
//STRIP001 	USHORT nLB = 0, nVS = 0;
//STRIP001 	String aStr( aLbSound.GetSelectEntry() );
//STRIP001 	USHORT nSoundId = GetIdBySound( aStr );
//STRIP001 
//STRIP001 	switch( eAE )
//STRIP001 	{
//STRIP001 		// Kein Effekt
//STRIP001 		case presentation::AnimationEffect_NONE:						nLB = 0; nVS = 1; break;
//STRIP001 
//STRIP001 		// Ueberblenden
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_LEFT:				nLB = 1; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_UPPERLEFT:			nLB = 1; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_TOP:				nLB = 1; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_UPPERRIGHT:		nLB = 1; nVS = 3; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_RIGHT:				nLB = 1; nVS = 6; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_LOWERRIGHT:		nLB = 1; nVS = 9; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_BOTTOM:			nLB = 1; nVS = 8; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_LOWERLEFT:			nLB = 1; nVS = 7; break;
//STRIP001 
//STRIP001 		// Aufdecken
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_LEFT:
//STRIP001 			if( nSoundId == 2 && pValueSet == &aCtlEffect ) // Favorit
//STRIP001 				{ nLB = 0; nVS = nSoundId; }
//STRIP001 			else
//STRIP001 				{ nLB = 2; nVS = 4; }
//STRIP001 			break;
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_TOP:
//STRIP001 			if( nSoundId == 5 && pValueSet == &aCtlEffect ) // Favorit
//STRIP001 				{ nLB = 0; nVS = nSoundId; }
//STRIP001 			else if( nSoundId == 6 && pValueSet == &aCtlTextEffect ) // Favorit (Text)
//STRIP001 				{ nLB = 0; nVS = nSoundId; pValueSet = &aCtlEffect; }
//STRIP001 			else
//STRIP001 				{ nLB = 2; nVS = 2; }
//STRIP001 			break;
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_RIGHT:				nLB = 2; nVS = 6; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_BOTTOM:			nLB = 2; nVS = 8; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:			nLB = 2; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:		nLB = 2; nVS = 3; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:		nLB = 2; nVS = 9; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:			nLB = 2; nVS = 7; break;
//STRIP001 
//STRIP001 		// verkuerzt aufdecken
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:		nLB = 3; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:	nLB = 3; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:			nLB = 3; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:	nLB = 3; nVS = 3; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:		nLB = 3; nVS = 6; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:	nLB = 3; nVS = 9; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:		nLB = 3; nVS = 8; break;
//STRIP001 		case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:	nLB = 3; nVS = 7; break;
//STRIP001 
//STRIP001 		// Dehnen
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_LEFT:			nLB = 4; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:		nLB = 4; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_TOP:			nLB = 4; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:		nLB = 4; nVS = 3; break;
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_RIGHT:			nLB = 4; nVS = 6; break;
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:		nLB = 4; nVS = 9; break;
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:			nLB = 4; nVS = 8; break;
//STRIP001 		case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:		nLB = 4; nVS = 7; break;
//STRIP001 
//STRIP001 		// Dehnen und Rotieren
//STRIP001 		case presentation::AnimationEffect_HORIZONTAL_STRETCH:			nLB = 5; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_VERTICAL_STRETCH:			nLB = 5; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_HORIZONTAL_ROTATE:			nLB = 5; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_VERTICAL_ROTATE:				nLB = 5; nVS = 5; break;
//STRIP001 
//STRIP001 		// Blenden
//STRIP001 		case presentation::AnimationEffect_FADE_TO_CENTER:				nLB = 6; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_FADE_FROM_CENTER:
//STRIP001 			if( nSoundId == 8 && pValueSet == &aCtlEffect ) // Favorit
//STRIP001 				{ nLB = 0; nVS = nSoundId; }
//STRIP001 			else if( nSoundId == 9 && pValueSet == &aCtlTextEffect ) // Favorit (Text)
//STRIP001 				{ nLB = 0; nVS = nSoundId; pValueSet = &aCtlEffect; }
//STRIP001 			else
//STRIP001 				{ nLB = 6; nVS = 2; }
//STRIP001 			break;
//STRIP001 		case presentation::AnimationEffect_VERTICAL_STRIPES:			nLB = 6; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_HORIZONTAL_STRIPES:			nLB = 6; nVS = 5; break;
//STRIP001 		case presentation::AnimationEffect_CLOCKWISE:					nLB = 6; nVS = 7; break;
//STRIP001 		case presentation::AnimationEffect_COUNTERCLOCKWISE:			nLB = 6; nVS = 8; break;
//STRIP001 
//STRIP001 		// Oeffnen / Schliessen
//STRIP001 		case presentation::AnimationEffect_OPEN_VERTICAL:				nLB = 7; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_OPEN_HORIZONTAL:				nLB = 7; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_CLOSE_VERTICAL:				nLB = 7; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_CLOSE_HORIZONTAL:			nLB = 7; nVS = 5; break;
//STRIP001 
//STRIP001 		// Schlangenlinien
//STRIP001 		case presentation::AnimationEffect_WAVYLINE_FROM_LEFT:			nLB = 8; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_WAVYLINE_FROM_RIGHT:			nLB = 8; nVS = 6; break;
//STRIP001 		case presentation::AnimationEffect_WAVYLINE_FROM_TOP:			nLB = 8; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM:		nLB = 8; nVS = 8; break;
//STRIP001 
//STRIP001 		// Spirale
//STRIP001 		case presentation::AnimationEffect_SPIRALIN_LEFT:				nLB = 9; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_SPIRALIN_RIGHT:				nLB = 9; nVS = 3; break;
//STRIP001 		case presentation::AnimationEffect_SPIRALOUT_LEFT:				nLB = 9; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_SPIRALOUT_RIGHT:				nLB = 9; nVS = 6; break;
//STRIP001 
//STRIP001 		// Laser
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_LEFT:				nLB = 10; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_TOP:				nLB = 10; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_RIGHT:			nLB = 10; nVS = 6; break;
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_BOTTOM:			nLB = 10; nVS = 8; break;
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:		nLB = 10; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
//STRIP001 			if( nSoundId == 3 && pValueSet == &aCtlTextEffect ) // Favorit (Text)
//STRIP001 				{ nLB = 0; nVS = nSoundId; pValueSet = &aCtlEffect; }
//STRIP001 			else
//STRIP001 				{ nLB = 10; nVS = 3; }
//STRIP001 			break;
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:		nLB = 10; nVS = 7; break;
//STRIP001 		case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:		nLB = 10; nVS = 9; break;
//STRIP001 
//STRIP001 		// Sonstige
//STRIP001 		case presentation::AnimationEffect_VERTICAL_LINES:				nLB = 11; nVS = 1; break;
//STRIP001 		case presentation::AnimationEffect_HORIZONTAL_LINES:			nLB = 11; nVS = 2; break;
//STRIP001 		case presentation::AnimationEffect_DISSOLVE:
//STRIP001 			if( nSoundId == 7 && pValueSet == &aCtlEffect ) // Favorit
//STRIP001 				{ nLB = 0; nVS = nSoundId; }
//STRIP001 			else
//STRIP001 				{ nLB = 11; nVS = 3; }
//STRIP001 			break;
//STRIP001 		case presentation::AnimationEffect_VERTICAL_CHECKERBOARD:		nLB = 11; nVS = 4; break;
//STRIP001 		case presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD:		nLB = 11; nVS = 5; break;
//STRIP001 		case presentation::AnimationEffect_APPEAR:						nLB = 11; nVS = 6; break;
//STRIP001 		case presentation::AnimationEffect_HIDE:						nLB = 11; nVS = 7; break;
//STRIP001 		case presentation::AnimationEffect_PATH:
//STRIP001 			if( nSoundId == 4 && pValueSet == &aCtlEffect ) // Favorit
//STRIP001 				{ nLB = 0; nVS = nSoundId; }
//STRIP001 			else
//STRIP001 				{ nLB = 11; nVS = 8; }
//STRIP001 			break;
//STRIP001 		case presentation::AnimationEffect_RANDOM:						nLB = 11; nVS = 9; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pValueSet == &aCtlEffect )
//STRIP001 	{
//STRIP001 		// Korrektur fuer nicht vorhandene Effekte (LASER)
//STRIP001 		if( nLB > 10 )
//STRIP001 			nLB--;
//STRIP001 		aLbEffect.SelectEntryPos( nLB );
//STRIP001 		FillValueSet( pValueSet );
//STRIP001 		aCtlEffect.SelectItem( nVS );
//STRIP001 		if( aLbEffect.IsVisible() && !aCtlEffect.IsVisible() )
//STRIP001 			aCtlEffect.Show();
//STRIP001 	}
//STRIP001 	else if( pValueSet == &aCtlTextEffect )
//STRIP001 	{
//STRIP001 		aLbTextEffect.SelectEntryPos( nLB );
//STRIP001 		FillValueSet( pValueSet );
//STRIP001 		aCtlTextEffect.SelectItem( nVS );
//STRIP001 		if( aLbTextEffect.IsVisible() && !aCtlTextEffect.IsVisible() )
//STRIP001 			aCtlTextEffect.Show();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 presentation::AnimationEffect SdEffectWin::GetAnimationEffect( ValueSet* pValueSet )
//STRIP001 {
//STRIP001 	presentation::AnimationEffect eAE = presentation::AnimationEffect_HIDE; // statt DontKnow
//STRIP001 
//STRIP001 	USHORT nLB;
//STRIP001 	USHORT nVS;
//STRIP001 
//STRIP001 	if( pValueSet == &aCtlEffect )
//STRIP001 	{
//STRIP001 		nLB = aLbEffect.GetSelectEntryPos();
//STRIP001 		nVS = aCtlEffect.GetSelectItemId();
//STRIP001 		// Korrektur fuer nicht vorhandene Effekte (LASER)
//STRIP001 		if( nLB >= 10 )
//STRIP001 			nLB++;
//STRIP001 	}
//STRIP001 	else if( pValueSet == &aCtlTextEffect )
//STRIP001 	{
//STRIP001 		nLB = aLbTextEffect.GetSelectEntryPos();
//STRIP001 		nVS = aCtlTextEffect.GetSelectItemId();
//STRIP001 	}
//STRIP001 
//STRIP001 	switch( nLB )
//STRIP001 	{
//STRIP001 		// Kein Effekt (Jetzt Favoriten)
//STRIP001 		case 0:
//STRIP001 		{
//STRIP001 			if( pValueSet == &aCtlEffect )
//STRIP001 			{
//STRIP001 				if( nVS == 1 )		eAE = presentation::AnimationEffect_NONE;
//STRIP001 				else if( nVS == 2 ) eAE = presentation::AnimationEffect_MOVE_FROM_LEFT;
//STRIP001 				else if( nVS == 3 ) eAE = presentation::AnimationEffect_LASER_FROM_UPPERRIGHT; // Text
//STRIP001 				else if( nVS == 4 ) eAE = presentation::AnimationEffect_PATH;
//STRIP001 				else if( nVS == 5 ) eAE = presentation::AnimationEffect_MOVE_FROM_TOP;
//STRIP001 				else if( nVS == 6 ) eAE = presentation::AnimationEffect_MOVE_FROM_TOP; // Text
//STRIP001 				else if( nVS == 7 ) eAE = presentation::AnimationEffect_DISSOLVE;
//STRIP001 				else if( nVS == 8 ) eAE = presentation::AnimationEffect_FADE_FROM_CENTER;
//STRIP001 				else if( nVS == 9 ) eAE = presentation::AnimationEffect_FADE_FROM_CENTER; // Text
//STRIP001 			}
//STRIP001 			else
//STRIP001 				eAE = presentation::AnimationEffect_NONE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Ueberblenden
//STRIP001 		case 1:
//STRIP001 		{
//STRIP001 			if( nVS == 4 )		eAE = presentation::AnimationEffect_FADE_FROM_LEFT;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_FADE_FROM_TOP;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_FADE_FROM_RIGHT;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_FADE_FROM_BOTTOM;
//STRIP001 			else if( nVS == 1 ) eAE = presentation::AnimationEffect_FADE_FROM_UPPERLEFT;
//STRIP001 			else if( nVS == 3 ) eAE = presentation::AnimationEffect_FADE_FROM_UPPERRIGHT;
//STRIP001 			else if( nVS == 7 ) eAE = presentation::AnimationEffect_FADE_FROM_LOWERLEFT;
//STRIP001 			else if( nVS == 9 ) eAE = presentation::AnimationEffect_FADE_FROM_LOWERRIGHT;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Aufdecken
//STRIP001 		case 2:
//STRIP001 		{
//STRIP001 			if( nVS == 4 )		eAE = presentation::AnimationEffect_MOVE_FROM_LEFT;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_MOVE_FROM_TOP;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_MOVE_FROM_RIGHT;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_MOVE_FROM_BOTTOM;
//STRIP001 			else if( nVS == 1 ) eAE = presentation::AnimationEffect_MOVE_FROM_UPPERLEFT;
//STRIP001 			else if( nVS == 3 ) eAE = presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT;
//STRIP001 			else if( nVS == 7 ) eAE = presentation::AnimationEffect_MOVE_FROM_LOWERLEFT;
//STRIP001 			else if( nVS == 9 ) eAE = presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// verkuerzt Aufdecken
//STRIP001 		case 3:
//STRIP001 		{
//STRIP001 			if( nVS == 4 )		eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_TOP;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM;
//STRIP001 			else if( nVS == 1 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT;
//STRIP001 			else if( nVS == 3 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT;
//STRIP001 			else if( nVS == 7 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT;
//STRIP001 			else if( nVS == 9 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Dehnen
//STRIP001 		case 4:
//STRIP001 		{
//STRIP001 			if( nVS == 4 )		eAE = presentation::AnimationEffect_STRETCH_FROM_LEFT;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_STRETCH_FROM_TOP;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_STRETCH_FROM_RIGHT;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_STRETCH_FROM_BOTTOM;
//STRIP001 			else if( nVS == 1 ) eAE = presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT;
//STRIP001 			else if( nVS == 3 ) eAE = presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT;
//STRIP001 			else if( nVS == 7 ) eAE = presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT;
//STRIP001 			else if( nVS == 9 ) eAE = presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Dehnen und Rotieren
//STRIP001 		case 5:
//STRIP001 		{
//STRIP001 			if( nVS == 1 )		eAE = presentation::AnimationEffect_HORIZONTAL_STRETCH;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_VERTICAL_STRETCH;
//STRIP001 			else if( nVS == 4 ) eAE = presentation::AnimationEffect_HORIZONTAL_ROTATE;
//STRIP001 			else if( nVS == 5 ) eAE = presentation::AnimationEffect_VERTICAL_ROTATE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Blenden
//STRIP001 		case 6:
//STRIP001 		{
//STRIP001 			if( nVS == 1 )		eAE = presentation::AnimationEffect_FADE_TO_CENTER;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_FADE_FROM_CENTER;
//STRIP001 			else if( nVS == 4 ) eAE = presentation::AnimationEffect_VERTICAL_STRIPES;
//STRIP001 			else if( nVS == 5 ) eAE = presentation::AnimationEffect_HORIZONTAL_STRIPES;
//STRIP001 			else if( nVS == 7 ) eAE = presentation::AnimationEffect_CLOCKWISE;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_COUNTERCLOCKWISE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Oeffnen / Schliessen
//STRIP001 		case 7:
//STRIP001 		{
//STRIP001 			if( nVS == 1 )		eAE = presentation::AnimationEffect_OPEN_VERTICAL;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_OPEN_HORIZONTAL;
//STRIP001 			else if( nVS == 4 ) eAE = presentation::AnimationEffect_CLOSE_VERTICAL;
//STRIP001 			else if( nVS == 5 ) eAE = presentation::AnimationEffect_CLOSE_HORIZONTAL;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Schlangenlinien
//STRIP001 		case 8:
//STRIP001 		{
//STRIP001 			if( nVS == 4 )		eAE = presentation::AnimationEffect_WAVYLINE_FROM_LEFT;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_WAVYLINE_FROM_RIGHT;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_WAVYLINE_FROM_TOP;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Spirale
//STRIP001 		case 9:
//STRIP001 		{
//STRIP001 			if( nVS == 1 )		eAE = presentation::AnimationEffect_SPIRALIN_LEFT;
//STRIP001 			else if( nVS == 3 ) eAE = presentation::AnimationEffect_SPIRALIN_RIGHT;
//STRIP001 			else if( nVS == 4 ) eAE = presentation::AnimationEffect_SPIRALOUT_LEFT;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_SPIRALOUT_RIGHT;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Laser
//STRIP001 		case 10:
//STRIP001 		{
//STRIP001 			if( nVS == 4 )		eAE = presentation::AnimationEffect_LASER_FROM_LEFT;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_LASER_FROM_TOP;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_LASER_FROM_RIGHT;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_LASER_FROM_BOTTOM;
//STRIP001 			else if( nVS == 1 ) eAE = presentation::AnimationEffect_LASER_FROM_UPPERLEFT;
//STRIP001 			else if( nVS == 3 ) eAE = presentation::AnimationEffect_LASER_FROM_UPPERRIGHT;
//STRIP001 			else if( nVS == 7 ) eAE = presentation::AnimationEffect_LASER_FROM_LOWERLEFT;
//STRIP001 			else if( nVS == 9 ) eAE = presentation::AnimationEffect_LASER_FROM_LOWERRIGHT;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// Sonstige
//STRIP001 		case 11:
//STRIP001 		{
//STRIP001 			if( nVS == 1 )		eAE = presentation::AnimationEffect_VERTICAL_LINES;
//STRIP001 			else if( nVS == 2 ) eAE = presentation::AnimationEffect_HORIZONTAL_LINES;
//STRIP001 			else if( nVS == 3 ) eAE = presentation::AnimationEffect_DISSOLVE;
//STRIP001 			else if( nVS == 4 ) eAE = presentation::AnimationEffect_VERTICAL_CHECKERBOARD;
//STRIP001 			else if( nVS == 5 ) eAE = presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD;
//STRIP001 			else if( nVS == 6 ) eAE = presentation::AnimationEffect_APPEAR;
//STRIP001 			else if( nVS == 7 ) eAE = presentation::AnimationEffect_HIDE;
//STRIP001 			else if( nVS == 8 ) eAE = presentation::AnimationEffect_PATH;
//STRIP001 			else if( nVS == 9 ) eAE = presentation::AnimationEffect_RANDOM;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return( eAE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdEffectWin::InitColorLB( const SdDrawDocument* pDoc )
//STRIP001 {
//STRIP001 	XColorTable* pColorTab = pDoc->GetColorTable();
//STRIP001 
//STRIP001 	aLbFadeOutColor.Fill( pColorTab );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdEffectWin::FillValueSet( ValueSet* pValueSet )
//STRIP001 {
//STRIP001 	USHORT 		nFirstItem = 0;
//STRIP001 	USHORT 		nPos;
//STRIP001 	ListBox*	pLb;
//STRIP001 
//STRIP001 	if( pValueSet == &aCtlEffect )
//STRIP001 	{
//STRIP001 		pLb = &aLbEffect;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pLb = &aLbTextEffect;
//STRIP001 	}
//STRIP001 	nPos = pLb->GetSelectEntryPos();
//STRIP001 
//STRIP001 	pValueSet->SetUpdateMode( FALSE );
//STRIP001 	//pValueSet->Hide();
//STRIP001 	pValueSet->Clear();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		for( int i = 1; i <= 11; i++ )
//STRIP001 		{
//STRIP001 			USHORT nStrId = GetStringId( i, nPos, pValueSet );
//STRIP001 			USHORT nBmpId = GetBitmapId( i, nPos, pValueSet );
//STRIP001 			if( nStrId != 0 && nBmpId != 0 )
//STRIP001 			{
//STRIP001 				pValueSet->InsertItem( i, Bitmap( SdResId( nBmpId ) ), String( SdResId( nStrId ) ) );
//STRIP001 
//STRIP001 				if( nFirstItem == 0 )
//STRIP001 					nFirstItem = i;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pValueSet->InsertSpace( i );
//STRIP001 		}
//STRIP001 		if( !pValueSet->IsVisible() && pLb->IsVisible() )
//STRIP001 			pValueSet->Show();
//STRIP001 
//STRIP001 		if( nFirstItem > 0 )
//STRIP001 			pValueSet->SelectItem( nFirstItem );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pValueSet->Hide();
//STRIP001 	pValueSet->SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SdEffectWin::GetBitmapId( USHORT i, USHORT nPos, ValueSet* pValueSet )
//STRIP001 {
//STRIP001 	const bool bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
//STRIP001 
//STRIP001 	List* pList;
//STRIP001 	if( pValueSet == &aCtlEffect )
//STRIP001 	{
//STRIP001 		if( bHighContrast )
//STRIP001 			pList = (List*) ppHCBitmapIdList->GetObject( nPos );
//STRIP001 		else
//STRIP001 			pList = (List*) ppBitmapIdList->GetObject( nPos );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if( bHighContrast )
//STRIP001 			pList = (List*) ppHCBitmapIdListTE->GetObject( nPos );
//STRIP001 		else
//STRIP001 			pList = (List*) ppBitmapIdListTE->GetObject( nPos );
//STRIP001 	}
//STRIP001 	ULONG nId = (ULONG) pList->GetObject( i );
//STRIP001 	return( (USHORT) nId );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SdEffectWin::GetStringId( USHORT i, USHORT nPos, ValueSet* pValueSet )
//STRIP001 {
//STRIP001 	List* pList;
//STRIP001 	if( pValueSet == &aCtlEffect )
//STRIP001 		pList = (List*) ppStringIdList->GetObject( nPos );
//STRIP001 	else
//STRIP001 		pList = (List*) ppStringIdListTE->GetObject( nPos );
//STRIP001 	ULONG nId = (ULONG) pList->GetObject( i );
//STRIP001 	return( (USHORT) nId );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdEffectWin::WaitInEffect( ULONG nMilliSeconds ) const
//STRIP001 {
//STRIP001 	long aEnd = Time::GetSystemTicks() + nMilliSeconds;
//STRIP001 	clock_t aCurrent = Time::GetSystemTicks();
//STRIP001 	while (aCurrent < aEnd)
//STRIP001 	{
//STRIP001 		aCurrent = Time::GetSystemTicks();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SdEffectWin::GetViewTypeResId( ViewType eVT, BOOL bImage )
//STRIP001 {
//STRIP001 	switch( eVT )
//STRIP001 	{
//STRIP001 		case VIEWTYPE_EFFECT:
//STRIP001 				return( bImage ? IMG_EFFECT : STR_VIEWTYPE_EFFECT );
//STRIP001 		case VIEWTYPE_EXTRAS:
//STRIP001 				return( bImage ? IMG_EXTRAS : STR_VIEWTYPE_EXTRAS );
//STRIP001 		case VIEWTYPE_TEXT:
//STRIP001 				return( bImage ? IMG_TEXT : STR_VIEWTYPE_TEXT );
//STRIP001 		case VIEWTYPE_ORDER:
//STRIP001 				return( bImage ? IMG_ORDER : STR_VIEWTYPE_ORDER );
//STRIP001 		default: DBG_ERROR( "Keine Resource fuer ViewType vorhanden!" );
//STRIP001 	}
//STRIP001 	return( 0 );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdEffectWin::OpenFileDialog()
//STRIP001 {
//STRIP001 	SdOpenSoundFileDialog	aFileDialog;
//STRIP001 
//STRIP001 	String aFile;
//STRIP001 	USHORT nPos = aLbSound.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		aFile = *(String*)pSoundList->GetObject( (long)nPos );
//STRIP001 	else
//STRIP001 		aFile = SvtPathOptions().GetGraphicPath();
//STRIP001 
//STRIP001 	aFileDialog.SetPath( aFile );
//STRIP001 
//STRIP001 	BOOL bValidSoundFile(TRUE);
//STRIP001 	BOOL bQuitLoop(FALSE);	
//STRIP001 
//STRIP001 	while( bQuitLoop == FALSE &&
//STRIP001 		   aFileDialog.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		aFile = aFileDialog.GetPath();
//STRIP001 		//aLbSound.SelectEntry( aFile );
//STRIP001 		// Ist jetzt nicht mehr so einfach, da Gallery, die Liste und
//STRIP001 		// die ListBox auf den neusten Stand gebracht werden muessen
//STRIP001 		long nPos = GetSoundObject( aFile );
//STRIP001 
//STRIP001 		if( nPos < 0 ) // not in Soundliste
//STRIP001 		{
//STRIP001 			// try to insert in Gallery
//STRIP001 			if( GalleryExplorer::InsertURL( GALLERY_THEME_USERSOUNDS, aFile, SGA_FORMAT_SOUND ) )
//STRIP001 			{
//STRIP001 				ClearSoundList();
//STRIP001 				aLbSound.Clear();
//STRIP001 			
//STRIP001 				FillSoundListAndBox();
//STRIP001 				nPos = GetSoundObject( aFile );
//STRIP001 				DBG_ASSERT( nPos >= 0, "Sound nicht in Liste!" );
//STRIP001 
//STRIP001 				bValidSoundFile=TRUE;
//STRIP001 				bQuitLoop=TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				String aStrWarning(SdResId(STR_WARNING_NOSOUNDFILE));
//STRIP001 				String aStr; aStr += sal_Unicode('%');
//STRIP001 				aStrWarning.SearchAndReplace( aStr , aFile );
//STRIP001 				WarningBox aWarningBox( NULL, WB_3DLOOK | WB_RETRY_CANCEL, aStrWarning );
//STRIP001 				aWarningBox.SetModalInputMode (TRUE);
//STRIP001 				bQuitLoop = aWarningBox.Execute()==RET_RETRY ? FALSE : TRUE;
//STRIP001 				
//STRIP001 				bValidSoundFile=FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bValidSoundFile=TRUE;
//STRIP001 			bQuitLoop=TRUE;
//STRIP001 		}		  
//STRIP001 		
//STRIP001 		if( bValidSoundFile )
//STRIP001 			aLbSound.SelectEntryPos( (USHORT) nPos );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdEffectWin::FillSoundListAndBox()
//STRIP001 {
//STRIP001 	GalleryExplorer::FillObjList( GALLERY_THEME_SOUNDS, *pSoundList );
//STRIP001 	GalleryExplorer::FillObjList( GALLERY_THEME_USERSOUNDS, *pSoundList );
//STRIP001 
//STRIP001 	for( ULONG i = 0; i < pSoundList->Count(); i++ )
//STRIP001 	{
//STRIP001 		INetURLObject aURL( *(String*) pSoundList->GetObject( i ) );
//STRIP001 		aLbSound.InsertEntry( aURL.getBase() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdEffectWin::ClearSoundList()
//STRIP001 {
//STRIP001 	ULONG nCount = pSoundList->Count();
//STRIP001 	for( ULONG i = 0; i < nCount; i++ )
//STRIP001 		delete (String*)pSoundList->GetObject( i );
//STRIP001 	pSoundList->Clear();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 long SdEffectWin::GetSoundObject( const String& rStr )
//STRIP001 {
//STRIP001 	String aStrIn( rStr );
//STRIP001 
//STRIP001 	aStrIn.ToLowerAscii();
//STRIP001 
//STRIP001 	for( ULONG i = 0, nCount = pSoundList->Count(); i < nCount; i++ )
//STRIP001 	{
//STRIP001 		String aTmpStr( *(String*)pSoundList->GetObject( i ) );
//STRIP001 
//STRIP001 		aTmpStr.ToLowerAscii();
//STRIP001 
//STRIP001 		if( aTmpStr == aStrIn )
//STRIP001 			return( i );
//STRIP001 	}
//STRIP001 
//STRIP001 	return( -1L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 String SdEffectWin::GetSoundById( USHORT nId )
//STRIP001 {
//STRIP001 	String aStr;
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 		case 2: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "left" ) );   break;
//STRIP001 		case 4: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "curve" ) );  break;
//STRIP001 		case 5: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "falling" ) );break;
//STRIP001 		case 7: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "untie" ) );  break;
//STRIP001 		case 8: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "apert2" ) ); break;
//STRIP001 
//STRIP001 		case 3: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "laser" ) );  break;
//STRIP001 		case 6: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "top" ) );    break;
//STRIP001 		case 9: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "apert" ) );  break;
//STRIP001 	}
//STRIP001 	return( aStr );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SdEffectWin::GetIdBySound( const String& rStr )
//STRIP001 {
//STRIP001 	USHORT nId = 1;
//STRIP001 	String aStr( rStr );
//STRIP001 	aStr.ToLowerAscii();
//STRIP001 
//STRIP001 	if( aStr.EqualsAscii( "left" ) )
//STRIP001 		nId = 2;
//STRIP001 	else if( aStr.EqualsAscii( "curve" ) )
//STRIP001 		nId = 4;
//STRIP001 	else if( aStr.EqualsAscii( "falling" ) )
//STRIP001 		nId = 5;
//STRIP001 	else if( aStr.EqualsAscii( "untie" ) )
//STRIP001 		nId = 7;
//STRIP001 	else if( aStr.EqualsAscii( "apert2" ) )
//STRIP001 		nId = 8;
//STRIP001 	else if( aStr.EqualsAscii( "laser" ) )
//STRIP001 		nId = 3;
//STRIP001 	else if( aStr.EqualsAscii( "top" ) )
//STRIP001 		nId = 6;
//STRIP001 	else if( aStr.EqualsAscii( "apert" ) )
//STRIP001 		nId = 9;
//STRIP001 
//STRIP001 	return( nId );
//STRIP001 }


}
