/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_SchTransferable.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:15:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "SchTransferable.hxx"

#include "schmod.hxx"

#ifndef _SVDMODEL_HXX
#include <bf_svx/svdmodel.hxx>
#endif
#ifndef _SVDXCGV_HXX
#include <bf_svx/svdxcgv.hxx>
#endif
#ifndef _SVDPAGE_HXX
#include <bf_svx/svdpage.hxx>
#endif

#ifndef _SVDOGRAF_HXX 
#include <bf_svx/svdograf.hxx>
#endif
#ifndef _CPPUHELPER_QUERYINTERFACE_HXX_
#include <cppuhelper/queryinterface.hxx>
#endif
// header for class OGuard
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
// header for class Application
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
namespace binfilter {

#define SCH_TRANSFER_OBJECTTYPE_OLE			0x00000001
#define SCH_TRANSFER_OBJECTTYPE_DRAWMODEL   0x00000002

using namespace ::com::sun::star;

//STRIP001 SchTransferable::SchTransferable( SdrModel* pObjModel,
//STRIP001                                   SdrExchangeView* pSrcView,
//STRIP001                                   const TransferableObjectDescriptor& rObjDesc,
//STRIP001                                   sal_Bool bLateInit /* sal_False */ ) :
//STRIP001     mpContentModel   ( pObjModel ),
//STRIP001     mpSourceView     ( pSrcView ),
//STRIP001     mpOwnModel       ( NULL ),
//STRIP001     mpOwnView        ( NULL ),
//STRIP001     mpGraphic        ( NULL ),
//STRIP001     maObjDesc        ( rObjDesc ),
//STRIP001     mbLateInit       ( bLateInit ),
//STRIP001     mbDataCreated    ( false )
//STRIP001 {
//STRIP001     if( ! mbLateInit )
//STRIP001         CreateData();
//STRIP001 }

//STRIP001 SchTransferable::~SchTransferable()
//STRIP001 {
//STRIP001     ::vos::OGuard aGuard( Application::GetSolarMutex());
//STRIP001 
//STRIP001     ObjectReleased();
//STRIP001     
//STRIP001     // note: the external view is NOT owned by the transferable
//STRIP001     if( mpOwnView )
//STRIP001         delete mpOwnView;
//STRIP001 
//STRIP001     // important: delete model after view!
//STRIP001     if( mpOwnModel )
//STRIP001         delete mpOwnModel;
//STRIP001     else if( mpContentModel )
//STRIP001     {
//STRIP001         // the transferable owns the model
//STRIP001         delete mpContentModel;
//STRIP001     }
//STRIP001 
//STRIP001     if( mpGraphic )
//STRIP001         delete mpGraphic;
//STRIP001 }

//STRIP001 void SchTransferable::CreateData()
//STRIP001 {
//STRIP001     // copy to clipboard
//STRIP001 	if( mpContentModel && ! mpSourceView )
//STRIP001 	{
//STRIP001         ::vos::OGuard aGuard( Application::GetSolarMutex());
//STRIP001 		const SdrPage* pPage = mpContentModel->GetPage( 0 );
//STRIP001 
//STRIP001 		if( pPage && pPage->GetObjCount() == 1 )
//STRIP001 		{
//STRIP001 			SdrObject* pObj = pPage->GetObj( 0 );
//STRIP001 			if( pObj->ISA( SdrGrafObj ))
//STRIP001 			{
//STRIP001 				if( mpGraphic )
//STRIP001 					delete mpGraphic;
//STRIP001 
//STRIP001 				mpGraphic = new Graphic( ((SdrGrafObj*) pObj )->GetTransformedGraphic());
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         // get size of selected objects
//STRIP001 
//STRIP001         mpOwnView = new SdrExchangeView( mpContentModel );
//STRIP001         Point aPos;
//STRIP001         SdrPageView* pPv = mpOwnView->ShowPagePgNum( 0, aPos );
//STRIP001         mpOwnView->MarkAll( pPv );
//STRIP001         Size aSize = mpOwnView->GetAllMarkedRect().GetSize();
//STRIP001         maObjDesc.maSize = aSize;
//STRIP001         mpSourceView = mpOwnView;
//STRIP001 	}
//STRIP001     // drag and drop and selection clipboard
//STRIP001     else if( mpSourceView && ! mpContentModel )
//STRIP001 	{
//STRIP001         ::vos::OGuard aGuard( Application::GetSolarMutex());
//STRIP001         const SdrMarkList&	rMarkList = mpSourceView->GetMarkList();
//STRIP001 
//STRIP001 		if( rMarkList.GetMarkCount() == 1 )
//STRIP001 		{
//STRIP001 			const SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 
//STRIP001 			if ( pObj && pObj->ISA( SdrGrafObj ) )
//STRIP001 				mpGraphic = new Graphic( ((SdrGrafObj*) pObj )->GetTransformedGraphic());
//STRIP001 		}
//STRIP001 
//STRIP001         mpOwnModel = mpSourceView->GetMarkedObjModel();
//STRIP001         mpContentModel = mpOwnModel;
//STRIP001 	}
//STRIP001 	
//STRIP001 	mbDataCreated = true;
//STRIP001 }

// protected - implementation of TransferableHelper methods
//STRIP001 void SchTransferable::AddSupportedFormats()
//STRIP001 {
//STRIP001     if( ! mbLateInit &&
//STRIP001 		! mbDataCreated )
//STRIP001 	    CreateData();
//STRIP001 
//STRIP001 	if( mpGraphic )
//STRIP001 	{
//STRIP001 		AddFormat( SOT_FORMATSTR_ID_SVXB );
//STRIP001 
//STRIP001 		if( mpGraphic->GetType() == GRAPHIC_BITMAP )
//STRIP001 		{
//STRIP001 			AddFormat( SOT_FORMAT_BITMAP );
//STRIP001 			AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001 			AddFormat( SOT_FORMAT_BITMAP );
//STRIP001 		}
//STRIP001 	}
//STRIP001     else
//STRIP001     {
//STRIP001         AddFormat( SOT_FORMAT_GDIMETAFILE );
//STRIP001         AddFormat( SOT_FORMAT_BITMAP );
//STRIP001     }
//STRIP001 }

//STRIP001 sal_Bool SchTransferable::GetData( const datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_uInt32	nFormat = SotExchange::GetFormat( rFlavor );
//STRIP001 	sal_Bool	bOK = sal_False;
//STRIP001 
//STRIP001 	if( mbLateInit )
//STRIP001 		CreateData();
//STRIP001 
//STRIP001 	DBG_ASSERT( mbDataCreated, "Clipboard data has not been created!" );
//STRIP001 
//STRIP001 	if( HasFormat( nFormat ) )
//STRIP001 	{
//STRIP001 		if( ( nFormat == SOT_FORMATSTR_ID_LINKSRCDESCRIPTOR ||
//STRIP001 			  nFormat == SOT_FORMATSTR_ID_OBJECTDESCRIPTOR ))
//STRIP001 		{
//STRIP001             bOK = SetTransferableObjectDescriptor( maObjDesc, rFlavor );
//STRIP001 		}
//STRIP001 		else if( nFormat == FORMAT_GDIMETAFILE ||
//STRIP001                  nFormat == FORMAT_BITMAP )
//STRIP001         {
//STRIP001             DBG_ASSERT( mpSourceView, "Invalid View!" );
//STRIP001             if( mpSourceView )
//STRIP001             {
//STRIP001                 if( nFormat == FORMAT_GDIMETAFILE )
//STRIP001                 {
//STRIP001                     bOK = SetGDIMetaFile( mpSourceView->GetAllMarkedMetaFile( TRUE ), rFlavor );
//STRIP001                 }
//STRIP001                 else if( nFormat == FORMAT_BITMAP )
//STRIP001                 {
//STRIP001                     bOK = SetBitmap( mpSourceView->GetAllMarkedBitmap( TRUE ), rFlavor );
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001 		else if( nFormat == FORMAT_STRING )
//STRIP001 		{
//STRIP001 			bOK = SetString( String(), rFlavor );
//STRIP001 		}
//STRIP001 		else if( ( nFormat == SOT_FORMATSTR_ID_SVXB ) && mpGraphic )
//STRIP001 		{
//STRIP001             bOK = SetGraphic( *mpGraphic, rFlavor );
//STRIP001 		}
//STRIP001 		else if( nFormat == SOT_FORMATSTR_ID_EMBED_SOURCE )
//STRIP001 		{
//STRIP001             DBG_ERROR( "No longer supported" );
//STRIP001             bOK = sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bOK;	
//STRIP001 }

//STRIP001 sal_Bool SchTransferable::WriteObject(
//STRIP001 	SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId,
//STRIP001 	const datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001     if( nUserObjectId == SCH_TRANSFER_OBJECTTYPE_DRAWMODEL ||
//STRIP001         nUserObjectId == SCH_TRANSFER_OBJECTTYPE_OLE )
//STRIP001         DBG_ERROR( "No longer supported" );
//STRIP001 
//STRIP001     return sal_False;
//STRIP001 
//STRIP001     // paste as OLE-Chart and paste of objects as drwing format are no longer supported (see #90893#)
//STRIP001 #if 0
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 
//STRIP001 	switch( nUserObjectId )
//STRIP001 	{
//STRIP001 		case SCH_TRANSFER_OBJECTTYPE_OLE  :
//STRIP001 			{
//STRIP001                 DBG_ERROR( "No longer supported" );
//STRIP001                 bRet = sal_False;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001         case SCH_TRANSFER_OBJECTTYPE_DRAWMODEL:
//STRIP001             {
//STRIP001                 SdrModel* pDrawModel = (SdrModel*)pUserObject;
//STRIP001 
//STRIP001                 pDrawModel->SetStreamingSdrModel( TRUE );
//STRIP001 
//STRIP001                 //  SdrModel stream operator doesn't support XML
//STRIP001                 //! call XML export here!
//STRIP001                 rxOStm->SetVersion( SOFFICE_FILEFORMAT_50 );
//STRIP001 
//STRIP001                 rxOStm->SetBufferSize( 0xff00 );
//STRIP001                 pDrawModel->PreSave();
//STRIP001                 pDrawModel->GetItemPool().SetFileFormatVersion( (USHORT)rxOStm->GetVersion() );
//STRIP001                 pDrawModel->GetItemPool().Store( *rxOStm );
//STRIP001                 *rxOStm << *pDrawModel;
//STRIP001                 pDrawModel->PostSave();
//STRIP001                 rxOStm->Commit();
//STRIP001                 pDrawModel->SetStreamingSdrModel( FALSE );
//STRIP001                 bRet = ( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 #endif
//STRIP001 }

//STRIP001 void SchTransferable::ObjectReleased()
//STRIP001 {
//STRIP001 	::vos::OGuard aGuard( Application::GetSolarMutex());
//STRIP001 
//STRIP001 	if( this == SCH_MOD1()->GetDragTransferable())
//STRIP001 		SCH_MOD1()->SetDragTransferable( NULL );
//STRIP001 
//STRIP001 	if( this == SCH_MOD1()->GetClipboardTransferable())
//STRIP001 		SCH_MOD1()->SetClipboardTransferable( NULL );
//STRIP001 
//STRIP001 	if( this == SCH_MOD1()->GetSelectionClipboardTransferable())
//STRIP001 		SCH_MOD1()->SetSelectionClipboardTransferable( NULL );
//STRIP001 
//STRIP001     TransferableHelper::ObjectReleased();
//STRIP001 }

// XUnoTunnel
//STRIP001 sal_Int64 SAL_CALL SchTransferable::getSomething( const uno::Sequence< sal_Int8 >& aIdentifier )
//STRIP001 	throw( uno::RuntimeException )
//STRIP001 {
//STRIP001 	if( aIdentifier.getLength() == 16 && 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(),
//STRIP001 																 aIdentifier.getConstArray(), 16 ) )
//STRIP001 	{
//STRIP001 		return (sal_Int64)this;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// helper for XUnoTunnel
//STRIP001 SchTransferable* SchTransferable::getImplementation( uno::Reference< uno::XInterface > xData ) throw()
//STRIP001 {
//STRIP001 	uno::Reference< lang::XUnoTunnel > xUT( xData, uno::UNO_QUERY );
//STRIP001 	if( xUT.is() )
//STRIP001 		return (SchTransferable*)xUT->getSomething( SchTransferable::getUnoTunnelId() );
//STRIP001 	else
//STRIP001 		return NULL;
//STRIP001 }

// generate a uniqueId
//STRIP001 const uno::Sequence< sal_Int8 > & SchTransferable::getUnoTunnelId() throw()
//STRIP001 {
//STRIP001 	static uno::Sequence< sal_Int8 > * pSeq = 0;
//STRIP001 	if( !pSeq )
//STRIP001 	{
//STRIP001 		osl::Guard< osl::Mutex > aGuard( osl::Mutex::getGlobalMutex() );
//STRIP001 		if( !pSeq )
//STRIP001 		{
//STRIP001 			static uno::Sequence< sal_Int8 > aSeq( 16 );
//STRIP001 			rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0, sal_True );
//STRIP001 			pSeq = &aSeq;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return *pSeq;
//STRIP001 }
}
