/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewfunc.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 20:29:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_VIEWFUNC_HXX
#define SC_VIEWFUNC_HXX

#ifndef SC_TABVIEW_HXX
#include "tabview.hxx"
#endif

#ifndef _SVSTDARR_USHORTS

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#endif

#ifndef _SVSTDARR_STRINGS

#define _SVSTDARR_STRINGS
#include <svtools/svstdarr.hxx>

#endif
namespace com { namespace sun { namespace star { namespace datatransfer { class XTransferable; } } } }
class SfxItemSet;
class SfxStyleSheet;
class SfxPoolItem; 
class SvInPlaceObject;
class Graphic;
namespace binfilter {

#define TABLEID_DOC		0xFFFF

class ScPatternAttr;
class ScAutoFormatData;
class SvxSearchItem;
class SvxBorderLine;
class SvxBoxItem;
class SvxBoxInfoItem;
class EditTextObject;
struct ScSolveParam;
struct ScTabOpParam;
class ScPostIt;
class ScConditionalFormat;
class ScValidationData;
class SdrModel;
class Exchange;
class ScRangeList;
class SvxHyperlinkItem;

//STRIP008 namespace com { namespace sun { namespace star { namespace datatransfer { class XTransferable; } } } }

// ---------------------------------------------------------------------------

class ScViewFunc : public ScTabView
{
private:
	ScAddress	aFormatSource;		// fuer automatisches Erweitern von Formatierung
	ScRange		aFormatArea;
	BOOL		bFormatValid;

public:
					ScViewFunc( Window* pParent, ScDocShell& rDocSh, ScTabViewShell* pViewShell );
					ScViewFunc( Window* pParent, const ScViewFunc& rViewFunc, ScTabViewShell* pViewShell );
					~ScViewFunc();

	const ScPatternAttr*    GetSelectionPattern	();
//STRIP001 	void					GetSelectionFrame	( SvxBoxItem&		rLineOuter,
//STRIP001 												  SvxBoxInfoItem&	rLineInner );

	BYTE			GetSelectionScriptType();

//STRIP001 	BOOL			GetAutoSumArea(ScRangeList& rRangeList);
//STRIP001 	void			EnterAutoSum(const ScRangeList& rRangeList, sal_Bool bSubTotal);

//STRIP001 	void			EnterData( USHORT nCol, USHORT nRow, USHORT nTab, const String& rString,
//STRIP001 								BOOL bRecord = TRUE );
//STRIP001 	void			EnterData( USHORT nCol, USHORT nRow, USHORT nTab, const double& rValue );
//STRIP001 	void			EnterData( USHORT nCol, USHORT nRow, USHORT nTab, const EditTextObject* pData,
//STRIP001 								BOOL bRecord = TRUE, BOOL bTestSimple = FALSE );

//STRIP001 	void			EnterMatrix( const String& rString );
//STRIP001 	void			EnterBlock( const String& rString, const EditTextObject* pData );

//STRIP001 	void			EnterDataAtCursor( const String& rString );			//! nicht benutzt ?

//STRIP001 	void			CutToClip( ScDocument* pClipDoc = NULL, BOOL bIncludeObjects = FALSE );
//STRIP001 	BOOL			CopyToClip( ScDocument* pClipDoc = NULL, BOOL bCut = FALSE, BOOL bApi = FALSE,
//STRIP001 								BOOL bIncludeObjects = FALSE );
//STRIP001 	BOOL			PasteFromClip( USHORT nFlags, ScDocument* pClipDoc,
//STRIP001 									USHORT nFunction = PASTE_NOFUNC, BOOL bSkipEmpty = FALSE,
//STRIP001 									BOOL bTranspose = FALSE, BOOL bAsLink = FALSE,
//STRIP001 									InsCellCmd eMoveMode = INS_NONE,
//STRIP001 									USHORT nUndoExtraFlags = IDF_NONE,
//STRIP001 									BOOL bAllowDialogs = FALSE );

//STRIP001 	void			FillTab( USHORT nFlags, USHORT nFunction, BOOL bSkipEmpty, BOOL bAsLink );

//STRIP001 	void			PasteFromSystem();
//STRIP001 	BOOL			PasteFromSystem( ULONG nFormatId, BOOL bApi = FALSE );

//STRIP001 	void			PasteDraw();
//STRIP001 	void			PasteDraw( const Point& rLogicPos, SdrModel* pModel,
//STRIP001                                 BOOL bGroup = FALSE, BOOL bSameDocClipboard = FALSE );

//STRIP001 	BOOL			PasteOnDrawObject( const ::com::sun::star::uno::Reference<
//STRIP001 											::com::sun::star::datatransfer::XTransferable >& rxTransferable,
//STRIP001 										SdrObject* pHitObj, BOOL bLink );

//STRIP001 	BOOL			PasteDataFormat( ULONG nFormatId,
//STRIP001 										const ::com::sun::star::uno::Reference<
//STRIP001 											::com::sun::star::datatransfer::XTransferable >& rxTransferable,
//STRIP001 										USHORT nPosX, USHORT nPosY, Point* pLogicPos = NULL,
//STRIP001 										BOOL bLink = FALSE, BOOL bAllowDialogs = FALSE );

//STRIP001 	BOOL			PasteFile( const Point&, const String&, BOOL bLink=FALSE );
//STRIP001 	BOOL			PasteObject( const Point&, SvInPlaceObject*, const Size* = NULL );
//STRIP001 	BOOL			PasteBitmap( const Point&, const Bitmap& );
//STRIP001 	BOOL			PasteMetaFile( const Point&, const GDIMetaFile& );
//STRIP001 	BOOL			PasteGraphic( const Point& rPos, const Graphic& rGraphic,
//STRIP001 									const String& rFile, const String& rFilter );
//STRIP001 	BOOL			PasteBookmark( ULONG nFormatId,
//STRIP001 								const ::com::sun::star::uno::Reference<
//STRIP001 									::com::sun::star::datatransfer::XTransferable >& rxTransferable,
//STRIP001 								USHORT nPosX, USHORT nPosY );
//STRIP001 	BOOL			PasteDDE( const ::com::sun::star::uno::Reference<
//STRIP001 								::com::sun::star::datatransfer::XTransferable >& rxTransferable );

//STRIP001 	BOOL			ApplyGraphicToObject( SdrObject* pObject, const Graphic& rGraphic );

//STRIP001 	void			InsertBookmark( const String& rDescription, const String& rURL,
//STRIP001 									USHORT nPosX, USHORT nPosY, const String* pTarget = NULL,
//STRIP001 									BOOL bTryReplace = FALSE );
//STRIP001 	BOOL			HasBookmarkAtCursor( SvxHyperlinkItem* pContent );

	long			DropRequestHdl( Exchange* pExchange );
//STRIP001 	BOOL			MoveBlockTo( const ScRange& rSource, const ScAddress& rDestPos,
//STRIP001 									BOOL bCut, BOOL bRecord, BOOL bPaint, BOOL bApi );

//STRIP001 	BOOL			LinkBlock( const ScRange& rSource, const ScAddress& rDestPos, BOOL bApi );

//STRIP001 	void			CreateNames( USHORT nFlags );
//STRIP001 	USHORT			GetCreateNameFlags();
//STRIP001 	void			InsertNameList();
//STRIP001 	BOOL			InsertName( const String& rName, const String& rSymbol,
//STRIP001 								const String& rType );

//STRIP001 	void			ApplyAttributes( const SfxItemSet* pDialogSet, const SfxItemSet* pOldSet,
//STRIP001 										BOOL bRecord = TRUE );
//STRIP001 	void			ApplyAttr( const SfxPoolItem& rAttrItem );
//STRIP001 	void			ApplySelectionPattern( const ScPatternAttr& rAttr,
//STRIP001 											BOOL bRecord = TRUE,
//STRIP001 											BOOL bCursorOnly = FALSE );
//STRIP001 	void			ApplyPatternLines( const ScPatternAttr& rAttr,
//STRIP001 										const SvxBoxItem* pNewOuter,
//STRIP001 										const SvxBoxInfoItem* pNewInner, BOOL bRecord = TRUE );

//STRIP001 	void			ApplyUserItemSet( const SfxItemSet& rItemSet );

	const SfxStyleSheet*	GetStyleSheetFromMarked();
//STRIP001 	void					SetStyleSheetToMarked( SfxStyleSheet* pStyleSheet,
//STRIP001 														BOOL bRecord = TRUE );
//STRIP001 	void					RemoveStyleSheetInUse( SfxStyleSheet* pStyleSheet );
//STRIP001 	void					UpdateStyleSheetInUse( SfxStyleSheet* pStyleSheet );
//STRIP001 
//STRIP001 	void			SetNumberFormat( short nFormatType, ULONG nAdd = 0 );
//STRIP001 	void			SetNumFmtByStr( const String& rCode );
//STRIP001 	void			ChangeNumFmtDecimals( BOOL bIncrement );
//STRIP001 
//STRIP001 	void			SetConditionalFormat( const ScConditionalFormat& rNew );
//STRIP001 	void			SetValidation( const ScValidationData& rNew );
//STRIP001 
//STRIP001 	void			ChangeIndent( BOOL bIncrement );
//STRIP001 
//STRIP001 	void			Protect( USHORT nTab, const String& rPassword );
//STRIP001 	BOOL			Unprotect( USHORT nTab, const String& rPassword );
//STRIP001 
//STRIP001 	void			DeleteCells( DelCellCmd eCmd, BOOL bRecord = TRUE );
//STRIP001 	BOOL			InsertCells( InsCellCmd eCmd, BOOL bRecord = TRUE, BOOL bPartOfPaste = FALSE );
//STRIP001 	void			DeleteMulti( BOOL bRows, BOOL bRecord = TRUE );
//STRIP001 
//STRIP001 	void			DeleteContents( USHORT nFlags, BOOL bRecord = TRUE );
//STRIP001 
//STRIP001 	void			SetWidthOrHeight( BOOL bWidth, USHORT nRangeCnt, USHORT* pRanges,
//STRIP001 										ScSizeMode eMode, USHORT nSizeTwips,
//STRIP001 										BOOL bRecord = TRUE, BOOL bPaint = TRUE,
//STRIP001 										ScMarkData* pMarkData = NULL );
//STRIP001 	void			SetMarkedWidthOrHeight( BOOL bWidth, ScSizeMode eMode, USHORT nSizeTwips,
//STRIP001 										BOOL bRecord = TRUE, BOOL bPaint = TRUE );
	void			ShowMarkedColumns( BOOL bShow, BOOL bRecord = TRUE );
	void			ShowMarkedRows( BOOL bShow, BOOL bRecord = TRUE );

//STRIP001 	BOOL			AdjustBlockHeight( BOOL bPaint = TRUE, ScMarkData* pMarkData = NULL );
//STRIP001 	BOOL			AdjustRowHeight( USHORT nStartRow, USHORT nEndRow, BOOL bPaint = TRUE );

//STRIP001 	void			ModifyCellSize( ScDirection eDir, BOOL bOptimal );

//STRIP001 	void			InsertPageBreak( BOOL bColumn, BOOL bRecord = TRUE,
//STRIP001 										const ScAddress* pPos = NULL,
//STRIP001 										BOOL bSetModified = TRUE );
//STRIP001 	void			DeletePageBreak( BOOL bColumn, BOOL bRecord = TRUE,
//STRIP001 										const ScAddress* pPos = NULL,
//STRIP001 										BOOL bSetModified = TRUE );

//STRIP001 	void			RemoveManualBreaks();

//STRIP001 	void			SetPrintZoom(USHORT nScale, USHORT nPages);
//STRIP001 	void			AdjustPrintZoom();

	BOOL			TestMergeCells();
	BOOL			TestRemoveMerge();

//STRIP001 	BOOL			MergeCells( BOOL bApi, BOOL& rDoContents, BOOL bRecord = TRUE );
//STRIP001 	BOOL			RemoveMerge( BOOL bRecord = TRUE );

//STRIP001 	void			FillSimple( FillDir eDir, BOOL bRecord = TRUE );
//STRIP001 	void			FillSeries( FillDir	eDir, FillCmd eCmd, FillDateCmd	eDateCmd,
//STRIP001 								double fStart, double fStep, double fMax, BOOL bRecord = TRUE );
//STRIP001 	void			FillAuto( FillDir eDir, USHORT nStartCol, USHORT nStartRow,
//STRIP001 								USHORT nEndCol, USHORT nEndRow, USHORT nCount, BOOL bRecord = TRUE );

//STRIP001 	void			TransliterateText( sal_Int32 nType );

//STRIP001 	ScAutoFormatData* CreateAutoFormatData();
//STRIP001 	void			AutoFormat( USHORT nFormatNo, BOOL bRecord = TRUE );

//STRIP001 	void			SearchAndReplace( const SvxSearchItem* pSearchItem,
//STRIP001 										BOOL bAddUndo, BOOL bIsApi );

//STRIP001 	void			Solve( const ScSolveParam& rParam );
//STRIP001 	void			TabOp( const ScTabOpParam& rParam,  BOOL bRecord = TRUE );

//STRIP001 	BOOL			InsertTable( const String& rName, USHORT nTabNr, BOOL bRecord = TRUE );
//STRIP001 	BOOL			InsertTables(SvStrings *pNames, USHORT nTab, USHORT nCount, BOOL bRecord = TRUE);


//STRIP001 	BOOL			AppendTable( const String& rName, BOOL bRecord = TRUE );

//STRIP001 	BOOL			DeleteTable( USHORT nTabNr, BOOL bRecord = TRUE );
//STRIP001 	BOOL			DeleteTables(const SvUShorts &TheTabs, BOOL bRecord = TRUE );

//STRIP001 	BOOL			RenameTable( const String& rName, USHORT nTabNr );
//STRIP001 	void			MoveTable( USHORT nDestDocNo, USHORT nDestTab, BOOL bCopy );
//STRIP001 	void			ImportTables( ScDocShell* pSrcShell,
//STRIP001 									USHORT nCount, const USHORT* pSrcTabs,
//STRIP001 									BOOL bLink,USHORT nTab);

//STRIP001 	void			InsertTableLink( const String& rFile,
//STRIP001 										const String& rFilter, const String& rOptions,
//STRIP001 										const String& rTabName );
//STRIP001 	void			InsertAreaLink( const String& rFile,
//STRIP001 										const String& rFilter, const String& rOptions,
//STRIP001 										const String& rSource, ULONG nRefresh );

//STRIP001 	void			ShowTable( const String& rName );
//STRIP001 	void			HideTable( USHORT nTabNr );

//STRIP001 	void			MakeScenario( const String& rName, const String& rComment,
//STRIP001 									const Color& rColor, USHORT nFlags );
//STRIP001 	void			ExtendScenario();
//STRIP001 	void			UseScenario( const String& rName );

//STRIP001 	void			InsertSpecialChar( const String& rStr, const Font& rFont );

	void			InsertDummyObject();
	void			InsertOleObject();

	void			InsertDraw();

//STRIP001 	void			SetSelectionFrameLines( const SvxBorderLine* pLine,
//STRIP001 											BOOL bColorOnly );

//STRIP001 	void			SetNote( USHORT nCol, USHORT nRow, USHORT nTab, const ScPostIt& rNote );
//STRIP001 	void			DoSpellingChecker( BOOL bRecord = TRUE );
//STRIP001 	void			DoThesaurus( BOOL bRecord = TRUE );
//STRIP001 	DECL_LINK( SpellError, void * );

//STRIP001 	void			SetPrintRanges( const String* pPrint,
//STRIP001 									const String* pRepCol, const String* pRepRow,
//STRIP001 									BOOL bAddPrint );

//STRIP001 	void			DetectiveAddPred();
//STRIP001 	void			DetectiveDelPred();
//STRIP001 	void			DetectiveAddSucc();
//STRIP001 	void			DetectiveDelSucc();
//STRIP001 	void			DetectiveAddError();
//STRIP001 	void			DetectiveMarkInvalid();
//STRIP001 	void			DetectiveDelAll();
//STRIP001 	void			DetectiveRefresh();

//STRIP001 	void			ShowNote();
//STRIP001 	void			EditNote();
//STRIP001 	void			HideNote();

	void			ForgetFormatArea()		{ bFormatValid = FALSE; }
	BOOL			SelectionEditable( BOOL* pOnlyNotBecauseOfMatrix = NULL );

												// interne Hilfsfunktionen
protected:
//STRIP001 	void			UpdateLineAttrs( SvxBorderLine&		  rLine,
//STRIP001 									 const SvxBorderLine* pDestLine,
//STRIP001 									 const SvxBorderLine* pSrcLine,
//STRIP001 									 BOOL 				  bColor );

//STRIP001 	void			PaintWidthHeight( BOOL bColumns, USHORT nStart, USHORT nEnd );


private:
//STRIP001 	void			PasteRTF( USHORT nCol, USHORT nStartRow,
//STRIP001 								const ::com::sun::star::uno::Reference<
//STRIP001 										::com::sun::star::datatransfer::XTransferable >& rxTransferable );
//STRIP001 	USHORT			GetOptimalColWidth( USHORT nCol, USHORT nTab, BOOL bFormula );

//STRIP001 	void			StartFormatArea();
//STRIP001 	BOOL			TestFormatArea( USHORT nCol, USHORT nRow, USHORT nTab, BOOL bAttrChanged );
//STRIP001 	void			DoAutoAttributes( USHORT nCol, USHORT nRow, USHORT nTab,
//STRIP001 										BOOL bAttrChanged, BOOL bAddUndo );
};



} //namespace binfilter
#endif

