/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: impastp3.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:43:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLASTPL_IMPL_HXX
#include "impastpl.hxx"
#endif
#ifndef _XMLOFF_PROPERTYSETMAPPER_HXX
#include "xmlprmap.hxx"
#endif

using namespace std;
using namespace rtl;

//#############################################################################
//
// Class SvXMLAutoStylePoolParent_Impl
//

///////////////////////////////////////////////////////////////////////////////
//
// dtor class SvXMLAutoStylePoolParent_Impl
//

SvXMLAutoStylePoolParentP_Impl::~SvXMLAutoStylePoolParentP_Impl()
{
	while( maPropertiesList.Count() )
		delete maPropertiesList.Remove( maPropertiesList.Count() -1 );
}

///////////////////////////////////////////////////////////////////////////////
//
// Adds a array of XMLPropertyState ( vector< XMLPropertyState > ) to list
// if not added, yet.
//

sal_Bool SvXMLAutoStylePoolParentP_Impl::Add( XMLFamilyData_Impl* pFamilyData, const vector< XMLPropertyState >& rProperties, OUString& rName )
{
	sal_Bool bAdded = sal_False;

	sal_Int32 nProperties = rProperties.size();
	sal_uInt32 nCount = maPropertiesList.Count();
	SvXMLAutoStylePoolPropertiesP_Impl *pProperties = 0;
	sal_uInt32 i;

	for( i = 0; i < nCount; i++ )
	{
		SvXMLAutoStylePoolPropertiesP_Impl *pIS = maPropertiesList.GetObject( i );
		if( nProperties > pIS->GetProperties().size() ) 
		{
			continue;
		}
		else if( nProperties < pIS->GetProperties().size() )
		{
			break;
		}
		else if( pFamilyData->mxMapper->Equals( pIS->GetProperties(), rProperties ) ) 
		{
			pProperties = pIS;
			break;
		}
	}
	
	if( !pProperties )
	{
		pProperties = new SvXMLAutoStylePoolPropertiesP_Impl( pFamilyData, rProperties );
		maPropertiesList.Insert( pProperties, i );
		bAdded = sal_True;
	}
	
	rName = pProperties->GetName();

	return bAdded;
}

///////////////////////////////////////////////////////////////////////////////
//
// Search for a array of XMLPropertyState ( vector< XMLPropertyState > ) in list
//

OUString SvXMLAutoStylePoolParentP_Impl::Find( const XMLFamilyData_Impl* pFamilyData, const vector< XMLPropertyState >& rProperties ) const
{
	OUString sName;
	sal_uInt16 nItems = rProperties.size();
	sal_uInt32 nCount = maPropertiesList.Count();
	for( sal_uInt32 i=0; i < nCount; i++ )
	{
		SvXMLAutoStylePoolPropertiesP_Impl *pIS = maPropertiesList.GetObject( i );
		if( nItems > pIS->GetProperties().size() ) 
		{
			continue;
		}
		else if( nItems < pIS->GetProperties().size() )
		{
			break;
		}
		else if( pFamilyData->mxMapper->Equals( pIS->GetProperties(), rProperties ) ) 
		{
			sName = pIS->GetName();
			break;
		}
	}
	
	return sName;
}

///////////////////////////////////////////////////////////////////////////////
//
// Sort-function for sorted list of SvXMLAutoStylePoolParent_Impl-elements
//

int SvXMLAutoStylePoolParentPCmp_Impl( const SvXMLAutoStylePoolParentP_Impl& r1,
									   const SvXMLAutoStylePoolParentP_Impl& r2)
{
	return (int)r1.GetParent().compareTo( r2.GetParent() );
}

///////////////////////////////////////////////////////////////////////////////
//
// Implementation of sorted list of SvXMLAutoStylePoolParent_Impl-elements
//

IMPL_CONTAINER_SORT( SvXMLAutoStylePoolParentsP_Impl, 
					 SvXMLAutoStylePoolParentP_Impl,
				     SvXMLAutoStylePoolParentPCmp_Impl )
