/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpURLStreamHandlerFactory.java,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:40:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

package com.sun.star.help;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;


public final class HelpURLStreamHandlerFactory
	implements URLStreamHandlerFactory {

	protected static byte[] _doc = null;
	private String _HelpURLHandler;

	public HelpURLStreamHandlerFactory(String HelpURLHandler) {
		_HelpURLHandler = HelpURLHandler;
		_doc = null;
	}

	protected static byte[] getData() {
		return _doc;
	}

	protected static void setMode(byte[] doc) {
		_doc = doc;
	}

    public URLStreamHandler createURLStreamHandler(String protocol) {
		try {
			if ("vnd.sun.star.help".equals(protocol)) {
				if ("with-jars".equals(_HelpURLHandler))
					return new HelpURLStreamHandlerWithJars();
				else if ("with-files".equals(_HelpURLHandler))
					return new HelpURLStreamHandler();
				else
					return null;
			} else if ("file".equals(protocol)) {
				Class c;
				try 
				{
					c = Class.forName("com.sun.star.help.FileURLStreamHandler");
				}
				catch (Exception e)
				{
					c = Class.forName("com.sun.star.help.GCJFileURLStreamHandler");
				}
				return (URLStreamHandler)c.newInstance();
			} else {
				try {
						Class handlerClass =
							Class.forName(
								"sun.net.www.protocol." + protocol + ".Handler");
						return (URLStreamHandler) handlerClass.newInstance();
				} catch (java.lang.ClassNotFoundException ec) {
						Class handlerClass =
							Class.forName(
								"gnu.java.net.protocol." + protocol + ".Handler");
						return (URLStreamHandler) handlerClass.newInstance();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

}
