/*
 * FileChooser.java
 *
 * Created on 15. Mai 2003, 10:04
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.awt.Component;

import java.io.File;

import javax.swing.JFileChooser;

/**
 * Provides a GUI and functionality for save and open file.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class FileChooser extends JFileChooser {
    /**
     * Creates a new FileChooser object.
     */
    public FileChooser() {
        super();
    }

    /**
     * Opens file save dialog and returns a file selected by the user.
     *
     * @param comp object
     *
     * @return selected file
     */
    public File saveDialog(Component comp) {
        setMultiSelectionEnabled(false);
        setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);

        int state = super.showSaveDialog(comp);
        File destFile = getSelectedFile();

        if ((destFile != null) && (state == JFileChooser.APPROVE_OPTION)) {
            return destFile;
        }

        return null;
    }

    /**
     * Opens file open dialog and returns a file selected by the user.
     *
     * @param comp object
     *
     * @return selected file
     */
    public File openDialog(Component comp) {
        int state = super.showOpenDialog(comp);
        setMultiSelectionEnabled(false);

        File file = getSelectedFile();

        if ((file != null) && (state == JFileChooser.APPROVE_OPTION)) {
            return file;
        }

        return null;
    }
}
