/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: backgrounddownload.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:24:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/**************************************************************************
								TODO
 **************************************************************************

 *************************************************************************/

#ifndef _UCBHELPER_BACKGROUNDDOWNLOAD_HXX_
#define _UCBHELPER_BACKGROUNDDOWNLOAD_HXX_

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASINK_HPP_
#include <com/sun/star/io/XActiveDataSink.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDENVIRONMENT_HPP_
#include <com/sun/star/ucb/XCommandEnvironment.hpp>
#endif

#ifndef INCLUDED_UCBHELPERDLLAPI_H
#include "ucbhelper/ucbhelperdllapi.h"
#endif

namespace ucb_impl
{   
    class DownloadThread_Impl;
}


namespace ucb
{
    /** An external library(l) often has an interface expecting:
     *  1. a callback - function of the following signature, corresponding
     *     to standard I/O function 'fwrite' (without last parameter FILE*).
     *  2. a pointer to userdata, given to the callback as last parameter.
     *
     *  In standard I/O the last parameter plays the role of the stream pointer
     +  (FILE*), to which the data are written.
     *
     *  If the above is your case, you can either use the following function 
     *  directly or wrap it with some simple function, to adapt it to the
     *  signature your library expects.
     *  
     *  Use '::ucb::DownloadThread::GetSink' to get the value for
     *  input parameter'userData'.
     *
     *  This function writes up to 'nmemb' objects of size 'size' from the
     *  array 'data' into the DataSink in userData.  The return value is
     *  the number of bytes written, if the call succeeds. 
     *  A value less than zero indicates some sort of error,
     *  such as running out of space.
     */
    
    extern "C" UCBHELPER_DLLPUBLIC int writeToDataSink(
        void *buffer,size_t size,size_t nmemb,void *userData);
    
    class UCBHELPER_DLLPUBLIC DataSink
    {
        UCBHELPER_DLLPUBLIC friend int writeToDataSink(
            void *data,size_t size,size_t nmemb,void *userData);
        
    private:
        
        
        UCBHELPER_DLLPRIVATE virtual int write(void *data,size_t size,size_t nmemb) = 0;
    };

    class UCBHELPER_DLLPUBLIC DownloadThread
    {
    public:
        
        /** never create this class or derived one on the stack.
         */
        
        DownloadThread(const com::sun::star::uno::Reference<
                       com::sun::star::ucb::XCommandEnvironment >& xEnv);
        
        
        /** only call the destructor if 'Get' failed.
         */
        
        virtual ~DownloadThread();
        
        
        /** blocks until either the user calls 'OnDownloading' or
         *  'OnAborted' from the work function or the external library
         *  calls 'writeToDataSink'.with a sink retrieved by 'GetSink'.
         *  Returns true on success, which yields the ownership of *this*
         *  object to the InputStream set at the XActiveDataSink.
         *  On failure, the no InputStream is set at the XActiveDataSink,
         *  and its your responsibility to cleanup.
         */
        
        bool Get(
            const ::com::sun::star::uno::Reference<
            ::com::sun::star::io::XActiveDataSink>& ) const;

                
    protected:


        /******************************************************
                       NOTIFICATIONS
        ******************************************************/

        /** 'OnDownload' should be called by your 'work' - method
            if the server is responding and the download procceeds.
        */
        
        void OnDownload();
        
        
        /** Can be called from your 'work' - function to signal an error.
         *  After such a call you *MUST* return from work.
         */
        
        void OnAbort();
        
                
        /******************************************************
                       SERVICES
        ******************************************************/
        
        /** Used like: 
         *  do {
         *     lib_function_download(writeToDataSink,GetSink());
         *     ...
         *  } while(retry);
         *  in the work function.
         *  The DataSink will not use more than nMaxMem bytes of memory
         *  for buffering (after which it will switch to a file for buffering.)
         *  Any other call resets the sink.
         */
        
        DataSink* GetSink(size_t nMaxMem = 1024*1024) const;
        
        
        /** ALWAYS use this method to access the environment from
         *  your work function. 
         *  Direct access to the methods of the CommandEnvironment used
         *  to construct this object return notoriously thread-unsafe
         *  interfaces, which you can't call directly from your work-function.
        */
        
        com::sun::star::uno::Reference<
            com::sun::star::ucb::XCommandEnvironment >
        GetEnv();
        

        /******************************************************
                       WORK OUT THE FOLLOWING
        ******************************************************/

        /** Please note that this function is called from a
         *  different thread, so its up to user of this class
         *  to ensure that *this* object exists, as long as member
         *  variables of the derived class will be accessed from work.
         */
        
        virtual void work() = 0;
        

    private:
        
        mutable osl::Mutex                             m_aMutex;
        friend class ucb_impl::DownloadThread_Impl;
        mutable ucb_impl::DownloadThread_Impl*         m_pImpl;
        
        mutable com::sun::star::uno::Reference<
            com::sun::star::ucb::XCommandEnvironment > m_xEnv;
    };
    

} // end namespace ucb

#endif
