/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: slidechangeanimation.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:20:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_SLIDECHANGEANIMATION_HXX
#define _SLIDESHOW_SLIDECHANGEANIMATION_HXX

#include <unoview.hxx>
#include <numberanimation.hxx>


/* Definition of SlideChangeAnimation interface */

namespace presentation
{
    namespace internal
    {
        /** Interface defining a number animation.

        	This interface is a specialization of the Animation
        	interface, and is used to animate attributes representable
        	by a single floating point value.
         */
        class SlideChangeAnimation : public NumberAnimation
        {
        public:
            /** Add a new view to this object

            	The slide change will be made visible on the new view
             */
            virtual void addView( const UnoViewSharedPtr& rView ) = 0;

            /** Revoke a view
                
            	The slide change will cease to be display on the given
            	view.
             */
            virtual bool removeView( const UnoViewSharedPtr& rView ) = 0;
        };

        typedef ::boost::shared_ptr< SlideChangeAnimation > SlideChangeAnimationSharedPtr;

    }
}

#endif /* _SLIDESHOW_SLIDECHANGEANIMATION_HXX */
