/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mediash.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/05/02 15:49:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <sfx2/app.hxx>
#include <sfx2/objface.hxx>
#include <sfx2/request.hxx>
#include <avmedia/mediaitem.hxx>
#include <svtools/whiter.hxx>
#include <svx/svdomedia.hxx>
#include <svx/sdr/contact/viewcontactofsdrmediaobj.hxx>

#include "mediash.hxx"
#include "sc.hrc"
#include "viewdata.hxx"
#include "drawview.hxx"
#include "scresid.hxx"

#define ScMediaShell
#include "scslots.hxx"

#define ITEMVALUE(ItemSet,Id,Cast) ((const Cast&)(ItemSet).Get(Id)).GetValue()


SFX_IMPL_INTERFACE(ScMediaShell, ScDrawShell, ScResId(SCSTR_GRAPHICSHELL) )
{
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT, ScResId(RID_MEDIA_OBJECTBAR) );
	SFX_POPUPMENU_REGISTRATION( ScResId(RID_POPUP_MEDIA) );
}

TYPEINIT1( ScMediaShell, ScDrawShell );

ScMediaShell::ScMediaShell(ScViewData* pData) :
	ScDrawShell(pData)
{
	SetHelpId(HID_SCSHELL_MEDIA);
	SetName( String( ScResId( SCSTR_MEDIASHELL ) ) );
}

ScMediaShell::~ScMediaShell()
{
}

void ScMediaShell::GetMediaState( SfxItemSet& rSet )
{
	ScDrawView* pView = GetViewData()->GetScDrawView();

	if( pView )
	{
		SfxWhichIter	aIter( rSet );
		USHORT			nWhich = aIter.FirstWhich();

		while( nWhich )
		{
			if( SID_AVMEDIA_TOOLBOX == nWhich )
			{
				SdrMarkList*	pMarkList = new SdrMarkList( pView->GetMarkedObjectList() );
				bool			bDisable = true;

				if( 1 == pMarkList->GetMarkCount() )
				{
					SdrObject* pObj = pMarkList->GetMark( 0 )->GetObj();

					if( pObj && pObj->ISA( SdrMediaObj ) )
					{
						::avmedia::MediaItem aItem( SID_AVMEDIA_TOOLBOX );

						static_cast< sdr::contact::ViewContactOfSdrMediaObj& >( pObj->GetViewContact() ).updateMediaItem( aItem );
						rSet.Put( aItem );
						bDisable = false;
					}
				}

				if( bDisable )
					rSet.DisableItem( SID_AVMEDIA_TOOLBOX );

				delete pMarkList;
			}

			nWhich = aIter.NextWhich();
		}
	}
}

void ScMediaShell::ExecuteMedia( SfxRequest& rReq )
{
	ScDrawView* pView = GetViewData()->GetScDrawView();

	if( pView && SID_AVMEDIA_TOOLBOX == rReq.GetSlot() )
	{
		const SfxItemSet*	pArgs = rReq.GetArgs();
		const SfxPoolItem*	pItem;
		USHORT				nSlot = rReq.GetSlot();
		BOOL				bGeometryChanged = FALSE;

		if( !pArgs || ( SFX_ITEM_SET != pArgs->GetItemState( SID_AVMEDIA_TOOLBOX, FALSE, &pItem ) ) )
			pItem = NULL;

		if( pItem )
		{
			SdrMarkList* pMarkList = new SdrMarkList( pView->GetMarkedObjectList() );

			if( 1 == pMarkList->GetMarkCount() )
			{
				SdrObject* pObj = pMarkList->GetMark( 0 )->GetObj();

				if( pObj && pObj->ISA( SdrMediaObj ) )
				{
					static_cast< sdr::contact::ViewContactOfSdrMediaObj& >( pObj->GetViewContact() ).executeMediaItem(
						static_cast< const ::avmedia::MediaItem& >( *pItem ) );
				}

				delete pMarkList;
			}
		}
	}

	Invalidate();
}
