
package org.netbeans.modules.openoffice.wizard.panels.idl;

import java.awt.*;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
//import org.netbeans.modules.openoffice.wizard.nodes.utils.IdlUtilities;


public class EnumPanel extends BasePanel
    implements DocumentListener
{
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField name;
    private JTextField values;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle");
    
    
    public EnumPanel()
    {
        initComponents();
        postInitComponents();
    }

    public String getName()
    {
        return name.getText().trim();
    }

    public void setName(String s)
    {
        name.setText(s);
    }

    public String getValues()
    {
        return values.getText();
    }

    public void setValues(String s)
    {
        values.setText(s);
    }

    private void postInitComponents()
    {
        name.getDocument().addDocumentListener(this);
        values.getDocument().addDocumentListener(this);
    }

    private void initComponents()
    {
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();
        name = new JTextField();
        values = new JTextField();
        setLayout(new GridBagLayout());
        setPreferredSize(new Dimension(250, 56));
        jLabel1.setText(bundle.getString("TXT_ModuleName"));
        jLabel1.setLabelFor(name);
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(8, 8, 4, 4);
        gridbagconstraints.anchor = 17;
        add(jLabel1, gridbagconstraints);
        jLabel2.setText(bundle.getString("TXT_EnumValues"));
        jLabel2.setLabelFor(values);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.insets = new Insets(4, 8, 8, 4);
        gridbagconstraints.anchor = 17;
        add(jLabel2, gridbagconstraints);
        name.setPreferredSize(new Dimension(100, 16));
        name.setToolTipText(bundle.getString("TIP_EnumName"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(8, 4, 4, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(name, gridbagconstraints);
        values.setPreferredSize(new Dimension(100, 16));
        values.setToolTipText(bundle.getString("TIP_EnumValues"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(4, 4, 8, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(values, gridbagconstraints);
    }

    public void removeUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void changedUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void insertUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    private void checkState()
    {
//        if(!IdlUtilities.isValidIDLIdentifier(name.getText()) || values.getText().length() == 0)
//        {
//            disableOk();
//        }
//        else
//        {
//            String s = values.getText().trim();
//            if(s.charAt(s.length() - 1) == ',')
//            {
//                disableOk();
//            }
//            else
//            {
//                for(StringTokenizer stringtokenizer = new StringTokenizer(s, ","); stringtokenizer.hasMoreTokens();)
//                {
//                    String s1 = stringtokenizer.nextToken();
//                    if(!IdlUtilities.isValidIDLIdentifier(s1))
//                    {
//                        disableOk();
//                        return;
//                    }
//                }
//
//                enableOk();
//            }
//        }
    }



}
