/*
 * MethodDescriptionPanel.java
 *
 * Created on 4. Februar 2002
 */

package org.netbeans.modules.openoffice.wizard.panels.addin;

import java.awt.Component;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.JComboBox;
import java.io.DataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.src.MethodParameter;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.Type;
import org.openide.src.SourceException;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.netbeans.modules.openoffice.wizard.IDLInterface;
import org.netbeans.modules.openoffice.wizard.IDLMethod;
import org.netbeans.modules.openoffice.wizard.IDLParameter;
import org.netbeans.modules.openoffice.wizard.OOAddinData;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectOutput;
import java.io.IOException;
import java.util.Vector;

import org.openide.filesystems.Repository;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;

import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.DataObjectList;
import org.netbeans.modules.jarpackager.JarContent;

import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.loaders.DataObjectNotFoundException;
import java.util.Enumeration;

/** A single panel for the OpenOffice.org Calc Add-ins wizard.
 *
 * @author Bertram Nolte
 */
public class MethodDescriptionPanel extends javax.swing.JPanel implements WizardDescriptor.Panel /* .FinishPanel */ {
    
    private Vector vectorInterfaces;
    private Vector vectorMethods = null;
    
    private OOAddinData oocalcaddinsdata;
    
    /** Create the wizard panel and set up some basic properties. */
    public MethodDescriptionPanel( OOAddinData myData ) {
        initComponents();
        // Provide a name in the title bar.
        setName(NbBundle.getMessage(MethodDescriptionPanel.class, "TITLE_WizardPanel"));
        /*
        // Optional: provide a special description for this pane.
        // You must have turned on WizardDescriptor.WizardPanel_helpDisplayed
        // (see descriptor in standard iterator template for an example of this).
        try {
            putClientProperty ("WizardPanel_helpURL", // NOI18N
                new URL ("nbresloc:/org/netbeans/modules/openoffice/wizard/CalcAddInsMethods/MethodDescriptionHelp.html")); // NOI18N
        } catch (MalformedURLException mfue) {
            throw new IllegalStateException (mfue.toString ());
        }
         */
        
        oocalcaddinsdata = myData;
    }
    
    // --- VISUAL DESIGN OF PANEL ---
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jcomboboxMethods = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jtextfieldMethodName = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jtextfieldMethodDescription = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jcomboboxCategory = new javax.swing.JComboBox();
        jPanel3 = new javax.swing.JPanel();
        jcomboboxParameters = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jtextfieldParameterName = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jtextfieldParameterDescription = new javax.swing.JTextField();
        jcomboboxInterfaces = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setPreferredSize(new java.awt.Dimension(601, 100));
        setMinimumSize(new java.awt.Dimension(601, 100));
        jLabel1.setText("Select an interface from the Interfaces list, a method from the Methods list,");
        jLabel1.setPreferredSize(new java.awt.Dimension(430, 17));
        jLabel1.setMinimumSize(new java.awt.Dimension(430, 17));
        jLabel1.setMaximumSize(new java.awt.Dimension(430, 17));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabel1, gridBagConstraints1);
        
        jPanel1.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints2;
        
        jPanel1.setBorder(new javax.swing.border.TitledBorder("Interfaces"));
        jPanel1.setPreferredSize(new java.awt.Dimension(380, 260));
        jPanel2.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints3;
        
        jPanel2.setBorder(new javax.swing.border.TitledBorder("Methods"));
        jPanel2.setPreferredSize(new java.awt.Dimension(368, 205));
        jcomboboxMethods.setToolTipText("Select a method.");
        jcomboboxMethods.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxMethodsActionPerformed(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new java.awt.Insets(22, 1, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jcomboboxMethods, gridBagConstraints3);
        
        jLabel4.setText("Method Display Name:");
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jLabel4, gridBagConstraints3);
        
        jtextfieldMethodName.setToolTipText("Enter a method name, which will be displayed.");
        jtextfieldMethodName.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jtextfieldMethodNameFocusLost(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints3.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jtextfieldMethodName, gridBagConstraints3);
        
        jLabel6.setText("Method Display Description:");
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 3;
        gridBagConstraints3.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jLabel6, gridBagConstraints3);
        
        jtextfieldMethodDescription.setToolTipText("Enter the method description, which will be displayed.");
        jtextfieldMethodDescription.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jtextfieldMethodDescriptionFocusLost(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints3.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jtextfieldMethodDescription, gridBagConstraints3);
        
        jLabel8.setText("Category Display Name:");
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jLabel8, gridBagConstraints3);
        
        jcomboboxCategory.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Database", "Date&Time", "Financial", "Information", "Logical", "Mathematical", "Array", "Statistical", "Spreadsheet", "Text", "Add-in" }));
        jcomboboxCategory.setToolTipText("Select a category for the selected method.");
        jcomboboxCategory.setSelectedIndex(10);
        jcomboboxCategory.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcomboboxCategoryActionPerformed(evt);
            }
        });
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 6;
        gridBagConstraints3.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(jcomboboxCategory, gridBagConstraints3);
        
        jPanel3.setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints4;
        
        jPanel3.setBorder(new javax.swing.border.TitledBorder("Parameters"));
        jcomboboxParameters.setToolTipText("Select an argument.");
        jcomboboxParameters.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcomboboxParametersActionPerformed(evt);
            }
        });
        
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jcomboboxParameters, gridBagConstraints4);
        
        jLabel5.setText("Parameter Display Name:");
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jLabel5, gridBagConstraints4);
        
        jtextfieldParameterName.setToolTipText("Enter an argument name, which will be displayed.");
        jtextfieldParameterName.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jtextfieldParameterNameFocusLost(evt);
            }
        });
        
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints4.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jtextfieldParameterName, gridBagConstraints4);
        
        jLabel7.setText("Parameter Display Description:");
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jLabel7, gridBagConstraints4);
        
        jtextfieldParameterDescription.setToolTipText("Enter the parameter description, which will be displayed.");
        jtextfieldParameterDescription.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jtextfieldParameterDescriptionFocusLost(evt);
            }
        });
        
        gridBagConstraints4 = new java.awt.GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints4.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints4.anchor = java.awt.GridBagConstraints.WEST;
        jPanel3.add(jtextfieldParameterDescription, gridBagConstraints4);
        
        gridBagConstraints3 = new java.awt.GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridheight = 7;
        gridBagConstraints3.insets = new java.awt.Insets(1, 10, 1, 1);
        gridBagConstraints3.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jPanel3, gridBagConstraints3);
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints2.insets = new java.awt.Insets(1, 1, 1, 1);
        jPanel1.add(jPanel2, gridBagConstraints2);
        
        jcomboboxInterfaces.setToolTipText("Select an interface.");
        jcomboboxInterfaces.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jcomboboxInterfacesActionPerformed(evt);
            }
        });
        
        gridBagConstraints2 = new java.awt.GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints2.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(jcomboboxInterfaces, gridBagConstraints2);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        add(jPanel1, gridBagConstraints1);
        
        jLabel2.setText("and if necessary a Parameter from the Parameters list,");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabel2, gridBagConstraints1);
        
        jLabel3.setText("then fill in the description below.");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jLabel3, gridBagConstraints1);
        
    }//GEN-END:initComponents
    
    private void jcomboboxInterfacesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcomboboxInterfacesActionPerformed
        int intSelectedIndex = jcomboboxInterfaces.getSelectedIndex();
        if ( intSelectedIndex != -1 ) {
            // Get interface.
            IDLInterface interfacedescriptionToDisplay
            = ( IDLInterface ) vectorInterfaces.elementAt(
            intSelectedIndex );
            
            vectorMethods = interfacedescriptionToDisplay.getVectorMethods();
            
            jcomboboxMethods.removeAllItems();
            
            for ( int intMethodCounter = 0;
            intMethodCounter < vectorMethods.size();
            intMethodCounter++ ) {
                IDLMethod methoddescription = ( IDLMethod )
                vectorMethods.elementAt( intMethodCounter );
                
                // Fill in the method combo box.
                jcomboboxMethods.addItem(
                methoddescription.getMethodElement().getName().getName() );
            }
            
            // Select the first item.
            jcomboboxMethods.setSelectedIndex( 0 );
        }
    }//GEN-LAST:event_jcomboboxInterfacesActionPerformed
    
    private void jtextfieldParameterDescriptionFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jtextfieldParameterDescriptionFocusLost
        IDLMethod methoddescription = ( IDLMethod )
        vectorMethods.elementAt( jcomboboxMethods.getSelectedIndex() );
        
        //ArgumentDescription argumentdescription[] = methoddescription.getArgumentDescription();
        methoddescription.getArgumentDescription()[
        jcomboboxParameters.getSelectedIndex() ].setArgumentDescription(
        jtextfieldParameterDescription.getText() );
    }//GEN-LAST:event_jtextfieldParameterDescriptionFocusLost
    
    private void jtextfieldParameterNameFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jtextfieldParameterNameFocusLost
        IDLMethod methoddescription = ( IDLMethod )
        vectorMethods.elementAt( jcomboboxMethods.getSelectedIndex() );
        
        methoddescription.getArgumentDescription()[
        jcomboboxParameters.getSelectedIndex() ].setDisplayArgumentName(
        jtextfieldParameterName.getText() );
    }//GEN-LAST:event_jtextfieldParameterNameFocusLost
    
    private void jtextfieldMethodDescriptionFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jtextfieldMethodDescriptionFocusLost
        IDLMethod methoddescription = ( IDLMethod )
        vectorMethods.elementAt( jcomboboxMethods.getSelectedIndex() );
        
        methoddescription.setFunctionDescription(
        jtextfieldMethodDescription.getText() );
    }//GEN-LAST:event_jtextfieldMethodDescriptionFocusLost
    
    private void jtextfieldMethodNameFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jtextfieldMethodNameFocusLost
        IDLMethod methoddescription = ( IDLMethod )
        vectorMethods.elementAt( jcomboboxMethods.getSelectedIndex() );
        
        methoddescription.setDisplayFunctionName(
        jtextfieldMethodName.getText() );
    }//GEN-LAST:event_jtextfieldMethodNameFocusLost
    
    private void jcomboboxCategoryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcomboboxCategoryActionPerformed
        IDLMethod methoddescription = ( IDLMethod )
        vectorMethods.elementAt( jcomboboxMethods.getSelectedIndex() );
        
        methoddescription.setCategory(
        ( String ) jcomboboxCategory.getSelectedItem() );
    }//GEN-LAST:event_jcomboboxCategoryActionPerformed
    
    private void jcomboboxParametersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jcomboboxParametersActionPerformed
        // Get index of parameter.
        int intArgumentIndex = jcomboboxParameters.getSelectedIndex();
        
        if ( intArgumentIndex != -1 ) {
            // Get index of method.
            int intMethodIndex = jcomboboxMethods.getSelectedIndex();
            
            IDLMethod methoddescription = ( IDLMethod )
            vectorMethods.elementAt( intMethodIndex );
            
            // Get arguments.
            IDLParameter argumentdescription =
            methoddescription.getArgumentDescription()[ intArgumentIndex ];
            
            // Set argument display name.
            jtextfieldParameterName.setText(
            argumentdescription.getDisplayArgumentName() );
            
            // Set argument description.
            jtextfieldParameterDescription.setText(
            argumentdescription.getArgumentDescription() );
        }
        
    }//GEN-LAST:event_jcomboboxParametersActionPerformed
    
    private void jComboBoxMethodsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxMethodsActionPerformed
        int intSelectedIndex = jcomboboxMethods.getSelectedIndex();
        if ( intSelectedIndex != -1 ) {
            // Get method.
            IDLMethod methoddescriptionToDisplay
            = ( IDLMethod ) vectorMethods.elementAt( intSelectedIndex );
            
            // Set category name.
            jcomboboxCategory.setSelectedItem(
            methoddescriptionToDisplay.getCategory() );
            
            // Set method display name.
            jtextfieldMethodName.setText(
            methoddescriptionToDisplay.getDisplayFunctionName() );
            
            // Set method description.
            jtextfieldMethodDescription.setText(
            methoddescriptionToDisplay.getFunctionDescription() );
            
            // Remove all parameters from the combo box.
            jcomboboxParameters.removeAllItems();
            
            MethodParameter[] methodparameter =
            methoddescriptionToDisplay.getMethodElement().getParameters();
            
            if ( methodparameter.length != 0 ) {
                for ( int intMethodCounter = 0;
                intMethodCounter < methodparameter.length;
                intMethodCounter++ ) {
                    jcomboboxParameters.addItem(
                    methodparameter[ intMethodCounter ].getName() );
                }
                
                // Select the first argument.
                jcomboboxParameters.setSelectedIndex( 0 );
            }
            else {
                // Remove parameter display name
                jtextfieldParameterName.setText( "" );
                
                // Remove parameter description
                jtextfieldParameterDescription.setText( "" );
            }
        }
        
    }//GEN-LAST:event_jComboBoxMethodsActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JComboBox jcomboboxMethods;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField jtextfieldMethodName;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JTextField jtextfieldMethodDescription;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JComboBox jcomboboxCategory;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JComboBox jcomboboxParameters;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextField jtextfieldParameterName;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JTextField jtextfieldParameterDescription;
    private javax.swing.JComboBox jcomboboxInterfaces;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    // End of variables declaration//GEN-END:variables
    
    // --- WizardDescriptor.Panel METHODS ---
    
    // Get the visual component for the panel. In this template, the same class
    // serves as the component and the Panel interface, but you could keep
    // them separate if you wished.
    public Component getComponent() {
        return this;
    }
    
    public HelpCtx getHelp() {
        return new HelpCtx( "org.netbeans.modules.openoffice.help.HOMEID" );
    }
    
    public boolean isValid() {
        // If it is always OK to press Next or Finish, then:
        return true;
        // If it depends on some condition (form filled out...), then:
        // return someCondition ();
        // and when this condition changes (last form field filled in...) then:
        // fireChangeEvent ();
        // and uncomment the complicated stuff below.
    }
    
    public final void addChangeListener(ChangeListener l) {}
    public final void removeChangeListener(ChangeListener l) {}
    /*
    private final Set listeners = new HashSet (1); // Set<ChangeListener>
    public final void addChangeListener (ChangeListener l) {
        synchronized (listeners) {
            listeners.add (l);
        }
    }
    public final void removeChangeListener (ChangeListener l) {
        synchronized (listeners) {
            listeners.remove (l);
        }
    }
    protected final void fireChangeEvent () {
        Iterator it;
        synchronized (listeners) {
            it = new HashSet (listeners).iterator ();
        }
        ChangeEvent ev = new ChangeEvent (this);
        while (it.hasNext ()) {
            ((ChangeListener) it.next ()).stateChanged (ev);
        }
    }
     */
    
    // You can use a settings object to keep track of state.
    // Normally the settings object will be the WizardDescriptor,
    // so you can use WizardDescriptor.getProperty & putProperty
    // to store information entered by the user.
    public void readSettings(Object settings) {
        vectorInterfaces = oocalcaddinsdata.getIDLInterfaces();
        
        // Set default descriptions for every interface.
        for ( int intIndexInterface = 0;
        intIndexInterface < vectorInterfaces.size();
        intIndexInterface++ ) {
            // Get the interface.
            IDLInterface idlinterface = ( IDLInterface )
            vectorInterfaces.elementAt( intIndexInterface );
            
            // Get the method vector.
            vectorMethods = idlinterface.getVectorMethods();
            
            // Set default descriptions for every method.
            for ( int intIndexMethod = 0;
            intIndexMethod < vectorMethods.size();
            intIndexMethod++ ) {
                // Get the method.
                IDLMethod idlmethod =
                ( IDLMethod ) vectorMethods.elementAt( intIndexMethod );
                
                // Set the default display function name.
                idlmethod.setDisplayFunctionName(
                idlmethod.getMethodElement().getName().getName() );
                
                // Set the default function desription.
                idlmethod.setFunctionDescription( "Without description." );
                
                // Set the default category.
                idlmethod.setCategory( "Add-in" );
                
                // Get the method element.
                MethodElement methodelement = idlmethod.getMethodElement();
                
                // Get the parameters from the method.
                MethodParameter[] methodparameter =
                methodelement.getParameters();
                
                // Create an array for the parameter description.
                IDLParameter[] idlparameter =
                new IDLParameter[ methodparameter.length ];
                
                // Set default descriptions for every parameter.
                for ( int intIndexParameter = 0;
                intIndexParameter < methodparameter.length;
                intIndexParameter++ ) {
                    // Create a new parameter.
                    idlparameter[ intIndexParameter ] = new IDLParameter();
                    
                    // Set default display parameter name.
                    idlparameter[ intIndexParameter ].setDisplayArgumentName(
                    methodparameter[ intIndexParameter ].getName() );
                    
                    // Set default display parameter description.
                    idlparameter[ intIndexParameter ].setArgumentDescription(
                    "Without description." );
                }
                
                // Set parameter description.
                idlmethod.setArgumentDescription( idlparameter );
            }
            
            // Fill in the interface combo box.
            jcomboboxInterfaces.addItem(
            idlinterface.getIdentifierName().getName() );
        }
        
        if ( vectorInterfaces.size() > 0 ) {
            // Enable text fields and combo box.
            jcomboboxCategory.enable();
            jtextfieldMethodName.enable();
            jtextfieldMethodDescription.enable();
            jtextfieldParameterName.enable();
            jtextfieldParameterDescription.enable();
            
            // Select the first item.
            jcomboboxInterfaces.setSelectedIndex( 0 );
        }
        else {
            // Disable text fields and combo box.
            jcomboboxCategory.disable();
            jtextfieldMethodName.disable();
            jtextfieldMethodDescription.disable();
            jtextfieldParameterName.disable();
            jtextfieldParameterDescription.disable();
        }
        
    }
    
    public void storeSettings(Object settings) {
        this.writeDescription();
    }
    
    private final void writeDescription() {
        // Writing descriptions into the class.
        
        // Initialize method counter.
        int intMethod = 0;
        
        // Get field with function names.
        FieldElement fieldelementFunctionNames =
        //oocalcaddinsdata.customized_innerclass.getField(
        oocalcaddinsdata.getInnerClass().getField(
        Identifier.create( "stringFunctionName" ) );
        
        // Get method element for display argument names.
        Type[] typeParameterArgumentName = new Type[ 2 ];
        typeParameterArgumentName[ 0 ] = Type.parse( "java.lang.String" );
        typeParameterArgumentName[ 1 ] = Type.parse( "int" );
        MethodElement methodelementDisplayArgumentName =
        //oocalcaddinsdata.customized_innerclass.getMethod(
        oocalcaddinsdata.getInnerClass().getMethod(
        Identifier.create( "getDisplayArgumentName" ),
        typeParameterArgumentName );
        
        // Get method element for argument description.
        Type[] typeParameterArgumentDescription = new Type[ 2 ];
        typeParameterArgumentDescription[ 0 ] = Type.parse( "java.lang.String" );
        typeParameterArgumentDescription[ 1 ] = Type.parse( "int" );
        MethodElement methodelementArgumentDescription =
        //oocalcaddinsdata.customized_innerclass.getMethod(
        oocalcaddinsdata.getInnerClass().getMethod(
        Identifier.create( "getArgumentDescription" ),
        typeParameterArgumentDescription );
        
        // Get method element for display function names.
        Type[] typeParameterFunctionName = new Type[ 1 ];
        typeParameterFunctionName[ 0 ] = Type.parse( "java.lang.String" );
        MethodElement methodelementDisplayFunctionName =
        //oocalcaddinsdata.customized_innerclass.getMethod(
        oocalcaddinsdata.getInnerClass().getMethod(
        Identifier.create( "getDisplayFunctionName" ),
        typeParameterFunctionName );
        
        // Get method element for function description.
        Type[] typeParameterFunctionDescription = new Type[ 1 ];
        typeParameterFunctionDescription[ 0 ] = Type.parse( "java.lang.String" );
        MethodElement methodelementFunctionDescription =
        //oocalcaddinsdata.customized_innerclass.getMethod(
        oocalcaddinsdata.getInnerClass().getMethod(
        Identifier.create( "getFunctionDescription" ),
        typeParameterFunctionDescription );
        
        // Get method element for programmatic category name.
        Type[] typeParameterCategoryName = new Type[ 1 ];
        typeParameterCategoryName[ 0 ] = Type.parse( "java.lang.String" );
        MethodElement methodelementCategoryName =
        //oocalcaddinsdata.customized_innerclass.getMethod(
        oocalcaddinsdata.getInnerClass().getMethod(
        Identifier.create( "getProgrammaticCategoryName" ),
        typeParameterCategoryName );
        
        for ( int intInterfaceCounter = 0;
        intInterfaceCounter < vectorInterfaces.size();
        intInterfaceCounter++ ) {
            IDLInterface interfacedescription = ( IDLInterface )
            vectorInterfaces.elementAt( intInterfaceCounter );
            for ( int intMethodCounter = 0;
            intMethodCounter < interfacedescription.getVectorMethods().size();
            intMethodCounter++ ) {
                try {
                    IDLMethod methoddescription = ( IDLMethod )
                    interfacedescription.getVectorMethods().elementAt( intMethodCounter );
                    
                    FieldElement fieldelement = new FieldElement();
                    
                    fieldelement.setName( Identifier.create( "short" +
                    methoddescription.getMethodElement().getName().getName().toUpperCase() ) );
                    
                    fieldelement.setInitValue( String.valueOf( intMethod++ ) );
                    
                    fieldelement.setType( Type.parse( "short" ) );
                    
                    fieldelement.setModifiers( Modifier.PRIVATE
                    + Modifier.FINAL + Modifier.STATIC );
                    
                    //oocalcaddinsdata.customized_innerclass.addField(
                    //fieldelement );
                    oocalcaddinsdata.getInnerClass().addField(
                    fieldelement );
                    
                    fieldelementFunctionNames.setInitValue(
                    fieldelementFunctionNames.getInitValue().substring( 0,
                    fieldelementFunctionNames.getInitValue().length() - 1 )
                    + ( ( intMethod == 1 ) ? "" : ",\n            " ) + "\""
                    + methoddescription.getMethodElement().getName().getName()
                    + "\"}" );
                    
                    // Insert display argument name.
                    MethodParameter[] methodparameter =
                    methoddescription.getMethodElement().getParameters();
                    
                    String stringCaseParameter =
                    /*
                    "                        case 0:\n"
                    + "                            stringReturn = \"(internal)\";\n"
                    + "                            break;\n";
                     */
                    "";
                    
                    for ( int intParameterCounter = 0;
                    intParameterCounter < methoddescription.getArgumentDescription().length;
                    intParameterCounter++ ) {
                        stringCaseParameter +=
                        "                        case "
                        //+ ( intParameterCounter + 1 ) + ":\n"
                        + intParameterCounter + ":\n"
                        + "                            stringReturn = \""
                        + methoddescription.getArgumentDescription()[ intParameterCounter ].getDisplayArgumentName()
                        + "\";\n"
                        + "                            break;\n";
                        
                    }
                    
                    String stringDisplayArgumentNameBody =
                    methodelementDisplayArgumentName.getBody();
                    
                    int intIndexCurlyBraceOpen =
                    stringDisplayArgumentNameBody.indexOf( "{" );
                    
                    stringDisplayArgumentNameBody =
                    stringDisplayArgumentNameBody.substring( 0,
                    intIndexCurlyBraceOpen + 1 )
                    + "\n                case short"
                    + methoddescription.getMethodElement().getName().getName().toUpperCase()
                    + ":\n"
                    + "                    switch( intArgument ) {\n"
                    + stringCaseParameter
                    + "                    }\n"
                    + "                    break;"
                    + stringDisplayArgumentNameBody.substring(
                    intIndexCurlyBraceOpen + 1 );
                    
                    methodelementDisplayArgumentName.setBody(
                    stringDisplayArgumentNameBody );
                    
                    // Insert argument description.
                    String stringCaseParameterDescription =
                    /*
                    "                        case 0:\n"
                    + "                            stringReturn = \"(internal)\";\n"
                    + "                            break;\n";
                     */
                    "";
                    
                    for ( int intParameterCounter = 0;
                    intParameterCounter < methoddescription.getArgumentDescription().length;
                    intParameterCounter++ ) {
                        stringCaseParameterDescription +=
                        "                        case "
                        //+ ( intParameterCounter + 1 ) + ":\n"
                        + intParameterCounter + ":\n"
                        + "                            stringReturn = \""
                        + methoddescription.getArgumentDescription()[ intParameterCounter ].getArgumentDescription()
                        + "\";\n"
                        + "                            break;\n";
                        
                    }
                    
                    String stringArgumentDescriptionBody =
                    methodelementArgumentDescription.getBody();
                    
                    intIndexCurlyBraceOpen =
                    stringArgumentDescriptionBody.indexOf( "{" );
                    
                    stringArgumentDescriptionBody =
                    stringArgumentDescriptionBody.substring( 0,
                    intIndexCurlyBraceOpen + 1 )
                    + "\n                case short"
                    + methoddescription.getMethodElement().getName().getName().toUpperCase()
                    + ":\n"
                    + "                    switch( intArgument ) {\n"
                    + stringCaseParameterDescription
                    + "                    }\n"
                    + "                    break;"
                    + stringArgumentDescriptionBody.substring(
                    intIndexCurlyBraceOpen + 1 );
                    
                    methodelementArgumentDescription.setBody(
                    stringArgumentDescriptionBody );
                    
                    // Insert display function names.
                    String stringDisplayFunctionNameBody =
                    methodelementDisplayFunctionName.getBody();
                    
                    intIndexCurlyBraceOpen =
                    stringDisplayFunctionNameBody.indexOf( "{" );
                    
                    stringDisplayFunctionNameBody =
                    stringDisplayFunctionNameBody.substring( 0,
                    intIndexCurlyBraceOpen + 1 )
                    + "\n                case short"
                    + methoddescription.getMethodElement().getName().getName().toUpperCase()
                    + ":\n"
                    + "                    stringReturn = \""
                    + methoddescription.getDisplayFunctionName()
                    + "\";\n"
                    + "                    break;"
                    + stringDisplayFunctionNameBody.substring(
                    intIndexCurlyBraceOpen + 1 );
                    
                    methodelementDisplayFunctionName.setBody(
                    stringDisplayFunctionNameBody );
                    
                    // Insert function description.
                    String stringFunctionDescriptionBody =
                    methodelementFunctionDescription.getBody();
                    
                    intIndexCurlyBraceOpen =
                    stringFunctionDescriptionBody.indexOf( "{" );
                    
                    stringFunctionDescriptionBody =
                    stringFunctionDescriptionBody.substring( 0,
                    intIndexCurlyBraceOpen + 1 )
                    + "\n                case short"
                    + methoddescription.getMethodElement().getName().getName().toUpperCase()
                    + ":\n"
                    + "                    stringReturn = \""
                    + methoddescription.getFunctionDescription()
                    + "\";\n"
                    + "                    break;"
                    + stringFunctionDescriptionBody.substring(
                    intIndexCurlyBraceOpen + 1 );
                    
                    methodelementFunctionDescription.setBody(
                    stringFunctionDescriptionBody );
                    
                    // Insert programmatic category name.
                    String stringCategoryNameBody =
                    methodelementCategoryName.getBody();
                    
                    intIndexCurlyBraceOpen =
                    stringCategoryNameBody.indexOf( "{" );
                    
                    stringCategoryNameBody =
                    stringCategoryNameBody.substring( 0,
                    intIndexCurlyBraceOpen + 1 )
                    + "\n                case short"
                    + methoddescription.getMethodElement().getName().getName().toUpperCase()
                    + ":\n"
                    + "                    stringReturn = \""
                    + methoddescription.getCategory()
                    + "\";\n"
                    + "                    break;"
                    + stringCategoryNameBody.substring(
                    intIndexCurlyBraceOpen + 1 );
                    
                    methodelementCategoryName.setBody(
                    stringCategoryNameBody );
                }
                catch( SourceException sourceexception ) {
                    // Show message.
                    TopManager.getDefault().notify(
                    new NotifyDescriptor.Message(
                    sourceexception.toString() ) );
                }
            }
        }
        
        try {
            fieldelementFunctionNames.setInitValue(
            fieldelementFunctionNames.getInitValue().substring( 0,
            fieldelementFunctionNames.getInitValue().length() - 1 )
            + "\n        }" );
        }
        catch( SourceException sourceexception ) {
            // Show message.
            TopManager.getDefault().notify( 
            new NotifyDescriptor.Message( 
            sourceexception.toString() ) );
        }
    }    
}
