
package org.netbeans.modules.openoffice.wizard.nodes;

import java.util.ArrayList;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.netbeans.modules.openoffice.wizard.util.*;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;
import org.openide.TopManager;
import org.openide.NotifyDescriptor;
import java.util.Vector;


public  class MovableNode extends BaseNode
{

   public MovableNode(NameKey namekey)
    {
        super(new IDLBaseChildren(),namekey);
    }

   public boolean canCut()
    {
        return false;
    }

   public boolean canMoveUp()
    {
        return true;
    }

    public boolean canMoveDown()
    {
        return true;
    }
    
   public boolean canCopy()
    {
        return false;
    }

    public boolean canDestroy()
    {
        return true;
    }

    public boolean canRename()
    {
        return true;
    }

    public SystemAction[] getActions()
    {
        if(actions == null)
            actions = createActions();
        return actions;
    }

    public void moveUp()
    {
        Children children = getParentNode().getChildren();
        ((IDLBaseChildren)children).moveUp(this);
    }

    public void moveDown()
    {
        Children children = getParentNode().getChildren();
        ((IDLBaseChildren)children).moveDown(this);
    }

    
    public void destroy()
    {
       
        Node node = getParentNode();
        if(node == null)
            return;
        Children children = node.getChildren();
        if(!(children instanceof IDLBaseChildren))
        {
            return;
        }
        else
        {
            ((IDLBaseChildren)children).removeKey(key);
            return;
        }
    }
  
    
   public String generateSelf(int i)
    {
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
            s1 = s1 + "    ";

        s = s1 + "module " + getName() + " {\n";
        Node anode[] = getChildren().getNodes();
        for(int k = 0; k < anode.length; k++)
        {
            s = s + ((BaseNode)anode[k]).generateSelf(i + 1);
            s = s + "\n";
        }

        s = s + s1 + "};\n";
        return s;
    }
    
   public SystemAction[] createActions()
    {
        return (new SystemAction[] {
          });
    }
    

   
    public BasePanel getEditPanel()
    {
        
        return null;
    }

    public void reInit(BasePanel expanel)
    {
        
    }
    
    public void generateImports(Vector Imports1)
    {
    }    
        
}
