
package org.netbeans.modules.openoffice.wizard.nodes;

import java.io.IOException;
import java.io.PrintWriter;
import org.netbeans.modules.openoffice.wizard.actions.idl.*;
import org.netbeans.modules.openoffice.wizard.nodes.*;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.openide.nodes.*;
import org.openide.util.actions.SystemAction;
import org.openide.TopManager;
import org.openide.NotifyDescriptor;
import java.util.Vector;


public class IdlFileNode extends MovableNode
    implements org.openide.nodes.Node.Cookie
{
    private Vector Imports;
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/idl";
        
    public IdlFileNode()
    {
        super(null);
        getCookieSet().add(this);
        setName("Idl File");
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/idl");
        Imports = new Vector();
    }

    public IdlFileNode(String s)
    {
        super(null);
        getCookieSet().add(this);
        setName(s);
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/idl");
        Imports = new Vector();
    }

    public SystemAction[] createActions()
    {
        return (new SystemAction[] {
                
                SystemAction.get(CreateConstantAction.class),
                SystemAction.get(CreateConstantsAction.class),
                SystemAction.get(CreateEnumAction.class),
                SystemAction.get(CreateExceptionAction.class),
//                SystemAction.get(CreateFwdDclAction.class),
                SystemAction.get(CreateInterfaceAction.class),
                SystemAction.get(CreateModuleAction.class),
                SystemAction.get(CreateServiceAction.class),
                SystemAction.get(CreateStructAction.class),
                SystemAction.get(CreateAliasAction.class)
               });
    }

    public String generateSelf(int i)
    {
        String s = new String();
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports);
            
        }
        for(int k = 0;k < Imports.size();k++ )
          {       
              s = s +  "#include <" +  ((String)Imports.get(k)) + ".idl>\n";      
          }
        
        s = s + "\n";
        for(int j = 0; j < anode.length; j++)
        {
            s = s + ((BaseNode)anode[j]).generateSelf(0);
            s = s + "\n";
        }

        return s;
    }

    public void generate(PrintWriter printwriter)
        throws IOException
    {
        printwriter.println(generateSelf(0));
    }

    public String generate()
    {
       return generateSelf(0);
    }

    public boolean canDestroy()
    {
        return false;
    }

    public boolean canRename()
    {
        return false;
    }

    public BasePanel getEditPanel()
    {
      return null;
    }

   public void reInit(BasePanel expanel)
    {
   
    }

    public boolean canMoveUp()
    {
        return false;
    }

    public boolean canMoveDown()
    {
        return false;
    }
    
    
}
