/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2dmline.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:11:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _B2D_MLINE_HXX
#define _B2D_MLINE_HXX

#ifndef _B2D_MBASE_HXX
#include "b2dmbase.hxx"
#endif

#include <stdlib.h>

//************************************************************
//   InterActionObjectLine
//************************************************************

class B2dIAOLine : public B2dIAObject
{
	// 2ndPosition of this IAO (logic and pixel)
	B2dPositionEntity			a2ndPosition;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

protected:
	// Access to 2ndPosition
	const Point& Get2ndPositionPixel() const { return a2ndPosition.GetPositionPixel(); }

public:
    TYPEINFO();
	B2dIAOLine(B2dIAOManager* pMan, Point aStartPos, Point aEndPos);
	virtual ~B2dIAOLine();

	// Access to 2ndPosition
	const Point& Get2ndPosition() const { return a2ndPosition.GetPosition(); }
	void Set2ndPosition(Point aNew);

	// Hittest
	virtual BOOL IsHit(const Point& rPixelPos, UINT16 nTol = 0) const;
};

//************************************************************
//   InterActionObjectLineStriped
//************************************************************

class B2dIAOLineStriped : public B2dIAOLine
{
	// length of stripes
	UINT16						nStripeLen;

protected:
	virtual BOOL AddLinePixel(const Point& rPos, UINT32 nPixelNum);

public:
    TYPEINFO();
	B2dIAOLineStriped(B2dIAOManager* pMan, Point aStartPos, Point aEndPos, UINT16 nSLen = 4);
	virtual ~B2dIAOLineStriped();

	// Get/SetStripeLen
	UINT16 GetStripeLength() const { return nStripeLen; }
	void SetStripeLength(UINT16 nNew);
};

//************************************************************
//   InterActionObjectLineTwoColor
//************************************************************

class B2dIAOLineTwoColor : public B2dIAOLineStriped
{
	// 2nd color of IAO (for Borders)
	Color						a2ndColor;

protected:
	virtual BOOL AddLinePixel(const Point& rPos, UINT32 nPixelNum);

public:
    TYPEINFO();
	B2dIAOLineTwoColor(B2dIAOManager* pMan, Point aStartPos, Point aEndPos, UINT16 nSLen = 4);
	virtual ~B2dIAOLineTwoColor();

	// Access to 2ndColor
	const Color& Get2ndColor() const { return a2ndColor; }
	void Set2ndColor(Color aNew);
};

//************************************************************
//   InterActionObjectLineTwoColorAnim
//************************************************************

class B2dIAOLineTwoColorAnim : public B2dIAOLineTwoColor
{
	// start step value
	UINT16						nStartCount;
	UINT16						nStartAdd;

	// React on animation (optional)
	virtual void AnimationStep(UINT32 nAnimCounter);

protected:
	virtual BOOL AddLinePixel(const Point& rPos, UINT32 nPixelNum);

public:
    TYPEINFO();
	B2dIAOLineTwoColorAnim(B2dIAOManager* pMan, Point aStartPos, Point aEndPos, UINT16 nSLen = 4);
	virtual ~B2dIAOLineTwoColorAnim();
};


#endif          // _B2D_MLINE_HXX
