/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: KResultSet.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: obo $ $Date: 2005/12/19 16:50:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "KResultSet.hxx"
#ifndef _CONNECTIVITY_KAB_RESULTSETMETADATA_HXX_
#include "KResultSetMetaData.hxx"
#endif
#ifndef _CONNECTIVITY_KAB_CONNECTION_HXX_
#include "KConnection.hxx"
#endif
#ifndef _CONNECTIVITY_KAB_CONDITION_HXX_
#include "kcondition.hxx"
#endif
#ifndef _CONNECTIVITY_KAB_ORDER_HXX_
#include "korder.hxx"
#endif
#ifndef _CONNECTIVITY_KAB_FIELDS_HXX_
#include "kfields.hxx"
#endif
#include <kabc/addressbook.h>
#include <qdatetime.h>

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBCX_COMPAREBOOKMARK_HPP_
#include <com/sun/star/sdbcx/CompareBookmark.hpp>
#endif
#ifndef CONNECTIVITY_CONNECTION_HXX
#include "TConnection.hxx"
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include <connectivity/dbexception.hxx>
#endif

using namespace connectivity::kab;
using namespace cppu;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::beans;
using namespace com::sun::star::sdbc;
using namespace com::sun::star::sdbcx;
using namespace com::sun::star::io;
using namespace com::sun::star::util;

IMPLEMENT_SERVICE_INFO(KabResultSet, "com.sun.star.sdbc.drivers.KabResultSet", "com.sun.star.sdbc.ResultSet");
// -------------------------------------------------------------------------
KabResultSet::KabResultSet(KabCommonStatement* pStmt) 
	: KabResultSet_BASE(m_aMutex),
	  OPropertySetHelper(KabResultSet_BASE::rBHelper),
	  m_xStatement(pStmt),
	  m_xMetaData(NULL),
	  m_aKabAddressees(),
	  m_nRowPos(-1),
	  m_bWasNull(sal_True)
{
}
// -------------------------------------------------------------------------
KabResultSet::~KabResultSet()
{
}
// -------------------------------------------------------------------------
void KabResultSet::allKabAddressees()
{
	KabConnection* pConnection = static_cast< KabConnection *>(m_xStatement->getConnection().get());
	KABC::AddressBook* pAddressBook = pConnection->getAddressBook();

	m_aKabAddressees = pAddressBook->allAddressees();
}
// -------------------------------------------------------------------------
void KabResultSet::someKabAddressees(const KabCondition *pCondition)
{
	KabConnection* pConnection = static_cast< KabConnection *>(m_xStatement->getConnection().get());
	KABC::AddressBook* pAddressBook = pConnection->getAddressBook();

	KABC::AddressBook::Iterator iterator;

	for (iterator = pAddressBook->begin();
	     iterator != pAddressBook->end();
	     ++iterator)
	{
		if (pCondition->eval(*iterator))
			m_aKabAddressees.push_back(*iterator);
	}
}
// -------------------------------------------------------------------------
void KabResultSet::sortKabAddressees(const KabOrder *pOrder)
{
	// We do not use class KAddresseeList, which has a sorting algorithm in it, because
	// it uses templates. It would expand to more or less the same code as the one
	// which follows, but it would need not be called in a much less convenient way.

	KABC::Addressee::List::Iterator
		begin = m_aKabAddressees.begin(),
		end = m_aKabAddressees.end(),
		iterator;

	// Bubble sort. Feel free to implement a better algorithm.
	while (begin != end)
	{
		end--;
		for (iterator = begin; iterator != end; ++iterator)
		{
			if (pOrder->compare(*iterator, *end) > 0)
				qSwap(*iterator, *end);
		}
	}
}
// -------------------------------------------------------------------------
void KabResultSet::disposing()
{
	OPropertySetHelper::disposing();

	::osl::MutexGuard aGuard(m_aMutex);

	m_xStatement	= NULL;
	m_xMetaData		= NULL;
}
// -------------------------------------------------------------------------
Any SAL_CALL KabResultSet::queryInterface(const Type & rType) throw(RuntimeException)
{
	Any aRet = OPropertySetHelper::queryInterface(rType);
	if (!aRet.hasValue())
		aRet = KabResultSet_BASE::queryInterface(rType);
	return aRet;
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::acquire() throw()
{
	KabResultSet_BASE::acquire();
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::release() throw()
{
	KabResultSet_BASE::release();
}
// -------------------------------------------------------------------------
Sequence<  Type > SAL_CALL KabResultSet::getTypes() throw(RuntimeException)
{
	OTypeCollection aTypes(
		::getCppuType( (const Reference< ::com::sun::star::beans::XMultiPropertySet >*) 0),
		::getCppuType( (const Reference< ::com::sun::star::beans::XFastPropertySet >*) 0),
		::getCppuType( (const Reference< ::com::sun::star::beans::XPropertySet >*) 0));

	return comphelper::concatSequences(aTypes.getTypes(), KabResultSet_BASE::getTypes());
}
// -------------------------------------------------------------------------
::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL KabResultSet::getPropertySetInfo(  ) throw(::com::sun::star::uno::RuntimeException)
{
	return ::cppu::OPropertySetHelper::createPropertySetInfo(getInfoHelper());
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL KabResultSet::findColumn(const ::rtl::OUString& columnName) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	// find the first column with the name columnName 
	Reference< XResultSetMetaData > xMeta = getMetaData();
	sal_Int32 nLen = xMeta->getColumnCount(),
	          i;

	for (i = 1; i <= nLen; ++i)
		if (xMeta->isCaseSensitive(i) ?
			columnName == xMeta->getColumnName(i) : 
			columnName.equalsIgnoreAsciiCase(xMeta->getColumnName(i)))
				return i;

	::dbtools::throwGenericSQLException(
		::rtl::OUString::createFromAscii("Invalid column name: ") + columnName,
		NULL);
}
// -------------------------------------------------------------------------
::rtl::OUString SAL_CALL KabResultSet::getString(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	::rtl::OUString aRet;
	sal_Int32 nAddressees = m_aKabAddressees.size();
	::KABC::Field::List aFields = ::KABC::Field::allFields();

	if (m_nRowPos != -1 && m_nRowPos != nAddressees && m_xMetaData.is())
	{
		sal_Int32 nFieldNumber = m_xMetaData->fieldAtColumn(columnIndex);
		QString aQtName;

		switch (nFieldNumber)
		{
			case KAB_FIELD_REVISION:
// trigger an exception here
m_bWasNull = true;
return aRet;
			default:
				aQtName = aFields[nFieldNumber - KAB_DATA_FIELDS]->value(m_aKabAddressees[m_nRowPos]);
		}
// KDE address book currently does not use NULL values.
// But it might do it someday
		if (!aQtName.isNull())
		{
			m_bWasNull = false;
			aRet = ::rtl::OUString((const sal_Unicode *) aQtName.ucs2());
			return aRet;
		}
	}
// Trigger an exception ?
	m_bWasNull = true;
	return aRet;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::getBoolean(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int8 SAL_CALL KabResultSet::getByte(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	sal_Int8 nRet = 0;
	return nRet;
}
// -------------------------------------------------------------------------
sal_Int16 SAL_CALL KabResultSet::getShort(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	sal_Int16 nRet = 0;
	return nRet;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL KabResultSet::getInt(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	sal_Int32 nRet = 0;
	return nRet;
}
// -------------------------------------------------------------------------
sal_Int64 SAL_CALL KabResultSet::getLong(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return sal_Int64();
}
// -------------------------------------------------------------------------
float SAL_CALL KabResultSet::getFloat(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	float nVal(0);
	return nVal;
}
// -------------------------------------------------------------------------
double SAL_CALL KabResultSet::getDouble(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	double nRet = 0;
	return nRet;
}
// -------------------------------------------------------------------------
Sequence< sal_Int8 > SAL_CALL KabResultSet::getBytes(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return Sequence< sal_Int8 >();
}
// -------------------------------------------------------------------------
Date SAL_CALL KabResultSet::getDate(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	Date aRet;
	return aRet;
}
// -------------------------------------------------------------------------
Time SAL_CALL KabResultSet::getTime(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	Time nRet;
	return nRet;
}
// -------------------------------------------------------------------------
DateTime SAL_CALL KabResultSet::getTimestamp(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	DateTime nRet;
	sal_Int32 nAddressees = m_aKabAddressees.size();

	if (m_nRowPos != -1 && m_nRowPos != nAddressees && m_xMetaData.is())
	{
		KabResultSetMetaData *pMeta = static_cast<KabResultSetMetaData *>(m_xMetaData.get());
		sal_Int32 nFieldNumber = pMeta->fieldAtColumn(columnIndex);

		if (nFieldNumber == KAB_FIELD_REVISION)
		{
			QDateTime nRevision(m_aKabAddressees[m_nRowPos].revision());

			if (!nRevision.isNull())
			{
				m_bWasNull = false;
				nRet.Year = nRevision.date().year();
				nRet.Month = nRevision.date().month();
				nRet.Day = nRevision.date().day();
				nRet.Hours = nRevision.time().hour();
				nRet.Minutes = nRevision.time().minute();
				nRet.Seconds = nRevision.time().second();
				nRet.HundredthSeconds = nRevision.time().msec() / 10;
				return nRet;
			}
		}
		else
			;
// trigger an exception here
	}
// Trigger an exception ?
	m_bWasNull = true;
	return nRet;
}
// -------------------------------------------------------------------------
Reference< XInputStream > SAL_CALL KabResultSet::getBinaryStream(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return NULL;
}
// -------------------------------------------------------------------------
Reference< XInputStream > SAL_CALL KabResultSet::getCharacterStream(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return NULL;
}
// -------------------------------------------------------------------------
Any SAL_CALL KabResultSet::getObject(sal_Int32 columnIndex, const Reference< ::com::sun::star::container::XNameAccess >& typeMap) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return Any();
}
// -------------------------------------------------------------------------
Reference< XRef > SAL_CALL KabResultSet::getRef(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return NULL;
}
// -------------------------------------------------------------------------
Reference< XBlob > SAL_CALL KabResultSet::getBlob(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return NULL;
}
// -------------------------------------------------------------------------
Reference< XClob > SAL_CALL KabResultSet::getClob(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return NULL;
}
// -------------------------------------------------------------------------
Reference< XArray > SAL_CALL KabResultSet::getArray(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

::dbtools::throwFunctionNotSupportedException(::rtl::OUString::createFromAscii("Not Implemented"), NULL);

	return NULL;
}
// -------------------------------------------------------------------------
Reference< XResultSetMetaData > SAL_CALL KabResultSet::getMetaData() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	if (!m_xMetaData.is())
		m_xMetaData = new KabResultSetMetaData(m_xStatement->getOwnConnection());

	Reference< XResultSetMetaData > xMetaData = m_xMetaData.get();
	return xMetaData;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::isBeforeFirst() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	if (m_nRowPos == -1)
		return sal_True;

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::isAfterLast() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	sal_Int32 nAddressees = m_aKabAddressees.size();
	if (m_nRowPos == nAddressees)
		return sal_True;

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::isFirst() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	if (m_nRowPos == 0)
		return sal_True;

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::isLast() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	sal_Int32 nAddressees = m_aKabAddressees.size();
	if (m_nRowPos == nAddressees - 1)
		return sal_True;

	return sal_False;
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::beforeFirst() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
		
	// move before the first row
	m_nRowPos == -1;
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::afterLast() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	// move after the last row
	sal_Int32 nAddressees = m_aKabAddressees.size();
	m_nRowPos = nAddressees;
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::close() throw(SQLException, RuntimeException)
{
	{
		::osl::MutexGuard aGuard( m_aMutex );
		checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
	}
	dispose();
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::first() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	sal_Int32 nAddressees = m_aKabAddressees.size();
	if (nAddressees == 0)
		return sal_False;

	m_nRowPos = 0;
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::last() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	sal_Int32 nAddressees = m_aKabAddressees.size();
	if (nAddressees == 0)
		return sal_False;

	m_nRowPos = nAddressees - 1;
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL KabResultSet::getRow() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return m_nRowPos;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::absolute(sal_Int32 row) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	sal_Int32 nAddressees = m_aKabAddressees.size();
	if (row <= -1 ||
	    row >= nAddressees)
		return sal_False;

	m_nRowPos = row;
	return sal_True;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::relative(sal_Int32 row) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return absolute(m_nRowPos + row);
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::next() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return absolute(m_nRowPos + 1);
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::previous() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return absolute(m_nRowPos - 1);
}
// -------------------------------------------------------------------------
Reference< XInterface > SAL_CALL KabResultSet::getStatement() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	Reference< XStatement > xStatement = m_xStatement.get();
	return xStatement;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::rowDeleted() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::rowInserted() throw(SQLException, RuntimeException)
{	
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::rowUpdated() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::wasNull() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	return m_bWasNull;
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::cancel() throw(RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::clearWarnings() throw(SQLException, RuntimeException)
{
}
// -------------------------------------------------------------------------
Any SAL_CALL KabResultSet::getWarnings() throw(SQLException, RuntimeException)
{
	return Any();
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::insertRow() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	// you only have to implement this if you want to insert new rows
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateRow() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
		
	// only when you allow updates
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::deleteRow() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::cancelRowUpdates() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::moveToInsertRow() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
		
	// only when you allow inserts
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::moveToCurrentRow() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateNull(sal_Int32 columnIndex) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateBoolean(sal_Int32 columnIndex, sal_Bool x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateByte(sal_Int32 columnIndex, sal_Int8 x) throw(SQLException, RuntimeException)
{
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
	::osl::MutexGuard aGuard( m_aMutex );
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateShort(sal_Int32 columnIndex, sal_Int16 x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateInt(sal_Int32 columnIndex, sal_Int32 x) throw(SQLException, RuntimeException)
{
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
	::osl::MutexGuard aGuard( m_aMutex );
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateLong(sal_Int32 columnIndex, sal_Int64 x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -----------------------------------------------------------------------
void SAL_CALL KabResultSet::updateFloat(sal_Int32 columnIndex, float x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateDouble(sal_Int32 columnIndex, double x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateString(sal_Int32 columnIndex, const ::rtl::OUString& x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateBytes(sal_Int32 columnIndex, const Sequence< sal_Int8 >& x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateDate(sal_Int32 columnIndex, const Date& x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateTime(sal_Int32 columnIndex, const Time& x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateTimestamp(sal_Int32 columnIndex, const DateTime& x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateBinaryStream(sal_Int32 columnIndex, const Reference< XInputStream >& x, sal_Int32 length) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateCharacterStream(sal_Int32 columnIndex, const Reference< XInputStream >& x, sal_Int32 length) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::refreshRow() throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateObject(sal_Int32 columnIndex, const Any& x) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
void SAL_CALL KabResultSet::updateNumericObject(sal_Int32 columnIndex, const Any& x, sal_Int32 scale) throw(SQLException, RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
}
// -------------------------------------------------------------------------
// XRowLocate
Any SAL_CALL KabResultSet::getBookmark() throw( SQLException,  RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

        sal_Int32 nAddressees = m_aKabAddressees.size();

        if (m_nRowPos != -1 && m_nRowPos != nAddressees)
        {
                QString aQtName = m_aKabAddressees[m_nRowPos].uid();
       		::rtl::OUString sUniqueIdentifier = ::rtl::OUString((const sal_Unicode *) aQtName.ucs2());
		return makeAny(sUniqueIdentifier);
	}
	return Any();
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::moveToBookmark(const  Any& bookmark) throw( SQLException,  RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	::rtl::OUString sBookmark = comphelper::getString(bookmark);
        sal_Int32 nAddressees = m_aKabAddressees.size();

	for (sal_Int32 nRow = 0; nRow < nAddressees; nRow++)
	{
                QString aQtName = m_aKabAddressees[nRow].uid();
       		::rtl::OUString sUniqueIdentifier = ::rtl::OUString((const sal_Unicode *) aQtName.ucs2());

		if (sUniqueIdentifier == sBookmark)
		{
			m_nRowPos = nRow;
			return sal_True;
		}
	}
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::moveRelativeToBookmark(const  Any& bookmark, sal_Int32 rows) throw( SQLException,  RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	sal_Int32 nRowSave = m_nRowPos;

	if (moveToBookmark(bookmark))
	{
		sal_Int32 nAddressees = m_aKabAddressees.size();

		m_nRowPos += rows;

		if (-1 < m_nRowPos && m_nRowPos < nAddressees)
			return sal_True;
	}

	m_nRowPos = nRowSave;
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL KabResultSet::compareBookmarks(const  Any& first, const  Any& second) throw( SQLException,  RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	::rtl::OUString sFirst = comphelper::getString(first);
	::rtl::OUString sSecond = comphelper::getString(second);

	if (sFirst < sSecond)
		return CompareBookmark::LESS;
	if (sFirst > sSecond)
		return CompareBookmark::GREATER;
	return CompareBookmark::EQUAL;
}
// -------------------------------------------------------------------------
sal_Bool SAL_CALL KabResultSet::hasOrderedBookmarks() throw( SQLException,  RuntimeException)
{
	return sal_False;
}
// -------------------------------------------------------------------------
sal_Int32 SAL_CALL KabResultSet::hashBookmark(const  Any& bookmark) throw( SQLException,  RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);

	::rtl::OUString sBookmark = comphelper::getString(bookmark);

	return sBookmark.hashCode();
}
// -------------------------------------------------------------------------
// XDeleteRows
Sequence< sal_Int32 > SAL_CALL KabResultSet::deleteRows(const  Sequence<  Any >& rows) throw( SQLException,  RuntimeException)
{
	::osl::MutexGuard aGuard( m_aMutex );
	checkDisposed(KabResultSet_BASE::rBHelper.bDisposed);
		
	return Sequence< sal_Int32 >();
}
// -------------------------------------------------------------------------
IPropertyArrayHelper* KabResultSet::createArrayHelper() const
{
	Sequence< Property > aProps(6);
	Property* pProperties = aProps.getArray();
	sal_Int32 nPos = 0;
	DECL_PROP1IMPL(CURSORNAME,			::rtl::OUString) PropertyAttribute::READONLY);
	DECL_PROP0(FETCHDIRECTION,			sal_Int32);
	DECL_PROP0(FETCHSIZE,				sal_Int32);
	DECL_BOOL_PROP1IMPL(ISBOOKMARKABLE) PropertyAttribute::READONLY);
	DECL_PROP1IMPL(RESULTSETCONCURRENCY,sal_Int32) PropertyAttribute::READONLY);
	DECL_PROP1IMPL(RESULTSETTYPE,		sal_Int32) PropertyAttribute::READONLY);

	return new OPropertyArrayHelper(aProps);
}
// -------------------------------------------------------------------------
IPropertyArrayHelper & KabResultSet::getInfoHelper()
{
	return *static_cast<KabResultSet*>(this)->getArrayHelper();
}
// -------------------------------------------------------------------------
sal_Bool KabResultSet::convertFastPropertyValue(
			Any & rConvertedValue,
			Any & rOldValue,
			sal_Int32 nHandle,
			const Any& rValue )
				throw (::com::sun::star::lang::IllegalArgumentException)
{
	switch (nHandle)
	{
		case PROPERTY_ID_ISBOOKMARKABLE:
		case PROPERTY_ID_CURSORNAME:
		case PROPERTY_ID_RESULTSETCONCURRENCY:
		case PROPERTY_ID_RESULTSETTYPE:
			throw ::com::sun::star::lang::IllegalArgumentException();
			break;
		case PROPERTY_ID_FETCHDIRECTION:
		case PROPERTY_ID_FETCHSIZE:
		default:
			;
	}
	return sal_False;
}
// -------------------------------------------------------------------------
void KabResultSet::setFastPropertyValue_NoBroadcast(
			sal_Int32 nHandle,
			const Any& rValue )
				 throw (Exception)
{
	switch (nHandle)
	{
		case PROPERTY_ID_ISBOOKMARKABLE:
		case PROPERTY_ID_CURSORNAME:
		case PROPERTY_ID_RESULTSETCONCURRENCY:
		case PROPERTY_ID_RESULTSETTYPE:
			throw Exception();
			break;
		case PROPERTY_ID_FETCHDIRECTION:
			break;
		case PROPERTY_ID_FETCHSIZE:
			break;
		default:
			;
	}
}
// -------------------------------------------------------------------------
void KabResultSet::getFastPropertyValue(
			Any& rValue,
			sal_Int32 nHandle) const
{
	switch (nHandle)
	{
		case PROPERTY_ID_ISBOOKMARKABLE:
		case PROPERTY_ID_CURSORNAME:
		case PROPERTY_ID_RESULTSETCONCURRENCY:
		case PROPERTY_ID_RESULTSETTYPE:
		case PROPERTY_ID_FETCHDIRECTION:
		case PROPERTY_ID_FETCHSIZE:
			;
	}
}
// -----------------------------------------------------------------------------
