/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: emptymetadata.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:15:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_EMPTYMETADATA_HXX_
#include <connectivity/emptymetadata.hxx>
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include <connectivity/dbexception.hxx>
#endif

//.........................................................................
namespace dbtools
{
//.........................................................................
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::sdbc;

	// =====================================================================
	// = OEmptyMetaData
	// =====================================================================
	// -------------------------------------------------------------------------
	OEmptyMetaData::OEmptyMetaData()
	{
	}

	// -------------------------------------------------------------------------
	OEmptyMetaData::~OEmptyMetaData()
	{
	}

	// -------------------------------------------------------------------------
	void OEmptyMetaData::throwException()
	{
		throwGenericSQLException(
			::rtl::OUString::createFromAscii("Invalid column index. The result set is empty."),
			static_cast< XResultSetMetaData* >(this));
	}

	// -------------------------------------------------------------------------
	sal_Int32 SAL_CALL OEmptyMetaData::getColumnCount(  ) throw(SQLException, RuntimeException)
	{
		return 0;
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isAutoIncrement( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isCaseSensitive( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isSearchable( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isCurrency( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	sal_Int32 SAL_CALL OEmptyMetaData::isNullable( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return 0;
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isSigned( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	sal_Int32 SAL_CALL OEmptyMetaData::getColumnDisplaySize( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return 0;
	}

	// -------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OEmptyMetaData::getColumnLabel( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return ::rtl::OUString();
	}

	// -------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OEmptyMetaData::getColumnName( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return ::rtl::OUString();
	}

	// -------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OEmptyMetaData::getSchemaName( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return ::rtl::OUString();
	}

	// -------------------------------------------------------------------------
	sal_Int32 SAL_CALL OEmptyMetaData::getPrecision( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return 0;
	}

	// -------------------------------------------------------------------------
	sal_Int32 SAL_CALL OEmptyMetaData::getScale( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return 0;
	}

	// -------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OEmptyMetaData::getTableName( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return ::rtl::OUString();
	}

	// -------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OEmptyMetaData::getCatalogName( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return ::rtl::OUString();
	}

	// -------------------------------------------------------------------------
	sal_Int32 SAL_CALL OEmptyMetaData::getColumnType( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return 0;
	}

	// -------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OEmptyMetaData::getColumnTypeName( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return ::rtl::OUString();
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isReadOnly( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isWritable( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	sal_Bool SAL_CALL OEmptyMetaData::isDefinitelyWritable( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return sal_False;
	}

	// -------------------------------------------------------------------------
	::rtl::OUString SAL_CALL OEmptyMetaData::getColumnServiceName( sal_Int32 column ) throw(SQLException, RuntimeException)
	{
		throwException();
		return ::rtl::OUString();
	}

//.........................................................................
}	// namespace dbtools
//.........................................................................

