/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DrawModelWrapper.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:19:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "DrawModelWrapper.hxx"

#ifndef SVX_UNOMODEL_HXX
#include <svx/unomodel.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
// header for class SfxBoolItem
#ifndef _SFXENUMITEM_HXX
#include <svtools/eitem.hxx>
#endif
// header for define EE_PARA_HYPHENATE
#ifndef _EEITEM_HXX
#include <svx/eeitem.hxx>
#endif
// header for class Svx3DPercentDiagonalItem
#ifndef _SVX3DITEMS_HXX
#include <svx/svx3ditems.hxx>
#endif
// header for class SvtPathOptions
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif

using namespace ::com::sun::star;

//.............................................................................
namespace chart
{
//.............................................................................

DrawModelWrapper::DrawModelWrapper(
		uno::Reference<uno::XComponentContext> const & xContext
        , SfxItemPool* pSchItemPool )
        : SdrModel( SvtPathOptions().GetPalettePath() ),
        m_xMCF( NULL )
        , m_pSchItemPool( pSchItemPool )
{
    //takes ownership of pSchItemPool

    m_xMCF = xContext->getServiceManager();

	SfxItemPool* pMasterPool = &GetItemPool();
	pMasterPool->SetDefaultMetric(SFX_MAPUNIT_100TH_MM);
	pMasterPool->SetPoolDefaultItem(SfxBoolItem(EE_PARA_HYPHENATE, TRUE) );
	pMasterPool->SetPoolDefaultItem(Svx3DPercentDiagonalItem (5));

    SfxItemPool* pPool = pMasterPool;
	// append chart pool to end of pool chain
	for (;;)
	{
		SfxItemPool* pSecondary = pPool->GetSecondaryPool();
		if (!pSecondary)
			break;

		pPool = pSecondary;
	}
	pPool->SetSecondaryPool(pSchItemPool);
	pMasterPool->FreezeIdRanges();
}

DrawModelWrapper::~DrawModelWrapper()
{
    //remove m_pSchItemPool from pool chain
    if(m_pSchItemPool)
    {
	    SfxItemPool* pPool = &GetItemPool();
	    for (;;)
	    {
		    SfxItemPool* pSecondary = pPool->GetSecondaryPool();
		    if(pSecondary == m_pSchItemPool)
		    {
			    pPool->SetSecondaryPool (NULL);
			    break;
		    }
		    pPool = pSecondary;
	    }
	    delete m_pSchItemPool;
    }
}

uno::Reference< uno::XInterface > DrawModelWrapper
::createUnoModel()
{
	uno::Reference< lang::XComponent > xComponent = new SvxUnoDrawingModel( this );
	return uno::Reference< uno::XInterface >::query( xComponent );
}

uno::Reference< frame::XModel > DrawModelWrapper::getUnoModel()
{
    uno::Reference< uno::XInterface > xI = this->SdrModel::getUnoModel();
    return uno::Reference<frame::XModel>::query( xI );
}

SdrModel& DrawModelWrapper::getSdrModel()
{
    return *this;
}

SfxItemPool& DrawModelWrapper::GetItemPool()
{
    return this->SdrModel::GetItemPool();
}
const SfxItemPool& DrawModelWrapper::GetItemPool() const
{
    return this->SdrModel::GetItemPool();
}
XColorTable* DrawModelWrapper::GetColorTable() const
{
    return this->SdrModel::GetColorTable();
}
XDashList* DrawModelWrapper::GetDashList() const
{
    return this->SdrModel::GetDashList();
}
XLineEndList* DrawModelWrapper::GetLineEndList() const
{
    return this->SdrModel::GetLineEndList();
}
XGradientList* DrawModelWrapper::GetGradientList() const
{
    return this->SdrModel::GetGradientList();
}
XHatchList* DrawModelWrapper::GetHatchList() const
{
    return this->SdrModel::GetHatchList();
}
XBitmapList* DrawModelWrapper::GetBitmapList() const
{
    return this->SdrModel::GetBitmapList();
}

//.............................................................................
} //namespace chart
//.............................................................................


/*
SvxUnoDrawingModel
*/
