/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: id_gener.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:11:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <id_gener.hxx>


// NOT FULLY DEFINED SERVICES
#include <stdio.h>


namespace ary
{

const UINT32  C_nTopProjectId = 1;
const UINT32  C_nGlobalNamespaceId = 2;
const UINT32  CID_START_OF_CIDS = 128;
const UINT32  CID_START_OF_TIDS = 1024;
const UINT32  CID_TID_ELLIPSE = 1;
const UINT32  CID_START_OF_BuiltInType_TIDS = 2;
const UINT32  CID_START_OF_LIDS = 1;
const UINT32  CID_START_OF_OSIDS = 1;
const UINT32  CID_START_OF_DIDS = 128;


Std_IdGenerator::Std_IdGenerator()
    :   nIds(CID_START_OF_CIDS),
        nTids(CID_START_OF_TIDS),
        nLids(CID_START_OF_LIDS),
        nOSids(CID_START_OF_OSIDS),
        nDids(CID_START_OF_DIDS),
        nAnonymous(1)
{
}

Std_IdGenerator::~Std_IdGenerator()
{
}

Cid
Std_IdGenerator::do_NewCid()
{
    return nIds++;
}

Tid
Std_IdGenerator::do_NewTid()
{
    return nTids++;
}

cpp::Did
Std_IdGenerator::do_NewDid()
{
    return nDids++;
}

Gid
Std_IdGenerator::do_NewGid()
{
    return nIds++;
}

Lid
Std_IdGenerator::do_NewLid()
{
    return nLids++;
}

OSid
Std_IdGenerator::do_NewOSid()
{
    return nOSids++;
}

udmstri
Std_IdGenerator::do_NewAnonymousName( char i_cStart )
{
 	char sResult[30];

    // convert for type safety in sprintf
    unsigned long nNr = nAnonymous++;

    sprintf( sResult,               // SAFE SPRINTF (#100211# - checked)
             "%c_Anonymous__%lu",
             i_cStart, nNr );

    return &sResult[0];
}

Gid
Std_IdGenerator::inq_Id_TopProject() const
{
    return C_nTopProjectId;
}

Cid
Std_IdGenerator::inq_Id_GlobalNamespace_Cpp() const
{
	return C_nGlobalNamespaceId;
}

Tid
Std_IdGenerator::inq_FirstId_BuiltInTypes() const
{
	return CID_START_OF_BuiltInType_TIDS;
}

Tid
Std_IdGenerator::inq_IdEllipse() const
{
 	return CID_TID_ELLIPSE;
}



}   // namespace ary




