/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: codeinfo.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:09:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#include <precomp.h>
#include <ary/info/codeinfo.hxx>


// NOT FULLY DEFINED SERVICES
#include <ary/info/all_tags.hxx>
#include <ary/info/docstore.hxx>
#include <ary/info/infodisp.hxx>


namespace ary
{
namespace info
{

unsigned char  C_ucNO_INDEX = 255;

typedef DYN StdTag * (F_CREATE)();


CodeInfo::CodeInfo()
	:	bIsObsolete(false),
		bIsInternal(false),
		bIsInterface(false)
{
	memset( nTags, C_ucNO_INDEX, size_t(C_eAtTag_NrOfClasses) );
}

CodeInfo::~CodeInfo()
{
}

void
CodeInfo::do_StoreAt( Display & o_rOut ) const
{
    ary::info::DocuDisplay * pD = dynamic_cast< ary::info::DocuDisplay* >(&o_rOut);
    if (pD != 0)
    {
     	pD->Display_CodeInfo(*this);
    }
}

void
CodeInfo::do_Store2( info::DocuStore & o_rDocuStore )
{
	o_rDocuStore.Store2ConnectedDeclaration(*this);
}

AtTag *
CodeInfo::Create_StdTag( E_AtTagId i_eId )
{
	UINT8 nIndex = i_eId;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new StdTag(i_eId);
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::CheckIn_BaseTag()
{
	UINT8 nIndex = atc_base;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new BaseTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::CheckIn_ExceptionTag()
{
	UINT8 nIndex = atc_exception;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new ExceptionTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::Create_ImplementsTag()
{
	UINT8 nIndex = atc_implements;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new ImplementsTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::Create_KeywordTag()
{
	UINT8 nIndex = atc_keyword;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new KeywordTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::CheckIn_ParameterTag()
{
	UINT8 nIndex = atc_parameter;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new ParameterTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::CheckIn_SeeTag()
{
	UINT8 nIndex = atc_see;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new SeeTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::CheckIn_TemplateTag()
{
	UINT8 nIndex = atc_template;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new TemplateTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::Create_LabelTag()
{
	UINT8 nIndex = atc_label;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new LabelTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::Create_DefaultTag()
{
	UINT8 nIndex = atid_descr;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new StdTag(atid_descr);
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}

AtTag *
CodeInfo::Create_SinceTag()
{
	UINT8 nIndex = atc_since;
	if ( nTags[nIndex] == C_ucNO_INDEX )
	{
		AtTag * ret = new SinceTag();
		NewTag(nIndex) = ret;
		return ret;
	}
	else
	{
		return GetTag(nIndex).GetFollower();
	}
}


void
CodeInfo::Replace_AtShort_By_AtDescr()
{
    unsigned char nPosInTags = nTags[atid_short];
    if ( nPosInTags == C_ucNO_INDEX )
        return;

	AtTag * pTag = aTags[ nPosInTags ];
	if ( pTag == 0 )    // Should be csv_assert().
        return;

    csv_assert( dynamic_cast< StdTag* >(pTag) != 0 );
	StdTag * pStdTag = static_cast< StdTag* >(pTag);

    pStdTag->ChangeId2(atid_descr);
    nTags[atid_short] = C_ucNO_INDEX;
    nTags[atid_descr] = nPosInTags;
}

void
CodeInfo::Set_Obsolete()
{
	bIsObsolete = true;
}

void
CodeInfo::Set_Internal()
{
	bIsInternal = true;
}

const AtTag &
CodeInfo::Short() const
{
    static const StdTag aNull_(atid_short);

    unsigned char nPosInTags = nTags[atid_short];
    if ( nPosInTags != C_ucNO_INDEX )
    {
		AtTag * pTag = aTags[ nPosInTags ];
		if ( pTag != 0 )    // Should be csv_assert().
		{
            return *pTag;
		}
	}

    return aNull_;
}

AtTag * &
CodeInfo::NewTag(UINT8 i_nIndex)
{
	nTags[i_nIndex] = aTags.size();
	aTags.push_back(0);
	return aTags.back();
}

AtTag &
CodeInfo::GetTag( UINT8	i_nIndex )
{
    csv_assert( i_nIndex < C_eAtTag_NrOfClasses );
    csv_assert( nTags[i_nIndex] != C_ucNO_INDEX );
    csv_assert( aTags[nTags[i_nIndex]] != 0 );
	return * aTags[nTags[i_nIndex]];
}

bool
CodeInfo::IsInternal() const
{
    return bIsInternal;
}

bool
CodeInfo::IsInterface() const
{
    return bIsInterface;
}


const CodeInfo &
CodeInfo::Null_()
{
	static const CodeInfo aNull_;

    return aNull_;
}


//**********************      Null_Documentation      *******************//


class Null_Documentation : public Documentation
{
  private:
	virtual void	   	do_StoreAt(
							Display &			o_rDisplay ) const;
	virtual void		do_Store2(
							info::DocuStore &   o_rDocuStore );
    virtual bool        IsInternal() const;
    virtual bool        IsInterface() const;
};

void
Null_Documentation::do_StoreAt( Display & o_rDisplay ) const { }
void
Null_Documentation::do_Store2( info::DocuStore & o_rDocuStore ) { }


bool
Null_Documentation::IsInternal() const
{
    return false;
}

bool
Null_Documentation::IsInterface() const
{
    return false;
}


}   // namespace info

const Documentation &
Documentation::Null_()
{
    static const info::Null_Documentation aNull_;
 	return aNull_;
}


}   // namespace ary





