/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cdf_gate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:34:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_CDF_GATE_HXX
#define ARY_CPP_CDF_GATE_HXX


// USED SERVICES
	// BASE CLASSES
#include <ary/cpp/crwg_def.hxx>
#include <ary/cpp/crog_def.hxx>
	// COMPONENTS
	// PARAMETERS



namespace ary
{
    namespace store
    {
        namespace cpp
        {
            class Defs_Ifc;
        }
    }

    class IdGenerator;

namespace cpp
{


/** This class contains and stores all ary::AryGroup s, which are
    not stored as ary::CodeEntity s.
*/
class Gate_Defines : public RwGate_Defines,
                     public RoGate_Defines
{
  public:
	// LIFECYCLE
                        Gate_Defines(
                            ary::store::cpp::Defs_Ifc &
                                                io_rDefs_Ifc,
                            ary::IdGenerator &  io_rIdGenerator );
    virtual             ~Gate_Defines();

    // KORR
    const ary::store::cpp::Defs_Ifc &
                        StoreIfc() const        { return *pDefs_Ifc; }

  private:
    // Interface ary::cpp::RwGate_Defines:
	virtual Define &    do_Store_Define(
                            const InputContext& i_rContext,
							const udmstri &     i_sName,
                            const StringVector &
                                                i_rDefinition );
	virtual Macro &     do_Store_Macro(
							const InputContext& i_rContext,
							const udmstri &     i_sName,
                            const StringVector &
                                                i_rParams,
                            const StringVector &
                                                i_rDefinition );
    // Interface ary::cpp::RwGate_Defines:
	virtual const Define *
                        inq_Find_Define(
							Did					i_nId ) const;
	virtual const Macro *
                        inq_Find_Macro(
							Did					i_nId ) const;
	virtual uintt       inq_Search_Defines(
                            List_DefIds &       o_rResult,
							const udmstri &     i_sDefinedName ) const;
	virtual uintt       inq_Search_Macros(
                            List_DefIds &       o_rResult,
							const udmstri &     i_sDefinedName ) const;
    virtual uintt       inq_Get_AllDefines(
                            List_DefIds &       o_rResult ) const;
    virtual uintt       inq_Get_AllMacros(
                            List_DefIds &       o_rResult ) const;

    // DATA
    ary::store::cpp::Defs_Ifc *
                        pDefs_Ifc;
    ary::IdGenerator *  pIdGenerator;
};


// IMPLEMENTATION



} // namespace cpp
} // namespace ary



#endif

