/*
 * AccessibleObjectFinder.java
 *
 * Created on 7. M?rz 2003, 11:15
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.uno.UnoRuntime;

/**
 * Searches in StarOffice the proper object for the specified X and Y coordinates.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class AccessibleObjectFind {
    private XExtendedToolkit m_XToolkit;

    /**
     * Creates a new AccessibleObjectFind object.
     *
     * @param xToolkit
     */
    public AccessibleObjectFind(XExtendedToolkit xToolkit) {
        m_XToolkit = xToolkit;
    }

    /**
     * Search for an accessible Object at the specified coordinates.
     *
     * @param x
     * @param y
     *
     * @return Found accessible object
     */
    public XAccessible findAccessibleObject(int x, int y) {
        // Iterate over all toplevel application windows.
        // Register at toolkit as focus event listener.
        XExtendedToolkit xToolkit = m_XToolkit; //maConnectionTask.getToolkit();
        XAccessible xObjectUnderPoint = null;

        if (xToolkit != null) {
            int nTopWindowCount = xToolkit.getTopWindowCount();

            try {
                for (int i = 0; i < nTopWindowCount; i++) {
                    XAccessible xAccessible = (XAccessible) UnoRuntime.queryInterface(XAccessible.class, xToolkit.getTopWindow(i));
                    xObjectUnderPoint = findAccessibleObjectViaBBox(xAccessible, new com.sun.star.awt.Point(x, y), 0);

                    if (xObjectUnderPoint != null) {
                        break;
                    }
                }
            } catch (com.sun.star.lang.IndexOutOfBoundsException aException) {
            }
        }

        return xObjectUnderPoint;
    }

    /**
     * Find that accessible object at the lowest level of the accessibility tree with the
     * given object as root that contains the given coordinates.  When there are more
     * than one such objects then return the first one.
     *
     * @param xAccessible object
     * @param aLocation
     * @param nLevel
     *
     * @return Found accessible object
     */
    private XAccessible findAccessibleObjectViaBBox(XAccessible xAccessible, com.sun.star.awt.Point aLocation, int nLevel) {
        XAccessible xObjectUnderPoint = null;

        if (xAccessible != null) {
            XAccessibleContext xContext = xAccessible.getAccessibleContext();
            XAccessibleComponent xComponent = (XAccessibleComponent) UnoRuntime.queryInterface(XAccessibleComponent.class, xContext);

            if (xComponent != null) {
                // Make point coordinates relative to the component.
                com.sun.star.awt.Point aComponentOrigin = xComponent.getLocationOnScreen();
                com.sun.star.awt.Point aTestPoint = new com.sun.star.awt.Point();
                aTestPoint.X = aLocation.X - aComponentOrigin.X;
                aTestPoint.Y = aLocation.Y - aComponentOrigin.Y;

                if (xComponent.containsPoint(aTestPoint)) {
                    // This object contains the test point.  If it has
                    // children then find the first descendant that contains
                    // the test point.  Otherwise return this object itself.
                    if (xContext.getAccessibleChildCount() != 0) {
                        try {
                            for (int i = 0; i < xContext.getAccessibleChildCount(); i++) {
                                xObjectUnderPoint = findAccessibleObjectInAccessible(xContext.getAccessibleChild(i), aLocation, nLevel + 1);

                                if (xObjectUnderPoint != null) {
                                    break;
                                }
                            }
                        } catch (com.sun.star.lang.IndexOutOfBoundsException e) {
                        }
                    } else {
                        xObjectUnderPoint = xAccessible;
                    }
                }
            }
        }

        return xObjectUnderPoint;
    }

    /**
     * Find that accessible object at the lowest level of the accessibility tree with the
     * given object as root that contains the given coordinates.  When there are more
     * than one such objects then return the first one. Recursive calls.
     *
     * @param xAccessible object
     * @param aLocation
     * @param nLevel
     *
     * @return Accessible object
     */
    private XAccessible findAccessibleObjectInAccessible(XAccessible xAccessible, com.sun.star.awt.Point aLocation, int nLevel) {
        XAccessible xObjectUnderPoint = null;

        try {
            if (xAccessible != null) {
                XAccessibleComponent xComponent = (XAccessibleComponent) UnoRuntime.queryInterface(XAccessibleComponent.class, xAccessible.getAccessibleContext());

                if (xComponent != null) {
                    // Make point coordinates relative to the component.
                    com.sun.star.awt.Point aComponentOrigin = xComponent.getLocationOnScreen();
                    com.sun.star.awt.Point aTestPoint = new com.sun.star.awt.Point();
                    aTestPoint.X = aLocation.X - aComponentOrigin.X;
                    aTestPoint.Y = aLocation.Y - aComponentOrigin.Y;

                    XAccessible xChild = xComponent.getAccessibleAtPoint(aTestPoint);

                    if (xChild != null) {
                        XAccessibleContext xChildContext = xChild.getAccessibleContext();

                        if (xChildContext.getAccessibleChildCount() != 0) {
                            xObjectUnderPoint = findAccessibleObjectInAccessible(xChild, aLocation, nLevel + 1);
                        } else {
                            xObjectUnderPoint = xChild;
                        }
                    } else if (xComponent.containsPoint(aTestPoint)) {
                        xObjectUnderPoint = xAccessible;
                    }

                    if (xAccessible != null) {
                        XAccessibleContext xContext = xAccessible.getAccessibleContext();

                        if (xContext.getAccessibleRole() == AccessibleRole.PAGE_TAB_LIST) {
                            try {
                                XAccessibleSelection xAccessibleSel = (XAccessibleSelection) UnoRuntime.queryInterface(XAccessibleSelection.class, xContext);

                                if (xAccessibleSel != null) {
                                    int count = xContext.getAccessibleChildCount();
                                    int selectedChild = -1;

                                    for (int index = 0; index < count; index++) {
                                        if (xAccessibleSel.isAccessibleChildSelected(index)) {
                                            selectedChild = index;

                                            break;
                                        }
                                    }

                                    if (selectedChild > -1) {
                                        XAccessible xAccessChild = xContext.getAccessibleChild(selectedChild);
                                        XAccessibleContext xChildContext = xAccessChild.getAccessibleContext();

                                        if (xChildContext.getAccessibleChildCount() != 0) {
                                            xObjectUnderPoint = findAccessibleObjectInAccessible(xAccessChild, aLocation, nLevel + 1);
                                        }
                                    }
                                }
                            } catch (com.sun.star.lang.IndexOutOfBoundsException iex) {
                            }
                        }
                    }
                }
            }
        } catch (com.sun.star.uno.RuntimeException ex) {
        }

        return xObjectUnderPoint;
    }
}
